/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.chat;

import android.content.Context;
import android.content.Intent;
import com.easemob.EMNotifierEvent;
import com.easemob.chat.EMChat;
import com.easemob.chat.EMChatManager;
import com.easemob.chat.EMMessage;
import com.easemob.chat.EMNotifier;
import com.easemob.util.EMLog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class EMOfflineMessageHandler {
    private static final String TAG = "EMOfflineMessageHandler";
    Set<String> offlineMsgUserSenders;
    Set<String> offlineMsgGrpSenders;
    List<EMMessage> offlineMessages = new ArrayList<EMMessage>();
    List<EMMessage> offlineCmdMessagesList = new ArrayList<EMMessage>();
    private EMMessage curOfflineMsg;
    private EMMessage preOfflineMsg;
    private static final long OFFLINE_INTERVAL = 3000L;
    private long publishInterval = 3000L;
    private Thread notifyThread = null;
    private boolean needSend = false;

    void onAppReady() {
        this.needSend = true;
    }

    EMOfflineMessageHandler() {
        this.offlineMsgUserSenders = Collections.synchronizedSet(new HashSet());
        this.offlineMsgGrpSenders = Collections.synchronizedSet(new HashSet());
    }

    void setPublishInterval(long l2) {
        this.publishInterval = l2;
    }

    void onNewOfflineMessage(EMMessage eMMessage) {
        if (!this.offlineMessages.contains(eMMessage)) {
            this.offlineMessages.add(eMMessage);
        }
        this.curOfflineMsg = eMMessage;
        this.startOfflineThread();
        EMLog.d(TAG, " offline msg, do not send notify for msg:" + eMMessage.msgId);
        if (eMMessage.getChatType() == EMMessage.ChatType.GroupChat) {
            String string = eMMessage.getTo();
            EMLog.d("notify", "offline group msg");
            if (!this.offlineMsgGrpSenders.contains(string)) {
                this.offlineMsgGrpSenders.add(string);
            }
        } else {
            String string = eMMessage.getFrom();
            if (!this.offlineMsgUserSenders.contains(string)) {
                this.offlineMsgUserSenders.add(string);
            }
        }
    }

    void addOfflineCmdMessage(EMMessage eMMessage) {
        if (!this.offlineCmdMessagesList.contains(eMMessage)) {
            this.offlineCmdMessagesList.add(eMMessage);
        }
    }

    void processOfflineCmdMessages() {
        for (EMMessage eMMessage : this.offlineCmdMessagesList) {
            EMChatManager.getInstance().notifyCmdMsg(eMMessage);
        }
        this.offlineCmdMessagesList.clear();
    }

    void stop() {
        this.sendOfflineBroadcast();
        this.stopOfflineThread();
    }

    synchronized void startOfflineThread() {
        if (this.notifyThread != null && this.notifyThread.isAlive()) {
            return;
        }
        this.notifyThread = new Thread(){

            @Override
            public void run() {
                EMLog.d(EMOfflineMessageHandler.TAG, "start offline notify thread...");
                long l2 = EMOfflineMessageHandler.this.publishInterval / 1000L;
                try {
                    while (true) {
                        1.sleep(1000L);
                        if (--l2 > 0L) continue;
                        l2 = EMOfflineMessageHandler.this.publishInterval / 1000L;
                        if (EMOfflineMessageHandler.this.curOfflineMsg == EMOfflineMessageHandler.this.preOfflineMsg) {
                            if (EMOfflineMessageHandler.this.curOfflineMsg != null) {
                                EMOfflineMessageHandler.this.sendOfflineBroadcast();
                                EMOfflineMessageHandler.this.notifyThread = null;
                                EMOfflineMessageHandler.this.curOfflineMsg = null;
                                EMOfflineMessageHandler.this.preOfflineMsg = null;
                            }
                            return;
                        }
                        EMOfflineMessageHandler.this.preOfflineMsg = EMOfflineMessageHandler.this.curOfflineMsg;
                        EMOfflineMessageHandler.this.sendOfflineBroadcast();
                    }
                }
                catch (InterruptedException interruptedException) {
                    EMOfflineMessageHandler.this.notifyThread = null;
                    EMOfflineMessageHandler.this.curOfflineMsg = null;
                    EMOfflineMessageHandler.this.preOfflineMsg = null;
                    return;
                }
            }
        };
        this.notifyThread.start();
    }

    void stopOfflineThread() {
        if (this.notifyThread != null) {
            this.notifyThread.interrupt();
        }
    }

    private synchronized void sendOfflineBroadcast() {
        Object object;
        if (this.offlineMsgUserSenders.size() > 0 || this.offlineMsgGrpSenders.size() > 0) {
            object = new Intent(EMChatManager.getInstance().getOfflineMessageBroadcastAction());
            String[] stringArray = this.offlineMsgUserSenders.toArray(new String[0]);
            object.putExtra("fromuser", stringArray);
            EMLog.d(TAG, "send offline message broadcast for users:" + stringArray.length);
            String[] stringArray2 = this.offlineMsgGrpSenders.toArray(new String[0]);
            object.putExtra("fromgroup", stringArray2);
            EMLog.d(TAG, "send offline message broadcast for groups:" + stringArray2.length);
            try {
                Context context = EMChat.getInstance().getAppContext();
                if (context != null && this.curOfflineMsg != null) {
                    context.sendOrderedBroadcast((Intent)object, null);
                    EMChatManager.getInstance().broadcastMessage(this.curOfflineMsg);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.offlineMsgUserSenders.clear();
            this.offlineMsgGrpSenders.clear();
        }
        if (this.offlineMessages.size() > 0) {
            object = new ArrayList();
            object.addAll(this.offlineMessages);
            EMNotifier.getInstance(EMChat.getInstance().getAppContext()).publishEvent(EMNotifierEvent.Event.EventOfflineMessage, object);
            this.offlineMessages.clear();
        }
    }

    void reset() {
        this.curOfflineMsg = null;
        this.preOfflineMsg = null;
        if (this.notifyThread != null) {
            this.notifyThread.interrupt();
        }
        this.offlineMsgUserSenders.clear();
        this.offlineMsgGrpSenders.clear();
        this.notifyThread = null;
        this.offlineMessages.clear();
        this.offlineCmdMessagesList.clear();
    }
}

