/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.chat;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.media.AudioManager;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import android.os.Vibrator;
import android.support.v4.app.NotificationCompat;
import com.easemob.EMEventListener;
import com.easemob.EMNotifierEvent;
import com.easemob.chat.EMChat;
import com.easemob.chat.EMChatManager;
import com.easemob.chat.EMContactManager;
import com.easemob.chat.EMMessage;
import com.easemob.chat.EMVoiceCallManager;
import com.easemob.chat.FileMessageBody;
import com.easemob.chat.OnMessageNotifyListener;
import com.easemob.chat.TextMessageBody;
import com.easemob.util.EMLog;
import com.easemob.util.EasyUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class EMNotifier {
    private static final String TAG = "notify";
    static Ringtone ringtone = null;
    private static final String[] msg_eng = new String[]{"sent a message", "sent a picture", "sent a voice", "sent location message", "sent a video", "sent a file", "%1 contacts sent %2 messages"};
    private static final String[] msg_ch = new String[]{"\u53d1\u6765\u4e00\u6761\u6d88\u606f", "\u53d1\u6765\u4e00\u5f20\u56fe\u7247", "\u53d1\u6765\u4e00\u6bb5\u8bed\u97f3", "\u53d1\u6765\u4f4d\u7f6e\u4fe1\u606f", "\u53d1\u6765\u4e00\u4e2a\u89c6\u9891", "\u53d1\u6765\u4e00\u4e2a\u6587\u4ef6", "%1\u4e2a\u8054\u7cfb\u4eba\u53d1\u6765%2\u6761\u6d88\u606f"};
    private static int notifyID = 341;
    private NotificationManager notificationManager = null;
    private HashSet<String> fromUsers = new HashSet();
    private int notificationNum = 0;
    private Context appContext;
    private String appName;
    private String packageName;
    private String[] msgs;
    private long lastNotifiyTime;
    private static EMNotifier instance;
    private OnMessageNotifyListener onMessageNotifyListener;
    private AudioManager audioManager;
    private Vibrator vibrator;
    private Hashtable<EMNotifierEvent.Event, List<EMEventListener>> filteredEventListeners = new Hashtable();
    private ExecutorService notifierThread = Executors.newSingleThreadExecutor();
    private ExecutorService newMsgQueue = Executors.newSingleThreadExecutor();

    private EMNotifier(Context context) {
        this.appContext = context;
        if (this.notificationManager == null) {
            this.notificationManager = (NotificationManager)context.getSystemService("notification");
        }
        this.onMessageNotifyListener = EMChatManager.getInstance().getChatOptions().onMessageNotifyListener;
        this.appName = this.appContext.getApplicationInfo().labelRes != 0 ? this.appContext.getString(this.appContext.getApplicationInfo().labelRes) : "";
        this.packageName = this.appContext.getApplicationInfo().packageName;
        this.msgs = Locale.getDefault().getLanguage().equals("zh") ? msg_ch : msg_eng;
        this.audioManager = (AudioManager)this.appContext.getSystemService("audio");
        this.vibrator = (Vibrator)this.appContext.getSystemService("vibrator");
    }

    public void clear() {
        this.filteredEventListeners.clear();
    }

    public static synchronized EMNotifier getInstance(Context context) {
        if (instance == null) {
            instance = new EMNotifier(context);
            return instance;
        }
        return instance;
    }

    public void stop() {
        if (ringtone != null) {
            ringtone.stop();
            ringtone = null;
        }
    }

    public void registerEventListener(EMEventListener eMEventListener) {
        if (eMEventListener == null) {
            return;
        }
        this.registerEventListener(eMEventListener, new EMNotifierEvent.Event[]{EMNotifierEvent.Event.EventNewCMDMessage, EMNotifierEvent.Event.EventNewMessage, EMNotifierEvent.Event.EventDeliveryAck, EMNotifierEvent.Event.EventOfflineMessage, EMNotifierEvent.Event.EventReadAck, EMNotifierEvent.Event.EventConversationListChanged});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventListener(EMEventListener eMEventListener) {
        if (eMEventListener == null) {
            return;
        }
        Hashtable<EMNotifierEvent.Event, List<EMEventListener>> hashtable = this.filteredEventListeners;
        synchronized (hashtable) {
            Collection<List<EMEventListener>> collection = this.filteredEventListeners.values();
            if (collection != null) {
                Iterator<List<EMEventListener>> iterator = collection.iterator();
                while (iterator.hasNext()) {
                    this.remove(iterator.next(), eMEventListener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEventListener(EMEventListener eMEventListener, EMNotifierEvent.Event[] eventArray) {
        Hashtable<EMNotifierEvent.Event, List<EMEventListener>> hashtable = this.filteredEventListeners;
        synchronized (hashtable) {
            EMNotifierEvent.Event[] eventArray2 = eventArray;
            int n2 = eventArray.length;
            int n3 = 0;
            while (n3 < n2) {
                EMNotifierEvent.Event event = eventArray2[n3];
                this.registerEventListener(eMEventListener, event);
                ++n3;
            }
        }
    }

    private void remove(List<EMEventListener> list, EMEventListener eMEventListener) {
        Iterator<EMEventListener> iterator = list.iterator();
        while (iterator.hasNext()) {
            EMEventListener eMEventListener2 = iterator.next();
            if (eMEventListener2 != eMEventListener) continue;
            iterator.remove();
        }
    }

    boolean publishEvent(final EMNotifierEvent.Event event, final Object object) {
        EMLog.d(TAG, "publish event, event type: " + event.toString());
        if (this.containsType(event)) {
            this.notifierThread.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Hashtable hashtable = EMNotifier.this.filteredEventListeners;
                    synchronized (hashtable) {
                        List list;
                        if (EMNotifier.this.containsType(event) && (list = (List)EMNotifier.this.filteredEventListeners.get((Object)event)) != null) {
                            Iterator iterator = list.iterator();
                            EMNotifier.this.publishEvent(iterator, event, object);
                        }
                    }
                }
            });
            return true;
        }
        return false;
    }

    private void registerEventListener(EMEventListener eMEventListener, EMNotifierEvent.Event event) {
        if (!this.filteredEventListeners.containsKey((Object)event)) {
            ArrayList<EMEventListener> arrayList = new ArrayList<EMEventListener>();
            arrayList.add(eMEventListener);
            this.filteredEventListeners.put(event, arrayList);
        } else {
            List<EMEventListener> list = this.filteredEventListeners.get((Object)event);
            if (!list.contains(eMEventListener)) {
                list.add(0, eMEventListener);
            }
        }
    }

    private boolean containsType(EMNotifierEvent.Event event) {
        return this.filteredEventListeners.containsKey((Object)event);
    }

    private void publishEvent(Iterator<EMEventListener> iterator, EMNotifierEvent.Event event, Object object) {
        while (iterator.hasNext()) {
            EMNotifierEvent eMNotifierEvent = new EMNotifierEvent();
            eMNotifierEvent.setEventData(object);
            eMNotifierEvent.setEvent(event);
            EMEventListener eMEventListener = iterator.next();
            if (eMEventListener == null) continue;
            eMEventListener.onEvent(eMNotifierEvent);
        }
    }

    void resetNotificationCount() {
        this.notificationNum = 0;
        this.fromUsers.clear();
    }

    void notifyChatMsg(final EMMessage eMMessage) {
        this.newMsgQueue.submit(new Runnable(){

            @Override
            public void run() {
                if (EMNotifier.this.publishEvent(EMNotifierEvent.Event.EventNewMessage, eMMessage)) {
                    return;
                }
                if (eMMessage.getBooleanAttribute("em_ignore_notification", false)) {
                    if (EasyUtils.isAppRunningForeground(EMNotifier.this.appContext)) {
                        EMNotifier.this.sendBroadcast(eMMessage);
                    }
                    return;
                }
                String string = null;
                List<String> list = null;
                if (eMMessage.chatType == EMMessage.ChatType.Chat) {
                    string = eMMessage.getFrom();
                    list = EMChatManager.getInstance().getChatOptions().getUsersOfNotificationDisabled();
                } else {
                    string = eMMessage.getTo();
                    list = EMChatManager.getInstance().getChatOptions().getGroupsOfNotificationDisabled();
                }
                if (EMChatManager.getInstance().getChatOptions().isShowNotificationInBackgroud() && !EasyUtils.isAppRunningForeground(EMNotifier.this.appContext)) {
                    EMLog.d(EMNotifier.TAG, "easemob chat app is not running, sending notification");
                    if (list == null || !list.contains(string)) {
                        EMNotifier.this.sendNotification(eMMessage);
                        EMNotifier.this.notifyOnNewMsg();
                    }
                    return;
                }
                EMNotifier.this.sendBroadcast(eMMessage);
                if (EMChat.getInstance().appInited && (list == null || !list.contains(string))) {
                    EMNotifier.this.notifyOnNewMsg();
                }
            }
        });
    }

    void sendReadAckMsgBroadcast(String string, String string2) {
        if (this.publishEvent(EMNotifierEvent.Event.EventReadAck, EMChatManager.getInstance().getMessage(string2))) {
            return;
        }
        Intent intent = new Intent(EMChatManager.getInstance().getAckMessageBroadcastAction());
        intent.putExtra("msgid", string2);
        intent.putExtra("from", string);
        EMLog.d(TAG, "send ack message broadcast for msg:" + string2);
        this.appContext.sendOrderedBroadcast(intent, null);
    }

    void sendDeliveryAckMsgBroadcast(String string, String string2) {
        if (this.publishEvent(EMNotifierEvent.Event.EventDeliveryAck, EMChatManager.getInstance().getMessage(string2))) {
            return;
        }
        Intent intent = new Intent(EMChatManager.getInstance().getDeliveryAckMessageBroadcastAction());
        intent.putExtra("msgid", string2);
        intent.putExtra("from", string);
        EMLog.d(TAG, "send delivery ack message broadcast for msg:" + string2);
        this.appContext.sendOrderedBroadcast(intent, null);
    }

    void sendBroadcast(EMMessage eMMessage) {
        Intent intent = new Intent(EMChatManager.getInstance().getNewMessageBroadcastAction());
        intent.putExtra("msgid", eMMessage.msgId);
        intent.putExtra("from", eMMessage.from.username);
        intent.putExtra("type", eMMessage.type.ordinal());
        EMLog.d(TAG, "send new message broadcast for msg:" + eMMessage.msgId);
        this.appContext.sendOrderedBroadcast(intent, null);
    }

    void sendCmdMsgBroadcast(EMMessage eMMessage) {
        if (this.publishEvent(EMNotifierEvent.Event.EventNewCMDMessage, eMMessage)) {
            return;
        }
        Context context = EMChat.getInstance().getAppContext();
        Intent intent = new Intent(EMChatManager.getInstance().getCmdMessageBroadcastAction());
        intent.putExtra("msgid", eMMessage.getMsgId());
        intent.putExtra("message", (Parcelable)eMMessage);
        EMLog.d(TAG, "received cmd message: " + eMMessage.getMsgId());
        context.sendOrderedBroadcast(intent, null);
    }

    private void sendNotification(EMMessage eMMessage) {
        String string = eMMessage.from.getNick();
        try {
            String string2;
            String string3;
            String string4;
            Object object;
            Object object2;
            String string5 = "";
            String string6 = String.valueOf(string) + " ";
            switch (eMMessage.type) {
                case TXT: {
                    string6 = String.valueOf(string6) + this.msgs[0];
                    object2 = (TextMessageBody)eMMessage.body;
                    string5 = object2.message;
                    break;
                }
                case IMAGE: {
                    string6 = String.valueOf(string6) + this.msgs[1];
                    break;
                }
                case VOICE: {
                    string6 = String.valueOf(string6) + this.msgs[2];
                    break;
                }
                case LOCATION: {
                    string6 = String.valueOf(string6) + this.msgs[3];
                    break;
                }
                case VIDEO: {
                    string6 = String.valueOf(string6) + this.msgs[4];
                    break;
                }
                case FILE: {
                    string6 = String.valueOf(string6) + this.msgs[5];
                    object = (FileMessageBody)eMMessage.body;
                    string5 = ((FileMessageBody)object).fileName;
                }
            }
            this.onMessageNotifyListener = EMChatManager.getInstance().getChatOptions().onMessageNotifyListener;
            object2 = this.appContext.getPackageManager();
            Object object3 = object = (String)object2.getApplicationLabel(this.appContext.getApplicationInfo());
            if (this.onMessageNotifyListener != null) {
                string4 = this.onMessageNotifyListener.onNewMessageNotify(eMMessage);
                string3 = this.onMessageNotifyListener.onSetNotificationTitle(eMMessage);
                if (string4 != null) {
                    string6 = string4;
                }
                if (string3 != null) {
                    object3 = string3;
                }
            }
            string4 = new NotificationCompat.Builder(this.appContext).setSmallIcon(this.appContext.getApplicationInfo().icon).setWhen(System.currentTimeMillis()).setAutoCancel(true);
            string3 = this.appContext.getPackageManager().getLaunchIntentForPackage(this.packageName);
            if (EMChatManager.getInstance().getChatOptions().onNotificationClickListener != null) {
                string3 = EMChatManager.getInstance().getChatOptions().onNotificationClickListener.onNotificationClick(eMMessage);
            }
            PendingIntent pendingIntent = PendingIntent.getActivity((Context)this.appContext, (int)notifyID, (Intent)string3, (int)0x10000000);
            ++this.notificationNum;
            this.fromUsers.add(eMMessage.getFrom());
            int n2 = this.fromUsers.size();
            String string7 = this.msgs[6].replaceFirst("%1", Integer.toString(n2)).replaceFirst("%2", Integer.toString(this.notificationNum));
            if (this.onMessageNotifyListener != null) {
                int n3;
                string2 = this.onMessageNotifyListener.onLatestMessageNotify(eMMessage, n2, this.notificationNum);
                if (string2 != null) {
                    string7 = string2;
                }
                if ((n3 = this.onMessageNotifyListener.onSetSmallIcon(eMMessage)) != 0) {
                    string4.setSmallIcon(n3);
                }
            }
            string4.setContentTitle((CharSequence)object3);
            string4.setTicker((CharSequence)string6);
            string4.setContentText((CharSequence)string7);
            string4.setContentIntent(pendingIntent);
            string2 = string4.build();
            try {
                this.notificationManager.cancel(notifyID);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.notificationManager.notify(notifyID, (Notification)string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void notifyOnNewMsg() {
        if (!EMChatManager.getInstance().getChatOptions().getNotificationEnable() || !EMChatManager.getInstance().getChatOptions().getNotifyBySoundAndVibrate()) {
            return;
        }
        try {
            Object object;
            if (System.currentTimeMillis() - this.lastNotifiyTime < 1000L) {
                return;
            }
            this.lastNotifiyTime = System.currentTimeMillis();
            if (this.audioManager.getRingerMode() == 0) {
                EMLog.e(TAG, "in slient mode now");
                return;
            }
            if (EMChatManager.getInstance().getChatOptions().getNoticedByVibrate()) {
                long[] lArray = new long[4];
                lArray[1] = 180L;
                lArray[2] = 80L;
                lArray[3] = 120L;
                object = lArray;
                this.vibrator.vibrate((long[])object, -1);
            }
            if (EMChatManager.getInstance().getChatOptions().getNoticedBySound()) {
                Object object2;
                object = Build.MANUFACTURER;
                if (ringtone == null) {
                    object2 = null;
                    object2 = EMChatManager.getInstance().getChatOptions().getNotifyRingUri() == null ? RingtoneManager.getDefaultUri((int)2) : EMChatManager.getInstance().getChatOptions().getNotifyRingUri();
                    ringtone = RingtoneManager.getRingtone((Context)this.appContext, (Uri)object2);
                    if (ringtone == null) {
                        EMLog.d(TAG, "cant find ringtone at:" + object2.getPath());
                        return;
                    }
                }
                if (!ringtone.isPlaying()) {
                    ringtone.play();
                    if (object != null && ((String)object).toLowerCase().contains("samsung")) {
                        object2 = new Thread(){

                            @Override
                            public void run() {
                                try {
                                    Thread.sleep(3000L);
                                    if (ringtone.isPlaying()) {
                                        ringtone.stop();
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        };
                        ((Thread)object2).run();
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void cancelNotificaton() {
        if (this.notificationManager != null) {
            this.notificationManager.cancel(notifyID);
        }
    }

    void sendIncomingVoiceCallBroadcast(String string, String string2) {
        String string3 = EMContactManager.getUserNameFromEid(string);
        Intent intent = new Intent(EMChatManager.getInstance().getIncomingCallBroadcastAction());
        intent.putExtra("from", string3);
        intent.putExtra("type", string2);
        EMLog.d(TAG, "send incoming call broadcaset with user : " + string3);
        if (EMVoiceCallManager.getInstance().getActiveSession() == null) {
            return;
        }
        if (string2 == EMVoiceCallManager.CallType.audio.toString()) {
            Intent intent2 = new Intent(EMChatManager.getInstance().getIncomingVoiceCallBroadcastAction());
            intent2.putExtra("from", string3);
            this.appContext.sendBroadcast(intent2, null);
        }
        this.appContext.sendBroadcast(intent, null);
    }
}

