/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.chat;

import android.graphics.Bitmap;
import com.easemob.chat.EMContact;
import com.easemob.chat.EMContactManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class EMMultiUserChatRoomModelBase
extends EMContact {
    protected String description;
    protected String owner;
    protected ArrayList<String> members;
    protected long lastModifiedTime;
    protected int maxUsers = 0;
    protected int affiliationsCount = -1;
    protected boolean isMsgBlocked = false;

    private void init() {
        this.lastModifiedTime = 0L;
        this.members = new ArrayList();
        this.description = "";
        this.owner = "";
    }

    protected EMMultiUserChatRoomModelBase() {
        this.init();
    }

    public EMMultiUserChatRoomModelBase(String string) {
        this.username = string;
        this.eid = EMContactManager.getEidFromGroupId(string);
        this.init();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String string) {
        this.owner = string;
    }

    public synchronized void addMember(String string) {
        this.members.add(string);
    }

    public synchronized void removeMember(String string) {
        this.members.remove(string);
    }

    public synchronized List<String> getMembers() {
        return Collections.unmodifiableList(this.members);
    }

    public synchronized void setMembers(List<String> list) {
        this.members.addAll(list);
    }

    public String getId() {
        return this.username;
    }

    public void setId(String string) {
        this.username = string;
        this.eid = EMContactManager.getEidFromGroupId(string);
    }

    public String getName() {
        return this.nick;
    }

    public void setName(String string) {
        this.nick = string;
    }

    public int getMaxUsers() {
        return this.maxUsers;
    }

    public void setMaxUsers(int n2) {
        this.maxUsers = n2;
    }

    public int getAffiliationsCount() {
        return this.affiliationsCount;
    }

    public void setAffiliationsCount(int n2) {
        this.affiliationsCount = n2;
    }

    public boolean getMsgBlocked() {
        return this.isMsgBlocked;
    }

    public boolean isMsgBlocked() {
        return this.isMsgBlocked;
    }

    public void setMsgBlocked(boolean bl) {
        this.isMsgBlocked = bl;
    }

    @Override
    public String toString() {
        return this.nick;
    }

    Bitmap getGroupAvator() {
        Exception exception = new Exception("group avator not supported yet");
        exception.printStackTrace();
        return null;
    }

    protected void copyModel(EMMultiUserChatRoomModelBase eMMultiUserChatRoomModelBase) {
        this.eid = eMMultiUserChatRoomModelBase.eid;
        this.description = eMMultiUserChatRoomModelBase.description;
        this.lastModifiedTime = System.currentTimeMillis();
        this.members.clear();
        this.members.addAll(eMMultiUserChatRoomModelBase.getMembers());
        this.nick = eMMultiUserChatRoomModelBase.nick;
        this.owner = eMMultiUserChatRoomModelBase.owner;
        this.username = eMMultiUserChatRoomModelBase.username;
        this.maxUsers = eMMultiUserChatRoomModelBase.maxUsers;
        this.affiliationsCount = eMMultiUserChatRoomModelBase.affiliationsCount;
        this.isMsgBlocked = eMMultiUserChatRoomModelBase.isMsgBlocked;
    }

    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public void setLastModifiedTime(long l2) {
        this.lastModifiedTime = l2;
    }
}

