/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.chat;

import com.easemob.chat.EMChatConfig;
import com.easemob.chat.EMChatManager;
import com.easemob.chat.EMSessionManager;
import com.easemob.chat.core.r;
import com.easemob.util.EMLog;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.muc.Affiliate;
import org.jivesoftware.smackx.muc.MultiUserChat;

class EMMultiUserChatProcessor
implements r {
    private static final String TAG = "EMMultiUserChatProcessor";
    private Map<String, MultiUserChat> multiUserChats = new ConcurrentHashMap<String, MultiUserChat>();
    XMPPConnection connection = null;

    EMMultiUserChatProcessor() {
    }

    @Override
    public void onInit() {
        this.connection = EMSessionManager.getInstance().getConnection();
        this.multiUserChats.clear();
    }

    @Override
    public void onDestroy() {
        this.multiUserChats.clear();
    }

    void joinMUC(String string, String string2) throws XMPPException {
        MultiUserChat multiUserChat = this.multiUserChats.get(string);
        if (multiUserChat == null) {
            multiUserChat = new MultiUserChat(this.connection, string);
        }
        multiUserChat.join(string2);
        EMLog.d(TAG, "joined muc:" + string);
        try {
            Collection<Affiliate> collection = multiUserChat.getMembers();
            EMLog.d(TAG, "  room members size:" + collection.size());
            for (Affiliate affiliate : collection) {
                EMLog.d(TAG, "  member jid:" + affiliate.getJid() + " role:" + affiliate.getRole());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    synchronized MultiUserChat getMUC(String string) throws XMPPException {
        return this.getMUC(string, 40000L);
    }

    synchronized MultiUserChat getMUC(String string, long l2) throws XMPPException {
        MultiUserChat multiUserChat;
        if (!string.contains("@")) {
            string = String.valueOf(string) + EMChatConfig.MUC_DOMAIN_SUFFIX;
        }
        if ((multiUserChat = this.multiUserChats.get(string)) == null) {
            multiUserChat = new MultiUserChat(this.connection, string);
            this.addMuc(string, multiUserChat);
        }
        if (!multiUserChat.isJoined()) {
            String string2 = EMChatManager.getInstance().getCurrentUser();
            multiUserChat.join(string2, l2);
            EMLog.d(TAG, "joined muc:" + multiUserChat.getRoom() + " with eid:" + string2);
        }
        return multiUserChat;
    }

    synchronized MultiUserChat getMUCWithoutJoin(String string) throws XMPPException {
        MultiUserChat multiUserChat;
        if (!string.contains("@")) {
            string = String.valueOf(string) + EMChatConfig.MUC_DOMAIN_SUFFIX;
        }
        if ((multiUserChat = this.multiUserChats.get(string)) == null) {
            multiUserChat = new MultiUserChat(this.connection, string);
            this.addMuc(string, multiUserChat);
        }
        return multiUserChat;
    }

    void deleteMUC(String string) throws XMPPException {
        MultiUserChat multiUserChat = this.getMUC(string);
        multiUserChat.destroy("delete-group", null);
    }

    void leaveMUC(String string, String string2) throws XMPPException {
        MultiUserChat multiUserChat = this.getMUC(string);
        multiUserChat.leave();
    }

    void leaveMUCWithoutJoin(String string) throws XMPPException {
        MultiUserChat multiUserChat = this.getMUCWithoutJoin(string);
        multiUserChat.leaveAndWait(20000L);
    }

    void leaveMUCRemoveMember(String string, String string2) throws XMPPException {
        MultiUserChat multiUserChat = null;
        try {
            multiUserChat = this.getMUC(string);
        }
        catch (XMPPException xMPPException) {
            if (xMPPException.getMessage().contains("403") || xMPPException.getMessage().contains("407")) {
                return;
            }
            throw new XMPPException(xMPPException);
        }
        try {
            multiUserChat.grantMembership(string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        multiUserChat.leave();
        try {
            multiUserChat.revokeMembership(string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void addMuc(String string, MultiUserChat multiUserChat) {
        this.multiUserChats.put(string, multiUserChat);
    }

    void removeMuc(String string) {
        this.multiUserChats.remove(string);
    }
}

