/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.chat;

import com.easemob.EMChatRoomChangeListener;
import com.easemob.EMGroupChangeListener;
import com.easemob.EMValueCallBack;
import com.easemob.chat.EMChatRoom;
import com.easemob.chat.EMChatRoomManager;
import com.easemob.chat.EMContactManager;
import com.easemob.chat.EMCursorResult;
import com.easemob.chat.EMGroup;
import com.easemob.chat.EMGroupInfo;
import com.easemob.chat.EMGroupManager;
import com.easemob.chat.EMMessage;
import com.easemob.chat.EMMultiUserChatRoomModelBase;
import com.easemob.chat.EMRestResultParser;
import com.easemob.chat.EMSessionManager;
import com.easemob.chat.core.r;
import com.easemob.chat.core.x;
import com.easemob.exceptions.EaseMobException;
import com.easemob.util.EMLog;
import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.OrFilter;
import org.jivesoftware.smack.filter.PacketExtensionFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smackx.muc.InvitationListener;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.packet.MUCUser;
import org.json.JSONException;
import org.json.JSONObject;

final class EMMultiUserChatManager
implements r {
    private static final String TAG = "EMMultiUserChatManager";
    private static final String MUC_ELEMENT_NAME = "x";
    public static final String MUC_NS_USER = "http://jabber.org/protocol/muc#user";
    private static EMMultiUserChatManager instance = null;
    private EMMUCInvitationListener invitationListener = null;
    private EMChatRoomManager chatRoomManager = new EMChatRoomManager();
    private EMGroupManager groupChatManager = EMGroupManager.getInstance();

    private EMMultiUserChatManager() {
    }

    public static synchronized EMMultiUserChatManager getInstance() {
        if (instance == null) {
            instance = new EMMultiUserChatManager();
        }
        return instance;
    }

    public void loadLocalData() {
        this.groupChatManager.loadAllGroups();
    }

    public void addChatRoomChangeListener(EMChatRoomChangeListener eMChatRoomChangeListener) {
        this.chatRoomManager.addChangeListener(eMChatRoomChangeListener);
    }

    public void removeChatRoomChangeListener(EMChatRoomChangeListener eMChatRoomChangeListener) {
        this.chatRoomManager.removeChangeListener(eMChatRoomChangeListener);
    }

    void joinChatRoom(String string) throws EaseMobException {
        this.chatRoomManager.joinChatRoom(string);
    }

    public void joinChatRoom(String string, EMValueCallBack<EMChatRoom> eMValueCallBack) {
        this.chatRoomManager.joinChatRoom(string, eMValueCallBack);
    }

    void leaveChatRoom(String string) {
        this.chatRoomManager.exitChatRoom(string, null);
    }

    List<EMChatRoom> fetchJoinedChatRoomsFromServer() throws EaseMobException {
        return this.chatRoomManager.getJoinedChatRooms();
    }

    public EMCursorResult<EMChatRoom> fetchPublicChatRoomsFromServer(int n2, String string) throws EaseMobException {
        return this.chatRoomManager.getChatRoomsFromServer(n2, string);
    }

    public EMChatRoom fetchChatRoomFromServer(String string) throws EaseMobException {
        return this.chatRoomManager.getChatRoomFromServer(string);
    }

    public EMChatRoom getChatRoom(String string) {
        return this.chatRoomManager.getChatRoom(string);
    }

    public List<EMChatRoom> getAllChatRooms() {
        return new ArrayList<EMChatRoom>(this.chatRoomManager.getAllChatRoom().values());
    }

    public void addGroupChangeListener(EMGroupChangeListener eMGroupChangeListener) {
        this.groupChatManager.addGroupChangeListener(eMGroupChangeListener);
    }

    public void removeGroupChangeListener(EMGroupChangeListener eMGroupChangeListener) {
        this.groupChatManager.removeGroupChangeListener(eMGroupChangeListener);
    }

    public void joinGroup(String string) throws EaseMobException {
        this.groupChatManager.joinGroup(string);
    }

    public void leaveGroup(String string) throws EaseMobException {
        this.groupChatManager.exitFromGroup(string);
    }

    public void dismissGroup(String string) throws EaseMobException {
        this.groupChatManager.exitAndDeleteGroup(string);
    }

    public List<EMGroup> fetchJoinedGroupsFromServer() throws EaseMobException {
        return this.groupChatManager.getGroupsFromServer();
    }

    public EMGroup fetchGroupFromServer(String string) throws EaseMobException {
        return this.groupChatManager.getGroupFromServer(string);
    }

    public EMCursorResult<EMGroupInfo> fetchPublicGroupsFromServer(int n2, String string) throws EaseMobException {
        return this.groupChatManager.getPublicGroupsFromServer(n2, string);
    }

    public EMGroup createPrivateGroup(String string, String string2, String[] stringArray, boolean bl, int n2) throws EaseMobException {
        return this.groupChatManager.createPrivateGroup(string, string2, stringArray, bl, n2);
    }

    public EMGroup createPublicGroup(String string, String string2, String[] stringArray, boolean bl, int n2) throws EaseMobException {
        return this.groupChatManager.createPublicGroup(string, string2, stringArray, bl, n2);
    }

    public List<EMGroup> getAllGroups() {
        return this.groupChatManager.getAllGroups();
    }

    public EMGroup getGroup(String string) {
        return this.groupChatManager.getGroup(string);
    }

    public void addUsersToGroup(String string, String[] stringArray) throws EaseMobException {
        this.groupChatManager.addUsersToGroup(string, stringArray);
    }

    public void removeUserFromGroup(String string, String string2) throws EaseMobException {
        this.groupChatManager.removeUserFromGroup(string, string2);
    }

    public EMGroup createOrUpdateLocalGroup(EMGroup eMGroup) {
        return this.groupChatManager.createOrUpdateLocalGroup(eMGroup);
    }

    public void changeGroupName(String string, String string2) throws EaseMobException {
        this.groupChatManager.changeGroupName(string, string2);
    }

    public void acceptInvitation(String string) throws EaseMobException {
        this.groupChatManager.acceptInvitation(string);
    }

    public void acceptApplication(String string, String string2) throws EaseMobException {
        this.groupChatManager.acceptApplication(string, string2);
    }

    public void declineApplication(String string, String string2, String string3) throws EaseMobException {
        this.groupChatManager.declineApplication(string, string2, string3);
    }

    public void setAutoAcceptInvitation(boolean bl) {
        this.groupChatManager.setAutoAcceptInvitation(bl);
    }

    public void inviteUser(String string, String[] stringArray, String string2) throws EaseMobException {
        this.groupChatManager.inviteUser(string, stringArray, string2);
    }

    public void applyJoinToGroup(String string, String string2) throws EaseMobException {
        this.groupChatManager.applyJoinToGroup(string, string2);
    }

    public void blockGroupMessage(String string) throws EaseMobException {
        this.groupChatManager.blockGroupMessage(string);
    }

    public void unblockGroupMessage(String string) throws EaseMobException {
        this.groupChatManager.unblockGroupMessage(string);
    }

    public void blockUser(String string, String string2) throws EaseMobException {
        this.groupChatManager.blockUser(string, string2);
    }

    public void unblockUser(String string, String string2) throws EaseMobException {
        this.groupChatManager.unblockUser(string, string2);
    }

    public List<String> getBlockedUsers(String string) throws EaseMobException {
        return this.groupChatManager.getBlockedUsers(string);
    }

    EMMultiUserChatRoomModelBase getRoom(String string) {
        EMMultiUserChatRoomModelBase eMMultiUserChatRoomModelBase = this.chatRoomManager.getChatRoom(string);
        if (eMMultiUserChatRoomModelBase == null) {
            eMMultiUserChatRoomModelBase = this.groupChatManager.getGroup(string);
        }
        return eMMultiUserChatRoomModelBase;
    }

    MultiUserChat getMUCWithoutJoin(String string, EMMessage.ChatType chatType) throws XMPPException {
        if (chatType == EMMessage.ChatType.ChatRoom) {
            return this.chatRoomManager.getMUCWithoutJoin(string);
        }
        if (chatType == EMMessage.ChatType.GroupChat) {
            return this.groupChatManager.getMUCWithoutJoin(string);
        }
        return null;
    }

    x getRoomTypeExtension(Packet packet) {
        x x2 = null;
        try {
            x2 = (x)packet.getExtension("roomtype", "easemob:x:roomtype");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return x2;
    }

    void clearRooms() {
        this.groupChatManager.clear();
    }

    @Override
    public void onInit() {
        EMLog.d(TAG, "init EMMultiUserChatManager");
        this.invitationListener = new EMMUCInvitationListener();
        MultiUserChat.addInvitationListener(EMSessionManager.getInstance().getConnection(), this.invitationListener);
        AndFilter andFilter = new AndFilter(new MessageTypeFilter(Message.Type.notify), new PacketExtensionFilter(MUC_ELEMENT_NAME, MUC_NS_USER));
        AndFilter andFilter2 = new AndFilter(new PacketTypeFilter(Presence.class), new PacketExtensionFilter("roomtype", "easemob:x:roomtype"));
        OrFilter orFilter = new OrFilter(andFilter, andFilter2);
        EMMUCPresenceListener eMMUCPresenceListener = new EMMUCPresenceListener();
        EMSessionManager.getInstance().getConnection().addPacketListener(eMMUCPresenceListener, orFilter);
        this.chatRoomManager.onInit();
        this.groupChatManager.onInit();
    }

    @Override
    public void onDestroy() {
        if (this.invitationListener != null && EMSessionManager.getInstance().getConnection() != null) {
            try {
                MultiUserChat.removeInvitationListener(EMSessionManager.getInstance().getConnection(), this.invitationListener);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.chatRoomManager.onDestroy();
        this.groupChatManager.onDestroy();
    }

    public void onAppReady() {
        this.chatRoomManager.processOfflineMessages();
        this.groupChatManager.processOfflineMessages();
    }

    void parseRoom(EMMultiUserChatRoomModelBase eMMultiUserChatRoomModelBase, boolean bl, JSONObject jSONObject) throws JSONException {
        EMRestResultParser.parseRoom(eMMultiUserChatRoomModelBase, bl, jSONObject);
    }

    private class EMMUCInvitationListener
    implements InvitationListener {
        private EMMUCInvitationListener() {
        }

        @Override
        public void invitationReceived(Connection connection, String string, String string2, String string3, String string4, Message message) {
            EMLog.d(EMMultiUserChatManager.TAG, "invitation received room:" + string + " inviter:" + string2 + " reason:" + string3 + " message:" + message.getBody());
            String string5 = EMContactManager.getUserNameFromEid(string2);
            String string6 = EMContactManager.getGroupIdFromEid(string);
            x x2 = EMMultiUserChatManager.this.getRoomTypeExtension(message);
            if (x2 != null && x2.a() == x.a.a) {
                EMMultiUserChatManager.this.chatRoomManager.onInvitation(string6, string5, string3);
            } else {
                EMMultiUserChatManager.this.groupChatManager.onInvitation(string6, string5, string3);
            }
        }
    }

    private class EMMUCPresenceListener
    implements PacketListener {
        private static final String ITEM_DESTROY = "destroy";
        private static final String ITEM_EXITMUC = "<item affiliation=\"none\" role=\"none\">";
        private static final String AFFILIATION_NONE = "affiliation=\"none\"";
        private static final String ROLE_NONE = "role=\"none\"";
        private static final String ROLE_PARTICIPANT = "role=\"participant\"";

        private EMMUCPresenceListener() {
        }

        @Override
        public synchronized void processPacket(Packet packet) {
            try {
                Packet packet2 = packet;
                MUCUser mUCUser = (MUCUser)packet2.getExtension(EMMultiUserChatManager.MUC_ELEMENT_NAME, EMMultiUserChatManager.MUC_NS_USER);
                if (mUCUser != null) {
                    String string;
                    String string2 = mUCUser.toXML();
                    boolean bl = false;
                    x x2 = EMMultiUserChatManager.this.getRoomTypeExtension(packet2);
                    if (x2 != null && x2.a() == x.a.a) {
                        bl = true;
                    }
                    if (!bl && packet2 instanceof Presence) {
                        return;
                    }
                    if (mUCUser.getStatus() != null && (string = mUCUser.getStatus().getCode()) != null && string.contains("307")) {
                        if (!bl) {
                            EMMultiUserChatManager.this.groupChatManager.handleUserRemove(packet.getFrom());
                        } else {
                            EMMultiUserChatManager.this.chatRoomManager.handleUserRemove(packet.getFrom());
                        }
                        return;
                    }
                    if (packet2 instanceof Presence && ((Presence)packet2).getType() != Presence.Type.unavailable || packet2 instanceof Message && ((Message)packet2).getPresenceType() != Message.PresenceType.unavailable) {
                        if (string2.contains(ROLE_PARTICIPANT) && bl) {
                            EMMultiUserChatManager.this.chatRoomManager.onMemberJoined(packet.getFrom());
                        }
                    } else {
                        if (mUCUser.getStatus() != null && (string = mUCUser.getStatus().getCode()) != null && string.contains("110")) {
                            if (bl) {
                                EMMultiUserChatManager.this.chatRoomManager.onMemberExit(packet.getFrom());
                            }
                            return;
                        }
                        if (string2.contains(ITEM_DESTROY)) {
                            string = packet.getFrom();
                            if (!bl) {
                                String string3 = EMContactManager.getGroupIdFromEid(string);
                                if (EMMultiUserChatManager.this.chatRoomManager.getChatRoom(string3) != null) {
                                    EMMultiUserChatManager.this.chatRoomManager.handleRoomDestroy(string);
                                } else {
                                    EMMultiUserChatManager.this.groupChatManager.handleRoomDestroy(string);
                                }
                            } else {
                                EMMultiUserChatManager.this.chatRoomManager.handleRoomDestroy(string);
                            }
                        } else if (string2.contains(AFFILIATION_NONE) && string2.contains(ROLE_NONE)) {
                            if (bl) {
                                EMMultiUserChatManager.this.chatRoomManager.onMemberExit(packet.getFrom());
                            } else {
                                EMMultiUserChatManager.this.groupChatManager.handleUserRemove(packet.getFrom());
                            }
                        } else if (string2.contains(ROLE_NONE) && bl) {
                            EMMultiUserChatManager.this.chatRoomManager.onMemberExit(packet.getFrom());
                        }
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

