/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.chat;

import com.easemob.chat.CmdMessageBody;
import com.easemob.chat.EMChat;
import com.easemob.chat.EMChatConfig;
import com.easemob.chat.EMChatManager;
import com.easemob.chat.EMMessage;
import com.easemob.chat.EMReceiveMessageThread;
import com.easemob.chat.EMSessionManager;
import com.easemob.chat.FileMessageBody;
import com.easemob.chat.MessageEncoder;
import com.easemob.chat.core.a;
import com.easemob.chat.core.c;
import com.easemob.chat.core.i;
import com.easemob.chat.core.x;
import com.easemob.util.DateUtils;
import com.easemob.util.EMLog;
import com.easemob.util.PathUtil;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.util.StringUtils;

class EMMessageListener
implements PacketListener {
    private static final String TAG = "chat";
    private static final String INTERNAL_ACTION_PREFIX = "em_";
    protected String previousFrom = "";
    protected String previousBody = "";
    protected long previousTime = System.currentTimeMillis();
    protected EMChatManager chatManager = null;
    protected ExecutorService recvThreadPool = null;
    protected long previousPacketTime;
    protected ArrayBlockingQueue<String> recentMsgIdQueue;
    protected static final int RECENT_QUEUE_SIZE = 20;

    public EMMessageListener(EMChatManager eMChatManager) {
        this.chatManager = eMChatManager;
        this.recvThreadPool = Executors.newCachedThreadPool();
        this.recentMsgIdQueue = new ArrayBlockingQueue(20);
    }

    protected static void ackMessage(Message message) {
        String string = message.getPacketID();
        if (string == null || string.equals("")) {
            return;
        }
        Message message2 = new Message();
        message2.setPacketID(string);
        message2.setTo(EMChatConfig.DOMAIN);
        message2.setFrom(message.getTo());
        a a2 = new a("received");
        a2.setValue("id", string);
        message2.addExtension(a2);
        EMSessionManager.getInstance().getConnection().sendPacket(message2);
        EMLog.d(TAG, "send ack message back to server:" + message2);
        if (message.getType() == Message.Type.chat && EMChatManager.getInstance().getChatOptions().getRequireDeliveryAck()) {
            Message message3 = new Message();
            message3.setTo(message.getFrom());
            message3.setFrom(message.getTo());
            a a3 = new a("delivery");
            a3.setValue("id", string);
            message3.addExtension(a3);
            message3.setBody(string);
            EMLog.d(TAG, "send delivered ack msg to:" + message.getFrom() + " for msg:" + string);
            message3.setType(Message.Type.normal);
            EMSessionManager.getInstance().getConnection().sendPacket(message3);
            i.a().g(string, true);
        }
    }

    x getRoomTypeExtension(Packet packet) {
        x x2 = null;
        try {
            x2 = (x)packet.getExtension("roomtype", "easemob:x:roomtype");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return x2;
    }

    x.a getRoomType(Packet packet) {
        x x2 = this.getRoomTypeExtension(packet);
        if (x2 != null) {
            return x2.a();
        }
        return null;
    }

    protected boolean isDuplicateMsg(Message message) {
        x x2 = this.getRoomTypeExtension(message);
        if (x2 != null && x2.a() == x.a.a) {
            return false;
        }
        boolean bl = false;
        if (message.getFrom().equals(this.previousFrom) && message.getBody().equals(this.previousBody) && System.currentTimeMillis() - this.previousTime < 1000L) {
            EMLog.d(TAG, "ignore duplicate msg with same from and body:" + this.previousFrom);
            bl = true;
        }
        this.previousFrom = message.getFrom();
        this.previousBody = message.getBody();
        this.previousTime = System.currentTimeMillis();
        String string = message.getPacketID();
        if (string == null) {
            return bl;
        }
        for (String string2 : this.recentMsgIdQueue) {
            if (!string.equals(string2)) continue;
            EMLog.d(TAG, "ignore duplicate msg:" + message);
            return true;
        }
        if (this.recentMsgIdQueue.size() == 20) {
            try {
                this.recentMsgIdQueue.poll();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.recentMsgIdQueue.add(message.getPacketID());
        bl = false;
        return bl;
    }

    protected boolean processMessage(Message message) {
        EMMessageListener.ackMessage(message);
        if (message.getBody() == null || message.getBody().equals("")) {
            return true;
        }
        if (this.isDuplicateMsg(message)) {
            EMLog.d(TAG, "ignore duplicate msg");
            return true;
        }
        String string = StringUtils.parseBareAddress(message.getFrom());
        EMLog.d(TAG, "chat listener receive msg from:" + string + " body:" + message.getBody());
        if (message.getType() != Message.Type.chat) {
            return false;
        }
        EMMessage eMMessage = MessageEncoder.parseXmppMsg(message);
        if (message.getExtension("encrypt", "jabber:client") != null) {
            eMMessage.setAttribute("isencrypted", true);
        }
        return this.processEMMessage(eMMessage);
    }

    protected boolean processEMMessage(EMMessage eMMessage) {
        if (eMMessage == null) {
            return false;
        }
        if (eMMessage.getMsgId() == null) {
            eMMessage.msgId = DateUtils.getTimestampStr();
        }
        if (eMMessage.type == EMMessage.Type.CMD) {
            this.handleCmdMessage(eMMessage);
            return true;
        }
        if (eMMessage.body instanceof FileMessageBody && eMMessage.getType() != EMMessage.Type.FILE) {
            this.setLocalUrl(eMMessage);
            boolean bl = eMMessage.getBooleanAttribute("isencrypted", false);
            EMReceiveMessageThread eMReceiveMessageThread = new EMReceiveMessageThread(eMMessage, bl);
            this.recvThreadPool.execute(eMReceiveMessageThread);
        } else {
            if (eMMessage.getType() == EMMessage.Type.FILE) {
                this.setLocalUrl(eMMessage);
            }
            eMMessage.status = EMMessage.Status.SUCCESS;
        }
        EMChatManager.getInstance().saveMessage(eMMessage);
        if (eMMessage.offline) {
            this.chatManager.onNewOfflineMessage(eMMessage);
        } else {
            this.chatManager.notifyMessage(eMMessage);
        }
        return true;
    }

    private void handleCmdMessage(EMMessage eMMessage) {
        CmdMessageBody cmdMessageBody = (CmdMessageBody)eMMessage.getBody();
        String string = cmdMessageBody.action;
        if (string.startsWith(INTERNAL_ACTION_PREFIX)) {
            if (this.isAdvanceDebugMessage(string)) {
                c.a a2 = c.a.valueOf(string);
                c.a().a(eMMessage, a2);
                return;
            }
            this.handleNormalCmdMessage(eMMessage);
        } else {
            this.handleNormalCmdMessage(eMMessage);
        }
    }

    private boolean isAdvanceDebugMessage(String string) {
        if (string.startsWith(INTERNAL_ACTION_PREFIX)) {
            try {
                c.a.valueOf(string);
                return true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return false;
    }

    private void handleNormalCmdMessage(EMMessage eMMessage) {
        if (EMChat.getInstance().appInited) {
            EMChatManager.getInstance().notifyCmdMsg(eMMessage);
        } else {
            EMChatManager.getInstance().onNewOfflineCmdMessage(eMMessage);
        }
    }

    protected void setLocalUrl(EMMessage eMMessage) {
        FileMessageBody fileMessageBody = (FileMessageBody)eMMessage.body;
        String string = fileMessageBody.remoteUrl.substring(fileMessageBody.remoteUrl.lastIndexOf("/") + 1);
        fileMessageBody.localUrl = eMMessage.type == EMMessage.Type.IMAGE ? PathUtil.getInstance().getImagePath() + "/" + string : (eMMessage.type == EMMessage.Type.VOICE ? (!EMChatManager.getInstance().getChatOptions().getAudioFileWithExt() ? PathUtil.getInstance().getVoicePath() + "/" + string : PathUtil.getInstance().getVoicePath() + "/" + string + ".amr") : (eMMessage.type == EMMessage.Type.VIDEO ? PathUtil.getInstance().getVideoPath() + "/" + string : (eMMessage.type == EMMessage.Type.FILE ? PathUtil.getInstance().getFilePath() + "/" + fileMessageBody.fileName : PathUtil.getInstance().getVideoPath() + "/" + string)));
    }

    @Override
    public synchronized void processPacket(Packet packet) {
        Message message;
        if (!(packet instanceof Message)) {
            EMLog.d(TAG, "packet is not message, skip");
            return;
        }
        if (System.currentTimeMillis() - this.previousPacketTime >= 120000L) {
            this.previousPacketTime = System.currentTimeMillis();
            message = EMSessionManager.getInstance().getWakeLock();
            if (message != null && !message.isHeld()) {
                EMLog.d(TAG, "temp acquire 3s");
                message.acquire(3000L);
            }
        }
        message = (Message)packet;
        this.processMessage(message);
    }

    void clear() {
        this.recentMsgIdQueue.clear();
    }
}

