/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.chat;

import android.content.ContentValues;
import android.text.TextUtils;
import com.easemob.EMCallBack;
import com.easemob.EMMessageChangeEventData;
import com.easemob.chat.EMChatManager;
import com.easemob.chat.EMCloudOperationCallback;
import com.easemob.chat.EMContactManager;
import com.easemob.chat.EMConversationManager;
import com.easemob.chat.EMEncryptUtils;
import com.easemob.chat.EMMessage;
import com.easemob.chat.EMMessageUtils;
import com.easemob.chat.EMSendMessageRunnable;
import com.easemob.chat.EMSessionManager;
import com.easemob.chat.FileMessageBody;
import com.easemob.chat.ImageMessageBody;
import com.easemob.chat.MessageEncoder;
import com.easemob.chat.VideoMessageBody;
import com.easemob.chat.core.a;
import com.easemob.chat.core.i;
import com.easemob.chat.core.r;
import com.easemob.cloud.EMHttpClient;
import com.easemob.exceptions.EaseMobException;
import com.easemob.util.EMLog;
import com.easemob.util.PathUtil;
import java.io.File;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;

class EMMessageHandler
implements r {
    private static final String TAG = EMMessageHandler.class.getSimpleName();
    private static final EMMessageHandler me = new EMMessageHandler();
    ExecutorService sendThreadPool = Executors.newCachedThreadPool();
    PacketListener errorMsgLlistener = new PacketListener(){

        private void updateMessage(String string, int n2) {
            EMMessage eMMessage = EMChatManager.getInstance().getMessage(string);
            if (eMMessage != null) {
                EMMessage.Status status = eMMessage.status;
                eMMessage.setError(n2);
                eMMessage.status = EMMessage.Status.FAIL;
                EMChatManager.getInstance().updateMessageState(eMMessage);
                if (!EMSendMessageRunnable.notifyErrorMsgWaitLock(string)) {
                    EMMessageChangeEventData eMMessageChangeEventData = new EMMessageChangeEventData();
                    eMMessageChangeEventData.source = EMMessageChangeEventData.EMChangeSource.MessageState;
                    eMMessageChangeEventData.changedMsg = eMMessage;
                    eMMessageChangeEventData.setNewValue(EMMessage.Status.FAIL);
                    eMMessageChangeEventData.setOldValue(status);
                    EMChatManager.getInstance().notifyMessageChanged(eMMessageChangeEventData);
                }
            }
        }

        @Override
        public void processPacket(Packet packet) {
            String string = packet.getPacketID();
            EMLog.e(TAG, "received error, id=" + string);
            int n2 = packet.getError().getCode();
            if (n2 == 406) {
                this.updateMessage(string, -2000);
            } else if (n2 == 408) {
                EMMessage eMMessage = EMChatManager.getInstance().getMessage(string);
                if (eMMessage == null) {
                    EMLog.d(TAG, "the message : " + string + " is not found in sdk!");
                    return;
                }
                this.updateMessage(string, -2001);
            }
        }
    };

    EMMessageHandler() {
    }

    public static EMMessageHandler getInstance() {
        return me;
    }

    public void sendGroupMessage(EMMessage eMMessage, EMCallBack eMCallBack) {
        block7: {
            try {
                if (eMMessage.getChatType() == null || eMMessage.getChatType() == EMMessage.ChatType.Chat) {
                    eMMessage.setChatType(EMMessage.ChatType.GroupChat);
                }
                if (eMMessage.msgId == null) {
                    eMMessage.msgId = EMMessageUtils.getUniqueMessageId();
                }
                if (eMMessage.getType() != EMMessage.Type.CMD) {
                    EMConversationManager.getInstance().saveMessage(eMMessage);
                }
                eMMessage.status = EMMessage.Status.INPROGRESS;
                eMMessage.from = EMSessionManager.getInstance().currentUser;
                String string = eMMessage.getTo();
                if (eMMessage.getChatType() == EMMessage.ChatType.GroupChat) {
                    EMLog.d(TAG, "start send group message:" + string + " message:" + eMMessage.toString());
                } else {
                    EMLog.d(TAG, "start send chat room message:" + string + " message:" + eMMessage.toString());
                }
                EMSendMessageRunnable eMSendMessageRunnable = new EMSendMessageRunnable(string, eMMessage, eMCallBack);
                this.sendThreadPool.execute(eMSendMessageRunnable);
            }
            catch (Exception exception) {
                eMMessage.status = EMMessage.Status.FAIL;
                ContentValues contentValues = new ContentValues();
                contentValues.put("status", String.valueOf(eMMessage.status.ordinal()));
                i.a().a(eMMessage.msgId, contentValues);
                exception.printStackTrace();
                if (eMCallBack == null) break block7;
                EMMessageUtils.asyncCallback(eMCallBack, -2, exception.getLocalizedMessage());
            }
        }
    }

    public void sendMessage(Chat chat, EMMessage eMMessage, EMCallBack eMCallBack) {
        try {
            if (eMMessage.msgId == null) {
                eMMessage.msgId = EMMessageUtils.getUniqueMessageId();
            }
            if (eMMessage.getType() != EMMessage.Type.CMD) {
                EMConversationManager.getInstance().saveMessage(eMMessage);
            }
            eMMessage.status = EMMessage.Status.INPROGRESS;
            eMMessage.from = EMSessionManager.getInstance().currentUser;
            EMSendMessageRunnable eMSendMessageRunnable = new EMSendMessageRunnable(chat, eMMessage, eMCallBack);
            this.sendThreadPool.execute(eMSendMessageRunnable);
        }
        catch (Exception exception) {
            eMMessage.status = EMMessage.Status.FAIL;
            ContentValues contentValues = new ContentValues();
            contentValues.put("status", String.valueOf(eMMessage.status.ordinal()));
            i.a().a(eMMessage.msgId, contentValues);
            exception.printStackTrace();
            EMMessageUtils.asyncCallback(eMCallBack, -2, exception.getLocalizedMessage());
        }
    }

    public void asyncFetchMessage(final EMMessage eMMessage) {
        String string;
        final FileMessageBody fileMessageBody = (FileMessageBody)eMMessage.body;
        String string2 = fileMessageBody.localUrl;
        String string3 = fileMessageBody.remoteUrl;
        String string4 = fileMessageBody.fileName;
        if (TextUtils.isEmpty((CharSequence)string3)) {
            if (fileMessageBody.downloadCallback != null) {
                fileMessageBody.downloadCallback.onError(-1, "remoteUrl is null or empty");
            }
            if (eMMessage.messageStatusCallBack != null) {
                eMMessage.messageStatusCallBack.onError(-1, "remoteUrl is null or empty");
            }
            return;
        }
        if (eMMessage.type == EMMessage.Type.IMAGE) {
            if (!TextUtils.isEmpty((CharSequence)((ImageMessageBody)fileMessageBody).thumbnailUrl)) {
                string3 = ((ImageMessageBody)fileMessageBody).thumbnailUrl;
            }
        } else if (eMMessage.type != EMMessage.Type.VOICE && eMMessage.type == EMMessage.Type.VIDEO) {
            string3 = ((VideoMessageBody)fileMessageBody).thumbnailUrl;
        }
        eMMessage.status = EMMessage.Status.INPROGRESS;
        if (eMMessage.type == EMMessage.Type.IMAGE) {
            string4 = "th" + string3.substring(string3.lastIndexOf("/") + 1, string3.length());
            string = PathUtil.getInstance().getImagePath() + "/" + string4;
        } else if (eMMessage.type == EMMessage.Type.VIDEO) {
            string4 = string3.substring(string3.lastIndexOf("/") + 1, string3.length());
            ((VideoMessageBody)fileMessageBody).localThumb = string = PathUtil.getInstance().getImagePath() + "/" + string4;
            ((VideoMessageBody)fileMessageBody).localUrl = PathUtil.getInstance().getVideoPath() + "/" + string4 + ".mp4";
        } else if (eMMessage.type == EMMessage.Type.VOICE) {
            string4 = string3.substring(string3.lastIndexOf("/") + 1, string3.length());
            fileMessageBody.localUrl = string = PathUtil.getInstance().getVoicePath() + "/" + string4;
        } else if (eMMessage.type == EMMessage.Type.FILE) {
            fileMessageBody.localUrl = string = PathUtil.getInstance().getFilePath() + "/" + string4;
        } else {
            string = string2;
        }
        if (TextUtils.isEmpty((CharSequence)string4) || string4.equals("th")) {
            eMMessage.status = EMMessage.Status.FAIL;
            this.updateMsgState(eMMessage);
            if (fileMessageBody.downloadCallback != null) {
                fileMessageBody.downloadCallback.onError(-1, "fileName is null or empty");
            }
            return;
        }
        final String string5 = string;
        EMLog.d(TAG, "localUrl:" + fileMessageBody.localUrl + " remoteurl:" + string3);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (eMMessage.type == EMMessage.Type.IMAGE) {
            String string6 = ((ImageMessageBody)fileMessageBody).thumbnailSecret;
            if (TextUtils.isEmpty((CharSequence)string6)) {
                string6 = fileMessageBody.secret;
            }
            if (!TextUtils.isEmpty((CharSequence)string6)) {
                hashMap.put("share-secret", string6);
            }
        } else if (eMMessage.type == EMMessage.Type.VIDEO) {
            String string7 = ((VideoMessageBody)fileMessageBody).thumbnailSecret;
            if (!TextUtils.isEmpty((CharSequence)string7)) {
                hashMap.put("share-secret", string7);
            }
        } else if (eMMessage.type == EMMessage.Type.VOICE && fileMessageBody.secret != null) {
            hashMap.put("share-secret", fileMessageBody.secret);
        }
        if (eMMessage.type == EMMessage.Type.IMAGE || eMMessage.type == EMMessage.Type.VIDEO) {
            hashMap.put("thumbnail", "true");
        }
        EMHttpClient.getInstance().downloadFile(string3, string5, hashMap, new EMCloudOperationCallback(){

            @Override
            public void onSuccess(String string2) {
                File file = new File(string5);
                EMLog.d(TAG, "file downloaded:" + string5 + " size:" + file.length());
                if (EMChatManager.getInstance().getChatOptions().getUseEncryption()) {
                    EMEncryptUtils.decryptFile(file.getAbsolutePath(), eMMessage.getFrom());
                }
                fileMessageBody.downloaded = true;
                eMMessage.status = EMMessage.Status.SUCCESS;
                EMMessageHandler.this.updateMsgState(eMMessage);
                eMMessage.progress = 100;
                if (fileMessageBody.downloadCallback != null) {
                    fileMessageBody.downloadCallback.onProgress(100, null);
                    fileMessageBody.downloadCallback.onSuccess();
                }
                if (eMMessage.messageStatusCallBack != null) {
                    eMMessage.messageStatusCallBack.onProgress(100, null);
                    eMMessage.messageStatusCallBack.onSuccess();
                }
                if (eMMessage.type == EMMessage.Type.VOICE || eMMessage.type == EMMessage.Type.VIDEO) {
                    EMMessageHandler.this.updateMsgBody(eMMessage);
                }
            }

            @Override
            public void onError(String string2) {
                eMMessage.status = EMMessage.Status.FAIL;
                EMLog.e(TAG, "download file localThumbnailFilePath:" + string5 + ",error:" + string2);
                if (string != null && new File(string).exists()) {
                    File file = new File(string);
                    try {
                        if (file.isFile()) {
                            file.delete();
                        }
                    }
                    catch (Exception exception) {
                        EMLog.d(TAG, "temp file del fail." + string);
                    }
                }
                EMMessageHandler.this.updateMsgState(eMMessage);
                if (fileMessageBody.downloadCallback != null) {
                    fileMessageBody.downloadCallback.onError(-1, string2);
                }
                if (eMMessage.messageStatusCallBack != null) {
                    eMMessage.messageStatusCallBack.onError(-998, string2);
                }
            }

            @Override
            public void onProgress(int n2) {
                eMMessage.progress = n2;
                if (fileMessageBody.downloadCallback != null) {
                    fileMessageBody.downloadCallback.onProgress(n2, null);
                }
                if (eMMessage.messageStatusCallBack != null) {
                    eMMessage.messageStatusCallBack.onProgress(n2, null);
                }
            }
        });
    }

    public void ackMessageRead(String string, String string2, String string3) throws EaseMobException {
        Message message = new Message();
        String string4 = EMContactManager.getEidFromUserName(string2);
        try {
            a a2 = new a("acked");
            a2.setValue("id", string3);
            message.addExtension(a2);
            message.setBody(string3);
            EMLog.d(TAG, "send ack msg to:" + string2 + " for msg:" + string3);
            message.setType(Message.Type.normal);
            message.setTo(string4);
            String string5 = EMContactManager.getEidFromUserName(string);
            message.setFrom(string5);
            EMSessionManager.getInstance().getConnection().sendPacket(message);
            EMMessage eMMessage = EMChatManager.getInstance().getMessage(string3);
            if (eMMessage != null) {
                eMMessage.setAcked(true);
            }
            i.a().e(string3, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new EaseMobException(exception.getMessage());
        }
    }

    private void updateMsgState(EMMessage eMMessage) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("status", Integer.valueOf(eMMessage.status.ordinal()));
        i.a().a(eMMessage.getMsgId(), contentValues);
    }

    private void updateMsgBody(EMMessage eMMessage) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("msgbody", MessageEncoder.getJSONMsg(eMMessage, true));
        i.a().a(eMMessage.getMsgId(), contentValues);
    }

    void onConnected() {
        EMSendMessageRunnable.notifySendMsgLocks();
        EMSendMessageRunnable.flushPendingQueue();
    }

    @Override
    public void onInit() {
        EMSendMessageRunnable.onInit();
        MessageTypeFilter messageTypeFilter = new MessageTypeFilter(Message.Type.error);
        XMPPConnection xMPPConnection = EMSessionManager.getInstance().getConnection();
        xMPPConnection.addPacketListener(this.errorMsgLlistener, messageTypeFilter);
    }

    @Override
    public void onDestroy() {
        EMSendMessageRunnable.onDestroy();
    }
}

