/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.chat;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Pair;
import com.easemob.EMCallBack;
import com.easemob.chat.EMChatManager;
import com.easemob.chat.EMContact;
import com.easemob.chat.EMContactManager;
import com.easemob.chat.EMMessageUtils;
import com.easemob.chat.EMSessionManager;
import com.easemob.chat.ImageMessageBody;
import com.easemob.chat.LocationMessageBody;
import com.easemob.chat.MessageBody;
import com.easemob.chat.NormalFileMessageBody;
import com.easemob.chat.TextMessageBody;
import com.easemob.chat.VideoMessageBody;
import com.easemob.chat.VoiceMessageBody;
import com.easemob.exceptions.EaseMobException;
import com.easemob.util.EMLog;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EMMessage
implements Parcelable,
Cloneable {
    private static final String TAG = "msg";
    EMCallBack messageStatusCallBack;
    Type type;
    public Direct direct;
    public Status status = Status.CREATE;
    EMContact from;
    EMContact to;
    MessageBody body;
    String msgId;
    public boolean isAcked = false;
    public boolean isDelivered = false;
    long msgTime;
    ChatType chatType = ChatType.Chat;
    public transient int progress = 0;
    Hashtable<String, Object> attributes = new Hashtable();
    transient boolean unread = true;
    transient boolean offline = false;
    boolean isListened;
    static final String ATTR_ENCRYPTED = "isencrypted";
    private int error = 0;
    public static final Parcelable.Creator<EMMessage> CREATOR = new Parcelable.Creator<EMMessage>(){

        public EMMessage createFromParcel(Parcel parcel) {
            return new EMMessage(parcel, null);
        }

        public EMMessage[] newArray(int n2) {
            return new EMMessage[n2];
        }
    };

    EMMessage(Type type) {
        this.type = type;
        this.msgTime = System.currentTimeMillis();
    }

    public Type getType() {
        return this.type;
    }

    public MessageBody getBody() {
        return this.body;
    }

    public long getMsgTime() {
        return this.msgTime;
    }

    public void setMsgTime(long l2) {
        this.msgTime = l2;
    }

    public static EMMessage createSendMessage(Type type) {
        EMMessage eMMessage = new EMMessage(type);
        eMMessage.direct = Direct.SEND;
        EMContact eMContact = EMSessionManager.getInstance().currentUser;
        if (eMContact == null) {
            String string = EMSessionManager.getInstance().getLastLoginUser();
            eMContact = EMContactManager.getInstance().getContactByUserName(string);
        }
        eMMessage.from = eMContact;
        eMMessage.setMsgId(EMMessageUtils.getUniqueMessageId());
        return eMMessage;
    }

    public static EMMessage createReceiveMessage(Type type) {
        EMMessage eMMessage = new EMMessage(type);
        eMMessage.direct = Direct.RECEIVE;
        eMMessage.to = EMSessionManager.getInstance().currentUser;
        return eMMessage;
    }

    public static EMMessage createTxtSendMessage(String string, String string2) {
        if (string.length() > 0) {
            EMMessage eMMessage = EMMessage.createSendMessage(Type.TXT);
            TextMessageBody textMessageBody = new TextMessageBody(string);
            eMMessage.addBody(textMessageBody);
            eMMessage.setReceipt(string2);
            return eMMessage;
        }
        EMLog.e(TAG, "text content size must be greater than 10");
        return null;
    }

    public static EMMessage createVoiceSendMessage(String string, int n2, String string2) {
        if (!new File(string).exists()) {
            EMLog.e(TAG, "voice file does not exsit");
            return null;
        }
        EMMessage eMMessage = EMMessage.createSendMessage(Type.VOICE);
        VoiceMessageBody voiceMessageBody = new VoiceMessageBody(new File(string), n2);
        eMMessage.addBody(voiceMessageBody);
        eMMessage.setReceipt(string2);
        return eMMessage;
    }

    public static EMMessage createImageSendMessage(String string, boolean bl, String string2) {
        if (!new File(string).exists()) {
            EMLog.e(TAG, "image file does not exsit");
            return null;
        }
        EMMessage eMMessage = EMMessage.createSendMessage(Type.IMAGE);
        eMMessage.setReceipt(string2);
        ImageMessageBody imageMessageBody = new ImageMessageBody(new File(string));
        imageMessageBody.setSendOriginalImage(bl);
        eMMessage.addBody(imageMessageBody);
        return eMMessage;
    }

    public static EMMessage createVideoSendMessage(String string, String string2, int n2, String string3) {
        File file = new File(string);
        if (!file.exists()) {
            EMLog.e(TAG, "video file does not exist");
            return null;
        }
        EMMessage eMMessage = EMMessage.createSendMessage(Type.VIDEO);
        eMMessage.setReceipt(string3);
        VideoMessageBody videoMessageBody = new VideoMessageBody(file, string2, n2, file.length());
        eMMessage.addBody(videoMessageBody);
        return eMMessage;
    }

    public static EMMessage createLocationSendMessage(double d2, double d3, String string, String string2) {
        EMMessage eMMessage = EMMessage.createSendMessage(Type.LOCATION);
        LocationMessageBody locationMessageBody = new LocationMessageBody(string, d2, d3);
        eMMessage.addBody(locationMessageBody);
        eMMessage.setReceipt(string2);
        return eMMessage;
    }

    public static EMMessage createFileSendMessage(String string, String string2) {
        File file = new File(string);
        if (!file.exists()) {
            EMLog.e(TAG, "file does not exist");
            return null;
        }
        EMMessage eMMessage = EMMessage.createSendMessage(Type.FILE);
        eMMessage.setReceipt(string2);
        NormalFileMessageBody normalFileMessageBody = new NormalFileMessageBody(new File(string));
        eMMessage.addBody(normalFileMessageBody);
        return eMMessage;
    }

    public void addBody(MessageBody messageBody) {
        this.body = messageBody;
    }

    public String getFrom() {
        if (this.from == null) {
            return null;
        }
        return this.from.username;
    }

    public void setFrom(String string) {
        EMContact eMContact = new EMContact();
        eMContact.setUsername(string);
        this.from = eMContact;
    }

    public void setTo(String string) {
        EMContact eMContact = new EMContact();
        eMContact.setUsername(string);
        this.to = eMContact;
    }

    public String getTo() {
        if (this.to == null) {
            return null;
        }
        return this.to.username;
    }

    public String getMsgId() {
        return this.msgId;
    }

    public void setMsgId(String string) {
        this.msgId = string;
    }

    public void setReceipt(String string) {
        EMContactManager eMContactManager = EMContactManager.getInstance();
        EMContact eMContact = null;
        if (string.contains("@")) {
            EMLog.e(TAG, "error wrong uesrname format:" + string);
        } else {
            eMContact = eMContactManager.getContactByUserName(string);
        }
        if (eMContact == null) {
            eMContact = new EMContact(string);
        }
        this.to = eMContact;
    }

    public void setMessageStatusCallback(EMCallBack eMCallBack) {
        this.messageStatusCallBack = eMCallBack;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("msg{from:" + this.from.username);
        stringBuffer.append(", to:" + this.to.username);
        stringBuffer.append(" body:" + this.body.toString());
        return stringBuffer.toString();
    }

    public void setAttribute(String string, boolean bl) {
        if (this.attributes == null) {
            this.attributes = new Hashtable();
        }
        this.attributes.put(string, bl);
    }

    public void setAttribute(String string, int n2) {
        if (this.attributes == null) {
            this.attributes = new Hashtable();
        }
        this.attributes.put(string, n2);
    }

    public void setAttribute(String string, JSONObject jSONObject) {
        if (this.attributes == null) {
            this.attributes = new Hashtable();
        }
        this.attributes.put(string, jSONObject);
    }

    public void setAttribute(String string, JSONArray jSONArray) {
        if (this.attributes == null) {
            this.attributes = new Hashtable();
        }
        this.attributes.put(string, jSONArray);
    }

    public void setAttribute(String string, String string2) {
        if (this.attributes == null) {
            this.attributes = new Hashtable();
        }
        this.attributes.put(string, string2);
    }

    public boolean getBooleanAttribute(String string) throws EaseMobException {
        Boolean bl = null;
        if (this.attributes != null) {
            Object object = this.attributes.get(string);
            if (object instanceof Boolean) {
                bl = (Boolean)object;
            } else if (object instanceof Integer) {
                int n2 = (Integer)object;
                bl = n2 > 0 ? Boolean.valueOf(true) : Boolean.valueOf(false);
            }
        }
        if (bl == null) {
            throw new EaseMobException("attribute " + string + " not found");
        }
        return bl;
    }

    public boolean getBooleanAttribute(String string, boolean bl) {
        if (this.attributes == null) {
            return bl;
        }
        Boolean bl2 = null;
        try {
            bl2 = this.getBooleanAttribute(string);
        }
        catch (EaseMobException easeMobException) {
            // empty catch block
        }
        if (bl2 == null) {
            return bl;
        }
        return bl2;
    }

    public int getIntAttribute(String string, int n2) {
        Integer n3 = null;
        if (this.attributes != null) {
            n3 = (Integer)this.attributes.get(string);
        }
        if (n3 == null) {
            return n2;
        }
        return n3;
    }

    public int getIntAttribute(String string) throws EaseMobException {
        Integer n2 = null;
        if (this.attributes != null) {
            n2 = (Integer)this.attributes.get(string);
        }
        if (n2 == null) {
            throw new EaseMobException("attribute " + string + " not found");
        }
        return n2;
    }

    public String getStringAttribute(String string) throws EaseMobException {
        if (this.attributes != null && this.attributes.containsKey(string)) {
            Object object = this.attributes.get(string);
            if (object instanceof String) {
                return (String)object;
            }
            if (object instanceof JSONObject) {
                return ((JSONObject)object).toString();
            }
            if (object instanceof JSONArray) {
                return ((JSONArray)object).toString();
            }
            throw new EaseMobException("attribute " + string + " not String type");
        }
        throw new EaseMobException("attribute " + string + " not found");
    }

    public String getStringAttribute(String string, String string2) {
        if (this.attributes != null && this.attributes.containsKey(string)) {
            Object object = this.attributes.get(string);
            if (object instanceof String) {
                return (String)object;
            }
            if (object instanceof JSONObject) {
                return ((JSONObject)object).toString();
            }
            if (object instanceof JSONArray) {
                return ((JSONArray)object).toString();
            }
        }
        return string2;
    }

    public JSONObject getJSONObjectAttribute(String string) throws EaseMobException {
        if (this.attributes != null && this.attributes.containsKey(string)) {
            Object object = this.attributes.get(string);
            if (object instanceof JSONObject) {
                return (JSONObject)object;
            }
            if (object instanceof String) {
                try {
                    JSONObject jSONObject = new JSONObject((String)object);
                    return jSONObject;
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
            throw new EaseMobException("attribute " + string + " not JSONObject type");
        }
        throw new EaseMobException("attribute " + string + " not found");
    }

    public JSONArray getJSONArrayAttribute(String string) throws EaseMobException {
        if (this.attributes != null && this.attributes.containsKey(string)) {
            Object object = this.attributes.get(string);
            if (object instanceof JSONArray) {
                return (JSONArray)object;
            }
            if (object instanceof String) {
                try {
                    JSONArray jSONArray = new JSONArray((String)object);
                    return jSONArray;
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
            throw new EaseMobException("attribute " + string + " not JSONArray type");
        }
        throw new EaseMobException("attribute " + string + " not found");
    }

    public ChatType getChatType() {
        return this.chatType;
    }

    public void setChatType(ChatType chatType) {
        this.chatType = chatType;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeString(this.type.name());
        parcel.writeString(this.direct.name());
        parcel.writeString(this.msgId);
        parcel.writeLong(this.msgTime);
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        for (Map.Entry<String, Object> pair : this.attributes.entrySet()) {
            if (pair.getValue() == null) continue;
            if (pair.getValue() instanceof JSONObject) {
                arrayList.add(Pair.create((Object)pair.getKey(), (Object)((JSONObject)pair.getValue())));
                continue;
            }
            if (pair.getValue() instanceof JSONArray) {
                arrayList2.add(Pair.create((Object)pair.getKey(), (Object)((JSONArray)pair.getValue())));
                continue;
            }
            hashtable.put(pair.getKey(), pair.getValue());
        }
        parcel.writeInt(arrayList.size());
        for (Pair pair : arrayList) {
            parcel.writeString((String)pair.first);
            parcel.writeString(((JSONObject)pair.second).toString());
        }
        parcel.writeInt(arrayList2.size());
        for (Pair pair : arrayList2) {
            parcel.writeString((String)pair.first);
            parcel.writeString(((JSONArray)pair.second).toString());
        }
        parcel.writeMap(hashtable);
        parcel.writeParcelable((Parcelable)this.from, n2);
        parcel.writeParcelable((Parcelable)this.to, n2);
        parcel.writeParcelable((Parcelable)this.body, n2);
        parcel.writeString(this.chatType.name());
    }

    private EMMessage(Parcel parcel) {
        String string;
        this.type = Type.valueOf(parcel.readString());
        this.direct = Direct.valueOf(parcel.readString());
        this.msgId = parcel.readString();
        this.msgTime = parcel.readLong();
        this.attributes = new Hashtable();
        int n2 = parcel.readInt();
        int n3 = 0;
        while (n3 < n2) {
            String string2 = parcel.readString();
            string = null;
            try {
                string = new JSONObject(parcel.readString());
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            this.attributes.put(string2, string);
            ++n3;
        }
        n3 = parcel.readInt();
        int n4 = 0;
        while (n4 < n3) {
            string = parcel.readString();
            JSONArray jSONArray = null;
            try {
                jSONArray = new JSONArray(parcel.readString());
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            this.attributes.put(string, jSONArray);
            ++n4;
        }
        Hashtable hashtable = new Hashtable();
        parcel.readMap(hashtable, null);
        this.attributes.putAll(hashtable);
        this.from = (EMContact)parcel.readParcelable(EMMessage.class.getClassLoader());
        this.to = (EMContact)parcel.readParcelable(EMMessage.class.getClassLoader());
        this.body = (MessageBody)parcel.readParcelable(EMMessage.class.getClassLoader());
        this.chatType = ChatType.valueOf(parcel.readString());
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean isAcked() {
        return this.isAcked;
    }

    public void setAcked(boolean bl) {
        this.isAcked = bl;
    }

    public boolean isDelivered() {
        return this.isDelivered;
    }

    public void setDelivered(boolean bl) {
        this.isDelivered = bl;
    }

    public boolean isUnread() {
        return this.unread;
    }

    public void setUnread(boolean bl) {
        this.unread = bl;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public boolean isListened() {
        return this.isListened;
    }

    public void setListened(boolean bl) {
        this.isListened = bl;
    }

    public String getUserName() {
        String string = "";
        string = this.getFrom() != null && this.getFrom().equals(EMChatManager.getInstance().getCurrentUser()) ? this.getTo() : this.getFrom();
        return string;
    }

    void setError(int n2) {
        this.error = n2;
    }

    public int getError() {
        return this.error;
    }

    /* synthetic */ EMMessage(Parcel parcel, EMMessage eMMessage) {
        this(parcel);
    }

    public static enum ChatType {
        Chat,
        GroupChat,
        ChatRoom;

    }

    public static enum Direct {
        SEND,
        RECEIVE;

    }

    public static enum Status {
        SUCCESS,
        FAIL,
        INPROGRESS,
        CREATE;

    }

    public static enum Type {
        TXT,
        IMAGE,
        VIDEO,
        LOCATION,
        VOICE,
        FILE,
        CMD;

    }
}

