/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.chat;

import com.easemob.a.a;
import com.easemob.chat.EMChat;
import com.easemob.chat.EMStreamParams;
import com.easemob.chat.EMVideoCallHelper;
import com.easemob.chat.EMVoiceCallManager;
import com.easemob.media.AVNative;
import com.easemob.media.EMVideoCallBridge;
import com.easemob.media.IGxStatusCallback;
import com.easemob.util.EMLog;
import com.easemob.util.EasyUtils;
import com.xonami.javaBells.MediaType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.CandidatePacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.CandidateType;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.ContentPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.IceUdpTransportPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.JingleIQ;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.RtpDescriptionPacketExtension;
import org.json.JSONArray;
import org.json.JSONObject;

class EMJingleStreamManager {
    private static final String TAG = EMJingleStreamManager.class.getSimpleName();
    private final ContentPacketExtension.CreatorEnum creator;
    private ContentPacketExtension.SendersEnum senders;
    private List<String> mediaNames = new ArrayList<String>();
    private AVNative avNative = null;
    private EMVideoCallBridge videoBridge = EMVideoCallBridge.getInstance();
    private boolean isVideoCall = false;
    private EMStreamParams streamParams;
    private long callStartTime;
    int callCostTime;

    EMJingleStreamManager(ContentPacketExtension.CreatorEnum creatorEnum) {
        this.creator = creatorEnum;
        this.mediaNames.add(EMVoiceCallManager.CallType.audio.toString());
        this.isVideoCall = false;
    }

    EMJingleStreamManager(ContentPacketExtension.CreatorEnum creatorEnum, EMVoiceCallManager.CallType callType) {
        this(creatorEnum);
        if (EMVoiceCallManager.CallType.video == callType) {
            this.mediaNames.add(callType.toString());
            this.isVideoCall = true;
        }
    }

    List<String> getMediaNames() {
        return Collections.unmodifiableList(this.mediaNames);
    }

    boolean addDefaultMedia(MediaType mediaType, String string) {
        return true;
    }

    List<ContentPacketExtension> createContentList(ContentPacketExtension.SendersEnum sendersEnum) {
        this.senders = sendersEnum;
        ArrayList<ContentPacketExtension> arrayList = new ArrayList<ContentPacketExtension>();
        for (String string : this.mediaNames) {
            arrayList.add(this.createContentPacketExtention(sendersEnum, string));
        }
        return arrayList;
    }

    List<ContentPacketExtension> createcontentList(String string) {
        List<ContentPacketExtension> list;
        try {
            list = this.createContentList(ContentPacketExtension.SendersEnum.both);
            for (ContentPacketExtension contentPacketExtension : list) {
                String string2 = contentPacketExtension.getName();
                IceUdpTransportPacketExtension iceUdpTransportPacketExtension = this.getLocalCandidatePacketExtensionForStream(string2, string);
                contentPacketExtension.addChildExtension(iceUdpTransportPacketExtension);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return list;
    }

    IceUdpTransportPacketExtension getLocalCandidatePacketExtensionForStream(String string, String string2) throws Exception {
        IceUdpTransportPacketExtension iceUdpTransportPacketExtension = null;
        iceUdpTransportPacketExtension = new IceUdpTransportPacketExtension();
        JSONObject jSONObject = new JSONObject(string2);
        iceUdpTransportPacketExtension.setPassword(jSONObject.getString("pwd"));
        iceUdpTransportPacketExtension.setUfrag(jSONObject.getString("ufrag"));
        JSONArray jSONArray = jSONObject.getJSONArray("candidates");
        int n2 = 0;
        while (n2 < jSONArray.length()) {
            CandidatePacketExtension candidatePacketExtension = new CandidatePacketExtension();
            JSONObject jSONObject2 = jSONArray.getJSONObject(n2);
            int n3 = jSONObject2.getInt("component");
            if (!(string.equals(EMVoiceCallManager.CallType.audio.toString()) && n3 > 2 || string.equals(EMVoiceCallManager.CallType.video.toString()) && n3 < 3)) {
                if (n3 > 2) {
                    n3 -= 2;
                }
                candidatePacketExtension.setComponent(n3);
                candidatePacketExtension.setFoundation(jSONObject2.getString("foundation"));
                candidatePacketExtension.setGeneration(Integer.parseInt(jSONObject2.getString("generation")));
                candidatePacketExtension.setID(String.valueOf(jSONObject2.getInt("id")));
                candidatePacketExtension.setIP(jSONObject2.getString("ip"));
                candidatePacketExtension.setNetwork(jSONObject2.getInt("network"));
                candidatePacketExtension.setPort(jSONObject2.getInt("port"));
                candidatePacketExtension.setPriority(jSONObject2.getLong("priority"));
                candidatePacketExtension.setProtocol(jSONObject2.getString("protocol"));
                if (jSONObject2.has("rel-addr")) {
                    candidatePacketExtension.setRelAddr(jSONObject2.getString("rel-addr"));
                }
                if (jSONObject2.has("rel-port")) {
                    candidatePacketExtension.setRelPort(jSONObject2.getInt("rel-port"));
                }
                candidatePacketExtension.setType(CandidateType.valueOf(jSONObject2.getString("type")));
                iceUdpTransportPacketExtension.addCandidate(candidatePacketExtension);
            }
            ++n2;
        }
        return iceUdpTransportPacketExtension;
    }

    boolean isVideoCall() {
        return this.isVideoCall;
    }

    private ContentPacketExtension createContentPacketExtention(ContentPacketExtension.SendersEnum sendersEnum, String string) {
        this.senders = sendersEnum;
        ContentPacketExtension contentPacketExtension = new ContentPacketExtension();
        RtpDescriptionPacketExtension rtpDescriptionPacketExtension = new RtpDescriptionPacketExtension();
        contentPacketExtension.setCreator(this.creator);
        contentPacketExtension.setName(string);
        if (sendersEnum != null && sendersEnum != ContentPacketExtension.SendersEnum.both) {
            contentPacketExtension.setSenders(sendersEnum);
        }
        contentPacketExtension.addChildExtension(rtpDescriptionPacketExtension);
        rtpDescriptionPacketExtension.setMedia(string);
        return contentPacketExtension;
    }

    List<ContentPacketExtension> parseIncomingAndBuildMedia(JingleIQ jingleIQ, ContentPacketExtension.SendersEnum sendersEnum) throws IOException {
        return this.parseIncomingAndBuildMedia(jingleIQ.getContentList(), sendersEnum);
    }

    List<ContentPacketExtension> parseIncomingAndBuildMedia(List<ContentPacketExtension> list, ContentPacketExtension.SendersEnum sendersEnum) throws IOException {
        this.senders = sendersEnum;
        String string = null;
        String string2 = null;
        ArrayList<ContentPacketExtension> arrayList = new ArrayList<ContentPacketExtension>();
        for (ContentPacketExtension contentPacketExtension : list) {
            string2 = string = contentPacketExtension.getName();
            if (string == null) {
                throw new IOException();
            }
            String string3 = null;
            List<RtpDescriptionPacketExtension> list2 = contentPacketExtension.getChildExtensionsOfType(RtpDescriptionPacketExtension.class);
            for (RtpDescriptionPacketExtension rtpDescriptionPacketExtension : list2) {
                EMLog.d(TAG, "SIP description : " + rtpDescriptionPacketExtension);
                string3 = rtpDescriptionPacketExtension.getMedia();
                if ("audio".equals(string3)) {
                    arrayList.add(this.createContentPacketExtention(sendersEnum, string3));
                    continue;
                }
                if ("video".equals(string3)) {
                    this.isVideoCall = true;
                    arrayList.add(this.createContentPacketExtention(sendersEnum, string3));
                    continue;
                }
                throw new IOException("Unknown media type: " + string3);
            }
            if (string3 != null) continue;
            throw new IOException();
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList;
    }

    void initStreamParams(EMStreamParams eMStreamParams) {
        this.streamParams = eMStreamParams;
    }

    void startStream(final EMStreamParams eMStreamParams) {
        if (eMStreamParams == null) {
            return;
        }
        this.streamParams = eMStreamParams;
        if (this.avNative != null) {
            return;
        }
        this.avNative = new AVNative();
        final IGxStatusCallback iGxStatusCallback = new IGxStatusCallback(){

            @Override
            public void updateStatus(int n2) {
                EMLog.i(TAG, "call back status : " + String.valueOf(n2));
            }
        };
        EMLog.i(TAG, "local port : " + eMStreamParams.localPort + ", video local port : " + eMStreamParams.videoLocalPort + ", local address : " + eMStreamParams.localAddress + ", server port : " + eMStreamParams.remotePort + ", video server port : " + eMStreamParams.videoRemotePort + ", server address : " + eMStreamParams.remoteAddress + ", video server address : " + eMStreamParams.videoRemoteAddress + ", channel number : " + eMStreamParams.channelId + ", video channel number : " + eMStreamParams.videoChannelId + ", conference id : " + eMStreamParams.conferenceId + ", rcode : " + eMStreamParams.rcode);
        long l2 = System.currentTimeMillis();
        int n2 = this.avNative.register(iGxStatusCallback, EMChat.getInstance().getAppContext(), eMStreamParams.localPort, eMStreamParams.localAddress, eMStreamParams.remotePort, eMStreamParams.remoteAddress, eMStreamParams.conferenceId, eMStreamParams.channelId, eMStreamParams.rcode, "12345678", eMStreamParams.isRelayCall, 0);
        EMLog.d(TAG, "call rigister time: " + (System.currentTimeMillis() - l2));
        if (n2 == -1) {
            EMLog.e(TAG, "call rigister fail");
        }
        this.avNative.setFullDuplexSpeech(eMStreamParams.conferenceId);
        if (this.isVideoCall) {
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    int n2 = 0;
                    int n3 = 0;
                    EMJingleStreamManager eMJingleStreamManager = EMJingleStreamManager.this;
                    synchronized (eMJingleStreamManager) {
                        EMJingleStreamManager.this.avNative.nativeInit(EMJingleStreamManager.this.videoBridge);
                        EMLog.d(TAG, "start native video");
                        if (EMVideoCallHelper.getInstance().getVideoOrientation() == EMVideoCallHelper.EMVideoOrientation.EMPortrait) {
                            n2 = a.a().g();
                            n3 = a.a().f();
                        } else {
                            n3 = a.a().g();
                            n2 = a.a().f();
                        }
                    }
                    boolean bl = true;
                    if (!EasyUtils.isAppRunningForeground(EMChat.getInstance().getAppContext())) {
                        bl = false;
                    }
                    EMJingleStreamManager.this.avNative.nativeStartVideo(iGxStatusCallback, eMStreamParams.videoLocalPort, eMStreamParams.videoRemotePort, eMStreamParams.videoRemoteAddress, eMStreamParams.conferenceId, eMStreamParams.videoChannelId, eMStreamParams.rcode, "12345678", n2, n3, a.a().h(), eMStreamParams.isRelayCall, bl);
                    EMJingleStreamManager eMJingleStreamManager2 = EMJingleStreamManager.this;
                    synchronized (eMJingleStreamManager2) {
                        if (EMJingleStreamManager.this.avNative != null) {
                            EMLog.d(TAG, "quit video call");
                            try {
                                EMJingleStreamManager.this.avNative.nativeQuit();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                        a.a().d();
                    }
                }
            }).start();
        }
        this.callStartTime = System.currentTimeMillis();
    }

    synchronized void stopStream() {
        if (this.streamParams != null && this.streamParams.conferenceId != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    EMVoiceCallManager.getInstance().removeP2PConference(((EMJingleStreamManager)EMJingleStreamManager.this).streamParams.conferenceId);
                }
            }).start();
        }
        if (this.avNative != null) {
            EMLog.d(TAG, "try to stop the stream");
            this.callCostTime = (int)((System.currentTimeMillis() - this.callStartTime) / 1000L);
            this.avNative.stop(this.streamParams.conferenceId);
            this.avNative.unregister(this.streamParams.conferenceId);
            if (this.mediaNames.contains(EMVoiceCallManager.CallType.video.toString())) {
                EMLog.e(TAG, "to stop video");
                this.avNative.nativeStopVideo();
            }
            this.avNative = null;
            EMLog.d(TAG, "the stream was stopped");
        }
        this.isVideoCall = false;
    }

    void pauseVoiceStream() {
        if (this.avNative != null && this.streamParams.conferenceId != null) {
            this.avNative.stop(this.streamParams.conferenceId);
        }
    }

    void resumeVoiceStream() {
        if (this.avNative != null && this.streamParams.conferenceId != null) {
            this.avNative.setFullDuplexSpeech(this.streamParams.conferenceId);
        }
    }

    int getVoiceInputLevel() {
        if (this.avNative != null && this.streamParams.conferenceId != null) {
            return this.avNative.GetAudioInputLevel(this.streamParams.conferenceId);
        }
        return 0;
    }

    boolean streamStarted() {
        return this.avNative != null;
    }
}

