/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.chat;

import android.content.Context;
import android.text.TextUtils;
import android.util.Pair;
import com.easemob.EMCallBack;
import com.easemob.EMValueCallBack;
import com.easemob.analytics.EMPerformanceCollector;
import com.easemob.analytics.EMTimeTag;
import com.easemob.chat.EMChat;
import com.easemob.chat.EMChatConfig;
import com.easemob.chat.EMChatManager;
import com.easemob.chat.EMContactManager;
import com.easemob.chat.EMCursorResult;
import com.easemob.chat.EMGroup;
import com.easemob.chat.EMGroupInfo;
import com.easemob.chat.EMMultiUserChatProcessor;
import com.easemob.chat.EMSessionManager;
import com.easemob.chat.GroupChangeListener;
import com.easemob.chat.core.i;
import com.easemob.chat.core.p;
import com.easemob.cloud.EMHttpClient;
import com.easemob.exceptions.EMExceptionUtils;
import com.easemob.exceptions.EMPermissionException;
import com.easemob.exceptions.EaseMobException;
import com.easemob.util.DateUtils;
import com.easemob.util.EMLog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketExtensionFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smackx.Form;
import org.jivesoftware.smackx.FormField;
import org.jivesoftware.smackx.muc.Affiliate;
import org.jivesoftware.smackx.muc.HostedRoom;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.RoomInfo;
import org.jivesoftware.smackx.muc.UserStatusListener;
import org.jivesoftware.smackx.packet.MUCUser;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EMGroupManager {
    private static String TAG = "group";
    public static final String MUC_NS_USER = "http://jabber.org/protocol/muc#user";
    private static final String PERMISSION_ERROR_ADD = "only group owner can add member";
    private static final String PERMISSION_ERROR_REMOVE = "only group owner can remove member";
    private static final String PERMISSION_ERROR_DELETE = "only group owner can delete group";
    private static final String PERMISSION_ERROR = "only group owner has this permission";
    private static final int DEFAULT_MAX_USERS = 200;
    Map<String, EMGroup> allGroups = new Hashtable<String, EMGroup>();
    private static EMGroupManager instance = new EMGroupManager();
    private Context appContext;
    ArrayList<GroupChangeListener> groupChangeListeners;
    boolean autoAcceptInvitation = true;
    ArrayList<GroupChangeEvent> offlineGroupEvents;
    private final MucApplyListener applyListener;
    private boolean allGroupLoaded = false;
    private ExecutorService threadPool = Executors.newCachedThreadPool();
    XMPPConnection connection = null;
    private EMMultiUserChatProcessor chatProcessor = null;
    private Object mutex = new Object();
    private boolean receivedQuery = false;

    private EMGroupManager() {
        this.groupChangeListeners = new ArrayList();
        this.offlineGroupEvents = new ArrayList();
        this.applyListener = new MucApplyListener();
        this.chatProcessor = new EMMultiUserChatProcessor();
    }

    public static EMGroupManager getInstance() {
        return instance;
    }

    private synchronized void syncLoadGroups(EMCallBack eMCallBack) {
        if (this.allGroupLoaded) {
            if (eMCallBack != null) {
                eMCallBack.onSuccess();
            }
            return;
        }
        this.loadGroups();
    }

    public void loadAllGroups(final EMCallBack eMCallBack) {
        new Thread(){

            @Override
            public void run() {
                EMGroupManager.this.syncLoadGroups(eMCallBack);
            }
        }.start();
    }

    public List<EMGroup> getAllGroups() {
        return Collections.unmodifiableList(new ArrayList<EMGroup>(this.allGroups.values()));
    }

    public EMGroup getGroup(String string) {
        return this.allGroups.get(string);
    }

    public void loadAllGroups() {
        this.syncLoadGroups(null);
    }

    private void loadGroups() {
        EMTimeTag eMTimeTag = new EMTimeTag();
        eMTimeTag.start();
        this.allGroups = i.a().f();
        EMLog.d(TAG, "load all groups from db. size:" + this.allGroups.values().size());
        this.allGroupLoaded = true;
        if (this.allGroups != null && this.allGroups.size() > 0) {
            EMPerformanceCollector.collectLoadAllLocalGroups(this.allGroups.size(), eMTimeTag.stop());
        }
    }

    public void joinGroupsAfterLogin() {
        Thread thread = new Thread(){

            @Override
            public void run() {
                List<EMGroup> list = EMGroupManager.this.getAllGroups();
                EMLog.d(TAG, "join groups. size:" + list.size());
                for (EMGroup eMGroup : list) {
                    String string = EMContactManager.getEidFromGroupId(eMGroup.getGroupId());
                    try {
                        EMGroupManager.this.chatProcessor.getMUC(string);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                EMLog.d(TAG, "join groups thread finished.");
            }
        };
        thread.start();
    }

    private String generateGroupId() {
        return DateUtils.getTimestampStr();
    }

    public EMGroup createPublicGroup(String string, String string2, String[] stringArray, boolean bl) throws EaseMobException {
        return this.createPublicGroup(string, string2, stringArray, bl, 200);
    }

    private String[] filterOwnerFromMembers(String string, String[] stringArray) throws EaseMobException {
        if (stringArray == null || stringArray.length < 1) {
            return stringArray;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < stringArray.length) {
            if (stringArray[n3].equals(string)) {
                ++n2;
            }
            if (stringArray[n3] == null || stringArray[n3].equals("")) {
                throw new EaseMobException("Your added a null number, Please add valid members!");
            }
            ++n3;
        }
        if (n2 == 0) {
            return stringArray;
        }
        n3 = stringArray.length - n2;
        if (n3 == 0) {
            throw new EaseMobException("Please add members who should not be the owner!");
        }
        String[] stringArray2 = new String[n3];
        int n4 = 0;
        int n5 = 0;
        while (n4 < stringArray.length) {
            if (!stringArray[n4].equals(string)) {
                stringArray2[n5] = stringArray[n4];
                ++n5;
            }
            ++n4;
        }
        return stringArray2;
    }

    public EMGroup createPublicGroup(String string, String string2, String[] stringArray, boolean bl, int n2) throws EaseMobException {
        String string3 = this.generateGroupId();
        String string4 = EMChatManager.getInstance().getCurrentUser();
        String string5 = EMContactManager.getEidFromGroupId(string3);
        String[] stringArray2 = this.filterOwnerFromMembers(string4, stringArray);
        if (stringArray2 == null && n2 < 1) {
            throw new EaseMobException(-1018, "the max group members are reached!");
        }
        if (stringArray2 != null && stringArray2.length >= n2) {
            throw new EaseMobException(-1018, "the max group members are reached!");
        }
        try {
            Object object;
            this.createPublicXmppMUC(string5, string, string2, string4, bl, n2);
            if (stringArray2 != null) {
                String[] stringArray3 = stringArray2;
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    object = stringArray3[n4];
                    String string6 = EMContactManager.getEidFromUserName((String)object);
                    this.addUserToMUC(string5, string6, true);
                    ++n4;
                }
            }
            object = new EMGroup(string3);
            ((EMGroup)object).setGroupName(string);
            ((EMGroup)object).setDescription(string2);
            ((EMGroup)object).setOwner(EMChatManager.getInstance().getCurrentUser());
            ((EMGroup)object).setPublic(true);
            ((EMGroup)object).setMaxUsers(n2);
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(((EMGroup)object).getOwner());
            if (stringArray2 != null) {
                String[] stringArray4 = stringArray2;
                int n5 = stringArray2.length;
                int n6 = 0;
                while (n6 < n5) {
                    String string7 = stringArray4[n6];
                    arrayList.add(string7);
                    ++n6;
                }
            }
            ((EMGroup)object).setMembers(arrayList);
            ((EMGroup)object).setAffiliationsCount(arrayList.size());
            i.a().a((EMGroup)object);
            this.allGroups.put(((EMGroup)object).getGroupId(), (EMGroup)object);
            return object;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new EaseMobException(exception.toString());
        }
    }

    public EMGroup createPrivateGroup(String string, String string2, String[] stringArray) throws EaseMobException {
        return this.createPrivateGroup(string, string2, stringArray, false);
    }

    public EMGroup createPrivateGroup(String string, String string2, String[] stringArray, boolean bl) throws EaseMobException {
        return this.createPrivateGroup(string, string2, stringArray, bl, 200);
    }

    public EMGroup createPrivateGroup(String string, String string2, String[] stringArray, boolean bl, int n2) throws EaseMobException {
        String string3 = this.generateGroupId();
        String string4 = EMChatManager.getInstance().getCurrentUser();
        String string5 = EMContactManager.getEidFromGroupId(string3);
        String[] stringArray2 = this.filterOwnerFromMembers(string4, stringArray);
        if (stringArray2 == null && n2 < 1) {
            throw new EaseMobException(-1018, "the max group members are reached!");
        }
        if (stringArray2 != null && stringArray2.length >= n2) {
            throw new EaseMobException(-1018, "the max group members are reached!");
        }
        try {
            Object object;
            this.createPrivateXmppMUC(string5, string, string2, string4, bl, n2);
            if (stringArray2 != null) {
                String[] stringArray3 = stringArray2;
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    object = stringArray3[n4];
                    String string6 = EMContactManager.getEidFromUserName((String)object);
                    this.addUserToMUC(string5, string6, true);
                    ++n4;
                }
            }
            object = new EMGroup(string3);
            ((EMGroup)object).setGroupName(string);
            ((EMGroup)object).setDescription(string2);
            ((EMGroup)object).setMaxUsers(n2);
            ((EMGroup)object).setOwner(EMChatManager.getInstance().getCurrentUser());
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(((EMGroup)object).getOwner());
            if (stringArray2 != null) {
                String[] stringArray4 = stringArray2;
                int n5 = stringArray2.length;
                int n6 = 0;
                while (n6 < n5) {
                    String string7 = stringArray4[n6];
                    arrayList.add(string7);
                    ++n6;
                }
            }
            ((EMGroup)object).setMembers(arrayList);
            ((EMGroup)object).setAffiliationsCount(arrayList.size());
            i.a().a((EMGroup)object);
            this.getAllGroup().put(((EMGroup)object).getGroupId(), (EMGroup)object);
            return object;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new EaseMobException(exception.toString());
        }
    }

    Map<String, EMGroup> getAllGroup() {
        return this.allGroups;
    }

    public EMGroup createGroup(String string, String string2, String[] stringArray) throws EaseMobException {
        return this.createPrivateGroup(string, string2, stringArray);
    }

    private void createPrivateXmppMUC(String string, String string2, String string3, String string4, boolean bl, int n2) throws Exception {
        MultiUserChat multiUserChat = new MultiUserChat(this.connection, string);
        EMLog.d(TAG, "create muc room jid:" + string + " roomName:" + string2 + " owner:" + string4 + " allowInvites:" + bl);
        try {
            multiUserChat.create(string4);
            Form form = multiUserChat.getConfigurationForm();
            Form form2 = form.createAnswerForm();
            Iterator<FormField> iterator = form.getFields();
            while (iterator.hasNext()) {
                FormField formField = iterator.next();
                if ("hidden".equals(formField.getType()) || formField.getVariable() == null) continue;
                form2.setDefaultAnswer(formField.getVariable());
            }
            form2.setAnswer("muc#roomconfig_persistentroom", true);
            form2.setAnswer("muc#roomconfig_membersonly", true);
            form2.setAnswer("muc#roomconfig_moderatedroom", true);
            if (n2 > 0) {
                form2.setAnswer("muc#roomconfig_maxusers", n2);
            }
            form2.setAnswer("muc#roomconfig_publicroom", false);
            form2.setAnswer("members_by_default", true);
            form2.setAnswer("muc#roomconfig_allowinvites", bl);
            form2.setAnswer("muc#roomconfig_roomname", string2);
            form2.setAnswer("muc#roomconfig_roomdesc", string3);
            multiUserChat.sendConfigurationForm(form2);
            multiUserChat.join(string4);
            this.chatProcessor.addMuc(string, multiUserChat);
            EMLog.d(TAG, "muc created:" + multiUserChat.getRoom());
        }
        catch (XMPPException xMPPException) {
            xMPPException.printStackTrace();
            throw xMPPException;
        }
    }

    private void createPublicXmppMUC(String string, String string2, String string3, String string4, boolean bl, int n2) throws Exception {
        MultiUserChat multiUserChat = new MultiUserChat(this.connection, string);
        EMLog.d(TAG, "create muc room jid:" + string + " roomName:" + string2 + " owner:" + string4);
        try {
            multiUserChat.create(string4);
            Form form = multiUserChat.getConfigurationForm();
            Form form2 = form.createAnswerForm();
            Iterator<FormField> iterator = form.getFields();
            while (iterator.hasNext()) {
                FormField formField = iterator.next();
                if ("hidden".equals(formField.getType()) || formField.getVariable() == null) continue;
                form2.setDefaultAnswer(formField.getVariable());
            }
            form2.setAnswer("muc#roomconfig_persistentroom", true);
            form2.setAnswer("muc#roomconfig_moderatedroom", false);
            form2.setAnswer("muc#roomconfig_publicroom", true);
            if (bl) {
                form2.setAnswer("muc#roomconfig_membersonly", true);
            } else {
                form2.setAnswer("muc#roomconfig_membersonly", false);
            }
            form2.setAnswer("members_by_default", true);
            form2.setAnswer("muc#roomconfig_roomname", string2);
            form2.setAnswer("muc#roomconfig_roomdesc", string3);
            if (n2 > 0) {
                form2.setAnswer("muc#roomconfig_maxusers", n2);
            }
            multiUserChat.sendConfigurationForm(form2);
            multiUserChat.join(string4);
            this.chatProcessor.addMuc(string, multiUserChat);
            EMLog.d(TAG, "muc created:" + multiUserChat.getRoom());
        }
        catch (XMPPException xMPPException) {
            xMPPException.printStackTrace();
            throw xMPPException;
        }
    }

    public void exitAndDeleteGroup(String string) throws EaseMobException {
        EMGroup eMGroup = this.getAllGroup().get(string);
        if (eMGroup == null) {
            throw new EaseMobException(-1016, "group doesn't exist in local:" + string);
        }
        this.checkGroupOwner(eMGroup, PERMISSION_ERROR_DELETE);
        try {
            String string2 = EMContactManager.getEidFromGroupId(string);
            this.chatProcessor.deleteMUC(string2);
            EMGroup eMGroup2 = this.getAllGroup().get(string);
            if (eMGroup2 != null) {
                this.deleteLocalGroup(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new EaseMobException(exception.toString());
        }
    }

    public void deleteLocalGroup(String string) {
        EMLog.d(TAG, "delete local group:" + string);
        i.a().g(string);
        this.removeGroupFromCache(string);
    }

    private void removeGroupFromCache(String string) {
        String string2 = EMContactManager.getEidFromGroupId(string);
        this.chatProcessor.removeMuc(string2);
        this.getAllGroup().remove(string);
        if (EMChatManager.getInstance().getChatOptions().isDeleteMessagesAsExitGroup()) {
            EMChatManager.getInstance().deleteConversation(string, true, true);
        }
    }

    private void checkGroupOwner(EMGroup eMGroup, String string) throws EMPermissionException {
        String string2 = eMGroup.getOwner();
        String string3 = EMChatManager.getInstance().getCurrentUser();
        if (string2 == null || !string3.equals(string2)) {
            throw new EMPermissionException(-1020, string);
        }
    }

    public void addUsersToGroup(String string, String[] stringArray) throws EaseMobException {
        EMGroup eMGroup = this.getAllGroup().get(string);
        if (eMGroup == null) {
            throw new EaseMobException(-1016, "group doesn't exist in local:" + string);
        }
        this.checkGroupOwner(eMGroup, PERMISSION_ERROR_ADD);
        try {
            String string2;
            String string3 = EMContactManager.getEidFromGroupId(string);
            EMGroup eMGroup2 = this.getMUC(string3, EMChatManager.getInstance().getCurrentUser(), false, true);
            int n2 = eMGroup2.getAffiliationsCount();
            int n3 = eMGroup2.getMaxUsers();
            if (n2 >= n3) {
                throw new EaseMobException(-1018, "the max group members are reached!");
            }
            if (n3 - n2 < stringArray.length) {
                throw new EaseMobException(-1019, "there is no room to add new members");
            }
            String[] stringArray2 = stringArray;
            int n4 = stringArray.length;
            int n5 = 0;
            while (n5 < n4) {
                string2 = stringArray2[n5];
                String string4 = EMContactManager.getEidFromUserName(string2);
                this.addUserToMUC(string3, string4, true);
                ++n5;
            }
            stringArray2 = stringArray;
            n4 = stringArray.length;
            n5 = 0;
            while (n5 < n4) {
                string2 = stringArray2[n5];
                if (!eMGroup.getMembers().contains(string2)) {
                    eMGroup.addMember(string2);
                }
                ++n5;
            }
            eMGroup.setAffiliationsCount(eMGroup.getMembers().size());
            i.a().b(eMGroup);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (exception instanceof EaseMobException) {
                throw (EaseMobException)exception;
            }
            throw new EaseMobException(-1, exception.getMessage());
        }
    }

    private void addUserToMUC(String string, String string2, boolean bl) throws XMPPException {
        EMLog.d(TAG, "muc add user:" + string2 + " to chat room:" + string);
        MultiUserChat multiUserChat = this.chatProcessor.getMUC(string);
        if (bl) {
            multiUserChat.invite(string2, "EaseMob-Group");
        }
        multiUserChat.grantMembership(string2);
    }

    public void removeUserFromGroup(String string, String string2) throws EaseMobException {
        EMGroup eMGroup = this.getAllGroup().get(string);
        if (eMGroup == null) {
            throw new EaseMobException(-1016, "group doesn't exist in local:" + string);
        }
        this.checkGroupOwner(eMGroup, PERMISSION_ERROR_REMOVE);
        String string3 = EMContactManager.getEidFromGroupId(string);
        String string4 = EMContactManager.getEidFromUserName(string2);
        try {
            this.removeUserFromMUC(string3, string4);
            eMGroup.removeMember(string2);
            eMGroup.setAffiliationsCount(eMGroup.getMembers().size());
            i.a().b(eMGroup);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void removeUserFromMUC(String string, String string2) throws Exception {
        EMLog.d(TAG, "muc remove user:" + string2 + " from chat room:" + string);
        MultiUserChat multiUserChat = this.chatProcessor.getMUC(string);
        multiUserChat.revokeMembership(string2);
        String string3 = EMContactManager.getUserNameFromEid(string2);
        try {
            EMLog.d(TAG, "try to kick user if already joined");
            multiUserChat.kickParticipant(string3, "RemoveFromGroup");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void exitFromGroup(String string) throws EaseMobException {
        try {
            String string2 = EMContactManager.getEidFromGroupId(string);
            String string3 = EMChatManager.getInstance().getCurrentUser();
            String string4 = EMContactManager.getEidFromUserName(string3);
            this.chatProcessor.leaveMUCRemoveMember(string2, string4);
            this.deleteLocalGroup(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new EaseMobException(exception.toString());
        }
    }

    public EMGroup getGroupFromServer(String string) throws EaseMobException {
        if (string == null) {
            throw new EaseMobException(-1017, "group id is null");
        }
        this.checkConnection();
        EMGroup eMGroup = this.getGroupFromRestServer(string, true);
        return eMGroup;
    }

    private EMGroup getGroupFromRestServer(String string, boolean bl) throws EaseMobException {
        block7: {
            String string2 = String.valueOf(p.c().L()) + "/chatgroups/" + string + "?version=v2";
            if (bl) {
                string2 = String.valueOf(string2) + "&needmembers=true";
            }
            EMTimeTag eMTimeTag = new EMTimeTag();
            eMTimeTag.start();
            Pair<Integer, String> pair = EMHttpClient.getInstance().sendRequestWithToken(string2, null, EMHttpClient.GET);
            int n2 = (Integer)pair.first;
            String string3 = (String)pair.second;
            if (n2 == 200 || n2 == 204) {
                try {
                    JSONObject jSONObject = new JSONObject(string3);
                    if (jSONObject.has("data")) {
                        Object object;
                        JSONObject jSONObject2 = jSONObject.getJSONArray("data").getJSONObject(0);
                        if (jSONObject2.has("error") && "group id doesn't exist".equals(object = jSONObject2.getString("error"))) {
                            throw new EaseMobException(-1017, "no group on server with groupid: " + string);
                        }
                        object = this.parseGroupFromData(true, jSONObject2);
                        EMPerformanceCollector.collectRetrieveGroupFromServer((EMGroup)object, eMTimeTag.stop());
                        return object;
                    }
                    break block7;
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                    throw new EaseMobException(jSONException.toString());
                }
            }
            if (n2 == 400 || n2 == 404) {
                throw new EaseMobException(-1017, "no group on server with groupid: " + string);
            }
            throw new EaseMobException(string3);
        }
        return null;
    }

    public EMGroup createOrUpdateLocalGroup(EMGroup eMGroup) {
        EMGroup eMGroup2 = i.a().e(eMGroup.getGroupId());
        if (eMGroup2 == null) {
            i.a().a(eMGroup);
        } else {
            i.a().b(eMGroup);
        }
        return this.updateCache(eMGroup);
    }

    private EMGroup updateCache(EMGroup eMGroup) {
        EMGroup eMGroup2 = this.getAllGroup().get(eMGroup.getGroupId());
        if (eMGroup2 != null) {
            eMGroup2.copyGroup(eMGroup);
            return eMGroup2;
        }
        this.getAllGroup().put(eMGroup.getGroupId(), eMGroup);
        return eMGroup;
    }

    EMGroup getMUC(String string, String string2, boolean bl, boolean bl2) throws XMPPException {
        RoomInfo roomInfo = MultiUserChat.getRoomInfo(this.connection, string);
        if (roomInfo == null) {
            return null;
        }
        String string3 = roomInfo.getRoomName();
        String string4 = roomInfo.getDescription();
        String string5 = EMContactManager.getUserNameFromEid(string);
        EMGroup eMGroup = new EMGroup(string5);
        eMGroup.setGroupName(string3);
        eMGroup.setDescription(string4);
        eMGroup.membersOnly = roomInfo.isMembersOnly();
        eMGroup.isPublic = roomInfo.isPublic();
        eMGroup.allowInvites = roomInfo.isAllowInvites();
        eMGroup.maxUsers = roomInfo.getMaxUsers();
        eMGroup.affiliationsCount = roomInfo.getAffiliationsCount();
        if (roomInfo.getOwner() != null) {
            eMGroup.owner = EMContactManager.getGroupIdFromEid(roomInfo.getOwner());
        }
        EMLog.d(TAG, "get room info for roomjid:" + string + " name:" + string3 + " desc:" + string4 + "owner:" + roomInfo.getOwner() + " ispublic:" + eMGroup.isPublic() + " ismemberonly:" + eMGroup.isMembersOnly() + " isallowinvites:" + eMGroup.isAllowInvites() + " maxusers:" + eMGroup.maxUsers + " affCounts:" + eMGroup.affiliationsCount + " isjoin:" + bl2 + " owner:" + eMGroup.owner);
        MultiUserChat multiUserChat = this.chatProcessor.getMUCWithoutJoin(string);
        if (bl2) {
            multiUserChat.join(string2);
        }
        if (!bl) {
            return eMGroup;
        }
        try {
            String string6;
            Object object;
            Object object2;
            Object object3;
            Collection<Affiliate> collection = multiUserChat.getOwners();
            Object object4 = collection.iterator();
            if (object4.hasNext()) {
                object3 = object4.next();
                object2 = ((Affiliate)object3).getJid();
                object = EMContactManager.getUserNameFromEid((String)object2);
                eMGroup.setOwner((String)object);
                EMLog.d(TAG, " room owner:" + (String)object);
            }
            eMGroup.addMember(eMGroup.getOwner());
            object3 = multiUserChat.getMembers();
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object4 = (Affiliate)object2.next();
                object = ((Affiliate)object4).getJid();
                string6 = EMContactManager.getUserNameFromEid((String)object);
                eMGroup.addMember(string6);
                EMLog.d(TAG, "  room member:" + string6);
            }
            try {
                object4 = multiUserChat.getAdmins();
                object = object4.iterator();
                while (object.hasNext()) {
                    object2 = (Affiliate)object.next();
                    string6 = ((Affiliate)object2).getJid();
                    String string7 = EMContactManager.getUserNameFromEid(string6);
                    eMGroup.addMember(string7);
                    String string8 = EMChatManager.getInstance().getCurrentUser();
                    if (string7.equals(string8)) {
                        EMLog.d(TAG, " this room is blocked group msg:" + string5);
                        eMGroup.isMsgBlocked = true;
                    }
                    EMLog.d(TAG, "  room blockedmsg member:" + string7);
                }
            }
            catch (Exception exception) {
                EMLog.d(TAG, "error when retrieve blocked members:" + exception.toString());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            EMLog.d(TAG, "error when retrieve group info from server:" + exception.toString());
            this.chatProcessor.removeMuc(string);
            return null;
        }
        return eMGroup;
    }

    public synchronized List<EMGroup> getGroupsFromServer() throws EaseMobException {
        try {
            this.checkConnection();
            EMTimeTag eMTimeTag = new EMTimeTag();
            eMTimeTag.start();
            List<EMGroup> list = this.getGroupsFromRestServer(true);
            eMTimeTag.stop();
            EMPerformanceCollector.collectRetrieveGroupsFromServerTime(list.size(), eMTimeTag.timeSpent());
            eMTimeTag.start();
            this.syncGroupsWithRemoteGroupList(list);
            eMTimeTag.stop();
            EMPerformanceCollector.collectSyncWithServerGroups(list.size(), eMTimeTag.timeSpent());
            return list;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (exception instanceof EaseMobException) {
                throw (EaseMobException)exception;
            }
            throw new EaseMobException(exception.toString());
        }
    }

    public synchronized List<EMGroup> getJoinedGroupsFromServer() throws EaseMobException {
        return this.getGroupsFromServer();
    }

    private void checkConnection() throws EaseMobException {
        EMSessionManager.getInstance().checkConnection();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<EMGroup> getGroupsFromRestServer(boolean bl) throws EaseMobException {
        String string = String.valueOf(p.c().L()) + "/users/" + EMChatManager.getInstance().getCurrentUser() + "/joined_chatgroups";
        if (bl) {
            string = String.valueOf(string) + "?detail=true";
        }
        ArrayList<EMGroup> arrayList = new ArrayList<EMGroup>();
        Pair<Integer, String> pair = EMHttpClient.getInstance().sendRequestWithToken(string, null, EMHttpClient.GET);
        int n2 = (Integer)pair.first;
        String string2 = (String)pair.second;
        if (n2 != 200 && n2 != 204) throw new EaseMobException(string2);
        try {
            JSONObject jSONObject = new JSONObject(string2);
            if (!jSONObject.has("data")) return arrayList;
            JSONArray jSONArray = jSONObject.getJSONArray("data");
            int n3 = 0;
            while (n3 < jSONArray.length()) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(n3);
                EMGroup eMGroup = this.parseGroupFromData(bl, jSONObject2);
                arrayList.add(eMGroup);
                ++n3;
            }
            return arrayList;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            throw new EaseMobException(jSONException.toString());
        }
    }

    private EMGroup parseGroupFromData(boolean bl, JSONObject jSONObject) throws JSONException {
        String string = jSONObject.getString("groupid");
        String string2 = jSONObject.getString("groupname");
        EMGroup eMGroup = new EMGroup(string);
        eMGroup.setGroupName(string2);
        if (bl) {
            if (jSONObject.has("owner")) {
                eMGroup.setOwner(jSONObject.getString("owner"));
            }
            if (jSONObject.has("membersonly")) {
                eMGroup.membersOnly = jSONObject.getBoolean("membersonly");
            }
            if (jSONObject.has("allowinvites")) {
                eMGroup.allowInvites = jSONObject.getBoolean("allowinvites");
            }
            if (jSONObject.has("public")) {
                eMGroup.isPublic = jSONObject.getBoolean("public");
            }
            if (jSONObject.has("description")) {
                eMGroup.description = jSONObject.getString("description");
            }
            if (jSONObject.has("maxusers")) {
                eMGroup.maxUsers = jSONObject.getInt("maxusers");
            }
            if (jSONObject.has("shieldgroup")) {
                eMGroup.isMsgBlocked = jSONObject.getBoolean("shieldgroup");
            }
            if (jSONObject.has("affiliations_count")) {
                eMGroup.affiliationsCount = jSONObject.getInt("affiliations_count");
            }
            if (jSONObject.has("member")) {
                ArrayList<String> arrayList = new ArrayList<String>();
                JSONArray jSONArray = jSONObject.getJSONArray("member");
                int n2 = 0;
                while (n2 < jSONArray.length()) {
                    String string3 = jSONArray.getString(n2);
                    if (string3.equals(eMGroup.getOwner())) {
                        arrayList.add(0, string3);
                    } else {
                        arrayList.add(string3);
                    }
                    ++n2;
                }
                eMGroup.setMembers(arrayList);
            }
        }
        return eMGroup;
    }

    public void asyncGetGroupsFromServer(final EMValueCallBack<List<EMGroup>> eMValueCallBack) {
        if (eMValueCallBack == null) {
            throw new RuntimeException("callback is null!");
        }
        this.threadPool.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    List<EMGroup> list = EMGroupManager.this.getGroupsFromServer();
                    eMValueCallBack.onSuccess(list);
                }
                catch (EaseMobException easeMobException) {
                    easeMobException.printStackTrace();
                    int n2 = EMExceptionUtils.fromExceptionToErrorCode(easeMobException);
                    if (n2 == -999) {
                        n2 = -998;
                    }
                    eMValueCallBack.onError(n2, easeMobException.getMessage());
                }
            }
        });
    }

    public List<EMGroupInfo> getAllPublicGroupsFromServer() throws EaseMobException {
        try {
            String string = EMContactManager.getEidFromUserName(EMChatManager.getInstance().getCurrentUser());
            List<EMGroupInfo> list = this.getPublicMUCs(string, EMChatConfig.getInstance().APPKEY);
            return list;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new EaseMobException(exception.toString());
        }
    }

    public EMCursorResult<EMGroupInfo> getPublicGroupsFromServer(int n2, String string) throws EaseMobException {
        this.checkConnection();
        return this.getPublicGroupsFromRest(n2, string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EMCursorResult<EMGroupInfo> getPublicGroupsFromRest(int n2, String string) throws EaseMobException {
        String string2 = String.valueOf(p.c().L()) + "/publicchatgroups" + "?limit=" + n2;
        if (string != null) {
            string2 = String.valueOf(string2) + "&cursor=" + string;
        }
        EMCursorResult<EMGroupInfo> eMCursorResult = new EMCursorResult<EMGroupInfo>();
        ArrayList<EMGroupInfo> arrayList = new ArrayList<EMGroupInfo>();
        Pair<Integer, String> pair = EMHttpClient.getInstance().sendRequestWithToken(string2, null, EMHttpClient.GET);
        int n3 = (Integer)pair.first;
        String string3 = (String)pair.second;
        if (n3 != 200 && n3 != 204) throw new EaseMobException(string3);
        try {
            JSONObject jSONObject = new JSONObject(string3);
            String string4 = null;
            if (jSONObject.has("cursor")) {
                string4 = jSONObject.getString("cursor");
                eMCursorResult.setCursor(string4);
            }
            if (!jSONObject.has("data")) return eMCursorResult;
            JSONArray jSONArray = jSONObject.getJSONArray("data");
            int n4 = 0;
            while (n4 < jSONArray.length()) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(n4);
                String string5 = jSONObject2.getString("groupid");
                String string6 = jSONObject2.getString("groupname");
                EMGroupInfo eMGroupInfo = new EMGroupInfo(string5, string6);
                arrayList.add(eMGroupInfo);
                ++n4;
            }
            eMCursorResult.setData((EMGroupInfo)((Object)arrayList));
            return eMCursorResult;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            throw new EaseMobException(jSONException.toString());
        }
    }

    public void asyncGetAllPublicGroupsFromServer(final EMValueCallBack<List<EMGroupInfo>> eMValueCallBack) {
        if (eMValueCallBack == null) {
            throw new RuntimeException("callback is null!");
        }
        this.threadPool.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    List<EMGroupInfo> list = EMGroupManager.this.getAllPublicGroupsFromServer();
                    eMValueCallBack.onSuccess(list);
                }
                catch (EaseMobException easeMobException) {
                    easeMobException.printStackTrace();
                    int n2 = EMExceptionUtils.fromExceptionToErrorCode(easeMobException);
                    if (n2 == -999) {
                        n2 = -998;
                    }
                    eMValueCallBack.onError(n2, easeMobException.getMessage());
                }
            }
        });
    }

    private void syncGroupsWithRemoteGroupList(List<EMGroup> list) {
        for (EMGroup object2 : list) {
            if (this.getAllGroup().containsKey(object2.getGroupId())) {
                EMLog.d(TAG, " group sync. local already exists:" + object2.getGroupId());
            }
            this.updateCache(object2);
        }
        i.a().a(list);
        Set<String> set = this.getAllGroup().keySet();
        ArrayList arrayList = new ArrayList();
        for (String string : set) {
            boolean bl = false;
            for (EMGroup eMGroup : list) {
                if (!eMGroup.getGroupId().equals(string)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(string);
        }
        EMLog.d(TAG, "delete local groups which not exists on server:" + arrayList);
        i.a().b(arrayList);
        Iterator<String> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string;
            string = iterator.next();
            this.removeGroupFromCache(string);
        }
    }

    void batchRemoveGroups(List<String> list) {
    }

    List<EMGroup> getMUCs(String string, boolean bl) throws EaseMobException, XMPPException {
        EMLog.d(TAG, "needJoin : " + bl);
        EMTimeTag eMTimeTag = new EMTimeTag();
        eMTimeTag.start();
        ArrayList<EMGroup> arrayList = new ArrayList<EMGroup>();
        Collection<HostedRoom> collection = MultiUserChat.getHostedRooms(this.connection, EMChatConfig.MUC_DOMAIN);
        EMLog.d(TAG, "joined room size:" + collection.size());
        for (HostedRoom hostedRoom : collection) {
            EMLog.d(TAG, "joined room room jid:" + hostedRoom.getJid() + " name:" + hostedRoom.getName());
            String string2 = EMChatManager.getInstance().getCurrentUser();
            try {
                EMGroup eMGroup = this.getMUC(hostedRoom.getJid(), string2, false, bl);
                if (eMGroup == null) continue;
                EMLog.d(TAG, "  get group detail:" + eMGroup.getGroupName());
                arrayList.add(eMGroup);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        EMLog.d(TAG, " retrieved groups from server:" + arrayList.size());
        if (arrayList != null && arrayList.size() > 0) {
            EMPerformanceCollector.collectRetrieveGroupsFromServerTime(arrayList.size(), eMTimeTag.stop());
        }
        return arrayList;
    }

    private List<EMGroupInfo> getPublicMUCs(String string, String string2) throws EaseMobException, XMPPException {
        ArrayList<EMGroupInfo> arrayList = new ArrayList<EMGroupInfo>();
        Collection<HostedRoom> collection = MultiUserChat.getPublicRooms(this.connection, EMChatConfig.MUC_DOMAIN, string2);
        EMLog.d(TAG, "public room size:" + collection.size());
        for (HostedRoom hostedRoom : collection) {
            String string3 = this.formatGroupName(hostedRoom.getName());
            EMLog.d(TAG, "joined room room jid:" + hostedRoom.getJid() + " name:" + string3);
            EMGroupInfo eMGroupInfo = new EMGroupInfo(EMContactManager.getGroupIdFromEid(hostedRoom.getJid()), string3);
            arrayList.add(eMGroupInfo);
        }
        EMLog.d(TAG, " retrieved public groups from server:" + arrayList.size());
        return arrayList;
    }

    private String formatGroupName(String string) {
        int n2 = string.lastIndexOf(" ");
        if (string.endsWith(")") && n2 > 0) {
            return string.substring(0, n2);
        }
        return string;
    }

    synchronized void clear() {
        this.allGroupLoaded = false;
        EMLog.d(TAG, "group manager clear");
        if (this.allGroups != null) {
            this.allGroups.clear();
        }
    }

    void removeMucs() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void retrieveUserMucsOnServer(String string) throws Exception {
        MUCSearchIQ mUCSearchIQ = new MUCSearchIQ(string, string);
        PacketTypeFilter packetTypeFilter = new PacketTypeFilter(IQ.class){

            @Override
            public boolean accept(Packet packet) {
                IQ iQ;
                if (packet instanceof IQ && (iQ = (IQ)packet).getType().equals(IQ.Type.RESULT)) {
                    String string = iQ.getChildElementXML();
                    EMLog.e(TAG, "childXML:" + string);
                    Exception exception = new Exception();
                    exception.printStackTrace();
                    return true;
                }
                return false;
            }
        };
        SearchPacketListener searchPacketListener = new SearchPacketListener();
        this.connection.addPacketListener(searchPacketListener, packetTypeFilter);
        this.receivedQuery = true;
        this.connection.sendPacket(mUCSearchIQ);
        Object object = this.mutex;
        synchronized (object) {
            this.mutex.wait(10000L);
        }
        if (!this.receivedQuery) {
            EMLog.e(TAG, "server no response for group search");
            throw new EaseMobException("server timeout");
        }
    }

    public void joinGroup(String string) throws EaseMobException {
        try {
            EMLog.d(TAG, "try to joinPublicGroup, current user:" + EMChatManager.getInstance().getCurrentUser() + " groupId:" + string);
            String string2 = EMContactManager.getEidFromGroupId(string);
            EMGroup eMGroup = this.getGroupFromServer(string);
            this.createOrUpdateLocalGroup(eMGroup);
            MultiUserChat multiUserChat = this.chatProcessor.getMUC(string2);
            if (multiUserChat != null && !multiUserChat.isJoined()) {
                multiUserChat.join(EMChatManager.getInstance().getCurrentUser());
            }
            String string3 = EMChatManager.getInstance().getCurrentUser();
            String string4 = EMContactManager.getEidFromUserName(string3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new EaseMobException(exception.toString());
        }
    }

    public void changeGroupName(String string, String string2) throws EaseMobException {
        String string3 = EMContactManager.getEidFromGroupId(string);
        EMGroup eMGroup = this.allGroups.get(string);
        if (eMGroup == null) {
            throw new EaseMobException(-1016, "group doesn't exist in local:" + string);
        }
        this.checkGroupOwner(eMGroup, PERMISSION_ERROR);
        try {
            MultiUserChat multiUserChat = this.chatProcessor.getMUC(string3);
            Form form = multiUserChat.getConfigurationForm();
            Form form2 = form.createAnswerForm();
            Iterator<FormField> iterator = form.getFields();
            while (iterator.hasNext()) {
                FormField formField = iterator.next();
                if ("hidden".equals(formField.getType()) || formField.getVariable() == null) continue;
                form2.setDefaultAnswer(formField.getVariable());
            }
            form2.setAnswer("muc#roomconfig_roomname", string2);
            multiUserChat.sendConfigurationForm(form2);
            if (multiUserChat != null && !multiUserChat.isJoined()) {
                multiUserChat.join(EMChatManager.getInstance().getCurrentUser());
            }
            eMGroup.setGroupName(string2);
            i.a().b(eMGroup);
        }
        catch (XMPPException xMPPException) {
            throw new EaseMobException(xMPPException.getMessage());
        }
    }

    public void addGroupChangeListener(GroupChangeListener groupChangeListener) {
        EMLog.d(TAG, "add group change listener:" + groupChangeListener.getClass().getName());
        if (!this.groupChangeListeners.contains(groupChangeListener)) {
            this.groupChangeListeners.add(groupChangeListener);
        }
    }

    public void removeGroupChangeListener(GroupChangeListener groupChangeListener) {
        EMLog.d(TAG, "remove group change listener:" + groupChangeListener.getClass().getName());
        this.groupChangeListeners.remove(groupChangeListener);
    }

    public EMGroup acceptInvitation(String string) throws EaseMobException {
        try {
            block4: {
                String string2 = EMContactManager.getEidFromGroupId(string);
                MultiUserChat multiUserChat = this.chatProcessor.getMUCWithoutJoin(string2);
                try {
                    multiUserChat.join(EMChatManager.getInstance().getCurrentUser());
                    EMLog.d(TAG, "join muc when acceptInvitation()");
                }
                catch (XMPPException xMPPException) {
                    xMPPException.printStackTrace();
                    if (xMPPException.getXMPPError().getCode() != 407) break block4;
                    throw xMPPException;
                }
            }
            EMGroup eMGroup = this.getGroupFromRestServer(string, false);
            this.createOrUpdateLocalGroup(eMGroup);
            return eMGroup;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new EaseMobException(exception.toString());
        }
    }

    void declineInvitation(String string, String string2, String string3) {
        EMLog.d(TAG, "decline invitation:" + string + " inviter:" + string2 + " reason" + string3);
        try {
            String string4 = EMContactManager.getEidFromGroupId(string);
            String string5 = EMContactManager.getEidFromUserName(string2);
            MultiUserChat.decline(this.connection, string4, string5, string3);
            this.deleteLocalGroup(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void acceptApplication(String string, String string2) throws EaseMobException {
        EMGroup eMGroup = this.allGroups.get(string2);
        if (eMGroup == null) {
            throw new EaseMobException("group doesn't exist:" + string2);
        }
        try {
            String string3 = EMContactManager.getEidFromGroupId(string2);
            String string4 = EMContactManager.getEidFromUserName(string);
            this.addUserToMUC(string3, string4, false);
            eMGroup.addMember(string);
            this.accept(string3, eMGroup.getGroupName(), string4);
            i.a().b(eMGroup);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new EaseMobException(exception.getMessage());
        }
    }

    public void declineApplication(String string, String string2, String string3) throws EaseMobException {
        try {
            String string4 = EMContactManager.getEidFromGroupId(string2);
            String string5 = EMContactManager.getEidFromUserName(string);
            EMGroup eMGroup = this.allGroups.get(string2);
            if (eMGroup == null) {
                throw new EaseMobException(-1016, "group doesn't exist in local:" + string2);
            }
            this.decline(string4, eMGroup.getGroupName(), string5, string3);
        }
        catch (Exception exception) {
            throw new EaseMobException(exception.getMessage());
        }
    }

    public void setAutoAcceptInvitation(boolean bl) {
        this.autoAcceptInvitation = bl;
    }

    public void inviteUser(String string, String[] stringArray, String string2) throws EaseMobException {
        try {
            Object object;
            EMLog.d(TAG, "invite usernames:" + stringArray + " to group:" + string + " reason:" + string2);
            if (string2 == null) {
                string2 = "";
            }
            String string3 = EMContactManager.getEidFromGroupId(string);
            ArrayList<String> arrayList = new ArrayList<String>();
            String[] stringArray2 = stringArray;
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                object = stringArray2[n3];
                String string4 = EMContactManager.getEidFromUserName((String)object);
                arrayList.add(string4);
                ++n3;
            }
            object = this.getMUC(string3, EMChatManager.getInstance().getCurrentUser(), false, true);
            n3 = ((EMGroup)object).getAffiliationsCount();
            if (n3 == (n2 = ((EMGroup)object).getMaxUsers())) {
                throw new EaseMobException(-1018, "\u7fa4\u6210\u5458\u6570\u5df2\u6ee1");
            }
            if (n2 - n3 < arrayList.size()) {
                throw new EaseMobException(-1019, "\u8981\u52a0\u5165\u7684\u7528\u6237\u4eba\u6570\u8d85\u8fc7\u5269\u4f59\u53ef\u52a0\u5165\u7684\u4eba\u6570");
            }
            this.inviteUserMUC(string3, arrayList, string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (exception instanceof EaseMobException) {
                throw (EaseMobException)exception;
            }
            throw new EaseMobException(-1, exception.getMessage());
        }
    }

    private void inviteUserMUC(String string, List<String> list, String string2) throws XMPPException {
        MultiUserChat multiUserChat = this.chatProcessor.getMUC(string);
        EMGroup eMGroup = EMGroupManager.getInstance().getGroup(EMContactManager.getGroupIdFromEid(string));
        if (list != null && list.size() != 0) {
            for (String string3 : list) {
                multiUserChat.invite(string3, string2);
                if (!eMGroup.isAllowInvites()) continue;
                eMGroup.addMember(EMContactManager.getUserNameFromEid(string3));
            }
        }
        eMGroup.setAffiliationsCount(eMGroup.getMembers().size());
    }

    public void applyJoinToGroup(String string, String string2) throws EaseMobException {
        String string3 = EMContactManager.getEidFromGroupId(string);
        String string4 = EMChatManager.getInstance().getCurrentUser();
        String string5 = EMContactManager.getEidFromUserName(string4);
        this.apply(new Message(), string3, string5, string2);
    }

    public void blockGroupMessage(String string) throws EaseMobException {
        EMLog.d(TAG, "try to block group msg:" + string);
        String string2 = EMContactManager.getEidFromGroupId(string);
        try {
            MultiUserChat multiUserChat = this.chatProcessor.getMUC(string2);
            String string3 = EMChatManager.getInstance().getCurrentUser();
            EMGroup eMGroup = this.getGroup(string);
            if (eMGroup == null) {
                throw new EaseMobException(-1016, "group not exist in local");
            }
            if (eMGroup.getOwner().equals(string3)) {
                throw new EMPermissionException(-1020, "group owner can not block group messages");
            }
            String string4 = EMContactManager.getEidFromUserName(string3);
            multiUserChat.grantAdmin(string4);
            EMLog.d(TAG, "block group msg done:" + string);
            eMGroup.setMsgBlocked(true);
            i.a().b(eMGroup);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new EaseMobException(exception.toString());
        }
    }

    public void unblockGroupMessage(String string) throws EaseMobException {
        EMLog.d(TAG, "try to unblock group msg:" + string);
        String string2 = EMContactManager.getEidFromGroupId(string);
        try {
            MultiUserChat multiUserChat = this.chatProcessor.getMUC(string2);
            String string3 = EMChatManager.getInstance().getCurrentUser();
            String string4 = EMContactManager.getEidFromUserName(string3);
            EMGroup eMGroup = this.getGroup(string);
            if (eMGroup == null) {
                throw new EaseMobException(-1016, "group not exist in local");
            }
            multiUserChat.grantMembership(string4);
            eMGroup.setMsgBlocked(false);
            i.a().b(eMGroup);
            EMLog.d(TAG, "block group msg done:" + string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new EaseMobException(exception.toString());
        }
    }

    public void blockUser(String string, String string2) throws EaseMobException {
        EMLog.d(TAG, "block user for groupid:" + string + " username:" + string2);
        EMGroup eMGroup = this.allGroups.get(string);
        if (eMGroup == null) {
            throw new EaseMobException(-1016, "group doesn't exist in local:" + string);
        }
        this.checkGroupOwner(eMGroup, PERMISSION_ERROR);
        try {
            String string3 = EMContactManager.getEidFromGroupId(string);
            String string4 = EMContactManager.getEidFromUserName(string2);
            this.blockUserMuc(string3, string4);
            EMGroup eMGroup2 = this.getGroupFromServer(string);
            this.createOrUpdateLocalGroup(eMGroup2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new EaseMobException(exception.toString());
        }
    }

    private void blockUserMuc(String string, String string2) throws XMPPException {
        MultiUserChat multiUserChat = this.chatProcessor.getMUCWithoutJoin(string);
        try {
            multiUserChat.kickParticipant(string2, "block");
        }
        catch (Exception exception) {
            // empty catch block
        }
        multiUserChat.banUser(string2, "easemob-block");
    }

    public void unblockUser(String string, String string2) throws EaseMobException {
        EMLog.d(TAG, "unblock user groupid:" + string + " username:" + string2);
        EMGroup eMGroup = this.allGroups.get(string);
        if (eMGroup == null) {
            throw new EaseMobException(-1016, "group doesn't exist in local:" + string);
        }
        this.checkGroupOwner(eMGroup, PERMISSION_ERROR);
        try {
            String string3 = EMContactManager.getEidFromGroupId(string);
            String string4 = EMContactManager.getEidFromUserName(string2);
            this.unblockUserMuc(string3, string4);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new EaseMobException(exception.toString());
        }
    }

    private void unblockUserMuc(String string, String string2) throws XMPPException {
        MultiUserChat multiUserChat = this.chatProcessor.getMUCWithoutJoin(string);
        multiUserChat.revokeMembership(string2);
    }

    public List<String> getBlockedUsers(String string) throws EaseMobException {
        EMLog.d(TAG, "get blocked users for group:" + string);
        try {
            String string2 = EMContactManager.getEidFromGroupId(string);
            return this.getBlockedUsersMuc(string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new EaseMobException(exception.toString());
        }
    }

    private List<String> getBlockedUsersMuc(String string) throws XMPPException {
        ArrayList<String> arrayList = new ArrayList<String>();
        MultiUserChat multiUserChat = this.chatProcessor.getMUCWithoutJoin(string);
        Collection<Affiliate> collection = multiUserChat.getOutcasts();
        for (Affiliate object : collection) {
            object.getJid();
        }
        try {
            Collection<Affiliate> xMPPException = multiUserChat.getOutcasts();
            for (Object affiliate : xMPPException) {
                EMLog.d(TAG, "blocked  member jid:" + ((Affiliate)affiliate).getJid());
                String string2 = ((Affiliate)affiliate).getJid();
                String string3 = EMContactManager.getUserNameFromEid(string2);
                arrayList.add(string3);
            }
        }
        catch (XMPPException exception) {
            throw exception;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    void onInvitation(String string, String string2, String string3) {
        String string4;
        block7: {
            string4 = string;
            EMGroup eMGroup = new EMGroup(string);
            eMGroup.setGroupName(string4);
            this.createOrUpdateLocalGroup(eMGroup);
            if (this.autoAcceptInvitation) {
                try {
                    EMLog.d(TAG, "auto accept group invitation for group:" + string4);
                    EMGroup object = this.acceptInvitation(string);
                    if (object != null && !TextUtils.isEmpty((CharSequence)object.getName())) {
                        string4 = object.getName();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (!exception.getMessage().contains("407")) break block7;
                    return;
                }
            }
        }
        if (EMChat.getInstance().appInited) {
            for (GroupChangeListener groupChangeListener : this.groupChangeListeners) {
                EMLog.d(TAG, "fire group inviatation received event for group:" + string4);
                groupChangeListener.onInvitationReceived(string, string4, string2, string3);
            }
        } else {
            EMLog.d(TAG, "aff offline group inviatation received event for group:" + string4);
            this.offlineGroupEvents.add(new GroupChangeEvent(GroupEventType.Invitate, string, string4, string2, string3));
        }
    }

    void processOfflineMessages() {
        EMLog.d(TAG, "process offline group event start: " + this.offlineGroupEvents.size());
        block8: for (GroupChangeEvent groupChangeEvent : this.offlineGroupEvents) {
            switch (groupChangeEvent.type) {
                case Invitate: {
                    for (GroupChangeListener xMPPException : this.groupChangeListeners) {
                        EMLog.d(TAG, "fire group inviatation received event for group:" + groupChangeEvent.groupName + " listener:" + xMPPException.hashCode());
                        EMGroup eMGroup = this.allGroups.get(groupChangeEvent.groupId);
                        if (eMGroup == null || !TextUtils.isEmpty((CharSequence)eMGroup.getName())) {
                            EMGroup eMGroup2 = new EMGroup(groupChangeEvent.groupId);
                            eMGroup2.setGroupName(groupChangeEvent.groupName);
                            this.createOrUpdateLocalGroup(eMGroup2);
                        }
                        xMPPException.onInvitationReceived(groupChangeEvent.groupId, groupChangeEvent.groupName, groupChangeEvent.inviterUserName, groupChangeEvent.reason);
                    }
                    continue block8;
                }
                case Apply: {
                    for (GroupChangeListener groupChangeListener : this.groupChangeListeners) {
                        EMLog.d(TAG, "fire group application received event for group:" + groupChangeEvent.groupName + " listener:" + groupChangeListener.hashCode());
                        groupChangeListener.onApplicationReceived(groupChangeEvent.groupId, groupChangeEvent.groupName, groupChangeEvent.inviterUserName, groupChangeEvent.reason);
                    }
                    continue block8;
                }
                case ApplicationAccept: {
                    try {
                        String string = EMContactManager.getEidFromGroupId(groupChangeEvent.groupId);
                        EMGroup eMGroup = this.getMUC(string, EMChatManager.getInstance().getCurrentUser(), false, true);
                        this.createOrUpdateLocalGroup(eMGroup);
                        for (GroupChangeListener groupChangeListener : this.groupChangeListeners) {
                            EMLog.d(TAG, "fire group application accept received event for group:" + groupChangeEvent.groupName + " listener:" + groupChangeListener.hashCode());
                            groupChangeListener.onApplicationAccept(groupChangeEvent.groupId, groupChangeEvent.groupName, groupChangeEvent.inviterUserName);
                        }
                    }
                    catch (XMPPException xMPPException) {
                        xMPPException.printStackTrace();
                    }
                    continue block8;
                }
                case ApplicationDeclind: {
                    for (GroupChangeListener groupChangeListener : this.groupChangeListeners) {
                        EMLog.d(TAG, "fire group application declind received event for group:" + groupChangeEvent.groupName + " listener:" + groupChangeListener.hashCode());
                        groupChangeListener.onApplicationDeclined(groupChangeEvent.groupId, groupChangeEvent.groupName, groupChangeEvent.inviterUserName, groupChangeEvent.reason);
                    }
                    continue block8;
                }
            }
        }
        this.offlineGroupEvents.clear();
        EMLog.d(TAG, "proess offline group event finish");
    }

    MultiUserChat getMUCWithoutJoin(String string) throws XMPPException {
        return this.chatProcessor.getMUCWithoutJoin(string);
    }

    void handleRoomDestroy(String string) {
        String string2 = EMContactManager.getGroupIdFromEid(string);
        EMGroup eMGroup = this.allGroups.get(string2);
        String string3 = "";
        if (eMGroup != null) {
            string3 = eMGroup.getGroupName();
        }
        EMLog.d(TAG, "group has been destroy on server:" + string2 + " name:" + string3);
        this.deleteLocalGroup(string2);
        for (GroupChangeListener groupChangeListener : this.groupChangeListeners) {
            groupChangeListener.onGroupDestroy(string2, string3);
        }
    }

    void handleUserRemove(String string) {
        int n2 = string.indexOf("/");
        String string2 = null;
        if (n2 > 0) {
            string2 = string.substring(n2 + 1);
            String string3 = string.substring(0, n2);
            String string4 = EMContactManager.getGroupIdFromEid(string3);
            if (string2.equals(EMChatManager.getInstance().getCurrentUser())) {
                EMLog.d(TAG, "user " + string2 + " has been removed from group:" + string4);
                String string5 = "";
                EMGroup eMGroup = this.allGroups.get(string4);
                if (eMGroup != null) {
                    string5 = eMGroup.getGroupName();
                }
                this.deleteLocalGroup(string4);
                for (GroupChangeListener groupChangeListener : this.groupChangeListeners) {
                    groupChangeListener.onUserRemoved(string4, string5);
                }
            }
        }
    }

    private void apply(Message message, String string, String string2, String string3) throws EaseMobException {
        try {
            EMGroup eMGroup = this.getAllGroup().get(EMContactManager.getGroupIdFromEid(string));
            if (eMGroup == null) {
                eMGroup = this.getGroupFromRestServer(EMContactManager.getGroupIdFromEid(string), false);
            }
            message.setTo(EMContactManager.getEidFromUserName(eMGroup.getOwner()));
            MUCUser mUCUser = new MUCUser();
            MUCUser.Apply apply = new MUCUser.Apply();
            apply.setFrom(string2);
            apply.setTo(string);
            apply.setReason(string3);
            apply.setToNick(eMGroup.getGroupName());
            mUCUser.setApply(apply);
            message.addExtension(mUCUser);
            this.connection.sendPacket(message);
        }
        catch (Exception exception) {
            throw new EaseMobException(exception.getMessage());
        }
    }

    private void decline(String string, String string2, String string3, String string4) {
        Message message = new Message(string3);
        MUCUser mUCUser = new MUCUser();
        MUCUser.Decline decline = new MUCUser.Decline();
        decline.setTo(string);
        decline.setFrom(EMContactManager.getEidFromUserName(EMChatManager.getInstance().getCurrentUser()));
        decline.setFromNick(string2);
        decline.setReason(string4);
        decline.setType(MUCUser.MucType.Apply);
        mUCUser.setDecline(decline);
        message.addExtension(mUCUser);
        this.connection.sendPacket(message);
    }

    private void accept(String string, String string2, String string3) {
        Message message = new Message(string3);
        MUCUser mUCUser = new MUCUser();
        MUCUser.Accept accept = new MUCUser.Accept();
        accept.setFrom(EMContactManager.getEidFromUserName(EMChatManager.getInstance().getCurrentUser()));
        accept.setTo(string);
        accept.setFromNick(string2);
        mUCUser.setAccept(accept);
        message.addExtension(mUCUser);
        this.connection.sendPacket(message);
    }

    void onInit() {
        EMLog.d(TAG, "init group manager");
        this.appContext = EMChat.getInstance().getAppContext();
        this.connection = EMSessionManager.getInstance().getConnection();
        PacketExtensionFilter packetExtensionFilter = new PacketExtensionFilter("x", MUC_NS_USER);
        this.connection.addPacketListener(this.applyListener, packetExtensionFilter);
        this.chatProcessor.onInit();
    }

    void onDestroy() {
        this.allGroupLoaded = false;
        EMLog.d(TAG, "group manager logout");
        if (this.allGroups != null) {
            this.allGroups.clear();
        }
        if (this.groupChangeListeners != null) {
            this.groupChangeListeners.clear();
        }
        if (this.offlineGroupEvents != null) {
            this.offlineGroupEvents.clear();
        }
    }

    private class GroupChangeEvent {
        String groupId;
        String groupName;
        String inviterUserName;
        String reason;
        GroupEventType type;

        public GroupChangeEvent(GroupEventType groupEventType, String string, String string2, String string3, String string4) {
            this.type = groupEventType;
            this.groupId = string;
            this.groupName = string2;
            this.inviterUserName = string3;
            this.reason = string4;
        }
    }

    private static enum GroupEventType {
        Invitate,
        Apply,
        ApplicationAccept,
        ApplicationDeclind;

    }

    private class MUCSearchIQ
    extends IQ {
        public MUCSearchIQ(String string, String string2) {
            this.setType(IQ.Type.GET);
            this.setFrom(string);
            this.setTo(string2);
        }

        @Override
        public String getChildElementXML() {
            return "<query xmlns='http://jabber.org/protocol/disco#items' node='http://jabber.org/protocol/muc#rooms'/>";
        }
    }

    class MucApplyListener
    implements PacketListener {
        private static final String TAG = "MucApplyListener";

        MucApplyListener() {
        }

        @Override
        public void processPacket(Packet packet) {
            if (!(packet instanceof Message)) {
                return;
            }
            Message message = (Message)packet;
            PacketExtension packetExtension = message.getExtension("x", EMGroupManager.MUC_NS_USER);
            if (packetExtension != null) {
                MUCUser mUCUser = (MUCUser)packetExtension;
                MUCUser.Apply apply = mUCUser.getApply();
                MUCUser.Accept accept = mUCUser.getAccept();
                MUCUser.Decline decline = mUCUser.getDecline();
                if (apply != null) {
                    String string = EMContactManager.getUserNameFromEid(apply.getFrom());
                    String string2 = EMContactManager.getGroupIdFromEid(apply.getTo());
                    if (EMChat.getInstance().appInited) {
                        for (GroupChangeListener groupChangeListener : EMGroupManager.this.groupChangeListeners) {
                            EMLog.d(TAG, "fire group application received event for group:" + apply.getToNick());
                            groupChangeListener.onApplicationReceived(string2, apply.getToNick(), string, apply.getReason());
                        }
                    } else {
                        EMLog.d(TAG, "aff offline group application received event for group:" + apply.getToNick());
                        EMGroupManager.this.offlineGroupEvents.add(new GroupChangeEvent(GroupEventType.Apply, string2, apply.getToNick(), string, apply.getReason()));
                    }
                } else if (accept != null) {
                    String string = EMContactManager.getUserNameFromEid(accept.getFrom());
                    String string3 = EMContactManager.getGroupIdFromEid(accept.getTo());
                    if (EMChat.getInstance().appInited) {
                        try {
                            EMGroup eMGroup = EMGroupManager.this.getMUC(accept.getTo(), EMChatManager.getInstance().getCurrentUser(), false, true);
                            EMGroupManager.this.createOrUpdateLocalGroup(eMGroup);
                            for (GroupChangeListener groupChangeListener : EMGroupManager.this.groupChangeListeners) {
                                EMLog.d(TAG, "fire group application accept received event for group:" + accept.getFromNick());
                                groupChangeListener.onApplicationAccept(string3, accept.getFromNick(), string);
                            }
                        }
                        catch (XMPPException xMPPException) {
                            xMPPException.printStackTrace();
                        }
                    } else {
                        EMLog.d(TAG, "aff offline group application accetpt received event for group:" + accept.getFromNick());
                        EMGroupManager.this.offlineGroupEvents.add(new GroupChangeEvent(GroupEventType.ApplicationAccept, string3, accept.getFromNick(), string, accept.getReason()));
                    }
                } else if (decline != null) {
                    String string = EMContactManager.getUserNameFromEid(decline.getFrom());
                    String string4 = EMContactManager.getGroupIdFromEid(decline.getTo());
                    if (EMChat.getInstance().appInited) {
                        for (GroupChangeListener groupChangeListener : EMGroupManager.this.groupChangeListeners) {
                            EMLog.d(TAG, "fire group application declind received event for group:" + decline.getFromNick());
                            groupChangeListener.onApplicationDeclined(string4, decline.getFromNick(), string, decline.getReason());
                        }
                    } else {
                        EMLog.d(TAG, "aff offline group application declind received event for group:" + decline.getFromNick());
                        EMGroupManager.this.offlineGroupEvents.add(new GroupChangeEvent(GroupEventType.ApplicationDeclind, string4, decline.getFromNick(), string, decline.getReason()));
                    }
                }
            }
        }
    }

    private class MucUserStatusListener
    implements UserStatusListener {
        private String roomJid;

        public MucUserStatusListener(String string) {
            this.roomJid = string;
        }

        @Override
        public void adminGranted() {
            EMLog.d(TAG, "admin granted");
        }

        @Override
        public void adminRevoked() {
            EMLog.d(TAG, "admin revoked");
        }

        @Override
        public void banned(String string, String string2) {
            EMLog.d(TAG, "banned actor:" + string + " reason:" + string2);
        }

        @Override
        public void kicked(String string, String string2) {
            try {
                String string3 = EMContactManager.getUserNameFromEid(string);
                EMLog.d(TAG, "kicked actor:" + string3 + " reason:" + string2);
                String string4 = EMContactManager.getGroupIdFromEid(this.roomJid);
                EMLog.d(TAG, "current user has been revoked membership. delete local group:" + string4);
                EMGroupManager.this.deleteLocalGroup(string4);
                for (GroupChangeListener groupChangeListener : EMGroupManager.this.groupChangeListeners) {
                    groupChangeListener.onUserRemoved(string4, "");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        @Override
        public void membershipGranted() {
            EMLog.d(TAG, "membership granted");
        }

        @Override
        public void membershipRevoked() {
            EMLog.d(TAG, "membership revoked");
            String string = EMContactManager.getGroupIdFromEid(this.roomJid);
            EMLog.d(TAG, "current user has been revoked membership. delete local group:" + string);
            EMGroupManager.this.deleteLocalGroup(string);
            for (GroupChangeListener groupChangeListener : EMGroupManager.this.groupChangeListeners) {
                groupChangeListener.onUserRemoved(string, "");
            }
        }

        @Override
        public void moderatorGranted() {
            EMLog.d(TAG, "moderator granted");
        }

        @Override
        public void moderatorRevoked() {
            EMLog.d(TAG, "moderator revoked");
        }

        @Override
        public void ownershipGranted() {
            EMLog.d(TAG, "ownership granted");
        }

        @Override
        public void ownershipRevoked() {
            EMLog.d(TAG, "ownership revoked");
        }

        @Override
        public void voiceGranted() {
            EMLog.d(TAG, "voice granted");
        }

        @Override
        public void voiceRevoked() {
            EMLog.d(TAG, "voice revoked");
        }
    }

    private class RoomQueryIQ
    extends IQ {
        private RoomQueryIQ() {
        }

        @Override
        public String getChildElementXML() {
            return "<query xmlns=\"http://jabber.org/protocol/disco#items\" node=\"http://jabber.org/protocol/muc#rooms\"></query>";
        }
    }

    private class SearchPacketListener
    implements PacketListener {
        private SearchPacketListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processPacket(Packet packet) {
            Object object = EMGroupManager.this.mutex;
            synchronized (object) {
                EMGroupManager.this.receivedQuery = true;
                EMGroupManager.this.mutex.notify();
            }
        }
    }
}

