/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.chat;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import com.easemob.EMNotifierEvent;
import com.easemob.chat.EMChat;
import com.easemob.chat.EMChatConfig;
import com.easemob.chat.EMChatManager;
import com.easemob.chat.EMCustomerServiceConfiguration;
import com.easemob.chat.EMMessage;
import com.easemob.chat.EMNotifier;
import com.easemob.chat.core.p;
import com.easemob.chat.core.r;
import com.easemob.util.EMLog;

class EMCustomerService
implements r {
    private static final String TAG = "EMCustomerService";
    private EMCustomerServiceConfiguration configuration = null;
    private static EMCustomerService instance = null;
    private PendingIntent logoutIntent = null;
    private HelpDeskLogoutReceiver logoutReceiver = null;
    private static final String CONFIG_EASEMOB_HELPDESK_JID = "EASEMOB_HELPDESK_JID";
    private static final String HELPDESK_LOGOUT_BROADCAST = "easemob.helpdesk.logout.";
    private static final long MAX_LOGOUT_DELAY = 57600L;
    private static final long MIN_INTERVAL_UPDATE_LOGOUT_TIME = 600L;
    private long logoutDelay = 57600L;

    private EMCustomerService() {
    }

    static synchronized EMCustomerService getInstance() {
        if (instance == null) {
            instance = new EMCustomerService();
        }
        return instance;
    }

    void setConfiguration(EMCustomerServiceConfiguration eMCustomerServiceConfiguration) {
        this.configuration = eMCustomerServiceConfiguration;
    }

    boolean isCustomServiceAgent(String string) {
        if (this.configuration == null) {
            return false;
        }
        if (this.configuration.getAgents() == null) {
            return false;
        }
        return this.configuration.getAgents().contains(string);
    }

    public void setLogoutDelay(long l2) {
        if (l2 < 57600L) {
            this.logoutDelay = l2;
        }
    }

    private String getLogoutBroadcastAction() {
        return HELPDESK_LOGOUT_BROADCAST + EMChatConfig.getInstance().APPKEY + EMChat.getInstance().getAppContext().getPackageName();
    }

    public void scheduleLogout(EMScheduleLogoutReason eMScheduleLogoutReason) {
        EMLog.d(TAG, "schedule helpdesk logout");
        Long l2 = System.currentTimeMillis() + this.logoutDelay * 1000L;
        if (p.c().H()) {
            long l3 = p.c().I();
            boolean bl = false;
            if (!bl && Math.abs(l2 - l3) < 600000L) {
                return;
            }
            long l4 = System.currentTimeMillis();
            if (eMScheduleLogoutReason == EMScheduleLogoutReason.EMNewMessage) {
                if (l3 < l4 + this.logoutDelay * 1000L) {
                    l2 = l4 + this.logoutDelay * 1000L;
                }
            } else if (eMScheduleLogoutReason == EMScheduleLogoutReason.EMLogin) {
                if (l3 < l4) {
                    this.forceLogout();
                    return;
                }
                l2 = l3;
            }
        }
        Context context = EMChat.getInstance().getAppContext();
        try {
            AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
            if (this.logoutIntent == null) {
                Intent intent = new Intent(this.getLogoutBroadcastAction());
                this.logoutIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent, (int)0);
            }
            if (this.logoutReceiver == null) {
                this.logoutReceiver = new HelpDeskLogoutReceiver();
                IntentFilter intentFilter = new IntentFilter(this.getLogoutBroadcastAction());
                context.registerReceiver((BroadcastReceiver)this.logoutReceiver, intentFilter);
            }
            alarmManager.cancel(this.logoutIntent);
            alarmManager.set(0, l2.longValue(), this.logoutIntent);
            p.c().c(l2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void unregisterLogoutTimerReceiver() {
        block4: {
            Intent intent;
            EMLog.d(TAG, "unregister helpdesk logout receiver");
            if (this.logoutReceiver == null) {
                return;
            }
            Context context = EMChat.getInstance().getAppContext();
            if (this.logoutIntent == null) {
                intent = new Intent(this.getLogoutBroadcastAction());
                this.logoutIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent, (int)0);
            }
            try {
                intent = (AlarmManager)context.getSystemService("alarm");
                intent.cancel(this.logoutIntent);
                context.unregisterReceiver((BroadcastReceiver)this.logoutReceiver);
                this.logoutReceiver = null;
            }
            catch (Exception exception) {
                if (exception.getMessage().contains("Receiver not registered")) break block4;
                exception.printStackTrace();
            }
        }
    }

    public void cancelScheduledLogout() {
        EMLog.d(TAG, "cancel helpdesk logout");
        p.c().J();
        this.unregisterLogoutTimerReceiver();
    }

    private void forceLogout() {
        EMChatManager.getInstance().logout();
        p.c().J();
        EMNotifier.getInstance(EMChat.getInstance().getAppContext()).publishEvent(EMNotifierEvent.Event.EventLogout, null);
    }

    boolean isMessageBelongingToCusomerService(EMMessage eMMessage) {
        return this.isCustomServiceAgent(eMMessage.getFrom());
    }

    @Override
    public void onInit() {
    }

    @Override
    public void onDestroy() {
        this.cancelScheduledLogout();
    }

    public static enum EMScheduleLogoutReason {
        EMLogin,
        EMNewMessage;

    }

    public class HelpDeskLogoutReceiver
    extends BroadcastReceiver {
        private static final String TAG = "HelpDeskLogoutReceiver";

        public void onReceive(Context context, Intent intent) {
            EMLog.d(TAG, "HelpDesk logout receiver received message");
            EMCustomerService.this.forceLogout();
        }
    }
}

