/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.chat;

import com.easemob.EMCallBack;
import com.easemob.EMNotifierEvent;
import com.easemob.analytics.EMPerformanceCollector;
import com.easemob.analytics.EMTimeTag;
import com.easemob.chat.EMChat;
import com.easemob.chat.EMChatManager;
import com.easemob.chat.EMChatRoom;
import com.easemob.chat.EMConversation;
import com.easemob.chat.EMCustomerService;
import com.easemob.chat.EMGroup;
import com.easemob.chat.EMMessage;
import com.easemob.chat.EMMultiUserChatManager;
import com.easemob.chat.EMMultiUserChatRoomModelBase;
import com.easemob.chat.EMNotifier;
import com.easemob.chat.core.i;
import com.easemob.util.EMLog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

class EMConversationManager {
    private static final String TAG = EMConversationManager.class.getSimpleName();
    private static final int DEFAULT_LOAD_MESSAGE_COUNT = 20;
    private static EMConversationManager instance = new EMConversationManager();
    private Hashtable<String, EMMessage> allMessages = new Hashtable();
    private Hashtable<String, EMConversation> conversations = new Hashtable();
    private Hashtable<String, EMConversation> tempConversations = new Hashtable();
    private Hashtable<EMConversation.EMConversationType, List<EMConversation>> typeConversations = new Hashtable();
    private boolean allConversationsLoaded = false;

    EMConversationManager() {
    }

    public static EMConversationManager getInstance() {
        return instance;
    }

    void loadAllConversations() {
        this.loadAllConversations(20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void loadAllConversations(int n2) {
        if (this.allConversationsLoaded) {
            return;
        }
        this.conversations.clear();
        this.tempConversations.clear();
        EMTimeTag eMTimeTag = new EMTimeTag();
        eMTimeTag.start();
        EMLog.d(TAG, "start to load converstations:");
        this.conversations = n2 == 1 ? i.a().c() : i.a().a(n2);
        Hashtable<String, EMConversation> hashtable = this.conversations;
        synchronized (hashtable) {
            for (EMConversation eMConversation : this.conversations.values()) {
                EMLog.d(TAG, "loaded user " + eMConversation.getUserName());
            }
        }
        hashtable = this.conversations;
        synchronized (hashtable) {
            for (EMConversation eMConversation : this.conversations.values()) {
                for (EMMessage eMMessage : eMConversation.messages) {
                    Hashtable<String, EMMessage> hashtable2 = this.allMessages;
                    synchronized (hashtable2) {
                        this.allMessages.put(eMMessage.msgId, eMMessage);
                    }
                }
            }
        }
        if (this.conversations != null && this.allMessages != null && this.conversations.size() > 0) {
            EMPerformanceCollector.collectLoadingAllConversations(this.conversations.size(), this.allMessages.size(), eMTimeTag.stop());
        }
        this.allConversationsLoaded = true;
    }

    public void asyncloadAllConversations(final EMCallBack eMCallBack, final int n2) {
        new Thread(){

            @Override
            public void run() {
                EMConversationManager.this.loadAllConversations(n2);
                if (eMCallBack != null) {
                    eMCallBack.onSuccess();
                }
            }
        }.start();
    }

    public void asyncloadAllConversations(EMCallBack eMCallBack) {
        this.asyncloadAllConversations(eMCallBack, 20);
    }

    synchronized List<EMMessage> getMessagesByMsgType(EMMessage.Type type, EMMessage.ChatType chatType, String string, String string2, int n2) {
        List<EMMessage> list = i.a().a(type, chatType, string, string2, n2);
        return list;
    }

    synchronized long getTotalMessageCountByMsgType(EMMessage.Type type, EMMessage.ChatType chatType, String string) {
        return i.a().a(type, chatType, string);
    }

    public EMConversation getConversation(String string) {
        EMLog.d(TAG, "get conversation for user:" + string);
        EMConversation eMConversation = this.conversations.get(string);
        if (eMConversation != null) {
            return eMConversation;
        }
        eMConversation = this.tempConversations.get(string);
        if (eMConversation != null) {
            return eMConversation;
        }
        List<EMMessage> list = null;
        EMMultiUserChatRoomModelBase eMMultiUserChatRoomModelBase = EMMultiUserChatManager.getInstance().getRoom(string);
        if (eMMultiUserChatRoomModelBase == null) {
            list = i.a().b(string, null, 20);
            long l2 = i.a().a(string, false);
            eMConversation = EMCustomerService.getInstance().isCustomServiceAgent(string) ? new EMConversation(string, list, EMConversation.EMConversationType.HelpDesk, l2) : new EMConversation(string, list, EMConversation.EMConversationType.Chat, l2);
        } else {
            list = i.a().a(string, null, 20);
            long l3 = i.a().a(string, true);
            if (eMMultiUserChatRoomModelBase instanceof EMGroup) {
                eMConversation = new EMConversation(string, list, EMConversation.EMConversationType.GroupChat, l3);
            } else if (eMMultiUserChatRoomModelBase instanceof EMChatRoom) {
                eMConversation = new EMConversation(string, list, EMConversation.EMConversationType.ChatRoom, l3);
            }
        }
        this.tempConversations.put(string, eMConversation);
        return eMConversation;
    }

    EMConversation getConversation(String string, boolean bl, EMConversation.EMConversationType eMConversationType) {
        EMLog.d(TAG, "get conversation for user:" + string);
        EMConversation eMConversation = this.conversations.get(string);
        if (eMConversation != null) {
            return eMConversation;
        }
        eMConversation = this.tempConversations.get(string);
        if (eMConversation != null) {
            return eMConversation;
        }
        List<EMMessage> list = null;
        long l2 = 0L;
        if (!bl) {
            list = i.a().b(string, null, 20);
            l2 = i.a().a(string, false);
        } else {
            list = i.a().a(string, null, 20);
            l2 = i.a().a(string, true);
        }
        eMConversation = new EMConversation(string, list, eMConversationType, l2);
        this.tempConversations.put(string, eMConversation);
        return eMConversation;
    }

    public boolean deleteConversation(String string) {
        EMLog.d(TAG, "remove conversation for user: " + string);
        EMConversation eMConversation = this.conversations.get(string);
        if (eMConversation == null) {
            eMConversation = this.getConversation(string);
        }
        if (eMConversation == null) {
            return false;
        }
        return this.deleteConversation(string, eMConversation.isGroup());
    }

    public boolean deleteConversation(String string, boolean bl) {
        return this.deleteConversation(string, bl, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteConversation(String string, boolean bl, boolean bl2) {
        EMLog.d(TAG, "remove conversation for user: " + string);
        EMConversation eMConversation = this.conversations.get(string);
        if (eMConversation == null) {
            eMConversation = this.getConversation(string);
        }
        if (eMConversation == null) {
            return false;
        }
        if (bl2) {
            if (bl) {
                i.a().i(string);
            } else {
                i.a().d(string);
            }
        }
        i.a().c(string, bl);
        try {
            List<EMMessage> list;
            List<EMMessage> list2 = list = eMConversation.getAllMessages();
            synchronized (list2) {
                for (EMMessage eMMessage : list) {
                    if (!this.allMessages.containsKey(eMMessage.getMsgId())) continue;
                    this.allMessages.remove(eMMessage.getMsgId());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        eMConversation.clear();
        this.conversations.remove(string);
        if (this.tempConversations.containsKey(string)) {
            this.tempConversations.remove(string);
        }
        EMNotifier.getInstance(EMChat.getInstance().getAppContext()).publishEvent(EMNotifierEvent.Event.EventConversationListChanged, null);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteAllConversations() {
        Hashtable<String, EMConversation> hashtable = this.conversations;
        synchronized (hashtable) {
            Enumeration<String> enumeration = this.conversations.keys();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                this.deleteConversation(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetAllUnreadMsgCount() {
        Hashtable<String, EMConversation> hashtable = this.conversations;
        synchronized (hashtable) {
            Enumeration<String> enumeration = this.conversations.keys();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                this.conversations.get(string).resetUnreadMsgCount();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clearConversation(String string) {
        EMLog.d(TAG, "clear conversation for user: " + string);
        EMConversation eMConversation = this.conversations.get(string);
        if (eMConversation == null) {
            eMConversation = this.getConversation(string);
        }
        if (eMConversation == null) {
            return false;
        }
        if (eMConversation.isGroup()) {
            i.a().i(string);
        } else {
            i.a().d(string);
        }
        try {
            List<EMMessage> list;
            List<EMMessage> list2 = list = eMConversation.getAllMessages();
            synchronized (list2) {
                for (EMMessage eMMessage : list) {
                    if (!this.allMessages.containsKey(eMMessage.getMsgId())) continue;
                    this.allMessages.remove(eMMessage.getMsgId());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        eMConversation.clear();
        eMConversation.msgCount = 0L;
        return true;
    }

    void removeMessage(String string) {
        this.allMessages.remove(string);
    }

    public Hashtable<String, EMConversation> getAllConversations() {
        return this.conversations;
    }

    public EMMessage getMessage(String string) {
        return this.allMessages.get(string);
    }

    void replaceMessageId(String string, String string2) {
        EMMessage eMMessage = this.allMessages.get(string);
        if (eMMessage != null) {
            i.a().a(string, string2);
            this.allMessages.remove(string);
            eMMessage.msgId = string2;
            this.allMessages.put(string2, eMMessage);
        }
    }

    boolean areAllConversationsLoaded() {
        return this.allConversationsLoaded;
    }

    void addMessage(EMMessage eMMessage) {
        this.addMessage(eMMessage, true);
    }

    void addMessage(EMMessage eMMessage, boolean bl) {
        String string = eMMessage.msgId;
        if (!this.allMessages.containsKey(string)) {
            String string2;
            this.allMessages.put(string, eMMessage);
            boolean bl2 = false;
            if (eMMessage.getChatType() == EMMessage.ChatType.Chat) {
                string2 = eMMessage.direct == EMMessage.Direct.RECEIVE ? eMMessage.from.username : eMMessage.to.username;
            } else {
                string2 = eMMessage.getTo();
                bl2 = true;
            }
            EMConversation eMConversation = this.getConversation(string2, bl2, EMConversation.msgType2ConversationType(string2, eMMessage.getChatType()));
            eMConversation.addMessage(eMMessage, bl);
            if (!this.conversations.containsKey(string2)) {
                this.conversations.put(string2, eMConversation);
            }
        }
    }

    private void addConversationToDB(EMMessage eMMessage) {
        boolean bl;
        String string = "";
        boolean bl2 = bl = eMMessage.getChatType() != EMMessage.ChatType.Chat;
        string = bl ? eMMessage.getTo() : (eMMessage.getFrom().equals(EMChatManager.getInstance().getCurrentUser()) ? eMMessage.getTo() : eMMessage.getFrom());
        i.a().a(string, EMConversation.msgType2ConversationType(string, eMMessage.getChatType()));
    }

    public void saveMessage(EMMessage eMMessage) {
        EMLog.d(TAG, "save message:" + eMMessage.getMsgId());
        try {
            if (!this.allMessages.containsKey(eMMessage.getMsgId())) {
                this.addMessage(eMMessage);
                i.a().a(eMMessage);
            }
            this.addConversationToDB(eMMessage);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void saveMessage(EMMessage eMMessage, boolean bl) {
        EMLog.d(TAG, "save message:" + eMMessage.getMsgId());
        try {
            this.addMessage(eMMessage, bl);
            i.a().a(eMMessage);
            this.addConversationToDB(eMMessage);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUnreadMsgsCount() {
        int n2 = 0;
        Hashtable<String, EMConversation> hashtable = this.conversations;
        synchronized (hashtable) {
            Collection<EMConversation> collection = this.conversations.values();
            Iterator<EMConversation> iterator = collection.iterator();
            while (iterator.hasNext()) {
                n2 += iterator.next().getUnreadMsgCount();
            }
        }
        EMLog.d(TAG, "getunreadmsgcount return:" + n2);
        return n2;
    }

    public List<String> getConversationsUnread() {
        return i.a().h();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EMConversation> getConversationsByType(EMConversation.EMConversationType eMConversationType) {
        ArrayList<EMConversation> arrayList = new ArrayList<EMConversation>();
        Hashtable<String, EMConversation> hashtable = this.conversations;
        synchronized (hashtable) {
            for (EMConversation eMConversation : this.conversations.values()) {
                if (eMConversation.getType() != eMConversationType) continue;
                arrayList.add(eMConversation);
            }
        }
        return arrayList;
    }

    public synchronized void clear() {
        if (this.conversations != null) {
            this.conversations.clear();
        }
        if (this.tempConversations != null) {
            this.tempConversations.clear();
        }
        if (this.allMessages != null) {
            this.allMessages.clear();
        }
        this.allConversationsLoaded = false;
    }
}

