/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.chat;

import android.text.TextUtils;
import com.easemob.chat.EMChatManager;
import com.easemob.chat.EMContact;
import com.easemob.chat.EMConversationManager;
import com.easemob.chat.EMCustomerService;
import com.easemob.chat.EMGroupManager;
import com.easemob.chat.EMMessage;
import com.easemob.chat.core.i;
import com.easemob.util.EMLog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class EMConversation {
    private static final String TAG = "conversation";
    List<EMMessage> messages;
    private int unreadMsgCount = 0;
    private String username;
    private boolean isGroup = false;
    private EMContact opposite = null;
    private EMConversationType type = EMConversationType.Chat;
    long msgCount = 0L;
    private boolean isKeywordSearchEnabled = false;

    public EMConversation(String string) {
        this.isGroup = EMGroupManager.getInstance().getGroup(string) != null;
        this.username = string;
        if (this.messages == null) {
            this.messages = Collections.synchronizedList(new ArrayList());
        }
        if (this.unreadMsgCount <= 0) {
            this.unreadMsgCount = i.a().j(string);
        }
    }

    public EMConversation(String string, boolean bl) {
        this.username = string;
        this.isGroup = bl;
        if (this.messages == null) {
            this.messages = Collections.synchronizedList(new ArrayList());
        }
        if (this.unreadMsgCount <= 0) {
            this.unreadMsgCount = i.a().j(string);
        }
    }

    public EMConversation(String string, List<EMMessage> list, EMConversationType eMConversationType, Long l2) {
        this.username = string;
        this.type = eMConversationType;
        boolean bl = this.isGroup = eMConversationType != EMConversationType.Chat;
        if (this.messages == null) {
            this.messages = Collections.synchronizedList(list);
        }
        if (this.unreadMsgCount <= 0) {
            this.unreadMsgCount = i.a().j(string);
        }
        this.msgCount = l2;
    }

    public void addMessage(EMMessage eMMessage) {
        this.addMessage(eMMessage, true);
    }

    void addMessage(EMMessage eMMessage, boolean bl) {
        if (eMMessage.getChatType() == EMMessage.ChatType.GroupChat) {
            this.isGroup = true;
        }
        if (this.messages.size() > 0) {
            EMMessage eMMessage2 = this.messages.get(this.messages.size() - 1);
            if (eMMessage.getMsgId() != null && eMMessage2.getMsgId() != null && eMMessage.getMsgId().equals(eMMessage2.getMsgId())) {
                return;
            }
        }
        boolean bl2 = false;
        for (EMMessage eMMessage3 : this.messages) {
            if (!eMMessage3.getMsgId().equals(eMMessage.getMsgId())) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            this.messages.add(eMMessage);
            ++this.msgCount;
            if (eMMessage.direct == EMMessage.Direct.RECEIVE && eMMessage.unread && bl) {
                ++this.unreadMsgCount;
                this.saveUnreadMsgCount(this.unreadMsgCount);
            }
        }
    }

    void saveUnreadMsgCount(final int n2) {
        EMChatManager.getInstance().msgCountThreadPool.submit(new Runnable(){

            @Override
            public void run() {
                i.a().a(EMConversation.this.username, n2);
            }
        });
    }

    void deleteUnreadMsgCountRecord() {
        EMChatManager.getInstance().msgCountThreadPool.submit(new Runnable(){

            @Override
            public void run() {
                i.a().k(EMConversation.this.username);
            }
        });
    }

    public int getUnreadMsgCount() {
        if (this.unreadMsgCount < 0) {
            this.unreadMsgCount = 0;
        }
        return this.unreadMsgCount;
    }

    public void resetUnsetMsgCount() {
        this.unreadMsgCount = 0;
        this.saveUnreadMsgCount(0);
    }

    public void resetUnreadMsgCount() {
        this.unreadMsgCount = 0;
        this.saveUnreadMsgCount(0);
    }

    public void markAllMessagesAsRead() {
        this.resetUnreadMsgCount();
    }

    public int getMsgCount() {
        return this.messages.size();
    }

    public int getAllMsgCount() {
        return (int)this.msgCount;
    }

    public EMMessage getMessage(int n2) {
        return this.getMessage(n2, true);
    }

    public EMMessage getMessage(int n2, boolean bl) {
        if (n2 >= this.messages.size()) {
            EMLog.e(TAG, "outofbound, messages.size:" + this.messages.size());
            return null;
        }
        EMMessage eMMessage = this.messages.get(n2);
        if (bl && eMMessage != null && eMMessage.unread) {
            eMMessage.unread = false;
            if (this.unreadMsgCount > 0) {
                --this.unreadMsgCount;
                this.saveUnreadMsgCount(this.unreadMsgCount);
            }
        }
        return eMMessage;
    }

    public List<EMMessage> loadMoreMsgFromDB(String string, int n2) {
        List<Object> list = new ArrayList();
        list = i.a().b(this.username, string, n2);
        this.messages.addAll(0, list);
        for (EMMessage eMMessage : list) {
            EMChatManager.getInstance().addMessage(eMMessage, false);
        }
        return list;
    }

    public List<EMMessage> loadMoreMessages(boolean bl, String string, int n2) {
        List<EMMessage> list = new ArrayList<EMMessage>();
        if (string == null) {
            return list;
        }
        list = this.isGroup ? i.a().a(this.username, bl, string, n2) : i.a().b(this.username, bl, string, n2);
        if (!bl) {
            this.messages.addAll(list);
        } else {
            this.messages.addAll(0, list);
        }
        if (!this.isKeywordSearchEnabled) {
            for (EMMessage eMMessage : list) {
                EMChatManager.getInstance().addMessage(eMMessage, false);
            }
        }
        return list;
    }

    public List<EMMessage> loadMoreGroupMsgFromDB(String string, int n2) {
        List<EMMessage> list = i.a().a(this.username, string, n2);
        this.messages.addAll(0, list);
        for (EMMessage eMMessage : list) {
            EMChatManager.getInstance().addMessage(eMMessage, false);
        }
        return list;
    }

    public EMMessage getMessage(String string) {
        return this.getMessage(string, true);
    }

    public EMMessage getMessage(String string, boolean bl) {
        int n2 = this.messages.size() - 1;
        while (n2 >= 0) {
            EMMessage eMMessage = this.messages.get(n2);
            if (eMMessage.msgId.equals(string)) {
                if (bl && eMMessage.unread) {
                    eMMessage.unread = false;
                    if (this.unreadMsgCount > 0) {
                        --this.unreadMsgCount;
                        this.saveUnreadMsgCount(this.unreadMsgCount);
                    }
                }
                return eMMessage;
            }
            --n2;
        }
        return null;
    }

    public EMMessage loadMessage(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        EMMessage eMMessage = this.getMessage(string, false);
        if (eMMessage == null) {
            eMMessage = i.a().c(string);
        }
        return eMMessage;
    }

    public List<EMMessage> loadMessages(List<String> list) {
        if (list == null) {
            return null;
        }
        ArrayList<EMMessage> arrayList = new ArrayList<EMMessage>();
        for (String string : list) {
            EMMessage eMMessage = this.loadMessage(string);
            if (eMMessage == null) continue;
            arrayList.add(eMMessage);
        }
        return arrayList.size() > 0 ? arrayList : null;
    }

    public void markMessageAsRead(String string) {
        this.getMessage(string);
    }

    public List<EMMessage> getAllMessages() {
        return this.messages;
    }

    public int getMessagePosition(EMMessage eMMessage) {
        try {
            for (EMMessage eMMessage2 : this.messages) {
                if (!eMMessage.getMsgId().equals(eMMessage2.getMsgId())) continue;
                return this.messages.indexOf(eMMessage2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    public String getUserName() {
        return this.username;
    }

    public void removeMessage(String string) {
        EMLog.d(TAG, "remove msg from conversation:" + string);
        int n2 = this.messages.size() - 1;
        while (n2 >= 0) {
            EMMessage eMMessage = this.messages.get(n2);
            if (eMMessage.msgId.equals(string)) {
                if (eMMessage.unread) {
                    eMMessage.unread = false;
                    if (this.unreadMsgCount > 0) {
                        --this.unreadMsgCount;
                        this.saveUnreadMsgCount(this.unreadMsgCount);
                    }
                }
                this.messages.remove(n2);
                if (this.msgCount > 0L) {
                    --this.msgCount;
                }
                i.a().b(string);
                EMConversationManager.getInstance().removeMessage(string);
                break;
            }
            --n2;
        }
    }

    public boolean getIsGroup() {
        return this.isGroup;
    }

    public boolean isGroup() {
        return this.isGroup;
    }

    public void setGroup(boolean bl) {
        this.isGroup = bl;
    }

    public EMMessage getLastMessage() {
        if (this.messages.size() == 0) {
            return null;
        }
        return this.messages.get(this.messages.size() - 1);
    }

    public void clear() {
        this.messages.clear();
        this.unreadMsgCount = 0;
        i.a().k(this.username);
    }

    public void setExtField(String string) {
        i.a().a(this.username, this.isGroup, string);
    }

    public String getExtField() {
        return i.a().h(this.username, this.isGroup);
    }

    public EMConversationType getType() {
        return this.type;
    }

    public void markAsKeywordSearch() {
        this.isKeywordSearchEnabled = true;
    }

    void setType(EMConversationType eMConversationType) {
        this.type = eMConversationType;
    }

    public static EMConversationType msgType2ConversationType(String string, EMMessage.ChatType chatType) {
        if (chatType == EMMessage.ChatType.Chat) {
            if (EMCustomerService.getInstance().isCustomServiceAgent(string)) {
                return EMConversationType.HelpDesk;
            }
            return EMConversationType.Chat;
        }
        if (chatType == EMMessage.ChatType.GroupChat) {
            return EMConversationType.GroupChat;
        }
        if (chatType == EMMessage.ChatType.ChatRoom) {
            return EMConversationType.ChatRoom;
        }
        return EMConversationType.Chat;
    }

    public static enum EMConversationType {
        Chat,
        GroupChat,
        ChatRoom,
        DiscussionGroup,
        HelpDesk;

    }
}

