/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.chat;

import android.content.Context;
import com.easemob.analytics.EMPerformanceCollector;
import com.easemob.analytics.EMTimeTag;
import com.easemob.chat.EMChat;
import com.easemob.chat.EMChatConfig;
import com.easemob.chat.EMChatManager;
import com.easemob.chat.EMContact;
import com.easemob.chat.EMContactListener;
import com.easemob.chat.EMRosterListener;
import com.easemob.chat.EMRosterStorageImpl;
import com.easemob.chat.EMSessionManager;
import com.easemob.chat.core.EMConnectionManager;
import com.easemob.chat.core.i;
import com.easemob.exceptions.EaseMobException;
import com.easemob.util.EMLog;
import com.easemob.util.NetUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jivesoftware.smack.PrivacyList;
import org.jivesoftware.smack.PrivacyListManager;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.RosterEntry;
import org.jivesoftware.smack.RosterStorage;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.PrivacyItem;
import org.jivesoftware.smack.packet.RosterPacket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMContactManager {
    private static final String TAG = "contact";
    Map<String, EMContact> contactTable = new Hashtable<String, EMContact>(100);
    private EMRosterListener rosterListener = null;
    private Roster roster;
    EMRosterStorageImpl rosterStorage;
    private static EMContactManager instance = null;
    private static final String black_list_name = "special";
    boolean enableRosterVersion = true;
    EMContactListener contactListener = null;
    Set<String> deleteContactsSet = null;
    List<String> blackList = Collections.synchronizedList(new ArrayList());
    private boolean hasGetBlacklist = false;
    private static final String BROADCAST_CONTACT_CHANGED_ACTION = "com.easemob.contact.changed";
    private EMConnectionManager xmppConnectionManager;
    private Context context;
    private boolean isIntied = false;

    private EMContactManager() {
    }

    public static EMContactManager getInstance() {
        if (instance == null) {
            instance = new EMContactManager();
        }
        return instance;
    }

    void init(Context context, EMConnectionManager eMConnectionManager) {
        if (this.isIntied) {
            return;
        }
        EMLog.d(TAG, "try to init contact manager");
        this.context = context;
        this.xmppConnectionManager = eMConnectionManager;
        this.deleteContactsSet = Collections.synchronizedSet(new HashSet());
        if (this.enableRosterVersion) {
            this.loadContacts();
        }
        if (this.needGetRosterFromServer()) {
            EMTimeTag eMTimeTag = new EMTimeTag();
            eMTimeTag.start();
            this.roster = eMConnectionManager.getConnection().getRoster();
            EMPerformanceCollector.collectRetrieveRoster(this.roster.getEntries().size(), eMTimeTag.stop());
        } else {
            this.roster = eMConnectionManager.getConnection().getRosterWithoutLoad();
        }
        this.rosterListener = new EMRosterListener(this, this.roster);
        this.roster.addRosterListener(this.rosterListener);
        this.isIntied = true;
        EMLog.d(TAG, "created contact manager");
    }

    boolean needGetRosterFromServer() {
        return i.a().k() || EMChatManager.getInstance().getChatOptions().getUseRoster();
    }

    public void addContact(String string, String string2) throws EaseMobException {
        this.addContactToRosterThroughPresence(string.toLowerCase(), string2);
    }

    public void deleteContact(String string) throws EaseMobException {
        this.removeContactFromRoster(string);
        EMChatManager.getInstance().deleteConversation(string);
    }

    void addContactInternal(EMContact eMContact) {
        EMLog.d(TAG, "internal add contact:" + eMContact.eid);
        this.contactTable.put(eMContact.username, eMContact);
        i.a().b(eMContact.eid, eMContact.username);
    }

    void deleteContactInternal(String string) {
        EMLog.d(TAG, "delete contact:" + string);
        EMContact eMContact = this.contactTable.remove(string);
        if (eMContact != null) {
            i.a().m(eMContact.eid);
        } else {
            EMLog.w(TAG, "local contact doesnt exists will try to delete:" + string);
        }
        eMContact = null;
        EMChatManager.getInstance().deleteConversation(string, false);
    }

    EMContact getContactByUserName(String string) {
        EMContact eMContact = this.contactTable.get(string);
        if (eMContact == null) {
            eMContact = new EMContact(string);
        }
        return eMContact;
    }

    void removeContactFromRoster(String string) throws EaseMobException {
        try {
            RosterEntry rosterEntry = this.roster.getEntry(EMContactManager.getEidFromUserName(string));
            if (rosterEntry != null) {
                this.roster.removeEntry(rosterEntry);
            }
        }
        catch (Exception exception) {
            EMLog.e(TAG, "Failed to delete contact:", exception);
            throw new EaseMobException("Failed to delete contact:" + exception);
        }
    }

    void removeContactByUsername(String string) {
        EMContact eMContact = this.contactTable.remove(string);
        if (eMContact != null) {
            i.a().m(eMContact.eid);
        }
        EMChatManager.getInstance().deleteConversation(string, false);
        EMLog.d(TAG, "removed contact:" + eMContact);
        eMContact = null;
    }

    public void reset() {
        this.contactTable.clear();
        this.blackList.clear();
        this.hasGetBlacklist = false;
        this.roster = null;
        this.rosterStorage = null;
        this.removeContactListener();
        this.isIntied = false;
    }

    RosterStorage getRosterStorage(Context context) {
        if (this.rosterStorage == null) {
            this.rosterStorage = new EMRosterStorageImpl(context, this);
        }
        return this.rosterStorage;
    }

    List<String> getRosterUserNames() throws EaseMobException {
        EMChatManager.getInstance().checkConnection();
        if (this.enableRosterVersion) {
            this.loadContacts();
        }
        EMLog.d(TAG, "start to get roster for user:" + EMSessionManager.getInstance().getLoginUserName());
        EMTimeTag eMTimeTag = new EMTimeTag();
        eMTimeTag.start();
        this.roster = this.xmppConnectionManager.getConnection().getRoster();
        Collection<RosterEntry> collection = this.roster.getEntries();
        if (collection != null) {
            EMPerformanceCollector.collectRetrieveRoster(collection.size(), eMTimeTag.stop());
        }
        EMLog.d(TAG, "get roster return size:" + collection.size());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (RosterEntry rosterEntry : collection) {
            EMLog.d(TAG, "entry name:" + rosterEntry.getName() + " user:" + rosterEntry.getUser());
            if (rosterEntry.getType() != RosterPacket.ItemType.both && rosterEntry.getType() != RosterPacket.ItemType.from) continue;
            String string = rosterEntry.getName();
            if (string == null || string.equals("")) {
                string = EMContactManager.getUserNameFromEid(rosterEntry.getUser());
            }
            if (string.startsWith(EMChatConfig.getInstance().APPKEY)) {
                string = string.substring((EMChatConfig.getInstance().APPKEY + "_").length());
            }
            EMLog.d(TAG, "get roster contact:" + string);
            arrayList.add(string);
        }
        return arrayList;
    }

    void addContactToRosterThroughPresence(String string, String string2) throws EaseMobException {
        try {
            EMChatManager.getInstance().checkConnection();
            Presence presence = new Presence(Presence.Type.subscribe);
            String string3 = EMContactManager.getEidFromUserName(string);
            presence.setTo(string3);
            if (string2 != null && !"".equals(string2)) {
                presence.setStatus(string2);
            }
            EMSessionManager.getInstance().getConnection().sendPacket(presence);
        }
        catch (Exception exception) {
            throw new EaseMobException(exception.getMessage());
        }
    }

    static String getBareEidFromUserName(String string) {
        return EMChatConfig.getInstance().APPKEY + "_" + string;
    }

    static String getEidFromUserName(String string) {
        if (string.contains("@")) {
            return string;
        }
        if (string.equals("bot")) {
            return "bot@echo.easemob.com";
        }
        return EMChatConfig.getInstance().APPKEY + "_" + string + "@" + EMChatConfig.DOMAIN;
    }

    public static String getUserNameFromEid(String string) {
        String string2;
        String string3 = string.contains("@") ? string.substring(0, string.indexOf("@")) : string;
        if (string3 == null || "".equals(string3)) {
            string3 = string;
        }
        if ((string2 = string3).startsWith(EMChatConfig.getInstance().APPKEY)) {
            return string2.substring((EMChatConfig.getInstance().APPKEY + "_").length());
        }
        return string2;
    }

    static String getEidFromGroupId(String string) {
        if (string.contains("@")) {
            return string;
        }
        return EMChatConfig.getInstance().APPKEY + "_" + string + EMChatConfig.MUC_DOMAIN_SUFFIX;
    }

    static String getGroupIdFromEid(String string) {
        String string2;
        String string3 = string.contains("@") ? string.substring(0, string.indexOf("@")) : string;
        if (string3 == null || "".equals(string3)) {
            string3 = string;
        }
        if ((string2 = string3).startsWith(EMChatConfig.getInstance().APPKEY)) {
            return string2.substring((EMChatConfig.getInstance().APPKEY + "_").length());
        }
        return string2;
    }

    String getCurrentUserFullJid() {
        String string = EMSessionManager.getInstance().currentUser.username;
        String string2 = EMConnectionManager.getXmppResource(this.context);
        String string3 = EMContactManager.getEidFromUserName(string);
        String string4 = string3 + "/" + string2;
        return string4;
    }

    public List<String> getContactUserNames() throws EaseMobException {
        return this.getRosterUserNames();
    }

    public void setContactListener(EMContactListener eMContactListener) {
        this.contactListener = eMContactListener;
    }

    public void removeContactListener() {
        this.contactListener = null;
    }

    public void addUserToBlackList(String string, boolean bl) throws EaseMobException {
        String string2 = EMContactManager.getEidFromUserName(string);
        this.addToPrivacyList(string2, bl);
        i.a().o(string);
        if (!this.blackList.contains(string)) {
            this.blackList.add(string);
        }
    }

    public void deleteUserFromBlackList(String string) throws EaseMobException {
        String string2 = EMContactManager.getEidFromUserName(string);
        this.deleteFromPrivacyList(string2);
        i.a().n(string);
        if (this.blackList.contains(string)) {
            this.blackList.remove(string);
        }
    }

    public List<String> getBlackListUsernames() {
        List<String> list;
        if (this.blackList.size() == 0 && (list = i.a().j()).size() != 0) {
            this.blackList.addAll(list);
        }
        return this.blackList;
    }

    public List<String> getBlackListUsernamesFromServer() throws EaseMobException {
        ArrayList<String> arrayList;
        block6: {
            arrayList = new ArrayList<String>();
            if (this.xmppConnectionManager == null || this.xmppConnectionManager.getConnection() == null || !this.xmppConnectionManager.getConnection().isConnected()) {
                throw new EaseMobException("connetion is not connected");
            }
            PrivacyListManager privacyListManager = PrivacyListManager.getInstanceFor(this.xmppConnectionManager.getConnection());
            if (privacyListManager != null) {
                try {
                    PrivacyList privacyList = privacyListManager.getPrivacyList(black_list_name);
                    if (privacyList != null) {
                        List<PrivacyItem> list = privacyList.getItems();
                        for (PrivacyItem privacyItem : list) {
                            String string = privacyItem.getValue();
                            arrayList.add(EMContactManager.getUserNameFromEid(string));
                        }
                    }
                }
                catch (XMPPException xMPPException) {
                    if (xMPPException != null && xMPPException.getMessage() != null && xMPPException.getMessage().contains("item-not-found")) break block6;
                    throw new EaseMobException(xMPPException.getMessage());
                }
            }
        }
        return arrayList;
    }

    public void saveBlackList(List<String> list) {
        if (list != null) {
            this.blackList.clear();
            this.blackList.addAll(list);
            i.a().d(list);
        }
    }

    private void addToPrivacyList(String string, boolean bl) throws EaseMobException {
        try {
            PrivacyListManager privacyListManager = PrivacyListManager.getInstanceFor(this.xmppConnectionManager.getConnection());
            if (privacyListManager == null) {
                throw new EaseMobException("PrivacyListManager is null");
            }
            PrivacyList[] privacyListArray = privacyListManager.getPrivacyLists();
            if (privacyListArray.length == 0) {
                ArrayList<PrivacyItem> arrayList = new ArrayList<PrivacyItem>();
                PrivacyItem privacyItem = new PrivacyItem("jid", false, 100);
                if (!bl) {
                    privacyItem.setFilterMessage(true);
                }
                privacyItem.setValue(string);
                arrayList.add(privacyItem);
                privacyListManager.updatePrivacyList(black_list_name, arrayList);
                privacyListManager.setDefaultListName(black_list_name);
                privacyListManager.setActiveListName(black_list_name);
                return;
            }
            PrivacyList privacyList = privacyListManager.getPrivacyList(black_list_name);
            if (privacyList != null) {
                List<PrivacyItem> list = privacyList.getItems();
                boolean bl2 = false;
                for (PrivacyItem privacyItem : list) {
                    String string2 = privacyItem.getValue();
                    EMLog.d(TAG, "addToPrivacyList item.getValue=" + privacyItem.getValue());
                    if (!string2.equalsIgnoreCase(string)) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) {
                    EMLog.d(TAG, "current user is already in black list");
                    return;
                }
                PrivacyItem privacyItem = new PrivacyItem("jid", false, 100);
                privacyItem.setValue(string);
                list.add(privacyItem);
                if (!bl) {
                    privacyItem.setFilterMessage(true);
                }
                EMLog.d(TAG, "addToPrivacyList item.getValue=" + privacyItem.toXML());
                privacyListManager.updatePrivacyList(black_list_name, list);
                privacyListManager.setActiveListName(black_list_name);
            }
        }
        catch (Exception exception) {
            throw new EaseMobException(exception.getMessage());
        }
    }

    private void deleteFromPrivacyList(String string) throws EaseMobException {
        if (this.xmppConnectionManager == null || this.xmppConnectionManager.getConnection() == null) {
            throw new EaseMobException("connection is null, please login first");
        }
        PrivacyListManager privacyListManager = PrivacyListManager.getInstanceFor(this.xmppConnectionManager.getConnection());
        if (privacyListManager == null) {
            throw new EaseMobException("PrivacyListManager is null");
        }
        try {
            PrivacyList privacyList;
            PrivacyList[] privacyListArray = privacyListManager.getPrivacyLists();
            if (privacyListArray.length != 0 && (privacyList = privacyListManager.getPrivacyList(black_list_name)) != null) {
                List<PrivacyItem> list = privacyList.getItems();
                if (list != null && list.size() != 0) {
                    boolean bl = false;
                    for (PrivacyItem privacyItem : list) {
                        String string2 = privacyItem.getValue();
                        EMLog.d(TAG, "PrivacyList item.getValue=" + privacyItem.getValue());
                        if (!string2.equalsIgnoreCase(string)) continue;
                        list.remove(privacyItem);
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        EMLog.d(TAG, "current user is not exsit in the black list");
                        return;
                    }
                    privacyListManager.declineDefaultList();
                    privacyListManager.updatePrivacyList(black_list_name, list);
                    if (list.size() > 0) {
                        privacyListManager.setDefaultListName(black_list_name);
                        privacyListManager.setActiveListName(black_list_name);
                    }
                } else {
                    EMLog.d(TAG, "current user is not exsit in the black list");
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new EaseMobException(exception.getMessage());
        }
    }

    public static String getContactChangeAction() {
        return "com.easemob.contact.changed_" + EMChatConfig.getInstance().APPKEY;
    }

    void checkConnection() throws EaseMobException {
        if (this.xmppConnectionManager == null) {
            return;
        }
        if (this.xmppConnectionManager.getConnection() == null) {
            return;
        }
        if (!this.xmppConnectionManager.getConnection().isConnected() || !this.xmppConnectionManager.getConnection().isAuthenticated()) {
            EMLog.e(TAG, "network unconnected");
            if (NetUtils.hasDataConnection(EMChat.getInstance().getAppContext())) {
                EMLog.d(TAG, "try to reconnect after check connection failed");
            }
        }
    }

    void loadContacts() {
        if (!EMChatManager.getInstance().getChatOptions().getUseRoster() && !this.enableRosterVersion) {
            EMLog.d(TAG, "roster is disabled, skip load contacts from db");
            return;
        }
        if (i.a() == null) {
            EMLog.d(TAG, "first time exec. no contact db");
            return;
        }
        List<EMContact> list = i.a().i();
        for (EMContact eMContact : list) {
            this.contactTable.put(eMContact.username, eMContact);
        }
        EMLog.d(TAG, "loaded contacts:" + this.contactTable.size());
        if (this.rosterStorage != null) {
            EMLog.d(TAG, "sync roster storage with db");
            this.rosterStorage.loadEntries();
        }
    }

    boolean hasContact(String string) {
        return this.contactTable.get(string) != null;
    }
}

