/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.chat;

import android.util.Pair;
import com.easemob.EMCallBack;
import com.easemob.EMChatRoomChangeListener;
import com.easemob.EMConnectionListener;
import com.easemob.EMValueCallBack;
import com.easemob.analytics.EMPerformanceCollector;
import com.easemob.analytics.EMTimeTag;
import com.easemob.chat.EMChat;
import com.easemob.chat.EMChatManager;
import com.easemob.chat.EMChatRoom;
import com.easemob.chat.EMContactManager;
import com.easemob.chat.EMCursorResult;
import com.easemob.chat.EMLeaveRoom;
import com.easemob.chat.EMMultiUserChatManager;
import com.easemob.chat.EMMultiUserChatProcessor;
import com.easemob.chat.EMSessionManager;
import com.easemob.chat.core.d;
import com.easemob.chat.core.e;
import com.easemob.chat.core.i;
import com.easemob.chat.core.p;
import com.easemob.chat.core.r;
import com.easemob.cloud.EMHttpClient;
import com.easemob.exceptions.EaseMobException;
import com.easemob.util.EMLog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class EMChatRoomManager
implements r {
    private static final String TAG = "EMChatRoomManager";
    Map<String, EMChatRoom> allChatRooms = new ConcurrentHashMap<String, EMChatRoom>();
    ArrayList<EMChatRoomChangeListener> chatRoomChangeListeners = new ArrayList();
    ArrayList<EMChatRoomChangeEvent> offlineChatRoomEvents = new ArrayList();
    boolean allChatRoomLoaded;
    private EMMultiUserChatProcessor chatProcessor = new EMMultiUserChatProcessor();
    private d cleaner = d.a(1);
    private boolean deadRoomLoaded = false;
    private EMConnectionListener cnnListener = null;
    private ExecutorService threadPool = null;

    EMChatRoomManager() {
    }

    EMCursorResult<EMChatRoom> getChatRoomsFromServer(int n2, String string) throws EaseMobException {
        this.checkConnection();
        String string2 = String.valueOf(p.c().L()) + "/chatrooms";
        Pair<Integer, String> pair = EMHttpClient.getInstance().sendRequestWithToken(string2, null, EMHttpClient.GET);
        int n3 = (Integer)pair.first;
        String string3 = (String)pair.second;
        if (n3 == 200 || n3 == 204) {
            try {
                JSONObject jSONObject = new JSONObject(string3);
                String string4 = null;
                ArrayList<EMChatRoom> arrayList = new ArrayList<EMChatRoom>();
                EMCursorResult<EMChatRoom> eMCursorResult = new EMCursorResult<EMChatRoom>();
                if (jSONObject.has("cursor")) {
                    string4 = jSONObject.getString("cursor");
                    eMCursorResult.setCursor(string4);
                }
                if (jSONObject.has("data")) {
                    JSONArray jSONArray = jSONObject.getJSONArray("data");
                    int n4 = 0;
                    while (n4 < jSONArray.length()) {
                        JSONObject jSONObject2 = jSONArray.getJSONObject(n4);
                        EMChatRoom eMChatRoom = this.parseRoom(false, jSONObject2);
                        arrayList.add(eMChatRoom);
                        ++n4;
                    }
                    eMCursorResult.setCursor(string4);
                    eMCursorResult.setData((EMChatRoom)((Object)arrayList));
                }
                return eMCursorResult;
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
                throw new EaseMobException(jSONException.toString());
            }
        }
        throw new EaseMobException(string3);
    }

    List<EMChatRoom> getJoinedChatRooms() throws EaseMobException {
        EMChatManager.getInstance().checkConnection();
        try {
            List<EMChatRoom> list = this.retrieveChatRooms(false);
            this.syncWithServers(list);
            return list;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private List<EMChatRoom> retrieveChatRooms(boolean bl) throws EaseMobException {
        String string = String.valueOf(p.c().L()) + "/users/" + EMChatManager.getInstance().getCurrentUser() + "/joined_chatrooms";
        Pair<Integer, String> pair = EMHttpClient.getInstance().sendRequestWithToken(string, null, EMHttpClient.GET);
        int n2 = (Integer)pair.first;
        String string2 = (String)pair.second;
        ArrayList<EMChatRoom> arrayList = null;
        if (n2 == 200 || n2 == 204) {
            try {
                JSONObject jSONObject = new JSONObject(string2);
                if (jSONObject.has("data")) {
                    arrayList = new ArrayList<EMChatRoom>();
                    JSONArray jSONArray = jSONObject.getJSONArray("data");
                    int n3 = 0;
                    while (n3 < jSONArray.length()) {
                        JSONObject jSONObject2 = jSONArray.getJSONObject(n3);
                        EMChatRoom eMChatRoom = this.parseRoom(bl, jSONObject2);
                        arrayList.add(eMChatRoom);
                        ++n3;
                    }
                }
                return arrayList;
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
                throw new EaseMobException(jSONException.toString());
            }
        }
        throw new EaseMobException(string2);
    }

    private EMChatRoom parseRoom(boolean bl, JSONObject jSONObject) throws JSONException {
        EMChatRoom eMChatRoom = new EMChatRoom();
        EMMultiUserChatManager.getInstance().parseRoom(eMChatRoom, bl, jSONObject);
        return eMChatRoom;
    }

    private void syncWithServers(List<EMChatRoom> list) {
        for (EMChatRoom object2 : list) {
            this.saveRoomInCache(object2);
            this.saveRoomInDB(object2);
        }
        Set<String> set = this.allChatRooms.keySet();
        ArrayList arrayList = new ArrayList();
        for (String string : set) {
            boolean bl = false;
            for (EMChatRoom eMChatRoom : list) {
                if (!eMChatRoom.getId().equals(string)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(string);
        }
        Iterator<String> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string;
            string = iterator.next();
            EMLog.d(TAG, "delete local room which did not exists on server:" + string);
            this.deleteLocalChatRoom(string);
        }
    }

    EMChatRoom getChatRoomFromServer(String string) throws EaseMobException {
        this.checkConnection();
        return this.getChatRoomFromRest(string, false);
    }

    public List<EMChatRoom> getAllChatRooms() {
        return Collections.unmodifiableList(new ArrayList<EMChatRoom>(this.allChatRooms.values()));
    }

    private Map<String, EMChatRoom> loadAllChatRooms() {
        EMTimeTag eMTimeTag = new EMTimeTag();
        eMTimeTag.start();
        this.allChatRooms = i.a().g();
        EMLog.d(TAG, "load all chat rooms from db. size:" + this.allChatRooms.values().size());
        if (this.allChatRooms != null && this.allChatRooms.size() > 0) {
            EMPerformanceCollector.collectLoadAllLocalChatRooms(this.allChatRooms.size(), eMTimeTag.stop());
        }
        return this.allChatRooms;
    }

    public EMChatRoom getChatRoom(String string) {
        return this.allChatRooms.get(string);
    }

    private EMChatRoom getChatRoomFromRest(String string, boolean bl) throws EaseMobException {
        String string2 = String.valueOf(p.c().L()) + "/chatrooms/" + string;
        Pair<Integer, String> pair = EMHttpClient.getInstance().sendRequestWithToken(string2, null, EMHttpClient.GET, 20000);
        int n2 = (Integer)pair.first;
        String string3 = (String)pair.second;
        if (n2 == 200 || n2 == 204) {
            try {
                JSONObject jSONObject = new JSONObject(string3);
                if (jSONObject.has("data")) {
                    JSONObject jSONObject2 = jSONObject.getJSONArray("data").getJSONObject(0);
                    EMChatRoom eMChatRoom = this.parseRoom(true, jSONObject2);
                    return eMChatRoom;
                }
            }
            catch (JSONException jSONException) {
                EMLog.e(TAG, jSONException.getMessage());
                throw new EaseMobException(jSONException.toString());
            }
        }
        throw new EaseMobException(string3);
    }

    public void addChangeListener(EMChatRoomChangeListener eMChatRoomChangeListener) {
        EMLog.d(TAG, "add chat room change listener:" + eMChatRoomChangeListener.getClass().getName());
        if (!this.chatRoomChangeListeners.contains(eMChatRoomChangeListener)) {
            this.chatRoomChangeListeners.add(eMChatRoomChangeListener);
        }
    }

    void removeChangeListener(EMChatRoomChangeListener eMChatRoomChangeListener) {
        this.chatRoomChangeListeners.remove(eMChatRoomChangeListener);
    }

    public void joinChatRoom(final String string, final EMValueCallBack<EMChatRoom> eMValueCallBack) {
        this.threadPool.submit(new Runnable(){

            @Override
            public void run() {
                block3: {
                    EMChatRoom eMChatRoom = null;
                    try {
                        eMChatRoom = EMChatRoomManager.this.joinChatRoom(string);
                        if (eMValueCallBack != null) {
                            eMValueCallBack.onSuccess(eMChatRoom);
                        }
                    }
                    catch (EaseMobException easeMobException) {
                        if (eMValueCallBack == null) break block3;
                        eMValueCallBack.onError(easeMobException.getErrorCode(), easeMobException.toString());
                    }
                }
            }
        });
    }

    public EMChatRoom joinChatRoom(String string) throws EaseMobException {
        EMChatManager.getInstance().checkConnection();
        EMChatRoom eMChatRoom = null;
        try {
            this.cleaner.b(new EMLeaveRoom(string, this));
            String string2 = EMContactManager.getEidFromGroupId(string);
            MultiUserChat multiUserChat = this.chatProcessor.getMUC(string2, 20000L);
            if (multiUserChat != null && !multiUserChat.isJoined()) {
                multiUserChat.join(EMChatManager.getInstance().getCurrentUser(), 20000L);
            }
            eMChatRoom = new EMChatRoom(string);
            this.saveRoomInDB(eMChatRoom);
            this.saveRoomInCache(eMChatRoom);
        }
        catch (Exception exception) {
            throw new EaseMobException(exception.toString());
        }
        try {
            eMChatRoom = this.getChatRoomFromServer(string);
            this.saveRoomInDB(eMChatRoom);
            this.saveRoomInCache(eMChatRoom);
        }
        catch (EaseMobException easeMobException) {
            EMLog.e(TAG, easeMobException.getMessage());
        }
        return eMChatRoom;
    }

    public void exitChatRoom(final String string, final EMCallBack eMCallBack) {
        this.threadPool.submit(new Runnable(){

            @Override
            public void run() {
                EMChatRoomManager.this.exitChatRoom(string);
                if (eMCallBack != null) {
                    eMCallBack.onSuccess();
                }
            }
        });
    }

    public void exitChatRoom(String string) {
        try {
            this.cmdExitRoom(string);
        }
        catch (EaseMobException easeMobException) {
            this.cleaner.a(new EMLeaveRoom(string, this));
        }
    }

    void cmdExitRoom(String string) throws EaseMobException {
        EMChatRoom eMChatRoom = this.getChatRoom(string);
        if (eMChatRoom == null) {
            EMLog.w(TAG, "this room is not exist,roomid:" + string);
            return;
        }
        if (eMChatRoom.getOwner().equals(EMChatManager.getInstance().getCurrentUser()) && !EMChatManager.getInstance().getChatOptions().isChatroomOwnerLeaveAllowed()) {
            EMLog.w(TAG, "owner should not leave the room : " + string);
            return;
        }
        EMLog.d(TAG, "try to exit room : " + string);
        String string2 = EMContactManager.getEidFromGroupId(string);
        try {
            EMChatManager.getInstance().deleteConversation(string, true);
            EMChatManager.getInstance().checkConnection();
            this.chatProcessor.leaveMUCWithoutJoin(string2);
            EMLog.d(TAG, "roomId : " + string + " was exited");
            this.deleteLocalChatRoom(string);
        }
        catch (XMPPException xMPPException) {
            EMLog.d(TAG, "exit room : " + string + " with error :" + xMPPException.toString());
            throw new EaseMobException(-998, xMPPException.toString());
        }
    }

    void handleRoomDestroy(String string) {
        String string2 = EMContactManager.getGroupIdFromEid(string);
        EMChatRoom eMChatRoom = this.allChatRooms.get(string2);
        String string3 = "";
        if (eMChatRoom != null) {
            string3 = eMChatRoom.getName();
        }
        EMLog.d(TAG, "chat room has been destroy on server:" + string2 + " name:" + string3);
        this.deleteLocalChatRoom(string2);
        for (EMChatRoomChangeListener eMChatRoomChangeListener : this.chatRoomChangeListeners) {
            eMChatRoomChangeListener.onChatRoomDestroyed(string2, string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleUserRemove(String string) {
        Pair<String, String> pair = this.parseRoomJid(string);
        if (pair != null) {
            String string2 = (String)pair.first;
            String string3 = (String)pair.second;
            String string4 = "";
            EMLog.d(TAG, "user " + string2 + " has been removed from chat room:" + string3);
            EMChatRoom eMChatRoom = this.allChatRooms.get(string3);
            if (eMChatRoom != null) {
                string4 = eMChatRoom.getName();
            }
            if (string2.equals(EMChatManager.getInstance().getCurrentUser())) {
                this.deleteLocalChatRoom(string3);
            }
            ArrayList<EMChatRoomChangeListener> arrayList = this.chatRoomChangeListeners;
            synchronized (arrayList) {
                EMChatRoom eMChatRoom2 = this.getChatRoom(string3);
                if (eMChatRoom2 != null) {
                    eMChatRoom2.removeMember(string2);
                    i.a().b(eMChatRoom2);
                }
                for (EMChatRoomChangeListener eMChatRoomChangeListener : this.chatRoomChangeListeners) {
                    eMChatRoomChangeListener.onMemberKicked(string3, string4, string2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onMemberExit(String string) {
        Pair<String, String> pair = this.parseRoomJid(string);
        if (pair != null) {
            String string2 = "";
            EMLog.d(TAG, "user " + (String)pair.first + " has been removed from chat room:" + (String)pair.second);
            EMChatRoom eMChatRoom = this.allChatRooms.get(pair.second);
            if (eMChatRoom != null) {
                string2 = eMChatRoom.getName();
            }
            if (((String)pair.first).equals(EMChatManager.getInstance().getCurrentUser())) {
                this.deleteLocalChatRoom((String)pair.second);
            } else {
                ArrayList<EMChatRoomChangeListener> arrayList = this.chatRoomChangeListeners;
                synchronized (arrayList) {
                    for (EMChatRoomChangeListener eMChatRoomChangeListener : this.chatRoomChangeListeners) {
                        eMChatRoomChangeListener.onMemberExited((String)pair.second, string2, (String)pair.first);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onMemberJoined(String string) {
        Pair<String, String> pair = this.parseRoomJid(string);
        if (pair != null) {
            EMLog.d(TAG, "member " + (String)pair.first + " join the room : " + (String)pair.second);
            ArrayList<EMChatRoomChangeListener> arrayList = this.chatRoomChangeListeners;
            synchronized (arrayList) {
                EMChatRoom eMChatRoom = this.getChatRoom((String)pair.second);
                if (eMChatRoom != null) {
                    eMChatRoom.addMember((String)pair.first);
                    i.a().b(eMChatRoom);
                }
                for (EMChatRoomChangeListener eMChatRoomChangeListener : this.chatRoomChangeListeners) {
                    eMChatRoomChangeListener.onMemberJoined((String)pair.second, (String)pair.first);
                }
            }
        }
    }

    private Pair<String, String> parseRoomJid(String string) {
        int n2 = string.indexOf("/");
        if (n2 > 0) {
            String string2 = string.substring(n2 + 1);
            String string3 = string.substring(0, n2);
            String string4 = EMContactManager.getGroupIdFromEid(string3);
            return new Pair((Object)string2, (Object)string4);
        }
        return null;
    }

    void deleteLocalChatRoom(String string) {
        EMLog.d(TAG, "delete local chatroom:" + string);
        String string2 = EMContactManager.getEidFromGroupId(string);
        this.chatProcessor.removeMuc(string2);
        i.a().h(string);
        this.getAllChatRoom().remove(string);
        EMChatManager.getInstance().deleteConversation(string, true);
    }

    MultiUserChat getMUCWithoutJoin(String string) throws XMPPException {
        return this.chatProcessor.getMUCWithoutJoin(string);
    }

    private EMChatRoom saveRoomInCache(EMChatRoom eMChatRoom) {
        String string = eMChatRoom.getId();
        EMChatRoom eMChatRoom2 = this.getAllChatRoom().get(string);
        if (eMChatRoom2 != null) {
            eMChatRoom2.copyModel(eMChatRoom);
            return eMChatRoom2;
        }
        this.getAllChatRoom().put(string, eMChatRoom);
        return eMChatRoom;
    }

    private void saveRoomInDB(EMChatRoom eMChatRoom) {
        String string = eMChatRoom.getId();
        EMChatRoom eMChatRoom2 = i.a().f(string);
        if (eMChatRoom2 == null) {
            i.a().a(eMChatRoom);
        } else {
            i.a().b(eMChatRoom);
        }
    }

    Map<String, EMChatRoom> getAllChatRoom() {
        return this.allChatRooms;
    }

    void checkConnection() throws EaseMobException {
        EMSessionManager.getInstance().checkConnection();
    }

    void onInvitation(String string, String string2, String string3) {
        String string4 = string;
        EMChatRoom eMChatRoom = new EMChatRoom(string, string4);
        try {
            EMLog.d(TAG, "accept chat room invitation for room:" + string4);
            EMChatRoom object = this.joinChatRoom(string);
            if (object != null && object.getName() != null && !object.getName().equals("")) {
                eMChatRoom.copyModel(object);
            }
            string4 = eMChatRoom.getName();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (EMChat.getInstance().appInited) {
            for (EMChatRoomChangeListener eMChatRoomChangeListener : this.chatRoomChangeListeners) {
                EMLog.d(TAG, "fire chat room inviatation received event for room:" + string4);
            }
        } else {
            EMLog.d(TAG, "aff offline group inviatation received event for group:" + string4);
            this.offlineChatRoomEvents.add(new EMChatRoomChangeEvent(EMChatRoomEventType.Invitate, string, string4, string2, string3));
        }
    }

    void processOfflineMessages() {
        EMLog.d(TAG, "process offline chat room event start: " + this.offlineChatRoomEvents.size());
        block3: for (EMChatRoomChangeEvent eMChatRoomChangeEvent : this.offlineChatRoomEvents) {
            switch (eMChatRoomChangeEvent.type) {
                case Invitate: {
                    for (EMChatRoomChangeListener eMChatRoomChangeListener : this.chatRoomChangeListeners) {
                        EMLog.d(TAG, "fire chatroom inviatation received event for chatroom:" + eMChatRoomChangeEvent.roomName + " listener:" + eMChatRoomChangeListener.hashCode());
                    }
                    continue block3;
                }
            }
        }
        this.offlineChatRoomEvents.clear();
        EMLog.d(TAG, "proess offline group event finish");
    }

    @Override
    public void onInit() {
        this.threadPool = Executors.newFixedThreadPool(1);
        this.chatProcessor.onInit();
        this.cleaner.onInit();
        if (!EMChatManager.getInstance().getChatOptions().isAutomaticallyLeaveChatroomDisabledOnLogin()) {
            this.loadAllChatRooms();
        }
        if (this.cnnListener == null) {
            this.cnnListener = new EMConnectionListener(){

                @Override
                public void onConnected() {
                    if (EMChatManager.getInstance().getChatOptions().isAutomaticallyLeaveChatroomDisabledOnLogin()) {
                        return;
                    }
                    if (EMChatRoomManager.this.deadRoomLoaded) {
                        return;
                    }
                    List<EMChatRoom> list = EMChatRoomManager.this.getAllChatRooms();
                    if (list.size() > 0) {
                        ArrayList<e> arrayList = new ArrayList<e>();
                        for (EMChatRoom eMChatRoom : list) {
                            arrayList.add(new EMLeaveRoom(eMChatRoom.getId(), EMChatRoomManager.this));
                        }
                        EMChatRoomManager.this.cleaner.a(arrayList);
                    }
                    EMChatRoomManager.this.deadRoomLoaded = true;
                }

                @Override
                public void onDisconnected(int n2) {
                }
            };
        }
        EMChatManager.getInstance().addConnectionListener(this.cnnListener);
    }

    @Override
    public void onDestroy() {
        this.allChatRoomLoaded = false;
        this.deadRoomLoaded = false;
        if (this.allChatRooms != null) {
            this.allChatRooms.clear();
        }
        if (this.offlineChatRoomEvents != null) {
            this.offlineChatRoomEvents.clear();
        }
        EMLog.d(TAG, "init chat room manager");
        this.chatProcessor.onDestroy();
        this.cleaner.onDestroy();
    }

    private class EMChatRoomChangeEvent {
        String roomId;
        String roomName;
        String inviterUserName;
        String reason;
        EMChatRoomEventType type;

        public EMChatRoomChangeEvent(EMChatRoomEventType eMChatRoomEventType, String string, String string2, String string3, String string4) {
            this.type = eMChatRoomEventType;
            this.roomId = string;
            this.roomName = string2;
            this.inviterUserName = string3;
            this.reason = string4;
        }
    }

    private static enum EMChatRoomEventType {
        Invitate;

    }
}

