/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.chat;

import android.content.ComponentName;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.Process;
import android.text.TextUtils;
import android.util.Pair;
import com.easemob.EMCallBack;
import com.easemob.EMChatRoomChangeListener;
import com.easemob.EMConnectionListener;
import com.easemob.EMEventListener;
import com.easemob.EMMessageChangeEventData;
import com.easemob.EMNotifierEvent;
import com.easemob.EMValueCallBack;
import com.easemob.b.a;
import com.easemob.chat.ConnectionListener;
import com.easemob.chat.EMCallStateChangeListener;
import com.easemob.chat.EMChat;
import com.easemob.chat.EMChatConfig;
import com.easemob.chat.EMChatDB;
import com.easemob.chat.EMChatOptions;
import com.easemob.chat.EMChatRoom;
import com.easemob.chat.EMChatService;
import com.easemob.chat.EMCloudOperationCallback;
import com.easemob.chat.EMContact;
import com.easemob.chat.EMContactManager;
import com.easemob.chat.EMConversation;
import com.easemob.chat.EMConversationManager;
import com.easemob.chat.EMCursorResult;
import com.easemob.chat.EMCustomerService;
import com.easemob.chat.EMCustomerServiceConfiguration;
import com.easemob.chat.EMExtraService;
import com.easemob.chat.EMGroupManager;
import com.easemob.chat.EMGroupMessageListener;
import com.easemob.chat.EMKeywordSearchInfo;
import com.easemob.chat.EMMessage;
import com.easemob.chat.EMMessageHandler;
import com.easemob.chat.EMMessageListener;
import com.easemob.chat.EMMessageUtils;
import com.easemob.chat.EMMonitor;
import com.easemob.chat.EMMultiUserChatManager;
import com.easemob.chat.EMNotifier;
import com.easemob.chat.EMOfflineMessageHandler;
import com.easemob.chat.EMPresenceHandler;
import com.easemob.chat.EMPushNotificationHelper;
import com.easemob.chat.EMRecvAckListener;
import com.easemob.chat.EMSessionManager;
import com.easemob.chat.EMVoiceCallManager;
import com.easemob.chat.EncryptProvider;
import com.easemob.chat.core.EMConnectionManager;
import com.easemob.chat.core.c;
import com.easemob.chat.core.i;
import com.easemob.chat.core.j;
import com.easemob.chat.core.p;
import com.easemob.chat.core.q;
import com.easemob.cloud.EMHttpClient;
import com.easemob.cloud.HttpClientConfig;
import com.easemob.exceptions.EMExceptionUtils;
import com.easemob.exceptions.EMNetworkUnconnectedException;
import com.easemob.exceptions.EMNoActiveCallException;
import com.easemob.exceptions.EMServiceNotReadyException;
import com.easemob.exceptions.EaseMobException;
import com.easemob.util.CryptoUtils;
import com.easemob.util.EMLog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Pattern;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ChatManager;
import org.jivesoftware.smack.ChatManagerListener;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.json.JSONObject;

public class EMChatManager {
    private static final String TAG = "EMChatManager";
    private static final String NEW_MSG_BROADCAST = "easemob.newmsg.";
    private static final String READ_ACK_MSG_BROADCAST = "easemob.ackmsg.";
    private static final String DELIVERY_ACK_MSG_BROADCAST = "easemob.deliverymsg.";
    private static final String CONTACT_INVITE_EVENT_BROADCAST = "easemob.contact.invite.";
    private static final String OFFLINE_MSG_BROADCAST = "easemob.offlinemsg.";
    private static final String INCOMING_VOICE_CALL_BROADCAST = "easemob.incomingvoicecall.invite";
    private static final String INCOMING_CALL_BROADCAST = "easemob.incomingcall.invite";
    private static final String CMD_MSG_BROADCAST = "easemob.cmdmsg";
    private static EMChatManager instance = new EMChatManager();
    private ChatManager xmppChatManager;
    private EMConnectionManager xmppConnectionManager;
    private EMChatManagerListener chatManagerListener;
    private final EMMessageListener chatListener;
    private final EMGroupMessageListener groupChatListener;
    private final EMRecvAckListener recvAckListener;
    private Map<String, Chat> chats;
    private final List<ConnectionListener> connectionListeners = Collections.synchronizedList(new ArrayList());
    private List<EMConnectionListener> newConnectionListeners = Collections.synchronizedList(new ArrayList());
    private Handler handler = new Handler();
    private final XmppConnectionListener xmppConnectionListener = new XmppConnectionListener();
    private Context applicationContext;
    private EMNotifier notifier;
    private CryptoUtils cryptoUtils;
    private EncryptProvider encryptProvider = null;
    private ExecutorService threadPool = null;
    private EMChatOptions chatOptions;
    private ArrayList<Presence> offlineRosterPresenceList;
    ExecutorService msgCountThreadPool;
    EMOfflineMessageHandler offlineHandler = null;
    EMOfflineMessageHandler chatroomOfflineHandler = null;
    boolean stopService;

    public void login(String string, String string2, final EMCallBack eMCallBack) {
        if (!EMChat.getInstance().isSDKInited()) {
            throw new RuntimeException("SDK is not initialized!");
        }
        if (TextUtils.isEmpty((CharSequence)EMChatConfig.getInstance().APPKEY)) {
            throw new RuntimeException("please setup your appkey either in AndroidManifest.xml or through EMChat.setAppkey");
        }
        if (eMCallBack == null) {
            throw new IllegalArgumentException("callback is null!");
        }
        if (string == null || string2 == null || string.equals("") || string2.equals("")) {
            throw new IllegalArgumentException("username or password is null or empty!");
        }
        EMLog.e(TAG, "emchat manager login in process:" + Process.myPid());
        string = string.toLowerCase();
        EMSessionManager.getInstance().login(string, string2, true, new EMCallBack(){

            @Override
            public void onSuccess() {
                EMChatManager.this.doStartService();
                EMChatManager.this.saveAppname();
                eMCallBack.onSuccess();
            }

            @Override
            public void onProgress(int n2, String string) {
            }

            @Override
            public void onError(int n2, String string) {
                j.a().j();
                EMChatManager.this.doStopService();
                eMCallBack.onError(n2, string);
            }
        });
    }

    public void logout() {
        EMLog.d(TAG, " SDK Logout");
        EMSessionManager.getInstance().clearLastLoginUser();
        EMSessionManager.getInstance().clearLastLoginPwd();
        EMChat.getInstance().clear();
        try {
            EMContactManager.getInstance().reset();
            this.groupChatListener.clear();
            this.chatListener.clear();
            this.offlineHandler.reset();
            this.chatroomOfflineHandler.reset();
            this.chats.clear();
            EMConversationManager.getInstance().clear();
            EMMessageHandler.getInstance().onDestroy();
            EMCustomerService.getInstance().onDestroy();
            c.a().onDestroy();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        EMMultiUserChatManager.getInstance().onDestroy();
        try {
            if (i.a() != null) {
                i.a().b();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            EMSessionManager.getInstance().syncLogout();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        j.a().j();
        EMChat.getInstance().appInited = false;
        if (EMChatConfig.isDebugTrafficMode()) {
            a.c();
        }
        EMMonitor.getInstance().getMonitorDB().b(this.applicationContext.getPackageName());
        this.doStopService();
    }

    public void logout(final EMCallBack eMCallBack) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                if (eMCallBack != null) {
                    eMCallBack.onProgress(0, null);
                }
                EMChatManager.this.logout();
                if (eMCallBack != null) {
                    eMCallBack.onSuccess();
                }
            }
        };
        thread.setPriority(9);
        thread.start();
    }

    public void logout(final boolean bl, final EMCallBack eMCallBack) {
        if (eMCallBack == null) {
            throw new RuntimeException("callback is null");
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                eMCallBack.onProgress(0, null);
                int n2 = EMChatManager.this.logout(bl);
                if (n2 == 0) {
                    eMCallBack.onSuccess();
                } else {
                    eMCallBack.onError(-3000, "unbind devicetoken failed");
                }
            }
        };
        thread.setPriority(9);
        thread.start();
    }

    public int logout(boolean bl) {
        try {
            EMPushNotificationHelper.getInstance().onDestroy(bl);
        }
        catch (EaseMobException easeMobException) {
            return -3000;
        }
        catch (Exception exception) {
            return -3000;
        }
        this.logout();
        return 0;
    }

    void changePasswordOnServer(String string) throws EaseMobException {
        EMSessionManager.getInstance().changePasswordXMPP(string);
    }

    public void createAccountOnServer(String string, String string2) throws EaseMobException {
        string = string.toLowerCase();
        Pattern pattern = Pattern.compile("^[a-zA-Z0-9_-]{1,}$");
        boolean bl = pattern.matcher(string).find();
        if (!bl) {
            throw new EaseMobException(-1025, "illegal user name");
        }
        EMSessionManager.getInstance().createAccountRest(string, string2);
    }

    public boolean isConnected() {
        return EMSessionManager.getInstance().isConnected();
    }

    public void registerEventListener(EMEventListener eMEventListener) {
        EMNotifier.getInstance(this.applicationContext).registerEventListener(eMEventListener);
    }

    public void registerEventListener(EMEventListener eMEventListener, EMNotifierEvent.Event[] eventArray) {
        EMNotifier.getInstance(this.applicationContext).registerEventListener(eMEventListener, eventArray);
    }

    public void unregisterEventListener(EMEventListener eMEventListener) {
        EMNotifier.getInstance(this.applicationContext).removeEventListener(eMEventListener);
    }

    private EMChatManager() {
        this.chats = new HashMap<String, Chat>();
        this.chatListener = new EMMessageListener(this);
        this.groupChatListener = new EMGroupMessageListener(this);
        this.recvAckListener = new EMRecvAckListener();
        this.chatManagerListener = new EMChatManagerListener();
        this.offlineRosterPresenceList = new ArrayList();
        this.cryptoUtils = new CryptoUtils();
        this.cryptoUtils.init(1);
        this.threadPool = Executors.newCachedThreadPool();
        this.msgCountThreadPool = Executors.newSingleThreadExecutor();
        this.chatOptions = new EMChatOptions();
        new ChatServiceConnection();
        this.offlineHandler = new EMOfflineMessageHandler();
        this.chatroomOfflineHandler = new EMOfflineMessageHandler();
        this.chatroomOfflineHandler.setPublishInterval(1000L);
    }

    public static synchronized EMChatManager getInstance() {
        if (EMChatManager.instance.applicationContext == null) {
            EMChatManager.instance.applicationContext = EMChat.getInstance().getAppContext();
        }
        return instance;
    }

    synchronized EMChatManager onInit() {
        EMLog.d(TAG, "init chat manager");
        if (this.applicationContext == null) {
            this.applicationContext = EMChat.getInstance().getAppContext();
        }
        this.notifier = EMNotifier.getInstance(this.applicationContext);
        c.a().onInit();
        return this;
    }

    void onNewConnectionCreated(EMConnectionManager eMConnectionManager) {
        EMLog.d(TAG, "on new connection created");
        this.init(eMConnectionManager);
        EMMultiUserChatManager.getInstance().onInit();
        EMPushNotificationHelper.getInstance().onInit();
        EMCustomerService.getInstance().onInit();
        this.addPacketListeners(eMConnectionManager.getConnection());
        if (EMContactManager.getInstance().enableRosterVersion) {
            EMLog.d(TAG, "enable roster version. set roster storage");
            eMConnectionManager.getConnection().setRosterStorage(EMContactManager.getInstance().getRosterStorage(this.applicationContext));
            EMContactManager.getInstance().loadContacts();
        }
        this.doStartService();
    }

    void onAppInited() {
        try {
            this.processOfflinePresenceMessages();
            EMMultiUserChatManager.getInstance().onAppReady();
            this.processOfflineMessages();
            this.processOfflineCmdMessages();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void addPacketListeners(XMPPConnection xMPPConnection) {
        if (xMPPConnection.isConnected() && xMPPConnection.isAuthenticated()) {
            return;
        }
        MessageTypeFilter messageTypeFilter = new MessageTypeFilter(Message.Type.chat);
        xMPPConnection.addPacketListener(this.chatListener, messageTypeFilter);
        MessageTypeFilter messageTypeFilter2 = new MessageTypeFilter(Message.Type.groupchat);
        xMPPConnection.addPacketListener(this.groupChatListener, messageTypeFilter2);
        MessageTypeFilter messageTypeFilter3 = new MessageTypeFilter(Message.Type.normal);
        xMPPConnection.addPacketListener(this.recvAckListener, messageTypeFilter3);
        MessageTypeFilter messageTypeFilter4 = new MessageTypeFilter(Message.Type.notify);
        xMPPConnection.addPacketListener(new PacketListener(){

            @Override
            public void processPacket(Packet packet) {
                EMMessageListener.ackMessage((Message)packet);
            }
        }, messageTypeFilter4);
        PacketTypeFilter packetTypeFilter = new PacketTypeFilter(Presence.class){

            @Override
            public boolean accept(Packet packet) {
                Presence presence;
                return packet instanceof Presence && ((presence = (Presence)packet).getType().equals((Object)Presence.Type.subscribed) || presence.getType().equals((Object)Presence.Type.subscribe) || presence.getType().equals((Object)Presence.Type.unsubscribed) || presence.getType().equals((Object)Presence.Type.unsubscribe));
            }
        };
        this.xmppConnectionManager.getConnection().addPacketListener(new SingleInvitationListener(), packetTypeFilter);
    }

    private void init(EMConnectionManager eMConnectionManager) {
        EMLog.d(TAG, "init chat manager");
        if (eMConnectionManager == null || eMConnectionManager.getConnection() == null) {
            EMLog.e(TAG, "error in Chat Manage init. connection is null");
            return;
        }
        try {
            c.a().a(eMConnectionManager);
            this.chats.clear();
            this.xmppConnectionManager = eMConnectionManager;
            this.xmppChatManager = eMConnectionManager.getConnection().getChatManager();
            this.xmppChatManager.addChatListener(this.chatManagerListener);
            EMMessageHandler.getInstance().onInit();
            eMConnectionManager.setChatConnectionListener(this.xmppConnectionListener);
            try {
                if (Class.forName("com.easemob.chat.EMVoiceCallManager") != null) {
                    EMVoiceCallManager.getInstance().init();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.offlineHandler.setPublishInterval(this.getChatOptions().getOfflineInterval());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void processOfflinePresenceMessages() {
        EMLog.d(TAG, "process offline RosterPresence msg start");
        for (Presence presence : this.offlineRosterPresenceList) {
            this.processRosterPresence(presence);
        }
        this.offlineRosterPresenceList.clear();
        EMLog.d(TAG, "proess offline RosterPresence msg finish");
    }

    void processOfflineCmdMessages() {
        this.offlineHandler.processOfflineCmdMessages();
        this.chatroomOfflineHandler.processOfflineCmdMessages();
    }

    void processOfflineMessages() {
        this.offlineHandler.onAppReady();
        this.chatroomOfflineHandler.onAppReady();
    }

    void notifyCmdMsg(EMMessage eMMessage) {
        this.notifier.sendCmdMsgBroadcast(eMMessage);
    }

    void onNewOfflineCmdMessage(EMMessage eMMessage) {
        if (eMMessage.getChatType() == EMMessage.ChatType.ChatRoom) {
            this.chatroomOfflineHandler.addOfflineCmdMessage(eMMessage);
            return;
        }
        this.offlineHandler.addOfflineCmdMessage(eMMessage);
    }

    void onNewOfflineMessage(EMMessage eMMessage) {
        if (eMMessage.getChatType() == EMMessage.ChatType.ChatRoom) {
            this.chatroomOfflineHandler.onNewOfflineMessage(eMMessage);
            return;
        }
        this.offlineHandler.onNewOfflineMessage(eMMessage);
    }

    private void processRosterPresence(Presence presence) {
        EMPresenceHandler.getInstance().processRosterPresence(presence);
    }

    private void acceptInvitation(String string, boolean bl) throws EaseMobException {
        EMPresenceHandler.getInstance().acceptInvitation(string, bl);
    }

    public void acceptInvitation(String string) throws EaseMobException {
        this.acceptInvitation(EMContactManager.getEidFromUserName(string), true);
    }

    public void refuseInvitation(String string) throws EaseMobException {
        EMPresenceHandler.getInstance().refuseInvitation(string);
    }

    public void sendMessage(EMMessage eMMessage) throws EaseMobException {
        this.sendMessage(eMMessage, null);
    }

    public void sendMessage(EMMessage eMMessage, EMCallBack eMCallBack) {
        EMCallBack eMCallBack2 = this.getInnerCallBack(eMCallBack, eMMessage);
        if (this.xmppConnectionManager == null) {
            EMMessageUtils.asyncCallback(eMCallBack2, -1022, "connection init is failed due to failed login");
            return;
        }
        int n2 = EMMessageUtils.checkMessageError(eMMessage);
        if (n2 != 0) {
            eMMessage.status = EMMessage.Status.FAIL;
            ContentValues contentValues = new ContentValues();
            contentValues.put("status", String.valueOf(eMMessage.status.ordinal()));
            i.a().a(eMMessage.msgId, contentValues);
            if (eMCallBack2 != null) {
                EMMessageUtils.asyncCallback(eMCallBack2, n2, "send message error");
            }
        } else if (eMMessage.getChatType() == EMMessage.ChatType.GroupChat || eMMessage.getChatType() == EMMessage.ChatType.ChatRoom) {
            EMMessageHandler.getInstance().sendGroupMessage(eMMessage, eMCallBack2);
        } else {
            Chat chat;
            String string = eMMessage.to.eid;
            if (!string.contains("@")) {
                StringBuilder stringBuilder = new StringBuilder(String.valueOf(string)).append("@");
                EMChatConfig.getInstance();
                string = stringBuilder.append(EMChatConfig.DOMAIN).toString();
            }
            if ((chat = this.chats.get(string)) == null) {
                EMLog.d(TAG, "create a new chat for jid:" + string);
                chat = this.xmppChatManager.createChat(string, null);
            }
            EMMessageHandler.getInstance().sendMessage(chat, eMMessage, eMCallBack2);
        }
    }

    private EMCallBack getInnerCallBack(final EMCallBack eMCallBack, final EMMessage eMMessage) {
        EMCallBack eMCallBack2 = new EMCallBack(){

            @Override
            public void onSuccess() {
                if (eMCallBack != null) {
                    eMCallBack.onSuccess();
                }
                if (eMMessage.messageStatusCallBack != null) {
                    eMMessage.messageStatusCallBack.onSuccess();
                }
            }

            @Override
            public void onProgress(int n2, String string) {
                if (eMCallBack != null) {
                    eMCallBack.onProgress(n2, string);
                }
                if (eMMessage.messageStatusCallBack != null) {
                    eMMessage.messageStatusCallBack.onProgress(n2, string);
                }
            }

            @Override
            public void onError(int n2, String string) {
                if (eMCallBack != null) {
                    eMCallBack.onError(n2, string);
                }
                if (eMMessage.messageStatusCallBack != null) {
                    eMMessage.messageStatusCallBack.onError(n2, string);
                }
            }
        };
        return eMCallBack2;
    }

    public void sendGroupMessage(EMMessage eMMessage, EMCallBack eMCallBack) {
        EMMessageHandler.getInstance().sendGroupMessage(eMMessage, eMCallBack);
    }

    void notifyMessage(EMMessage eMMessage) {
        this.offlineHandler.stop();
        this.chatroomOfflineHandler.stop();
        this.notifier.notifyChatMsg(eMMessage);
    }

    void broadcastMessage(EMMessage eMMessage) {
        EMLog.d(TAG, "broad offline msg");
        this.notifier.sendBroadcast(eMMessage);
    }

    void notifiyReadAckMessage(String string, String string2) {
        this.notifier.sendReadAckMsgBroadcast(string, string2);
    }

    void notifyDeliveryAckMessage(String string, String string2) {
        this.notifier.sendDeliveryAckMsgBroadcast(string, string2);
    }

    void notifyMessageChanged(EMMessageChangeEventData eMMessageChangeEventData) {
        this.notifier.publishEvent(EMNotifierEvent.Event.EventMessageChanged, eMMessageChangeEventData);
    }

    void notifyIncomingCall(String string, EMVoiceCallManager.CallType callType) {
        this.notifier.sendIncomingVoiceCallBroadcast(string, callType.toString());
    }

    public String getNewMessageBroadcastAction() {
        return NEW_MSG_BROADCAST + this.getBroadcastSuffix();
    }

    public String getCmdMessageBroadcastAction() {
        return CMD_MSG_BROADCAST + this.getBroadcastSuffix();
    }

    public String getAckMessageBroadcastAction() {
        return READ_ACK_MSG_BROADCAST + this.getBroadcastSuffix();
    }

    public String getDeliveryAckMessageBroadcastAction() {
        return DELIVERY_ACK_MSG_BROADCAST + this.getBroadcastSuffix();
    }

    public String getContactInviteEventBroadcastAction() {
        return CONTACT_INVITE_EVENT_BROADCAST + this.getBroadcastSuffix();
    }

    public String getOfflineMessageBroadcastAction() {
        return OFFLINE_MSG_BROADCAST + this.getBroadcastSuffix();
    }

    public String getIncomingVoiceCallBroadcastAction() {
        return INCOMING_VOICE_CALL_BROADCAST + this.getBroadcastSuffix();
    }

    public String getIncomingCallBroadcastAction() {
        return INCOMING_CALL_BROADCAST + this.getBroadcastSuffix();
    }

    private String getBroadcastSuffix() {
        if (TextUtils.isEmpty((CharSequence)EMChatConfig.getInstance().APPKEY)) {
            throw new RuntimeException("please setup your appkey either in AndroidManifest.xml or through EMChat.setAppkey");
        }
        if (this.applicationContext != null) {
            return String.valueOf(EMChatConfig.getInstance().APPKEY.replaceAll("#", ".").replaceAll("-", ".")) + this.applicationContext.getPackageName();
        }
        return EMChatConfig.getInstance().APPKEY.replaceAll("#", ".").replaceAll("-", ".");
    }

    public void ackMessageRead(String string, String string2) throws EaseMobException {
        if (!this.chatOptions.getRequireAck()) {
            EMLog.d(TAG, "chat option reqire ack set to false. skip send out ask msg read");
            return;
        }
        this.checkConnection();
        String string3 = EMContactManager.getEidFromUserName(string);
        Chat chat = this.chats.get(string3);
        if (chat == null) {
            chat = this.xmppChatManager.createChat(string3, null);
            this.chats.put(string3, chat);
        }
        EMMessageHandler.getInstance().ackMessageRead(this.getCurrentUser(), string, string2);
    }

    public void setMessageListened(EMMessage eMMessage) {
        eMMessage.setListened(true);
        i.a().f(eMMessage.getMsgId(), true);
    }

    void checkConnection() throws EaseMobException {
        EMSessionManager.getInstance().checkConnection();
    }

    public void addConnectionListener(final ConnectionListener connectionListener) {
        if (connectionListener != null) {
            this.connectionListeners.add(connectionListener);
            if (this.xmppConnectionManager != null && this.xmppConnectionManager.getConnection() != null && this.xmppConnectionManager.getConnection().isConnected()) {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        for (ConnectionListener connectionListener2 : EMChatManager.this.connectionListeners) {
                            if (connectionListener2 == null || !connectionListener2.equals(connectionListener)) continue;
                            connectionListener2.onConnected();
                        }
                    }
                });
            } else {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        for (ConnectionListener connectionListener2 : EMChatManager.this.connectionListeners) {
                            if (connectionListener2 == null || !connectionListener2.equals(connectionListener)) continue;
                            connectionListener2.onDisConnected("connection is disconnected");
                        }
                    }
                });
            }
        }
    }

    public void addConnectionListener(final EMConnectionListener eMConnectionListener) {
        if (eMConnectionListener == null) {
            return;
        }
        if (this.connectionListeners.contains(eMConnectionListener)) {
            return;
        }
        this.newConnectionListeners.add(eMConnectionListener);
        if (this.xmppConnectionManager != null && this.xmppConnectionManager.isConnected()) {
            this.threadPool.submit(new Runnable(){

                @Override
                public void run() {
                    eMConnectionListener.onConnected();
                }
            });
        } else {
            this.threadPool.submit(new Runnable(){

                @Override
                public void run() {
                    eMConnectionListener.onDisconnected(-1001);
                }
            });
        }
    }

    public void removeConnectionListener(ConnectionListener connectionListener) {
        if (connectionListener != null) {
            this.connectionListeners.remove(connectionListener);
        }
    }

    public void removeConnectionListener(EMConnectionListener eMConnectionListener) {
        if (eMConnectionListener != null) {
            this.newConnectionListeners.remove(eMConnectionListener);
        }
    }

    public EMMessage getMessage(String string) {
        return EMConversationManager.getInstance().getMessage(string);
    }

    void replaceMessageId(String string, String string2) {
        EMConversationManager.getInstance().replaceMessageId(string, string2);
    }

    void addMessage(EMMessage eMMessage) {
        EMConversationManager.getInstance().addMessage(eMMessage);
    }

    void addMessage(EMMessage eMMessage, boolean bl) {
        EMConversationManager.getInstance().addMessage(eMMessage, bl);
    }

    public EMConversation getConversation(String string) {
        return EMConversationManager.getInstance().getConversation(string);
    }

    public EMConversation getConversation(String string, boolean bl) {
        if (bl) {
            return EMConversationManager.getInstance().getConversation(string, bl, EMConversation.EMConversationType.GroupChat);
        }
        return EMConversationManager.getInstance().getConversation(string, bl, EMConversation.EMConversationType.Chat);
    }

    public EMConversation getConversationByType(String string, EMConversation.EMConversationType eMConversationType) {
        boolean bl = eMConversationType != EMConversation.EMConversationType.Chat;
        return EMConversationManager.getInstance().getConversation(string, bl, eMConversationType);
    }

    public boolean deleteConversation(String string) {
        return EMConversationManager.getInstance().deleteConversation(string);
    }

    public void deleteAllConversation() {
        EMConversationManager.getInstance().deleteAllConversations();
    }

    public void resetAllUnreadMsgCount() {
        EMConversationManager.getInstance().resetAllUnreadMsgCount();
    }

    public void markAllConversationsAsRead() {
        EMConversationManager.getInstance().resetAllUnreadMsgCount();
    }

    public boolean deleteConversation(String string, boolean bl) {
        return EMConversationManager.getInstance().deleteConversation(string, bl);
    }

    public boolean deleteConversation(String string, boolean bl, boolean bl2) {
        return EMConversationManager.getInstance().deleteConversation(string, bl, bl2);
    }

    public boolean clearConversation(String string) {
        return EMConversationManager.getInstance().clearConversation(string);
    }

    public void loadAllConversations(EMCallBack eMCallBack) {
        EMConversationManager.getInstance().asyncloadAllConversations(eMCallBack, this.chatOptions.getNumberOfMessagesLoaded());
    }

    public void asyncLoadAllConversations(EMCallBack eMCallBack) {
        this.asyncLoadAllConversations(eMCallBack, this.chatOptions.getNumberOfMessagesLoaded());
    }

    void asyncLoadAllConversations(EMCallBack eMCallBack, int n2) {
        EMConversationManager.getInstance().asyncloadAllConversations(eMCallBack, n2);
    }

    public void loadAllConversations() {
        EMConversationManager.getInstance().loadAllConversations(this.chatOptions.getNumberOfMessagesLoaded());
    }

    public Hashtable<String, EMConversation> getAllConversations() {
        return EMConversationManager.getInstance().getAllConversations();
    }

    public int getUnreadMsgsCount() {
        return EMConversationManager.getInstance().getUnreadMsgsCount();
    }

    public void activityResumed() {
        if (this.notifier != null) {
            this.notifier.resetNotificationCount();
            this.notifier.cancelNotificaton();
        }
    }

    public void saveMessage(EMMessage eMMessage) {
        EMConversationManager.getInstance().saveMessage(eMMessage);
    }

    public void saveMessage(EMMessage eMMessage, boolean bl) {
        EMConversationManager.getInstance().saveMessage(eMMessage, bl);
    }

    public boolean updateMessageBody(EMMessage eMMessage) {
        return i.a().b(eMMessage);
    }

    void updateMessageState(EMMessage eMMessage) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("status", String.valueOf(eMMessage.status.ordinal()));
        i.a().a(eMMessage.msgId, contentValues);
    }

    public List<String> getContactUserNames() throws EaseMobException {
        return EMContactManager.getInstance().getRosterUserNames();
    }

    public String getCurrentUser() {
        return EMSessionManager.getInstance().currentUser.username;
    }

    public EMChatOptions getChatOptions() {
        return this.chatOptions;
    }

    public void setChatOptions(EMChatOptions eMChatOptions) {
        this.chatOptions = eMChatOptions;
    }

    public void setEncryptProvider(EncryptProvider encryptProvider) {
        this.encryptProvider = encryptProvider;
    }

    public EncryptProvider getEncryptProvider() {
        if (this.encryptProvider == null) {
            EMLog.d(TAG, "encrypt provider is not set, create default");
            this.encryptProvider = new EncryptProvider(){

                @Override
                public byte[] encrypt(byte[] byArray, String string) {
                    try {
                        return EMChatManager.this.cryptoUtils.encrypt(byArray);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return byArray;
                    }
                }

                @Override
                public byte[] decrypt(byte[] byArray, String string) {
                    try {
                        return EMChatManager.this.cryptoUtils.decrypt(byArray);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return byArray;
                    }
                }
            };
        }
        return this.encryptProvider;
    }

    public void addVoiceCallStateChangeListener(EMCallStateChangeListener eMCallStateChangeListener) {
        EMVoiceCallManager.getInstance().addStateChangeListener(eMCallStateChangeListener);
    }

    public void addCallStateChangeListener(EMCallStateChangeListener eMCallStateChangeListener) {
        EMVoiceCallManager.getInstance().addStateChangeListener(eMCallStateChangeListener);
    }

    public void removeCallStateChangeListener(EMCallStateChangeListener eMCallStateChangeListener) {
        EMVoiceCallManager.getInstance().removeStateChangeListener(eMCallStateChangeListener);
    }

    public void makeVoiceCall(String string) throws EMServiceNotReadyException {
        EMVoiceCallManager.getInstance().makeCall(string, EMVoiceCallManager.CallType.audio);
    }

    public void answerCall() throws EMNoActiveCallException, EMNetworkUnconnectedException {
        EMVoiceCallManager.getInstance().answerCall();
    }

    public void rejectCall() throws EMNoActiveCallException {
        EMVoiceCallManager.getInstance().rejectCall();
    }

    public void endCall() {
        EMVoiceCallManager.getInstance().endCall();
    }

    public void makeVideoCall(String string) throws EMServiceNotReadyException {
        EMVoiceCallManager.getInstance().makeCall(string, EMVoiceCallManager.CallType.video);
    }

    CryptoUtils getCryptoUtils() {
        return this.cryptoUtils;
    }

    void doStartService() {
        EMLog.d(TAG, "do start service: context:" + this.applicationContext);
        this.stopService = false;
        Intent intent = new Intent(this.applicationContext, EMChatService.class);
        this.applicationContext.startService(intent);
    }

    void doStopService() {
        try {
            if (this.applicationContext == null) {
                EMLog.w(TAG, "applicationContext is null, the server is not started before");
                return;
            }
            EMLog.d(TAG, "do stop service");
            this.stopService = true;
            Intent intent = new Intent(this.applicationContext, EMChatService.class);
            this.applicationContext.stopService(intent);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void saveAppname() {
        EMMonitor.getInstance().getMonitorDB().a(this.applicationContext.getPackageName());
    }

    public void onReconnectionSuccessful() {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                for (ConnectionListener connectionListener : EMChatManager.this.connectionListeners) {
                    if (connectionListener == null) continue;
                    connectionListener.onReConnected();
                }
            }
        });
        this.threadPool.submit(new Runnable(){

            @Override
            public void run() {
                for (EMConnectionListener eMConnectionListener : EMChatManager.this.newConnectionListeners) {
                    eMConnectionListener.onConnected();
                }
            }
        });
    }

    public void asyncFetchMessage(EMMessage eMMessage) {
        EMMessageHandler.getInstance().asyncFetchMessage(eMMessage);
    }

    public String importMessage(EMMessage eMMessage, boolean bl) {
        i.a().c(eMMessage);
        if (bl) {
            this.addMessage(eMMessage);
            this.notifyMessage(eMMessage);
        }
        return eMMessage.getMsgId();
    }

    public synchronized void importMessages(List<EMMessage> list) {
        i.a().c(list);
    }

    public boolean updateCurrentUserNick(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            EMLog.e(TAG, "nick name is null or empty");
            return false;
        }
        String string2 = this.getCurrentUser();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            EMLog.e(TAG, "currentUser is null or empty");
            return false;
        }
        String string3 = this.getAccessToken();
        if (TextUtils.isEmpty((CharSequence)string3)) {
            EMLog.e(TAG, "token is null or empty");
            return false;
        }
        String string4 = HttpClientConfig.getBaseUrlByAppKey();
        StringBuilder stringBuilder = new StringBuilder(string4);
        stringBuilder.append("/");
        stringBuilder.append("users/");
        stringBuilder.append(string2);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Authorization", "Bearer " + string3);
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("nickname", (Object)string);
            Pair<Integer, String> pair = EMHttpClient.getInstance().sendRequest(stringBuilder.toString(), hashMap, jSONObject.toString(), EMHttpClient.PUT);
            String string5 = (String)pair.second;
            if (string5.contains("error")) {
                EMLog.e(TAG, "response error : " + string5);
                return false;
            }
        }
        catch (Exception exception) {
            EMLog.e(TAG, "error:" + exception.getMessage());
            return false;
        }
        return true;
    }

    void initDB(String string) {
        Context context = EMChat.getInstance().getAppContext();
        if (context == null) {
            return;
        }
        EMChatDB.initDB(string);
    }

    void loadDB() {
        EMMultiUserChatManager.getInstance().clearRooms();
        EMConversationManager.getInstance().clear();
        Thread thread = new Thread(){

            @Override
            public void run() {
                EMLog.d(EMChatManager.TAG, "");
                EMMultiUserChatManager.getInstance().loadLocalData();
                EMChatManager.this.loadAllConversations();
            }
        };
        thread.setPriority(9);
        thread.start();
    }

    public String getAccessToken() {
        if (this.applicationContext == null) {
            EMLog.e(TAG, "applicationContext is null");
            return null;
        }
        String string = EMChatConfig.getInstance().APPKEY;
        if (TextUtils.isEmpty((CharSequence)string)) {
            EMLog.e(TAG, "appkey is null or empty");
            return null;
        }
        try {
            return p.c().x();
        }
        catch (Exception exception) {
            EMLog.e(TAG, "gettoken is error:" + exception.getMessage());
            return null;
        }
    }

    private void notifyMessageHandlerConnectionConnected() {
        EMMessageHandler.getInstance().onConnected();
    }

    public List<String> getConversationsUnread() {
        return EMConversationManager.getInstance().getConversationsUnread();
    }

    public boolean areAllConversationsLoaded() {
        return EMConversationManager.getInstance().areAllConversationsLoaded();
    }

    public List<EMConversation> getConversationsByType(EMConversation.EMConversationType eMConversationType) {
        return EMConversationManager.getInstance().getConversationsByType(eMConversationType);
    }

    void forceReconnect() {
        EMLog.d(TAG, "manually force to reconnect to server");
        EMSessionManager.getInstance().forceReconnect();
    }

    public boolean isSlientMessage(EMMessage eMMessage) {
        return eMMessage.getBooleanAttribute("em_ignore_notification", false);
    }

    void configureCustomService(EMCustomerServiceConfiguration eMCustomerServiceConfiguration) {
        EMCustomerService.getInstance().setConfiguration(eMCustomerServiceConfiguration);
    }

    public void downloadFile(String string, String string2, Map<String, String> map, final EMCallBack eMCallBack) {
        EMHttpClient.getInstance().downloadFile(string, string2, map, new EMCloudOperationCallback(){

            @Override
            public void onSuccess(String string) {
                if (eMCallBack != null) {
                    eMCallBack.onSuccess();
                }
            }

            @Override
            public void onError(String string) {
                if (eMCallBack != null) {
                    eMCallBack.onError(-998, string);
                }
            }

            @Override
            public void onProgress(int n2) {
                if (eMCallBack != null) {
                    eMCallBack.onProgress(n2, null);
                }
            }
        });
    }

    public void addChatRoomChangeListener(EMChatRoomChangeListener eMChatRoomChangeListener) {
        EMMultiUserChatManager.getInstance().addChatRoomChangeListener(eMChatRoomChangeListener);
    }

    public void removeChatRoomChangeListener(EMChatRoomChangeListener eMChatRoomChangeListener) {
        EMMultiUserChatManager.getInstance().removeChatRoomChangeListener(eMChatRoomChangeListener);
    }

    public void joinChatRoom(String string, EMValueCallBack<EMChatRoom> eMValueCallBack) {
        EMMultiUserChatManager.getInstance().joinChatRoom(string, eMValueCallBack);
    }

    public void leaveChatRoom(String string) {
        EMMultiUserChatManager.getInstance().leaveChatRoom(string);
    }

    public EMCursorResult<EMChatRoom> fetchPublicChatRoomsFromServer(int n2, String string) throws EaseMobException {
        return EMMultiUserChatManager.getInstance().fetchPublicChatRoomsFromServer(n2, string);
    }

    public EMChatRoom fetchChatRoomFromServer(String string) throws EaseMobException {
        return EMMultiUserChatManager.getInstance().fetchChatRoomFromServer(string);
    }

    public EMChatRoom getChatRoom(String string) {
        return EMMultiUserChatManager.getInstance().getChatRoom(string);
    }

    public List<EMChatRoom> getAllChatRooms() {
        return EMMultiUserChatManager.getInstance().getAllChatRooms();
    }

    public List<EMContact> getRobotsFromServer() throws EaseMobException {
        return EMExtraService.getInstance().getRobotsFromServer();
    }

    public void setGCMProjectNumber(String string) {
        p.c().a(string);
    }

    public boolean isDirectCall() {
        return EMVoiceCallManager.getInstance().isDirectCall();
    }

    public Map<String, EMKeywordSearchInfo> getKeywordInfoList(String string) {
        return i.a().p(string);
    }

    public List<EMMessage> getMessagesByKeyword(String string, String string2, int n2, String string3) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        EMMessage.ChatType chatType = EMGroupManager.getInstance().getGroup(string3) != null ? EMMessage.ChatType.GroupChat : EMMessage.ChatType.Chat;
        return i.a().a(chatType, string, string2, n2, string3);
    }

    public void pauseVoiceTransfer() {
        EMVoiceCallManager.getInstance().pauseVoiceTransfer();
    }

    public void resumeVoiceTransfer() {
        EMVoiceCallManager.getInstance().resumeVoiceTransfer();
    }

    public int getVoiceInputLevel() {
        return EMVoiceCallManager.getInstance().getVoiceInputLevel();
    }

    public List<EMMessage> getMessagesByMsgType(EMMessage.Type type, EMMessage.ChatType chatType, String string, String string2, int n2) {
        if (string == null) {
            return null;
        }
        return EMConversationManager.getInstance().getMessagesByMsgType(type, chatType, string, string2, n2);
    }

    public long getTotalMessageCountByMsgType(EMMessage.Type type, EMMessage.ChatType chatType, String string) {
        if (string == null) {
            return -1L;
        }
        return EMConversationManager.getInstance().getTotalMessageCountByMsgType(type, chatType, string);
    }

    private class ChatServiceConnection
    implements ServiceConnection {
        private ChatServiceConnection() {
        }

        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            ((EMChatService.LocalBinder)iBinder).getService();
            EMLog.d(EMChatManager.TAG, "service connected");
        }

        public void onServiceDisconnected(ComponentName componentName) {
            EMLog.d(EMChatManager.TAG, "EaseMobService is disconnected");
            EMLog.d(EMChatManager.TAG, "service disconnected");
        }
    }

    private class EMChatManagerListener
    implements ChatManagerListener {
        private EMChatManagerListener() {
        }

        @Override
        public void chatCreated(Chat chat, boolean bl) {
            String string = chat.getParticipant();
            EMLog.d(EMChatManager.TAG, "xmpp chat created for: " + string);
            EMChatManager.this.chats.put(string, chat);
        }
    }

    private class SingleInvitationListener
    implements PacketListener {
        private SingleInvitationListener() {
        }

        @Override
        public void processPacket(Packet packet) {
            if (packet instanceof Presence) {
                Presence presence = (Presence)packet;
                if (EMChat.getInstance().appInited) {
                    EMChatManager.this.processRosterPresence(presence);
                } else {
                    EMLog.d(EMChatManager.TAG, "received roster presence, but app is not ready");
                    EMChatManager.this.offlineRosterPresenceList.add(presence);
                }
            }
        }
    }

    private class XmppConnectionListener
    implements q {
        private XmppConnectionListener() {
        }

        @Override
        public void connectionClosed() {
            EMLog.d(EMChatManager.TAG, "closing connection");
            EMChatManager.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    for (ConnectionListener connectionListener : EMChatManager.this.connectionListeners) {
                        if (connectionListener == null) continue;
                        connectionListener.onDisConnected("connectionClosed");
                    }
                }
            });
            EMChatManager.this.threadPool.submit(new Runnable(){

                @Override
                public void run() {
                    for (EMConnectionListener eMConnectionListener : EMChatManager.this.newConnectionListeners) {
                        eMConnectionListener.onDisconnected(-1013);
                    }
                }
            });
        }

        @Override
        public void connectionClosedOnError(final Exception exception) {
            EMLog.d(EMChatManager.TAG, "connectionClosedOnError");
            EMChatManager.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    for (ConnectionListener connectionListener : EMChatManager.this.connectionListeners) {
                        if (connectionListener == null) continue;
                        connectionListener.onDisConnected("connectionClosedOnError:" + exception.getMessage());
                    }
                }
            });
            EMChatManager.this.threadPool.submit(new Runnable(){

                @Override
                public void run() {
                    int n2;
                    int n3 = -1013;
                    if (exception != null && (n2 = EMExceptionUtils.fromExceptionToErrorCode(exception)) != -999) {
                        n3 = n2;
                    }
                    for (EMConnectionListener eMConnectionListener : EMChatManager.this.newConnectionListeners) {
                        try {
                            eMConnectionListener.onDisconnected(n3);
                        }
                        catch (Exception exception2) {
                            exception2.printStackTrace();
                        }
                    }
                }
            });
        }

        @Override
        public void reconnectingIn(int n2) {
            EMLog.d(EMChatManager.TAG, "reconnectingIn in " + n2);
        }

        @Override
        public void reconnectionFailed(final Exception exception) {
            EMLog.d(EMChatManager.TAG, "reconnectionFailed");
            EMChatManager.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    for (ConnectionListener connectionListener : EMChatManager.this.connectionListeners) {
                        if (connectionListener == null) continue;
                        connectionListener.onDisConnected(exception.getMessage());
                    }
                }
            });
            EMChatManager.this.threadPool.submit(new Runnable(){

                @Override
                public void run() {
                    int n2;
                    int n3 = -1013;
                    if (exception != null && (n2 = EMExceptionUtils.fromExceptionToErrorCode(exception)) != -999) {
                        n3 = n2;
                    }
                    for (EMConnectionListener eMConnectionListener : EMChatManager.this.newConnectionListeners) {
                        try {
                            eMConnectionListener.onDisconnected(n3);
                        }
                        catch (Exception exception2) {
                            exception2.printStackTrace();
                        }
                    }
                }
            });
        }

        @Override
        public void reconnectionSuccessful() {
            EMLog.d(EMChatManager.TAG, "reconnectionSuccessful");
            EMChatManager.this.onReconnectionSuccessful();
        }

        @Override
        public void onConnectionSuccessful() {
            EMLog.d(EMChatManager.TAG, "onConnectionSuccessful");
            EMChatManager.this.notifyMessageHandlerConnectionConnected();
            EMContactManager.getInstance().init(EMChat.getInstance().getAppContext(), EMChatManager.this.xmppConnectionManager);
            if (EMChatManager.this.xmppConnectionManager != null) {
                String string = EMSessionManager.getInstance().getLastLoginUser();
                String string2 = EMChatManager.this.xmppConnectionManager.getCurrentUser();
                p.c().e(string2);
                if (!(string2 == null || string != null && string.equals(string2))) {
                    EMSessionManager.getInstance().setLastLoginUser(string2);
                    EMSessionManager.getInstance().setLastLoginPwd(EMChatManager.this.xmppConnectionManager.getCurrentPwd());
                }
            }
            EMChatManager.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    for (ConnectionListener connectionListener : EMChatManager.this.connectionListeners) {
                        if (connectionListener == null) continue;
                        connectionListener.onConnected();
                    }
                }
            });
            EMChatManager.this.threadPool.submit(new Runnable(){

                @Override
                public void run() {
                    for (EMConnectionListener eMConnectionListener : EMChatManager.this.newConnectionListeners) {
                        eMConnectionListener.onConnected();
                    }
                }
            });
        }

        @Override
        public void onConnecting() {
            EMLog.d(EMChatManager.TAG, "onConnecting...");
        }
    }
}

