/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.chat;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.easemob.chat.core.c;
import com.easemob.chat.core.j;
import com.easemob.chat.core.p;
import com.easemob.util.EMLog;

public class EMChatConfig {
    private static final String TAG = "conf";
    private static final String CONFIG_EASEMOB_APPKEY = "EASEMOB_APPKEY";
    private static final String CONFIG_EASEMOB_CHAT_ADDRESS = "EASEMOB_CHAT_ADDRESS";
    private static final String CONFIG_EASEMOB_CHAT_DOMAIN = "EASEMOB_CHAT_DOMAIN";
    private static final String CONFIG_EASEMOB_GROUP_DOMAIN = "EASEMOB_GROUP_DOMAIN";
    private static final String CONFIG_EASEMOB_API_URL = "EASEMOB_API_URL";
    static String DOMAIN = "easemob.com";
    static String DOMAIN_SUFFIX = "@easemob.com";
    static String MUC_DOMAIN = "conference.easemob.com";
    static String MUC_DOMAIN_SUFFIX = "@conference.easemob.com";
    static final String UUID = "uuid";
    static final String SHARE_SERCRET = "share-secret";
    static final String TOKEN_ENTITY = "entities";
    public String APPKEY = null;
    private static boolean debugTrafficMode = false;
    private static EMChatConfig instance = null;
    private String chatServer;
    private String restServer;

    private EMChatConfig() {
    }

    public static EMChatConfig getInstance() {
        if (instance == null) {
            instance = new EMChatConfig();
        }
        return instance;
    }

    public static boolean isDebugTrafficMode() {
        return debugTrafficMode;
    }

    boolean loadConfig(Context context) {
        String string = context.getPackageName();
        ApplicationInfo applicationInfo = null;
        try {
            applicationInfo = context.getPackageManager().getApplicationInfo(string, 128);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            EMLog.e(TAG, nameNotFoundException.getMessage());
            EMLog.e(TAG, "\u627e\u4e0d\u5230ApplicationInfo");
        }
        if (applicationInfo != null) {
            Bundle bundle = applicationInfo.metaData;
            if (bundle == null) {
                EMLog.w(TAG, "\u8bf7\u786e\u8ba4meta\u5c5e\u6027\u5199\u5728\u6e05\u5355\u6587\u4ef6\u91cc\u7684application\u8282\u70b9\u4ee5\u5185");
            } else {
                String string2;
                String string3;
                String string4;
                String string5;
                String string6 = bundle.getString(CONFIG_EASEMOB_APPKEY);
                if (string6 == null && this.APPKEY == null) {
                    Log.w((String)TAG, (String)"EASEMOB_APPKEY is not set in AndroidManifest file");
                } else if (TextUtils.isEmpty((CharSequence)this.APPKEY)) {
                    this.APPKEY = string6;
                }
                String string7 = bundle.getString(CONFIG_EASEMOB_CHAT_ADDRESS);
                if (string7 != null) {
                    this.chatServer = string7;
                }
                if ((string5 = bundle.getString(CONFIG_EASEMOB_API_URL)) != null) {
                    this.restServer = string5;
                }
                if ((string4 = bundle.getString(CONFIG_EASEMOB_CHAT_DOMAIN)) != null) {
                    DOMAIN = string4;
                }
                if ((string3 = bundle.getString(CONFIG_EASEMOB_GROUP_DOMAIN)) != null) {
                    MUC_DOMAIN = string3;
                }
                if ((string2 = bundle.getString("GCM_PROJECT_NUMBER")) != null && p.c().b() == null) {
                    p.c().a(string2);
                }
            }
        }
        DOMAIN_SUFFIX = "@" + DOMAIN;
        MUC_DOMAIN_SUFFIX = "@" + MUC_DOMAIN;
        this.setAdvanceDebugConfig();
        p.c().d(this.APPKEY);
        EMLog.i(TAG, "EASEMOB_APPKEY is set to:" + this.APPKEY);
        if (this.chatServer != null && !this.chatServer.equals("")) {
            p.c().b(this.chatServer);
        }
        if (this.restServer != null && !this.restServer.equals("")) {
            p.c().c(this.restServer);
        }
        this.printConfig();
        return true;
    }

    private void setAdvanceDebugConfig() {
        try {
            String string = c.a().e();
            if (string != null) {
                EMLog.debugMode = Boolean.parseBoolean(string);
            }
            if (c.a().d() != null) {
                this.APPKEY = c.a().d();
            }
            String string2 = c.a().b();
            String string3 = c.a().c();
            if (string2 != null && string3 != null) {
                this.chatServer = string2;
                this.restServer = string3;
                p.c().b(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void printConfig() {
        EMLog.d(TAG, " APPKEY:" + this.APPKEY + " CHATSERVER:" + p.c().h() + " domain:" + DOMAIN);
        EMLog.d(TAG, "STORAGE_URL:" + p.c().l());
    }

    public String getDomain() {
        return DOMAIN;
    }

    public String getStorageUrl() {
        return j.a().c().a;
    }

    void setEnv(EMEnvMode eMEnvMode) {
        p.c().a(eMEnvMode);
    }

    void setSDKMode(EMSDKMode eMSDKMode) {
        p.c().a(eMSDKMode);
    }

    EMSDKMode getSDKMode() {
        return p.c().u();
    }

    EMEnvMode getEnvMode() {
        return p.c().t();
    }

    public static enum EMEnvMode {
        EMSandboxMode,
        EMProductMode,
        EMDevMode;

    }

    public static enum EMSDKMode {
        EMChatMode,
        EMHelpDeskMode;

    }
}

