/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.chat;

import android.content.Context;
import android.os.Process;
import android.text.TextUtils;
import android.util.Log;
import com.easemob.EMCallBack;
import com.easemob.analytics.EMActiveCollector;
import com.easemob.chat.EMChatConfig;
import com.easemob.chat.EMChatManager;
import com.easemob.chat.EMSessionManager;
import com.easemob.chat.InitSmackStaticCode;
import com.easemob.chat.core.c;
import com.easemob.chat.core.j;
import com.easemob.chat.core.p;
import com.easemob.debug.DebugHelper;
import com.easemob.util.EMLog;
import java.util.Random;

public class EMChat {
    private static final String TAG = "EaseMob";
    private static EMChat instance = new EMChat();
    boolean appInited = false;
    private boolean autoLogin = true;
    private boolean initSingleProcess = true;
    private boolean sdkInited = false;
    private Context appContext = null;
    private String userName = null;
    private String password = null;
    private static final String PID_FILE = ".easemob.pid";

    public static EMChat getInstance() {
        return instance;
    }

    public void setDebugMode(boolean bl) {
        String string;
        if (EMChat.getInstance().isSDKInited() && (string = c.a().e()) != null) {
            bl = Boolean.parseBoolean(string);
        }
        p.c().f(bl);
        EMLog.debugMode = bl;
    }

    public void setLogMode(EMLog.ELogMode eLogMode) {
        EMLog.setLogMode(eLogMode);
    }

    public void setAutoLogin(boolean bl) {
        this.autoLogin = bl;
    }

    public void setAppInited() {
        this.appInited = true;
        EMChatManager.getInstance().onAppInited();
    }

    public void setInitSingleProcess(boolean bl) {
        this.initSingleProcess = bl;
    }

    public void uploadLog(EMCallBack eMCallBack) {
        DebugHelper.uploadLog(this.appContext, j.a().c().a, eMCallBack);
    }

    public void setUserName(String string) {
        if (string == null || string.equals("")) {
            return;
        }
        this.userName = string;
    }

    public void setPassword(String string) {
        if (string == null || string.equals("")) {
            return;
        }
        this.password = string;
    }

    public void init(Context context) {
        if (this.initSingleProcess && this.checkSDKInited(context)) {
            Log.d((String)TAG, (String)"skip init easemob since already inited");
            return;
        }
        EMLog.e(TAG, "easemob init in process:" + Process.myPid());
        this.appContext = context.getApplicationContext();
        boolean bl = EMChatConfig.getInstance().loadConfig(this.appContext);
        if (!bl) {
            Log.e((String)TAG, (String)"wrong configuration");
            throw new RuntimeException("Initialization failed! : wrong configuration");
        }
        InitSmackStaticCode.initStaticCode(context);
        EMChatManager eMChatManager = EMChatManager.getInstance().onInit();
        EMSessionManager eMSessionManager = EMSessionManager.getInstance().onInit();
        String string = this.userName;
        EMLog.e(TAG, "passed userName : " + this.userName);
        if (string == null) {
            string = eMSessionManager.getLastLoginUser();
        }
        EMActiveCollector.sendActivePacket(this.appContext);
        EMLog.e(TAG, "is autoLogin : " + this.autoLogin);
        EMLog.e(TAG, "lastLoginUser : " + string);
        if (this.autoLogin) {
            if (this.isLoggedIn()) {
                String string2 = this.password;
                if (string2 == null) {
                    string2 = eMSessionManager.getLastLoginPwd();
                }
                eMSessionManager.login(string, string2, false, null);
            }
        } else if (string != null && !string.equals("")) {
            eMChatManager.initDB(string);
            eMChatManager.loadDB();
        }
        EMLog.e(TAG, "HuanXin SDK is initialized with version : " + p.c().d());
        this.sdkInited = true;
    }

    public String getVersion() {
        return p.c().d();
    }

    public Context getAppContext() {
        return this.appContext;
    }

    public void setEnv(EMChatConfig.EMEnvMode eMEnvMode) {
        EMChatConfig.getInstance().setEnv(eMEnvMode);
    }

    void setSDKMode(EMChatConfig.EMSDKMode eMSDKMode) {
        EMChatConfig.getInstance().setSDKMode(eMSDKMode);
    }

    public void setAppkey(String string) {
        EMChatConfig.getInstance().APPKEY = string;
        p.c().d(string);
    }

    public String getAppkey() {
        return p.c().v();
    }

    public void enalbeDNSConfig(boolean bl) {
        p.c().b(bl);
    }

    public boolean isLoggedIn() {
        if (!TextUtils.isEmpty((CharSequence)this.userName) && !TextUtils.isEmpty((CharSequence)this.password)) {
            return true;
        }
        EMSessionManager eMSessionManager = EMSessionManager.getInstance();
        String string = eMSessionManager.getLastLoginUser();
        String string2 = eMSessionManager.getLastLoginPwd();
        return string != null && string2 != null && !string.equals("") && !string2.equals("");
    }

    public void setServerAddress(String[] stringArray, String[] stringArray2) {
        if (stringArray == null || stringArray2 == null || stringArray.length < 1 || stringArray2.length < 1) {
            return;
        }
        this.enalbeDNSConfig(false);
        int n2 = new Random().nextInt(stringArray.length);
        String string = stringArray[n2];
        String[] stringArray3 = string.split(":");
        string = stringArray3[0];
        p.c().b(string);
        if (stringArray3.length == 2) {
            p.c().a(Integer.valueOf(stringArray3[1]));
        }
        n2 = new Random().nextInt(stringArray2.length);
        string = stringArray2[n2];
        string = string.split(":")[0];
        p.c().c(string);
    }

    boolean isSDKInited() {
        return this.sdkInited;
    }

    void clear() {
        this.userName = null;
        this.password = null;
    }

    private boolean checkSDKInited(Context context) {
        return this.sdkInited;
    }
}

