/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.chat;

import com.easemob.chat.EMCallDirection;
import com.easemob.chat.EMCallStateChangeListener;
import com.easemob.chat.EMSessionHandler;
import com.easemob.chat.EMStreamParams;
import com.easemob.chat.EMVoiceCallSession;
import com.easemob.exceptions.EMNetworkUnconnectedException;
import com.easemob.exceptions.EaseMobException;
import com.easemob.media.EIce;
import com.easemob.util.EMLog;
import com.xonami.javaBells.DefaultJingleSession;
import java.util.List;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.ContentPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.JingleIQ;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.JinglePacketFactory;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.Reason;
import org.jivesoftware.smack.XMPPConnection;
import org.json.JSONObject;

class EMCallerJingleSession
extends EMVoiceCallSession {
    private static final String TAG = EMCallerJingleSession.class.getSimpleName();
    private boolean callAccepted = false;
    private EIce caller;

    public EMCallerJingleSession(EMSessionHandler eMSessionHandler, String string, XMPPConnection xMPPConnection) {
        super(eMSessionHandler, string, xMPPConnection);
        this.callDirection = EMCallDirection.OUTGOING;
    }

    public EMCallerJingleSession buildPeer(String string) {
        this.peerJid = string;
        return this;
    }

    public void makeCall() throws EaseMobException {
        Object object;
        Object object2;
        EMLog.d(TAG, "callConfig is " + this.callConfig);
        try {
            this.streamParams = new EMStreamParams();
            object2 = new JSONObject(this.callConfig);
            this.streamParams.conferenceId = object = object2.getJSONObject("relayMS").getJSONObject("caller").getString("conferenceId");
            this.jingleStreamManager.initStreamParams(this.streamParams);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.caller = EIce.newCaller(this.callConfig);
        object2 = this.caller.getLocalContent();
        object = this.jingleStreamManager.createcontentList((String)object2);
        if (object == null) {
            this.closeSession(null);
            return;
        }
        JingleIQ jingleIQ = JinglePacketFactory.createSessionInitiate(this.connection.getUser(), this.peerJid, this.sessionId, (String)object2, (List<ContentPacketExtension>)object);
        jingleIQ.setStatistic(this.getCallStatistic(0));
        EMLog.i(TAG, "CALLER: sending jingle request: " + jingleIQ.toXML());
        try {
            this.connection.sendPacket(jingleIQ);
        }
        catch (IllegalStateException illegalStateException) {
            illegalStateException.printStackTrace();
            throw new EMNetworkUnconnectedException(illegalStateException.toString());
        }
        this.changeState(EMCallStateChangeListener.CallState.CONNECTING, EMCallStateChangeListener.CallError.ERROR_NONE);
    }

    @Override
    protected void closeSession(Reason reason) {
        super.closeSession(reason);
        this.connection.removePacketListener(this.jinglePacketHandler);
    }

    @Override
    public void handleSessionInitiate(JingleIQ jingleIQ) {
    }

    @Override
    public synchronized void handleSessionAccept(JingleIQ jingleIQ) {
        if (this.caller == null) {
            EMLog.d(TAG, "caller=null when handleSessionAccept");
            return;
        }
        if (!this.checkAndAck(jingleIQ)) {
            EMLog.d(TAG, "!checkAndAck(jiq) when handleSessionAccept");
            return;
        }
        this.state = DefaultJingleSession.SessionState.NEGOTIATING_TRANSPORT;
        try {
            Object object;
            String string = jingleIQ.getSdpJsonString();
            if (string == null) {
                object = jingleIQ.getContentList();
                string = this.contentListToJson((List<ContentPacketExtension>)object);
            }
            this.caller.callerNego(string, null);
            object = this.caller.waitforNegoResult();
            this.freeIce();
            this.handleNegoResult((String)object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.closeSession(Reason.FAILED_APPLICATION);
            this.changeState(EMCallStateChangeListener.CallState.DISCONNNECTED, EMCallStateChangeListener.CallError.ERROR_TRANSPORT);
        }
    }

    @Override
    protected synchronized void freeIce() {
        if (this.caller != null) {
            EMLog.d(TAG, "ice free");
            this.caller.freeCall();
            this.caller = null;
        }
    }

    @Override
    public void handleSessionTerminate(JingleIQ jingleIQ) {
        if (jingleIQ.getReason().getReason() == Reason.BUSY) {
            this.noNeedToCloseSesson = true;
            this.free();
            this.state = DefaultJingleSession.SessionState.CLOSED;
            this.jinglePacketHandler.removeJingleSession(this);
            this.changeState(EMCallStateChangeListener.CallState.DISCONNNECTED, EMCallStateChangeListener.CallError.ERROR_BUSY);
            return;
        }
        super.handleSessionTerminate(jingleIQ);
        this.callState = EMCallStateChangeListener.CallState.DISCONNNECTED;
        if (jingleIQ.getReason().getReason() == Reason.DECLINE) {
            this.free();
            this.changeState(this.callState, EMCallStateChangeListener.CallError.REJECTED);
        } else if (jingleIQ.getReason().getReason() == Reason.SUCCESS) {
            this.changeState(this.callState, EMCallStateChangeListener.CallError.ERROR_NONE);
        } else {
            this.free();
            this.changeState(this.callState, EMCallStateChangeListener.CallError.ERROR_TRANSPORT);
        }
    }

    @Override
    public void handleCallAccept(JingleIQ jingleIQ) {
        EMLog.d(TAG, "the call has been accepted by remote peer!");
        this.callAccepted = true;
        if (!this.checkAndAck(jingleIQ)) {
            return;
        }
        if (this.callState != EMCallStateChangeListener.CallState.CONNECTED) {
            return;
        }
        this.jingleStreamManager.startStream(this.streamParams);
        this.changeState(EMCallStateChangeListener.CallState.ACCEPTED, EMCallStateChangeListener.CallError.ERROR_NONE);
    }

    @Override
    protected void onConnectionConnected() {
        this.changeState(EMCallStateChangeListener.CallState.CONNECTED, EMCallStateChangeListener.CallError.ERROR_NONE);
        if (this.callAccepted && !this.jingleStreamManager.streamStarted()) {
            this.jingleStreamManager.startStream(this.streamParams);
            this.changeState(EMCallStateChangeListener.CallState.ACCEPTED, EMCallStateChangeListener.CallError.ERROR_NONE);
        }
    }
}

