/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.analytics;

import com.easemob.analytics.EMCollector;
import com.easemob.analytics.EMTimeTag;
import com.easemob.chat.EMGroup;
import com.easemob.util.EMLog;

public class EMPerformanceCollector
extends EMCollector {
    public static final String TAG = "[Collector][Perf]";
    public static final String RETRIEVE_GROUPS = "retrieve groups from server time";
    public static final String LOADING_ALL_CONVERSATIONS = "load all conversations time";
    public static final String LOAD_ALL_LOCAL_GROUPS = "load all local groups";
    public static final String LOAD_ALL_LOCAL_CHAT_ROOMS = "load all local chat rooms";
    public static final String RETRIEVE_ROSTER = "retrieve roster";
    public static final String DOWNLOAD_FILE = "download file time";
    public static final String UPLOAD_FILE = "upload file time";
    public static final String SYNC_GROUPS = "sync groups time";
    public static final String RETRIEVE_GROUP = "retrieve group detail";

    public static void collectRetrieveGroupsFromServerTime(int n2, long l2) {
        EMLog.d(TAG + EMPerformanceCollector.getTagPrefix(RETRIEVE_GROUPS), "time spent on loading groups size : " + n2 + " with time spent : " + EMPerformanceCollector.timeToString(l2));
    }

    public static void collectLoadingAllConversations(int n2, int n3, long l2) {
        EMLog.d(TAG + EMPerformanceCollector.getTagPrefix(LOADING_ALL_CONVERSATIONS), "time spent on loading all conversations : conversation size " + n2 + " messages count : " + n3 + " with time spent : " + EMPerformanceCollector.timeToString(l2));
    }

    public static void collectLoadAllLocalGroups(int n2, long l2) {
        EMLog.d(TAG + EMPerformanceCollector.getTagPrefix(LOAD_ALL_LOCAL_GROUPS), "load all local group with size : " + n2 + " timeSpent : " + EMPerformanceCollector.timeToString(l2));
    }

    public static void collectLoadAllLocalChatRooms(int n2, long l2) {
        EMLog.d(TAG + EMPerformanceCollector.getTagPrefix(LOAD_ALL_LOCAL_CHAT_ROOMS), "load all local chat rooms with size : " + n2 + " timeSpent : " + EMPerformanceCollector.timeToString(l2));
    }

    public static void collectRetrieveRoster(int n2, long l2) {
        EMLog.d(TAG + EMPerformanceCollector.getTagPrefix(RETRIEVE_ROSTER), "retrieve roster with size : " + n2 + " timeSpent : " + EMPerformanceCollector.timeToString(l2));
    }

    public static void collectDownloadFileTime(EMTimeTag eMTimeTag, long l2, String string) {
        EMLog.d(TAG + EMPerformanceCollector.getTagPrefix(DOWNLOAD_FILE), "download file : " + string + " size : " + l2 + " time spent : " + eMTimeTag.timeStr() + " speed(bytes/s) : " + l2 / eMTimeTag.timeSpent() * 1000L);
    }

    public static void collectUploadFileTime(EMTimeTag eMTimeTag, long l2, String string) {
        EMLog.d(TAG + EMPerformanceCollector.getTagPrefix(UPLOAD_FILE), "upload file : " + string + " size : " + l2 + " time spent : " + eMTimeTag.timeStr() + " speed(bytes/s) : " + l2 / eMTimeTag.timeSpent() * 1000L);
    }

    public static void collectSyncWithServerGroups(int n2, long l2) {
        EMLog.d(TAG + EMPerformanceCollector.getTagPrefix(SYNC_GROUPS), "sync groups with server with group size : " + n2 + " timeSpent : " + EMPerformanceCollector.timeToString(l2));
    }

    public static void collectRetrieveGroupFromServer(EMGroup eMGroup, long l2) {
        if (eMGroup == null) {
            return;
        }
        EMLog.d(TAG + EMPerformanceCollector.getTagPrefix(RETRIEVE_GROUP), "retrieve group details from server with group id : " + eMGroup.getId() + " group name : " + eMGroup.getName() + " members : " + eMGroup.getAffiliationsCount() + " time spent : " + EMPerformanceCollector.timeToString(l2));
    }
}

