/*
 * Decompiled with CFR 0.152.
 */
package ch.imvs.sdes4j;

import ch.imvs.sdes4j.CryptoSuite;
import ch.imvs.sdes4j.KeyParam;
import ch.imvs.sdes4j.SDesFactory;
import ch.imvs.sdes4j.SessionParam;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CryptoAttribute {
    protected int tag;
    protected CryptoSuite cryptoSuite;
    protected KeyParam[] keyParams;
    protected SessionParam[] sessionParams = null;

    protected CryptoAttribute() {
    }

    public static CryptoAttribute create(String attribute, SDesFactory f2) {
        CryptoAttribute result = f2.createCryptoAttribute();
        LinkedList<String> tokens = new LinkedList<String>();
        for (String s2 : attribute.split("\\s")) {
            if (s2.trim().length() <= 0) continue;
            tokens.add(s2);
        }
        result.setTag((String)tokens.remove(0));
        result.setCryptoSuite((String)tokens.remove(0), f2);
        if (tokens.size() < 1) {
            throw new IllegalArgumentException("There must be at least one key parameter");
        }
        result.setKeyParams((String)tokens.remove(0), f2);
        result.setSessionParams(tokens, f2);
        return result;
    }

    public static CryptoAttribute create(String tag, String cryptoSuite, String keyParams, String sessionParams, SDesFactory f2) {
        CryptoAttribute result = f2.createCryptoAttribute();
        result.setTag(tag);
        result.setCryptoSuite(cryptoSuite, f2);
        result.setKeyParams(keyParams, f2);
        LinkedList<String> tokens = new LinkedList<String>();
        if (sessionParams != null) {
            for (String s2 : sessionParams.split("\\s")) {
                if (s2.trim().length() <= 0) continue;
                tokens.add(s2);
            }
        }
        result.setSessionParams(tokens, f2);
        return result;
    }

    public CryptoAttribute(int tag, CryptoSuite cryptoSuite, KeyParam[] keyParams, SessionParam[] sessionParams) {
        if (tag > 99999999 || tag < 0) {
            throw new IllegalArgumentException("tag can have at most 10 digits and must be non-negative");
        }
        if (cryptoSuite == null) {
            throw new IllegalArgumentException("cryptoSuite cannot be null");
        }
        if (keyParams == null || keyParams.length == 0) {
            throw new IllegalArgumentException("keyParams cannot be null or empty");
        }
        this.tag = tag;
        this.cryptoSuite = cryptoSuite;
        this.keyParams = keyParams;
        this.sessionParams = sessionParams == null ? new SessionParam[0] : sessionParams;
    }

    public int getTag() {
        return this.tag;
    }

    private void setTag(String stringTag) {
        int tag = Integer.valueOf(stringTag);
        if (tag > 99999999 || tag < 0) {
            throw new IllegalArgumentException("tag can have at most 10 digits and must be non-negative");
        }
        this.tag = tag;
    }

    public CryptoSuite getCryptoSuite() {
        return this.cryptoSuite;
    }

    private void setCryptoSuite(String stringCryptoSuite, SDesFactory f2) {
        this.cryptoSuite = f2.createCryptoSuite(stringCryptoSuite);
    }

    public KeyParam[] getKeyParams() {
        return this.keyParams;
    }

    private void setKeyParams(String stringKeyParams, SDesFactory f2) {
        String[] params = stringKeyParams.split(";");
        LinkedList<KeyParam> keyParams = new LinkedList<KeyParam>();
        for (String p2 : params) {
            keyParams.add(f2.createKeyParam(p2));
        }
        this.keyParams = keyParams.toArray(f2.createKeyParamArray(0));
    }

    public SessionParam[] getSessionParams() {
        return this.sessionParams;
    }

    private void setSessionParams(List<String> tokens, SDesFactory f2) {
        LinkedList<SessionParam> sessionParams = new LinkedList<SessionParam>();
        while (tokens.size() > 0) {
            sessionParams.add(f2.createSessionParam(tokens.remove(0)));
        }
        this.sessionParams = sessionParams.toArray(f2.createSessionParamArray(0));
    }

    public String encode() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.tag);
        sb.append(' ');
        sb.append(this.cryptoSuite.encode());
        sb.append(' ');
        sb.append(this.getKeyParamsString());
        if (this.sessionParams != null && this.sessionParams.length > 0) {
            sb.append(' ');
            sb.append(this.getSessionParamsString());
        }
        return sb.toString();
    }

    public String getKeyParamsString() {
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < this.keyParams.length; ++i2) {
            sb.append(this.keyParams[i2].encode());
            if (i2 >= this.keyParams.length - 1) continue;
            sb.append(';');
        }
        return sb.toString();
    }

    public String getSessionParamsString() {
        if (this.sessionParams != null && this.sessionParams.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i2 = 0; i2 < this.sessionParams.length; ++i2) {
                sb.append(this.sessionParams[i2].encode());
                if (i2 >= this.sessionParams.length - 1) continue;
                sb.append(' ');
            }
            return sb.toString();
        }
        return null;
    }
}

