/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.net.SSLCertificateSocketFactory;
import android.net.SSLSessionCache;
import com.parse.ParseHttpBody;
import com.parse.ParseHttpClient;
import com.parse.ParseHttpRequest;
import com.parse.ParseHttpResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;

class ParseURLConnectionHttpClient
extends ParseHttpClient<HttpURLConnection, HttpURLConnection> {
    private int socketOperationTimeout;

    public ParseURLConnectionHttpClient(int socketOperationTimeout, SSLSessionCache sslSessionCache) {
        this.socketOperationTimeout = socketOperationTimeout;
        HttpsURLConnection.setDefaultSSLSocketFactory(SSLCertificateSocketFactory.getDefault((int)socketOperationTimeout, (SSLSessionCache)sslSessionCache));
    }

    @Override
    ParseHttpResponse executeInternal(ParseHttpRequest parseRequest) throws IOException {
        HttpURLConnection connection = this.getRequest(parseRequest);
        ParseHttpBody body = parseRequest.getBody();
        if (body != null) {
            OutputStream outputStream = connection.getOutputStream();
            body.writeTo(outputStream);
            outputStream.flush();
            outputStream.close();
        }
        ParseURLConnectionHttpClient.setParseRequestCancelRunnable(parseRequest, connection);
        return this.getResponse(connection);
    }

    @Override
    HttpURLConnection getRequest(ParseHttpRequest parseRequest) throws IOException {
        URL url = new URL(parseRequest.getUrl());
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod(parseRequest.getMethod().toString());
        connection.setConnectTimeout(this.socketOperationTimeout);
        connection.setReadTimeout(this.socketOperationTimeout);
        connection.setDoInput(true);
        connection.setInstanceFollowRedirects(false);
        for (Map.Entry<String, String> entry : parseRequest.getAllHeaders().entrySet()) {
            connection.setRequestProperty(entry.getKey(), entry.getValue());
        }
        ParseHttpBody body = parseRequest.getBody();
        if (body != null) {
            connection.setRequestProperty("Content-Length", String.valueOf(body.getContentLength()));
            connection.setRequestProperty("Content-Type", body.getContentType());
            connection.setFixedLengthStreamingMode(body.getContentLength());
            connection.setDoOutput(true);
        }
        return connection;
    }

    private static void setParseRequestCancelRunnable(ParseHttpRequest parseRequest, final HttpURLConnection connection) {
        parseRequest.setCancelRunnable(new Runnable(){

            @Override
            public void run() {
                connection.disconnect();
            }
        });
    }

    @Override
    ParseHttpResponse getResponse(HttpURLConnection connection) throws IOException {
        int statusCode = connection.getResponseCode();
        InputStream content = statusCode < 400 ? connection.getInputStream() : connection.getErrorStream();
        int totalSize = connection.getContentLength();
        String reasonPhrase = connection.getResponseMessage();
        HashMap<String, String> headers = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> entry : connection.getHeaderFields().entrySet()) {
            headers.put(entry.getKey(), entry.getValue() == null ? "" : entry.getValue().toString());
        }
        String contentType = connection.getContentType();
        return ((ParseHttpResponse.Builder)((ParseHttpResponse.Builder)((ParseHttpResponse.Builder)((ParseHttpResponse.Builder)((ParseHttpResponse.Builder)((ParseHttpResponse.Builder)new ParseHttpResponse.Builder().setStatusCode(statusCode)).setContent(content)).setTotalSize(totalSize)).setReasonPhase(reasonPhrase)).setHeaders(headers)).setContentType(contentType)).build();
    }
}

