/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.content.Context;
import bolts.Task;
import com.parse.LogInCallback;
import com.parse.ParseException;
import com.parse.ParseTaskUtils;
import com.parse.ParseUser;
import com.parse.SaveCallback;
import com.parse.TwitterAuthenticationProvider;
import com.parse.twitter.Twitter;

public final class ParseTwitterUtils {
    private static Twitter twitter;
    private static TwitterAuthenticationProvider provider;
    private static boolean isInitialized;

    private static TwitterAuthenticationProvider getAuthenticationProvider() {
        if (provider == null) {
            provider = new TwitterAuthenticationProvider(ParseTwitterUtils.getTwitter());
            ParseUser.registerAuthenticationProvider(provider);
        }
        return provider;
    }

    public static Twitter getTwitter() {
        if (twitter == null) {
            twitter = new Twitter("", "");
        }
        return twitter;
    }

    public static void initialize(String consumerKey, String consumerSecret) {
        ParseTwitterUtils.getTwitter().setConsumerKey(consumerKey).setConsumerSecret(consumerSecret);
        ParseTwitterUtils.getAuthenticationProvider();
        isInitialized = true;
    }

    private static void checkInitialization() {
        if (!isInitialized) {
            throw new IllegalStateException("You must call ParseTwitterUtils.initialize() before using ParseTwitterUtils");
        }
    }

    public static boolean isLinked(ParseUser user) {
        return user.isLinked("twitter");
    }

    public static Task<Void> linkInBackground(Context context, ParseUser user) {
        ParseTwitterUtils.checkInitialization();
        return ParseTwitterUtils.getAuthenticationProvider().setContext(context).linkAsync(user);
    }

    @Deprecated
    public static void link(ParseUser user, Context context) {
        ParseTwitterUtils.link(user, context, null);
    }

    public static void link(ParseUser user, Context context, SaveCallback callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(ParseTwitterUtils.linkInBackground(context, user), callback, true);
    }

    public static Task<Void> linkInBackground(ParseUser user, String twitterId, String screenName, String authToken, String authTokenSecret) {
        ParseTwitterUtils.checkInitialization();
        TwitterAuthenticationProvider provider = ParseTwitterUtils.getAuthenticationProvider();
        return provider.linkAsync(user, provider.getAuthData(twitterId, screenName, authToken, authTokenSecret));
    }

    @Deprecated
    public static void link(ParseUser user, String twitterId, String screenName, String authToken, String authTokenSecret) {
        ParseTwitterUtils.link(user, twitterId, screenName, authToken, authTokenSecret, null);
    }

    public static void link(ParseUser user, String twitterId, String screenName, String authToken, String authTokenSecret, SaveCallback callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(ParseTwitterUtils.linkInBackground(user, twitterId, screenName, authToken, authTokenSecret), callback);
    }

    public static Task<ParseUser> logInInBackground(String twitterId, String screenName, String authToken, String authTokenSecret) {
        ParseTwitterUtils.checkInitialization();
        TwitterAuthenticationProvider provider = ParseTwitterUtils.getAuthenticationProvider();
        return provider.logInAsync(provider.getAuthData(twitterId, screenName, authToken, authTokenSecret));
    }

    public static void logIn(String twitterId, String screenName, String authToken, String authTokenSecret, LogInCallback callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(ParseTwitterUtils.logInInBackground(twitterId, screenName, authToken, authTokenSecret), callback);
    }

    public static Task<ParseUser> logInInBackground(Context context) {
        ParseTwitterUtils.checkInitialization();
        return ParseTwitterUtils.getAuthenticationProvider().setContext(context).logInAsync();
    }

    public static void logIn(Context context, LogInCallback callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(ParseTwitterUtils.logInInBackground(context), callback, true);
    }

    public static void unlink(ParseUser user) throws ParseException {
        ParseTaskUtils.wait(ParseTwitterUtils.unlinkInBackground(user));
    }

    public static Task<Void> unlinkInBackground(ParseUser user) {
        ParseTwitterUtils.checkInitialization();
        return ParseTwitterUtils.getAuthenticationProvider().unlinkAsync(user);
    }

    public static void unlinkInBackground(ParseUser user, SaveCallback callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(ParseTwitterUtils.unlinkInBackground(user), callback);
    }

    private ParseTwitterUtils() {
    }
}

