/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import com.parse.ParseObject;
import com.parse.ParseQuery;
import com.parse.ParseRESTCommand;
import com.parse.ParseRequest;
import com.parse.ParseTextUtils;
import com.parse.PointerEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONObject;

class ParseRESTQueryCommand
extends ParseRESTCommand {
    public static <T extends ParseObject> ParseRESTQueryCommand findCommand(ParseQuery.State<T> state, String sessionToken) {
        String httpPath = String.format("classes/%s", state.className());
        Map<String, String> parameters = ParseRESTQueryCommand.encode(state, false);
        return new ParseRESTQueryCommand(httpPath, ParseRequest.Method.GET, parameters, sessionToken);
    }

    public static <T extends ParseObject> ParseRESTQueryCommand countCommand(ParseQuery.State<T> state, String sessionToken) {
        String httpPath = String.format("classes/%s", state.className());
        Map<String, String> parameters = ParseRESTQueryCommand.encode(state, true);
        return new ParseRESTQueryCommand(httpPath, ParseRequest.Method.GET, parameters, sessionToken);
    }

    static <T extends ParseObject> Map<String, String> encode(ParseQuery.State<T> state, boolean count) {
        Set<String> includeds;
        Set<String> selectedKeys;
        ParseQuery.QueryConstraints conditions;
        PointerEncoder encoder = PointerEncoder.get();
        HashMap<String, String> parameters = new HashMap<String, String>();
        List<String> order = state.order();
        if (!order.isEmpty()) {
            parameters.put("order", ParseTextUtils.join(",", order));
        }
        if (!(conditions = state.constraints()).isEmpty()) {
            JSONObject encodedConditions = (JSONObject)encoder.encode(conditions);
            parameters.put("where", encodedConditions.toString());
        }
        if ((selectedKeys = state.selectedKeys()) != null) {
            parameters.put("keys", ParseTextUtils.join(",", selectedKeys));
        }
        if (!(includeds = state.includes()).isEmpty()) {
            parameters.put("include", ParseTextUtils.join(",", includeds));
        }
        if (count) {
            parameters.put("count", Integer.toString(1));
        } else {
            int skip;
            int limit = state.limit();
            if (limit >= 0) {
                parameters.put("limit", Integer.toString(limit));
            }
            if ((skip = state.skip()) > 0) {
                parameters.put("skip", Integer.toString(skip));
            }
        }
        Map<String, Object> extraOptions = state.extraOptions();
        for (Map.Entry<String, Object> entry : extraOptions.entrySet()) {
            Object encodedExtraOptions = encoder.encode(entry.getValue());
            parameters.put(entry.getKey(), encodedExtraOptions.toString());
        }
        if (state.isTracingEnabled()) {
            parameters.put("trace", Integer.toString(1));
        }
        return parameters;
    }

    private ParseRESTQueryCommand(String httpPath, ParseRequest.Method httpMethod, Map<String, ?> parameters, String sessionToken) {
        super(httpPath, httpMethod, parameters, sessionToken);
    }
}

