/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.net.Uri;
import com.parse.ParseObject;
import com.parse.ParseRESTCommand;
import com.parse.ParseRequest;
import org.json.JSONObject;

class ParseRESTObjectCommand
extends ParseRESTCommand {
    public ParseRESTObjectCommand(String httpPath, ParseRequest.Method httpMethod, JSONObject parameters, String sessionToken) {
        super(httpPath, httpMethod, parameters, sessionToken);
    }

    public static ParseRESTObjectCommand getObjectCommand(String objectId, String className, String sessionToken) {
        String httpPath = String.format("classes/%s/%s", Uri.encode((String)className), Uri.encode((String)objectId));
        return new ParseRESTObjectCommand(httpPath, ParseRequest.Method.GET, null, sessionToken);
    }

    public static ParseRESTObjectCommand saveObjectCommand(ParseObject.State state, JSONObject operations, String sessionToken) {
        if (state.objectId() == null) {
            return ParseRESTObjectCommand.createObjectCommand(state.className(), operations, sessionToken);
        }
        return ParseRESTObjectCommand.updateObjectCommand(state.objectId(), state.className(), operations, sessionToken);
    }

    private static ParseRESTObjectCommand createObjectCommand(String className, JSONObject changes, String sessionToken) {
        String httpPath = String.format("classes/%s", Uri.encode((String)className));
        return new ParseRESTObjectCommand(httpPath, ParseRequest.Method.POST, changes, sessionToken);
    }

    private static ParseRESTObjectCommand updateObjectCommand(String objectId, String className, JSONObject changes, String sessionToken) {
        String httpPath = String.format("classes/%s/%s", Uri.encode((String)className), Uri.encode((String)objectId));
        return new ParseRESTObjectCommand(httpPath, ParseRequest.Method.PUT, changes, sessionToken);
    }

    public static ParseRESTObjectCommand deleteObjectCommand(ParseObject.State state, String sessionToken) {
        String httpPath = String.format("classes/%s", Uri.encode((String)state.className()));
        String objectId = state.objectId();
        if (objectId != null) {
            httpPath = httpPath + String.format("/%s", Uri.encode((String)objectId));
        }
        return new ParseRESTObjectCommand(httpPath, ParseRequest.Method.DELETE, null, sessionToken);
    }
}

