/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import com.parse.ParseByteArrayHttpBody;
import com.parse.ParseCountingByteArrayHttpBody;
import com.parse.ParseHttpBody;
import com.parse.ParseRESTCommand;
import com.parse.ParseRequest;
import com.parse.ProgressCallback;

class ParseRESTFileCommand
extends ParseRESTCommand {
    private final byte[] data;
    private final String contentType;

    public ParseRESTFileCommand(Builder builder) {
        super(builder);
        this.data = builder.data;
        this.contentType = builder.contentType;
    }

    @Override
    protected ParseHttpBody newBody(ProgressCallback progressCallback) {
        if (progressCallback == null) {
            return new ParseByteArrayHttpBody(this.data, this.contentType);
        }
        return new ParseCountingByteArrayHttpBody(this.data, this.contentType, progressCallback);
    }

    public static class Builder
    extends ParseRESTCommand.Init<Builder> {
        private byte[] data = null;
        private String contentType = null;

        public Builder() {
            this.method(ParseRequest.Method.POST);
        }

        public Builder fileName(String fileName) {
            return (Builder)this.httpPath(String.format("files/%s", fileName));
        }

        public Builder data(byte[] data) {
            this.data = data;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        Builder self() {
            return this;
        }

        public ParseRESTFileCommand build() {
            return new ParseRESTFileCommand(this);
        }
    }
}

