/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import bolts.Capture;
import bolts.Continuation;
import bolts.Task;
import com.parse.DeleteCallback;
import com.parse.EventuallyPin;
import com.parse.FindCallback;
import com.parse.GetCallback;
import com.parse.KnownParseObjectDecoder;
import com.parse.LocalIdManager;
import com.parse.LockSet;
import com.parse.OfflineStore;
import com.parse.Parse;
import com.parse.ParseACL;
import com.parse.ParseAddOperation;
import com.parse.ParseAddUniqueOperation;
import com.parse.ParseClassName;
import com.parse.ParseCorePlugins;
import com.parse.ParseDateFormat;
import com.parse.ParseDecoder;
import com.parse.ParseDeleteOperation;
import com.parse.ParseEncoder;
import com.parse.ParseEventuallyQueue;
import com.parse.ParseException;
import com.parse.ParseFieldOperation;
import com.parse.ParseFile;
import com.parse.ParseFileUtils;
import com.parse.ParseGeoPoint;
import com.parse.ParseImpreciseDateFormat;
import com.parse.ParseIncrementOperation;
import com.parse.ParseInstallation;
import com.parse.ParseJSONCacheItem;
import com.parse.ParseJSONUtils;
import com.parse.ParseMulticastDelegate;
import com.parse.ParseObjectController;
import com.parse.ParseOperationSet;
import com.parse.ParsePin;
import com.parse.ParseQuery;
import com.parse.ParseRESTObjectCommand;
import com.parse.ParseRelation;
import com.parse.ParseRemoveOperation;
import com.parse.ParseRole;
import com.parse.ParseSession;
import com.parse.ParseSetOperation;
import com.parse.ParseTaskUtils;
import com.parse.ParseTextUtils;
import com.parse.ParseTraverser;
import com.parse.ParseUser;
import com.parse.PointerEncoder;
import com.parse.PointerOrLocalIdEncoder;
import com.parse.RefreshCallback;
import com.parse.SaveCallback;
import com.parse.TaskQueue;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ParseObject {
    static String server = "https://api.parse.com";
    private static final String AUTO_CLASS_NAME = "_Automatic";
    static final String VERSION_NAME = "1.9.4";
    private static final String KEY_OBJECT_ID = "objectId";
    private static final String KEY_CLASS_NAME = "className";
    private static final String KEY_ACL = "ACL";
    private static final String KEY_CREATED_AT = "createdAt";
    private static final String KEY_UPDATED_AT = "updatedAt";
    private static final String KEY_COMPLETE = "__complete";
    private static final String KEY_OPERATIONS = "__operations";
    static final String KEY_IS_DELETING_EVENTUALLY = "__isDeletingEventually";
    private static final String KEY_IS_DELETING_EVENTUALLY_OLD = "isDeletingEventually";
    private static final Map<Class<? extends ParseObject>, String> classNames = new ConcurrentHashMap<Class<? extends ParseObject>, String>();
    private static final Map<String, Class<? extends ParseObject>> objectTypes = new ConcurrentHashMap<String, Class<? extends ParseObject>>();
    final Object mutex = new Object();
    final TaskQueue taskQueue = new TaskQueue();
    private State state;
    final LinkedList<ParseOperationSet> operationSetQueue;
    private final Map<String, Object> estimatedData;
    private final Map<String, Boolean> dataAvailability;
    private final Map<Object, ParseJSONCacheItem> hashedObjects;
    private String localId;
    private final ParseMulticastDelegate<ParseObject> saveEvent = new ParseMulticastDelegate();
    boolean isDeleted;
    int isDeletingEventually;
    private static final ThreadLocal<String> isCreatingPointerForObjectId = new ThreadLocal<String>(){

        @Override
        protected String initialValue() {
            return null;
        }
    };
    private static final String NEW_OFFLINE_OBJECT_ID_PLACEHOLDER = "*** Offline Object ***";
    public static final String DEFAULT_PIN = "_default";

    private static ParseObjectController getObjectController() {
        return ParseCorePlugins.getInstance().getObjectController();
    }

    protected ParseObject() {
        this(AUTO_CLASS_NAME);
    }

    public ParseObject(String theClassName) {
        String objectIdForPointer = isCreatingPointerForObjectId.get();
        if (theClassName == null) {
            throw new IllegalArgumentException("You must specify a Parse class name when creating a new ParseObject.");
        }
        if (AUTO_CLASS_NAME.equals(theClassName)) {
            theClassName = ParseObject.getClassName(this.getClass());
        }
        if (this.getClass().equals(ParseObject.class) && objectTypes.containsKey(theClassName) && !objectTypes.get(theClassName).isInstance(this)) {
            throw new IllegalArgumentException("You must create this type of ParseObject using ParseObject.create() or the proper subclass.");
        }
        if (!this.getClass().equals(ParseObject.class) && !this.getClass().equals(objectTypes.get(theClassName))) {
            throw new IllegalArgumentException("You must register this ParseObject subclass before instantiating it.");
        }
        this.operationSetQueue = new LinkedList();
        this.operationSetQueue.add(new ParseOperationSet());
        this.estimatedData = new HashMap<String, Object>();
        this.hashedObjects = new IdentityHashMap<Object, ParseJSONCacheItem>();
        this.dataAvailability = new HashMap<String, Boolean>();
        State.Init<?> builder = this.newStateBuilder(theClassName);
        if (objectIdForPointer == null) {
            this.setDefaultValues();
            builder.isComplete(true);
        } else {
            if (!objectIdForPointer.equals(NEW_OFFLINE_OBJECT_ID_PLACEHOLDER)) {
                builder.objectId(objectIdForPointer);
            }
            builder.isComplete(false);
        }
        this.state = builder.build();
        OfflineStore store = Parse.getLocalDatastore();
        if (store != null) {
            store.registerNewObject(this);
        }
    }

    public static ParseObject create(String className) {
        if (objectTypes.containsKey(className)) {
            try {
                return objectTypes.get(className).newInstance();
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException("Failed to create instance of subclass.", e);
            }
        }
        return new ParseObject(className);
    }

    public static <T extends ParseObject> T create(Class<T> subclass) {
        return (T)ParseObject.create(ParseObject.getClassName(subclass));
    }

    public static ParseObject createWithoutData(String className, String objectId) {
        OfflineStore store = Parse.getLocalDatastore();
        try {
            if (objectId == null) {
                isCreatingPointerForObjectId.set(NEW_OFFLINE_OBJECT_ID_PLACEHOLDER);
            } else {
                isCreatingPointerForObjectId.set(objectId);
            }
            ParseObject object = null;
            if (store != null && objectId != null) {
                object = store.getObject(className, objectId);
            }
            if (object == null && (object = ParseObject.create(className)).hasChanges()) {
                throw new IllegalStateException("A ParseObject subclass default constructor must not make changes to the object that cause it to be dirty.");
            }
            ParseObject parseObject = object;
            return parseObject;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create instance of subclass.", e);
        }
        finally {
            isCreatingPointerForObjectId.set(null);
        }
    }

    public static <T extends ParseObject> T createWithoutData(Class<T> subclass, String objectId) {
        return (T)ParseObject.createWithoutData(ParseObject.getClassName(subclass), objectId);
    }

    private static boolean isAccessible(Member m) {
        return Modifier.isPublic(m.getModifiers()) || m.getDeclaringClass().getPackage().getName().equals("com.parse") && !Modifier.isPrivate(m.getModifiers()) && !Modifier.isProtected(m.getModifiers());
    }

    public static void registerSubclass(Class<? extends ParseObject> subclass) {
        Class<? extends ParseObject> oldValue;
        String className = ParseObject.getClassName(subclass);
        if (className == null) {
            throw new IllegalArgumentException("No ParseClassName annotation provided on " + subclass);
        }
        if (subclass.getDeclaredConstructors().length > 0) {
            try {
                if (!ParseObject.isAccessible(subclass.getDeclaredConstructor(new Class[0]))) {
                    throw new IllegalArgumentException("Default constructor for " + subclass + " is not accessible.");
                }
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("No default constructor provided for " + subclass);
            }
        }
        if ((oldValue = objectTypes.get(className)) != null && subclass.isAssignableFrom(oldValue)) {
            return;
        }
        objectTypes.put(className, subclass);
        if (oldValue != null && !subclass.equals(oldValue)) {
            if (className.equals(ParseObject.getClassName(ParseUser.class))) {
                ParseUser.clearCurrentUserFromMemory();
            } else if (className.equals(ParseObject.getClassName(ParseInstallation.class))) {
                ParseInstallation.clearCurrentInstallationFromMemory();
            }
        }
    }

    static void unregisterSubclass(Class<? extends ParseObject> subclass) {
        ParseObject.unregisterSubclass(ParseObject.getClassName(subclass));
    }

    static void unregisterSubclass(String className) {
        objectTypes.remove(className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> Task<T> enqueueForAll(List<? extends ParseObject> objects, Continuation<Void, Task<T>> taskStart) {
        final Task.TaskCompletionSource readyToStart = Task.create();
        ArrayList<Lock> locks = new ArrayList<Lock>(objects.size());
        for (ParseObject parseObject : objects) {
            locks.add(parseObject.taskQueue.getLock());
        }
        LockSet lock = new LockSet(locks);
        lock.lock();
        try {
            Task task;
            try {
                task = (Task)taskStart.then(readyToStart.getTask());
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            final ArrayList childTasks = new ArrayList();
            for (ParseObject parseObject : objects) {
                parseObject.taskQueue.enqueue(new Continuation<Void, Task<T>>(){

                    public Task<T> then(Task<Void> task2) throws Exception {
                        childTasks.add(task2);
                        return task;
                    }
                });
            }
            Task.whenAll(childTasks).continueWith((Continuation)new Continuation<Void, Void>(){

                public Void then(Task<Void> task) throws Exception {
                    readyToStart.setResult(null);
                    return null;
                }
            });
            Task task2 = task;
            return task2;
        }
        finally {
            lock.unlock();
        }
    }

    static Task<ParseObject> migrateFromDiskToLDS(final String filename, String pinName) {
        final ParseObject disk = ParseObject.getFromDisk(filename);
        if (disk == null) {
            return Task.forResult(null);
        }
        return disk.pinInBackground(pinName).continueWith((Continuation)new Continuation<Void, ParseObject>(){

            public ParseObject then(Task<Void> task) throws Exception {
                if (!task.isFaulted()) {
                    ParseFileUtils.deleteQuietly(new File(Parse.getParseDir(), filename));
                }
                return disk;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveToDisk(String filename) {
        if (Parse.isLocalDatastoreEnabled()) {
            throw new IllegalStateException("ParseObject#saveToDisk is not allowed when OfflineStore is enabled");
        }
        Object object = this.mutex;
        synchronized (object) {
            JSONObject json = this.toJSONObjectForDataFile(this.state, PointerEncoder.get());
            try {
                ParseFileUtils.writeJSONObjectToFile(new File(Parse.getParseDir(), filename), json);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToHashedObjects(Object object) {
        Object object2 = this.mutex;
        synchronized (object2) {
            try {
                this.hashedObjects.put(object, new ParseJSONCacheItem(object));
            }
            catch (JSONException e) {
                throw new IllegalArgumentException("Couldn't serialize container value to JSON.");
            }
        }
    }

    static ParseObject getFromDisk(String filename) {
        JSONObject json;
        try {
            json = ParseFileUtils.readFileToJSONObject(new File(Parse.getParseDir(), filename));
        }
        catch (IOException | JSONException e) {
            return null;
        }
        return ParseObject.fromDiskJSON(json);
    }

    static <T extends ParseObject> T fromDiskJSON(JSONObject json) {
        String className = json.optString("classname", null);
        if (className == null) {
            return null;
        }
        String objectId = json.optString(KEY_OBJECT_ID, null);
        ParseObject object = ParseObject.createWithoutData(className, objectId);
        State newState = object.mergeFromDiskJSON(object.getState(), json);
        object.setState(newState);
        return (T)object;
    }

    static <T extends ParseObject> T fromJSON(JSONObject json, String defaultClassName, boolean isComplete) {
        return ParseObject.fromJSON(json, defaultClassName, isComplete, ParseDecoder.get());
    }

    static <T extends ParseObject> T fromJSON(JSONObject json, String defaultClassName, boolean isComplete, ParseDecoder decoder) {
        String className = json.optString(KEY_CLASS_NAME, defaultClassName);
        if (className == null) {
            return null;
        }
        String objectId = json.optString(KEY_OBJECT_ID, null);
        ParseObject object = ParseObject.createWithoutData(className, objectId);
        State newState = object.mergeFromServer(object.getState(), json, decoder, isComplete);
        object.setState(newState);
        return (T)object;
    }

    static <T extends ParseObject> T fromJSONPayload(JSONObject json, ParseDecoder decoder) {
        String className = json.optString(KEY_CLASS_NAME);
        if (className == null || ParseTextUtils.isEmpty(className)) {
            return null;
        }
        String objectId = json.optString(KEY_OBJECT_ID, null);
        ParseObject object = ParseObject.createWithoutData(className, objectId);
        object.build(json, decoder);
        return (T)object;
    }

    State.Init<?> newStateBuilder(String className) {
        return new State.Builder(className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    State getState() {
        Object object = this.mutex;
        synchronized (object) {
            return this.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setState(State newState) {
        Object object = this.mutex;
        synchronized (object) {
            this.setState(newState, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(State newState, boolean notifyIfObjectIdChanges) {
        Object object = this.mutex;
        synchronized (object) {
            String oldObjectId = this.state.objectId();
            String newObjectId = newState.objectId();
            this.state = newState;
            if (notifyIfObjectIdChanges && !ParseTextUtils.equals(oldObjectId, newObjectId)) {
                this.notifyObjectIdChanged(oldObjectId, newObjectId);
            }
            this.rebuildEstimatedData();
            this.rebuildDataAvailability();
            this.checkpointAllMutableContainers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getClassName() {
        Object object = this.mutex;
        synchronized (object) {
            return this.state.className();
        }
    }

    public Date getUpdatedAt() {
        long updatedAt = this.getState().updatedAt();
        return updatedAt > 0L ? new Date(updatedAt) : null;
    }

    public Date getCreatedAt() {
        long createdAt = this.getState().createdAt();
        return createdAt > 0L ? new Date(createdAt) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> keySet() {
        Object object = this.mutex;
        synchronized (object) {
            return Collections.unmodifiableSet(this.estimatedData.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void copyChangesFrom(ParseObject other) {
        Object object = this.mutex;
        synchronized (object) {
            ParseOperationSet operations = other.operationSetQueue.getFirst();
            for (String key : operations.keySet()) {
                this.performOperation(key, (ParseFieldOperation)operations.get(key));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeFromObject(ParseObject other) {
        Object object = this.mutex;
        synchronized (object) {
            if (this == other) {
                return;
            }
            Object copy = ((State.Init)other.getState().newBuilder()).build();
            this.setState((State)copy, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void revert(String key) {
        Object object = this.mutex;
        synchronized (object) {
            this.currentOperations().remove(key);
            this.rebuildEstimatedData();
            this.rebuildDataAvailability();
            this.checkpointAllMutableContainers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void revert() {
        Object object = this.mutex;
        synchronized (object) {
            this.currentOperations().clear();
            this.rebuildEstimatedData();
            this.rebuildDataAvailability();
            this.checkpointAllMutableContainers();
        }
    }

    private Map<String, ParseObject> collectFetchedObjects() {
        final HashMap<String, ParseObject> fetchedObjects = new HashMap<String, ParseObject>();
        ParseTraverser traverser = new ParseTraverser(){

            @Override
            protected boolean visit(Object object) {
                ParseObject parseObj;
                State state;
                if (object instanceof ParseObject && (state = (parseObj = (ParseObject)object).getState()).objectId() != null && state.isComplete()) {
                    fetchedObjects.put(state.objectId(), parseObj);
                }
                return true;
            }
        };
        traverser.traverse(this.estimatedData);
        return fetchedObjects;
    }

    State mergeFromDiskJSON(State state, JSONObject object) {
        try {
            JSONObject data;
            String updatedAtString;
            String createdAtString;
            Object builder = ((State.Init)state.newBuilder()).isComplete(true);
            if (object.has("id") && state.objectId() == null) {
                String newObjectId = object.getString("id");
                ((State.Init)builder).objectId(newObjectId);
            }
            if (object.has("created_at") && (createdAtString = object.getString("created_at")) != null) {
                ((State.Init)builder).createdAt(ParseImpreciseDateFormat.getInstance().parse(createdAtString));
            }
            if (object.has("updated_at") && (updatedAtString = object.getString("updated_at")) != null) {
                ((State.Init)builder).updatedAt(ParseImpreciseDateFormat.getInstance().parse(updatedAtString));
            }
            if (object.has("pointers")) {
                JSONObject newPointers = object.getJSONObject("pointers");
                Iterator keys = newPointers.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    JSONArray pointerArray = newPointers.getJSONArray(key);
                    ((State.Init)builder).put(key, ParseObject.createWithoutData(pointerArray.optString(0), pointerArray.optString(1)));
                }
            }
            if ((data = object.optJSONObject("data")) != null) {
                ParseDecoder decoder = ParseDecoder.get();
                Iterator keys = data.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    if (key.equals(KEY_OBJECT_ID)) {
                        String newObjectId = data.getString(key);
                        ((State.Init)builder).objectId(newObjectId);
                        continue;
                    }
                    if (key.equals(KEY_CREATED_AT)) {
                        ((State.Init)builder).createdAt(ParseDateFormat.getInstance().parse(data.getString(key)));
                        continue;
                    }
                    if (key.equals(KEY_UPDATED_AT)) {
                        ((State.Init)builder).updatedAt(ParseDateFormat.getInstance().parse(data.getString(key)));
                        continue;
                    }
                    Object value = data.get(key);
                    Object decodedObject = decoder.decode(value);
                    ((State.Init)builder).put(key, decodedObject);
                }
            }
            return ((State.Init)builder).build();
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    void build(JSONObject json, ParseDecoder decoder) {
        try {
            State.Builder builder = (State.Builder)new State.Builder(this.state).isComplete(true);
            builder.clear();
            Iterator keys = json.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                if (key.equals(KEY_CLASS_NAME)) continue;
                if (key.equals(KEY_OBJECT_ID)) {
                    String newObjectId = json.getString(key);
                    builder.objectId(newObjectId);
                    continue;
                }
                if (key.equals(KEY_CREATED_AT)) {
                    builder.createdAt(ParseDateFormat.getInstance().parse(json.getString(key)));
                    continue;
                }
                if (key.equals(KEY_UPDATED_AT)) {
                    builder.updatedAt(ParseDateFormat.getInstance().parse(json.getString(key)));
                    continue;
                }
                Object value = json.get(key);
                Object decodedObject = decoder.decode(value);
                if (decodedObject instanceof ParseFieldOperation) {
                    this.performOperation(key, (ParseFieldOperation)decodedObject);
                    continue;
                }
                this.put(key, decodedObject);
            }
            this.setState(builder.build());
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    State mergeFromServer(State state, JSONObject json, ParseDecoder decoder, boolean completeData) {
        try {
            Object builder = state.newBuilder();
            if (completeData) {
                ((State.Init)builder).clear();
            }
            ((State.Init)builder).isComplete(state.isComplete() || completeData);
            Iterator keys = json.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                if (key.equals("__type") || key.equals(KEY_CLASS_NAME)) continue;
                if (key.equals(KEY_OBJECT_ID)) {
                    String newObjectId = json.getString(key);
                    ((State.Init)builder).objectId(newObjectId);
                    continue;
                }
                if (key.equals(KEY_CREATED_AT)) {
                    ((State.Init)builder).createdAt(ParseDateFormat.getInstance().parse(json.getString(key)));
                    continue;
                }
                if (key.equals(KEY_UPDATED_AT)) {
                    ((State.Init)builder).updatedAt(ParseDateFormat.getInstance().parse(json.getString(key)));
                    continue;
                }
                if (key.equals(KEY_ACL)) {
                    ParseACL acl = ParseACL.createACLFromJSONObject(json.getJSONObject(key), decoder);
                    ((State.Init)builder).put(KEY_ACL, acl);
                    continue;
                }
                Object value = json.get(key);
                Object decodedObject = decoder.decode(value);
                ((State.Init)builder).put(key, decodedObject);
            }
            return ((State.Init)builder).build();
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JSONObject toRest(ParseEncoder encoder) {
        Object object = this.mutex;
        synchronized (object) {
            State state = this.getState();
            LinkedList<ParseOperationSet> operationSetQueue = this.operationSetQueue;
            return this.toRest(state, operationSetQueue, encoder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JSONObject toRest(State state, List<ParseOperationSet> operationSetQueue, ParseEncoder objectEncoder) {
        Object object = this.mutex;
        synchronized (object) {
            this.checkForChangesToMutableContainers();
            JSONObject json = new JSONObject();
            try {
                json.put(KEY_CLASS_NAME, (Object)state.className());
                if (state.objectId() != null) {
                    json.put(KEY_OBJECT_ID, (Object)state.objectId());
                }
                if (state.createdAt() > 0L) {
                    json.put(KEY_CREATED_AT, (Object)ParseDateFormat.getInstance().format(new Date(state.createdAt())));
                }
                if (state.updatedAt() > 0L) {
                    json.put(KEY_UPDATED_AT, (Object)ParseDateFormat.getInstance().format(new Date(state.updatedAt())));
                }
                for (String key : state.keySet()) {
                    Object value = state.get(key);
                    json.put(key, objectEncoder.encode(value));
                }
                json.put(KEY_COMPLETE, state.isComplete());
                json.put(KEY_IS_DELETING_EVENTUALLY, this.isDeletingEventually);
                JSONArray operations = new JSONArray();
                for (ParseOperationSet operationSet : operationSetQueue) {
                    operations.put((Object)operationSet.toRest(objectEncoder));
                }
                json.put(KEY_OPERATIONS, (Object)operations);
            }
            catch (JSONException e) {
                throw new RuntimeException("could not serialize object to JSON");
            }
            return json;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeREST(State state, JSONObject json, ParseDecoder decoder) {
        ArrayList<ParseOperationSet> saveEventuallyOperationSets = new ArrayList<ParseOperationSet>();
        Object object = this.mutex;
        synchronized (object) {
            try {
                boolean isComplete = json.getBoolean(KEY_COMPLETE);
                this.isDeletingEventually = ParseJSONUtils.getInt(json, Arrays.asList(KEY_IS_DELETING_EVENTUALLY, KEY_IS_DELETING_EVENTUALLY_OLD));
                JSONArray operations = json.getJSONArray(KEY_OPERATIONS);
                ParseOperationSet newerOperations = this.currentOperations();
                this.operationSetQueue.clear();
                ParseOperationSet current = null;
                for (int i = 0; i < operations.length(); ++i) {
                    JSONObject operationSetJSON = operations.getJSONObject(i);
                    ParseOperationSet operationSet = ParseOperationSet.fromRest(operationSetJSON, decoder);
                    if (operationSet.isSaveEventually()) {
                        if (current != null) {
                            this.operationSetQueue.add(current);
                            current = null;
                        }
                        saveEventuallyOperationSets.add(operationSet);
                        this.operationSetQueue.add(operationSet);
                        continue;
                    }
                    if (current != null) {
                        operationSet.mergeFrom(current);
                    }
                    current = operationSet;
                }
                if (current != null) {
                    this.operationSetQueue.add(current);
                }
                this.currentOperations().mergeFrom(newerOperations);
                boolean mergeServerData = false;
                if (state.updatedAt() < 0L) {
                    mergeServerData = true;
                } else if (json.has(KEY_UPDATED_AT)) {
                    Date otherUpdatedAt = ParseDateFormat.getInstance().parse(json.getString(KEY_UPDATED_AT));
                    if (new Date(state.updatedAt()).compareTo(otherUpdatedAt) < 0) {
                        mergeServerData = true;
                    }
                }
                if (mergeServerData) {
                    JSONObject mergeJSON = ParseJSONUtils.create(json, Arrays.asList(KEY_COMPLETE, KEY_IS_DELETING_EVENTUALLY, KEY_IS_DELETING_EVENTUALLY_OLD, KEY_OPERATIONS));
                    State newState = this.mergeFromServer(state, mergeJSON, decoder, isComplete);
                    this.setState(newState);
                }
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }
        for (ParseOperationSet operationSet : saveEventuallyOperationSets) {
            this.enqueueSaveEventuallyOperationAsync(operationSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasDirtyChildren() {
        Object object = this.mutex;
        synchronized (object) {
            ArrayList<ParseObject> unsavedChildren = new ArrayList<ParseObject>();
            ParseObject.collectDirtyChildren(this.estimatedData, unsavedChildren, null);
            return unsavedChildren.size() > 0;
        }
    }

    public boolean isDirty() {
        return this.isDirty(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isDirty(boolean considerChildren) {
        Object object = this.mutex;
        synchronized (object) {
            this.checkForChangesToMutableContainers();
            return this.isDeleted || this.getObjectId() == null || this.hasChanges() || considerChildren && this.hasDirtyChildren();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasChanges() {
        Object object = this.mutex;
        synchronized (object) {
            return this.currentOperations().size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasOutstandingOperations() {
        Object object = this.mutex;
        synchronized (object) {
            return this.operationSetQueue.size() > 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirty(String key) {
        Object object = this.mutex;
        synchronized (object) {
            return this.currentOperations().containsKey(key);
        }
    }

    boolean isContainerObject(String key, Object object) {
        return object instanceof JSONObject || object instanceof JSONArray || object instanceof Map || object instanceof List || object instanceof ParseACL || object instanceof ParseGeoPoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkpointAllMutableContainers() {
        Object object = this.mutex;
        synchronized (object) {
            for (Map.Entry<String, Object> entry : this.estimatedData.entrySet()) {
                this.checkpointMutableContainer(entry.getKey(), entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkpointMutableContainer(String key, Object object) {
        Object object2 = this.mutex;
        synchronized (object2) {
            if (this.isContainerObject(key, object)) {
                this.addToHashedObjects(object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForChangesToMutableContainer(String key, Object object) {
        Object object2 = this.mutex;
        synchronized (object2) {
            if (this.isContainerObject(key, object)) {
                ParseJSONCacheItem newCacheItem;
                ParseJSONCacheItem oldCacheItem = this.hashedObjects.get(object);
                if (oldCacheItem == null) {
                    throw new IllegalArgumentException("ParseObject contains container item that isn't cached.");
                }
                try {
                    newCacheItem = new ParseJSONCacheItem(object);
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
                if (!oldCacheItem.equals(newCacheItem)) {
                    this.performOperation(key, new ParseSetOperation(object));
                }
            } else {
                this.hashedObjects.remove(object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkForChangesToMutableContainers() {
        Object object = this.mutex;
        synchronized (object) {
            for (String key : this.estimatedData.keySet()) {
                this.checkForChangesToMutableContainer(key, this.estimatedData.get(key));
            }
            this.hashedObjects.keySet().retainAll(this.estimatedData.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getObjectId() {
        Object object = this.mutex;
        synchronized (object) {
            return this.state.objectId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObjectId(String newObjectId) {
        Object object = this.mutex;
        synchronized (object) {
            String oldObjectId = this.state.objectId();
            if (ParseTextUtils.equals(oldObjectId, newObjectId)) {
                return;
            }
            this.state = ((State.Init)((State.Init)this.state.newBuilder()).objectId(newObjectId)).build();
            this.notifyObjectIdChanged(oldObjectId, newObjectId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getOrCreateLocalId() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.localId == null) {
                if (this.state.objectId() != null) {
                    throw new IllegalStateException("Attempted to get a localId for an object with an objectId.");
                }
                this.localId = LocalIdManager.getDefaultInstance().createLocalId();
            }
            return this.localId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyObjectIdChanged(String oldObjectId, String newObjectId) {
        Object object = this.mutex;
        synchronized (object) {
            OfflineStore store = Parse.getLocalDatastore();
            if (store != null) {
                store.updateObjectId(this, oldObjectId, newObjectId);
            }
            if (this.localId != null) {
                LocalIdManager.getDefaultInstance().setObjectId(this.localId, newObjectId);
                this.localId = null;
            }
        }
    }

    private ParseRESTObjectCommand currentSaveCommand(ParseOperationSet operations, ParseEncoder objectEncoder, String sessionToken) throws ParseException {
        State state = this.getState();
        JSONObject objectJSON = this.toJSONObjectForSaving(state, operations, objectEncoder);
        ParseRESTObjectCommand command = ParseRESTObjectCommand.saveObjectCommand(state, objectJSON, sessionToken);
        command.enableRetrying();
        return command;
    }

    <T extends State> JSONObject toJSONObjectForDataFile(T state, ParseEncoder objectEncoder) {
        JSONObject objectJSON = new JSONObject();
        JSONObject dataJSON = new JSONObject();
        try {
            for (String key : state.keySet()) {
                Object object = state.get(key);
                dataJSON.put(key, objectEncoder.encode(object));
            }
            if (state.createdAt() > 0L) {
                dataJSON.put(KEY_CREATED_AT, (Object)ParseDateFormat.getInstance().format(new Date(state.createdAt())));
            }
            if (state.updatedAt() > 0L) {
                dataJSON.put(KEY_UPDATED_AT, (Object)ParseDateFormat.getInstance().format(new Date(state.updatedAt())));
            }
            if (state.objectId() != null) {
                dataJSON.put(KEY_OBJECT_ID, (Object)state.objectId());
            }
            objectJSON.put("data", (Object)dataJSON);
            objectJSON.put("classname", (Object)state.className());
        }
        catch (JSONException e) {
            throw new RuntimeException("could not serialize object to JSON");
        }
        return objectJSON;
    }

    <T extends State> JSONObject toJSONObjectForSaving(T state, ParseOperationSet operations, ParseEncoder objectEncoder) {
        JSONObject objectJSON = new JSONObject();
        try {
            for (String key : operations.keySet()) {
                ParseFieldOperation operation = (ParseFieldOperation)operations.get(key);
                objectJSON.put(key, objectEncoder.encode(operation));
            }
            if (state.objectId() != null) {
                objectJSON.put(KEY_OBJECT_ID, (Object)state.objectId());
            }
        }
        catch (JSONException e) {
            throw new RuntimeException("could not serialize object to JSON");
        }
        return objectJSON;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Task<Void> handleSaveResultAsync(JSONObject result, ParseOperationSet operationsBeforeSave) {
        State newState = null;
        if (result != null) {
            Object object = this.mutex;
            synchronized (object) {
                Map<String, ParseObject> fetchedObjects = this.collectFetchedObjects();
                KnownParseObjectDecoder decoder = new KnownParseObjectDecoder(fetchedObjects);
                newState = ParseObject.getObjectController().stateFromJSON(this.getState(), result, decoder, false);
            }
        }
        return this.handleSaveResultAsync(newState, operationsBeforeSave);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Task<Void> handleSaveResultAsync(final State result, final ParseOperationSet operationsBeforeSave) {
        Task task = Task.forResult((Object)null);
        boolean success = result != null;
        Object object = this.mutex;
        synchronized (object) {
            ListIterator<ParseOperationSet> opIterator = this.operationSetQueue.listIterator(this.operationSetQueue.indexOf(operationsBeforeSave));
            opIterator.next();
            opIterator.remove();
            ParseOperationSet nextOperation = opIterator.next();
            if (!success) {
                nextOperation.mergeFrom(operationsBeforeSave);
                return task;
            }
        }
        final OfflineStore store = Parse.getLocalDatastore();
        if (store != null) {
            task = task.onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

                public Task<Void> then(Task<Void> task) throws Exception {
                    return store.fetchLocallyAsync(ParseObject.this).makeVoid();
                }
            });
        }
        task = task.continueWith((Continuation)new Continuation<Void, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void then(Task<Void> task) throws Exception {
                Object object = ParseObject.this.mutex;
                synchronized (object) {
                    State newState = result.isComplete() ? result : ((State.Init)((State.Init)((State.Init)ParseObject.this.getState().newBuilder()).apply(operationsBeforeSave)).apply(result)).build();
                    ParseObject.this.setState(newState);
                }
                return null;
            }
        });
        if (store != null) {
            task = task.onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

                public Task<Void> then(Task<Void> task) throws Exception {
                    return store.updateDataForObjectAsync(ParseObject.this);
                }
            });
        }
        task = task.onSuccess((Continuation)new Continuation<Void, Void>(){

            public Void then(Task<Void> task) throws Exception {
                ParseObject.this.saveEvent.invoke(ParseObject.this, null);
                return null;
            }
        });
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ParseOperationSet startSave() {
        Object object = this.mutex;
        synchronized (object) {
            ParseOperationSet currentOperations = this.currentOperations();
            this.operationSetQueue.addLast(new ParseOperationSet());
            return currentOperations;
        }
    }

    void validateSave() {
    }

    public final void save() throws ParseException {
        ParseTaskUtils.wait(this.saveInBackground());
    }

    public final Task<Void> saveInBackground() {
        return ParseUser.getCurrentUserAsync().onSuccessTask((Continuation)new Continuation<ParseUser, Task<String>>(){

            public Task<String> then(Task<ParseUser> task) throws Exception {
                ParseUser current = (ParseUser)task.getResult();
                if (current == null) {
                    return Task.forResult(null);
                }
                if (!current.isLazy()) {
                    return Task.forResult((Object)current.getSessionToken());
                }
                if (!ParseObject.this.isDataAvailable(ParseObject.KEY_ACL)) {
                    return Task.forResult(null);
                }
                final ParseACL acl = ParseObject.this.getACL(false);
                if (acl == null) {
                    return Task.forResult(null);
                }
                final ParseUser user = acl.getUnresolvedUser();
                if (user == null || !user.isCurrentUser()) {
                    return Task.forResult(null);
                }
                return user.saveAsync(null).onSuccess((Continuation)new Continuation<Void, String>(){

                    public String then(Task<Void> task) throws Exception {
                        if (acl.hasUnresolvedUser()) {
                            throw new IllegalStateException("ACL has an unresolved ParseUser. Save or sign up before attempting to serialize the ACL.");
                        }
                        return user.getSessionToken();
                    }
                });
            }
        }).onSuccessTask((Continuation)new Continuation<String, Task<Void>>(){

            public Task<Void> then(Task<String> task) throws Exception {
                String sessionToken = (String)task.getResult();
                return ParseObject.this.saveAsync(sessionToken);
            }
        });
    }

    Task<Void> saveAsync(final String sessionToken) {
        return this.taskQueue.enqueue(new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> toAwait) throws Exception {
                return ParseObject.this.saveAsync(sessionToken, toAwait);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Task<Void> saveAsync(final String sessionToken, Task<Void> toAwait) {
        Task<Void> task;
        ParseOperationSet operations;
        if (!this.isDirty()) {
            return Task.forResult(null);
        }
        Object object = this.mutex;
        synchronized (object) {
            this.updateBeforeSave();
            this.validateSave();
            operations = this.startSave();
        }
        Object object2 = this.mutex;
        synchronized (object2) {
            task = ParseObject.deepSaveAsync(this.estimatedData, sessionToken);
        }
        return task.onSuccessTask(TaskQueue.waitFor(toAwait)).onSuccessTask((Continuation)new Continuation<Void, Task<State>>(){

            public Task<State> then(Task<Void> task) throws Exception {
                Map fetchedObjects = ParseObject.this.collectFetchedObjects();
                KnownParseObjectDecoder decoder = new KnownParseObjectDecoder(fetchedObjects);
                return ParseObject.getObjectController().saveAsync(ParseObject.this.getState(), operations, sessionToken, decoder);
            }
        }).continueWithTask((Continuation)new Continuation<State, Task<Void>>(){

            public Task<Void> then(final Task<State> saveTask) throws Exception {
                State result = (State)saveTask.getResult();
                return ParseObject.this.handleSaveResultAsync(result, operations).continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                    public Task<Void> then(Task<Void> task) throws Exception {
                        if (task.isFaulted() || task.isCancelled()) {
                            return task;
                        }
                        return saveTask.makeVoid();
                    }
                });
            }
        });
    }

    Task<JSONObject> saveAsync(ParseOperationSet operationSet, String sessionToken) throws ParseException {
        ParseRESTObjectCommand command = this.currentSaveCommand(operationSet, PointerEncoder.get(), sessionToken);
        return command.executeAsync();
    }

    public final void saveInBackground(SaveCallback callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(this.saveInBackground(), callback);
    }

    public final void saveEventually(SaveCallback callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(this.saveEventually(), callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Task<Void> saveEventually() {
        ParseRESTObjectCommand command;
        ParseOperationSet operationSet;
        if (!this.isDirty()) {
            Parse.getEventuallyQueue().fakeObjectUpdate();
            return Task.forResult(null);
        }
        Object object = this.mutex;
        synchronized (object) {
            this.updateBeforeSave();
            ArrayList<ParseObject> unsavedChildren = new ArrayList<ParseObject>();
            ParseObject.collectDirtyChildren(this.estimatedData, unsavedChildren, null);
            String localId = null;
            if (this.getObjectId() == null) {
                localId = this.getOrCreateLocalId();
            }
            operationSet = this.startSave();
            operationSet.setIsSaveEventually(true);
            String sessionToken = ParseUser.getCurrentSessionToken();
            try {
                command = this.currentSaveCommand(operationSet, PointerOrLocalIdEncoder.get(), sessionToken);
                command.setLocalId(localId);
                command.setOperationSetUUID(operationSet.getUUID());
                command.retainLocalIds();
                for (ParseObject object2 : unsavedChildren) {
                    object2.saveEventually();
                }
            }
            catch (ParseException exception) {
                throw new IllegalStateException("Unable to saveEventually.", exception);
            }
        }
        ParseEventuallyQueue cache = Parse.getEventuallyQueue();
        Task<JSONObject> runEventuallyTask = cache.enqueueEventuallyAsync(command, this);
        this.enqueueSaveEventuallyOperationAsync(operationSet);
        command.releaseLocalIds();
        Task handleSaveResultTask = Parse.isLocalDatastoreEnabled() ? runEventuallyTask.makeVoid() : runEventuallyTask.onSuccessTask((Continuation)new Continuation<JSONObject, Task<Void>>(){

            public Task<Void> then(Task<JSONObject> task) throws Exception {
                JSONObject json = (JSONObject)task.getResult();
                return ParseObject.this.handleSaveEventuallyResultAsync(json, operationSet);
            }
        });
        return handleSaveResultTask;
    }

    private Task<Void> enqueueSaveEventuallyOperationAsync(final ParseOperationSet operationSet) {
        if (!operationSet.isSaveEventually()) {
            throw new IllegalStateException("This should only be used to enqueue saveEventually operation sets");
        }
        return this.taskQueue.enqueue(new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> toAwait) throws Exception {
                return toAwait.continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                    public Task<Void> then(Task<Void> task) throws Exception {
                        ParseEventuallyQueue cache = Parse.getEventuallyQueue();
                        return cache.waitForOperationSetAndEventuallyPin(operationSet, null).makeVoid();
                    }
                });
            }
        });
    }

    Task<Void> handleSaveEventuallyResultAsync(JSONObject json, ParseOperationSet operationSet) {
        final boolean success = json != null;
        Task<Void> handleSaveResultTask = this.handleSaveResultAsync(json, operationSet);
        return handleSaveResultTask.onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                if (success) {
                    Parse.getEventuallyQueue().notifyTestHelper(5);
                }
                return task;
            }
        });
    }

    void updateBeforeSave() {
    }

    public final void deleteEventually(DeleteCallback callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(this.deleteEventually(), callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Task<Void> deleteEventually() {
        Task<JSONObject> runEventuallyTask;
        Object object = this.mutex;
        synchronized (object) {
            this.validateDelete();
            ++this.isDeletingEventually;
            String localId = null;
            if (this.getObjectId() == null) {
                localId = this.getOrCreateLocalId();
            }
            String sessionToken = ParseUser.getCurrentSessionToken();
            ParseRESTObjectCommand command = ParseRESTObjectCommand.deleteObjectCommand(this.getState(), sessionToken);
            command.enableRetrying();
            command.setLocalId(localId);
            runEventuallyTask = Parse.getEventuallyQueue().enqueueEventuallyAsync(command, this);
        }
        Task handleDeleteResultTask = Parse.isLocalDatastoreEnabled() ? runEventuallyTask.makeVoid() : runEventuallyTask.onSuccessTask((Continuation)new Continuation<JSONObject, Task<Void>>(){

            public Task<Void> then(Task<JSONObject> task) throws Exception {
                return ParseObject.this.handleDeleteEventuallyResultAsync();
            }
        });
        return handleDeleteResultTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Task<Void> handleDeleteEventuallyResultAsync() {
        Object object = this.mutex;
        synchronized (object) {
            --this.isDeletingEventually;
        }
        Task<Void> handleDeleteResultTask = this.handleDeleteResultAsync();
        return handleDeleteResultTask.onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                Parse.getEventuallyQueue().notifyTestHelper(6);
                return task;
            }
        });
    }

    Task<Void> handleFetchResultAsync(final State result) {
        Task task = Task.forResult((Object)null);
        final OfflineStore store = Parse.getLocalDatastore();
        if (store != null) {
            task = task.onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

                public Task<Void> then(Task<Void> task) throws Exception {
                    return store.fetchLocallyAsync(ParseObject.this).makeVoid();
                }
            }).continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                public Task<Void> then(Task<Void> task) throws Exception {
                    if (task.getError() instanceof ParseException && ((ParseException)task.getError()).getCode() == 120) {
                        return null;
                    }
                    return task;
                }
            });
        }
        task = task.onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Task<Void> then(Task<Void> task) throws Exception {
                Object object = ParseObject.this.mutex;
                synchronized (object) {
                    State newState = result.isComplete() ? result : ((State.Init)((State.Init)ParseObject.this.getState().newBuilder()).apply(result)).build();
                    ParseObject.this.setState(newState);
                }
                return null;
            }
        });
        if (store != null) {
            task = task.onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

                public Task<Void> then(Task<Void> task) throws Exception {
                    return store.updateDataForObjectAsync(ParseObject.this);
                }
            }).continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                public Task<Void> then(Task<Void> task) throws Exception {
                    if (task.getError() instanceof ParseException && ((ParseException)task.getError()).getCode() == 120) {
                        return null;
                    }
                    return task;
                }
            });
        }
        return task;
    }

    @Deprecated
    public final void refresh() throws ParseException {
        this.fetch();
    }

    @Deprecated
    public final void refreshInBackground(RefreshCallback callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(this.fetchInBackground(), callback);
    }

    public <T extends ParseObject> T fetch() throws ParseException {
        return (T)((ParseObject)ParseTaskUtils.wait(this.fetchInBackground()));
    }

    <T extends ParseObject> Task<T> fetchAsync(final String sessionToken, Task<Void> toAwait) {
        return toAwait.onSuccessTask((Continuation)new Continuation<Void, Task<State>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Task<State> then(Task<Void> task) throws Exception {
                Map fetchedObjects;
                State state;
                Object object = ParseObject.this.mutex;
                synchronized (object) {
                    state = ParseObject.this.getState();
                    fetchedObjects = ParseObject.this.collectFetchedObjects();
                }
                KnownParseObjectDecoder decoder = new KnownParseObjectDecoder(fetchedObjects);
                return ParseObject.getObjectController().fetchAsync(state, sessionToken, decoder);
            }
        }).onSuccessTask((Continuation)new Continuation<State, Task<Void>>(){

            public Task<Void> then(Task<State> task) throws Exception {
                State result = (State)task.getResult();
                return ParseObject.this.handleFetchResultAsync(result);
            }
        }).onSuccess(new Continuation<Void, T>(){

            public T then(Task<Void> task) throws Exception {
                return ParseObject.this;
            }
        });
    }

    public final <T extends ParseObject> Task<T> fetchInBackground() {
        return ParseUser.getCurrentSessionTokenAsync().onSuccessTask(new Continuation<String, Task<T>>(){

            public Task<T> then(Task<String> task) throws Exception {
                final String sessionToken = (String)task.getResult();
                return ParseObject.this.taskQueue.enqueue(new Continuation<Void, Task<T>>(){

                    public Task<T> then(Task<Void> toAwait) throws Exception {
                        return ParseObject.this.fetchAsync(sessionToken, toAwait);
                    }
                });
            }
        });
    }

    public final <T extends ParseObject> void fetchInBackground(GetCallback<T> callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(this.fetchInBackground(), callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T extends ParseObject> Task<T> fetchIfNeededInBackground() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.isDataAvailable()) {
                return Task.forResult((Object)this);
            }
            return this.fetchInBackground();
        }
    }

    public <T extends ParseObject> T fetchIfNeeded() throws ParseException {
        return (T)((ParseObject)ParseTaskUtils.wait(this.fetchIfNeededInBackground()));
    }

    public final <T extends ParseObject> void fetchIfNeededInBackground(GetCallback<T> callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(this.fetchIfNeededInBackground(), callback);
    }

    void validateDelete() {
    }

    private Task<Void> deleteAsync(final String sessionToken, Task<Void> toAwait) {
        this.validateDelete();
        return toAwait.onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                if (ParseObject.this.state.objectId() == null) {
                    return task.cast();
                }
                return ParseObject.this.deleteAsync(sessionToken);
            }
        }).onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                return ParseObject.this.handleDeleteResultAsync();
            }
        });
    }

    Task<Void> deleteAsync(String sessionToken) throws ParseException {
        return ParseObject.getObjectController().deleteAsync(this.getState(), sessionToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Task<Void> handleDeleteResultAsync() {
        Task task = Task.forResult(null);
        Object object = this.mutex;
        synchronized (object) {
            this.isDeleted = true;
        }
        final OfflineStore store = Parse.getLocalDatastore();
        if (store != null) {
            task = task.continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Task<Void> then(Task<Void> task) throws Exception {
                    Object object = ParseObject.this.mutex;
                    synchronized (object) {
                        if (ParseObject.this.isDeleted) {
                            store.unregisterObject(ParseObject.this);
                            return store.deleteDataForObjectAsync(ParseObject.this);
                        }
                        return store.updateDataForObjectAsync(ParseObject.this);
                    }
                }
            });
        }
        return task;
    }

    public final Task<Void> deleteInBackground() {
        return ParseUser.getCurrentSessionTokenAsync().onSuccessTask((Continuation)new Continuation<String, Task<Void>>(){

            public Task<Void> then(Task<String> task) throws Exception {
                final String sessionToken = (String)task.getResult();
                return ParseObject.this.taskQueue.enqueue(new Continuation<Void, Task<Void>>(){

                    public Task<Void> then(Task<Void> toAwait) throws Exception {
                        return ParseObject.this.deleteAsync(sessionToken, (Task<Void>)toAwait);
                    }
                });
            }
        });
    }

    public final void delete() throws ParseException {
        ParseTaskUtils.wait(this.deleteInBackground());
    }

    public final void deleteInBackground(DeleteCallback callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(this.deleteInBackground(), callback);
    }

    private static <T extends ParseObject> Task<Void> deleteAllAsync(List<T> objects, final String sessionToken) {
        if (objects.size() == 0) {
            return Task.forResult(null);
        }
        int objectCount = objects.size();
        final ArrayList<ParseObject> uniqueObjects = new ArrayList<ParseObject>(objectCount);
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < objectCount; ++i) {
            ParseObject obj = (ParseObject)objects.get(i);
            if (idSet.contains(obj.getObjectId())) continue;
            idSet.add(obj.getObjectId());
            uniqueObjects.add(obj);
        }
        return ParseObject.enqueueForAll(uniqueObjects, new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> toAwait) throws Exception {
                return ParseObject.deleteAllAsync(uniqueObjects, sessionToken, (Task<Void>)toAwait);
            }
        });
    }

    private static <T extends ParseObject> Task<Void> deleteAllAsync(final List<T> uniqueObjects, final String sessionToken, Task<Void> toAwait) {
        return toAwait.continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                int objectCount = uniqueObjects.size();
                ArrayList<State> states = new ArrayList<State>(objectCount);
                for (int i = 0; i < objectCount; ++i) {
                    ParseObject object = (ParseObject)uniqueObjects.get(i);
                    object.validateDelete();
                    states.add(object.getState());
                }
                List<Task<Void>> batchTasks = ParseObject.getObjectController().deleteAllAsync(states, sessionToken);
                ArrayList<Task> tasks = new ArrayList<Task>(objectCount);
                for (int i = 0; i < objectCount; ++i) {
                    Task<Void> batchTask = batchTasks.get(i);
                    final ParseObject object = (ParseObject)uniqueObjects.get(i);
                    tasks.add(batchTask.onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

                        public Task<Void> then(final Task<Void> batchTask) throws Exception {
                            return object.handleDeleteResultAsync().continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                                public Task<Void> then(Task<Void> task) throws Exception {
                                    return batchTask;
                                }
                            });
                        }
                    }));
                }
                return Task.whenAll(tasks);
            }
        });
    }

    public static <T extends ParseObject> void deleteAll(List<T> objects) throws ParseException {
        ParseTaskUtils.wait(ParseObject.deleteAllInBackground(objects));
    }

    public static <T extends ParseObject> void deleteAllInBackground(List<T> objects, DeleteCallback callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(ParseObject.deleteAllInBackground(objects), callback);
    }

    public static <T extends ParseObject> Task<Void> deleteAllInBackground(final List<T> objects) {
        return ParseUser.getCurrentSessionTokenAsync().onSuccessTask((Continuation)new Continuation<String, Task<Void>>(){

            public Task<Void> then(Task<String> task) throws Exception {
                String sessionToken = (String)task.getResult();
                return ParseObject.deleteAllAsync(objects, sessionToken);
            }
        });
    }

    private static void collectDirtyChildren(Object node, final Collection<ParseObject> dirtyChildren, final Collection<ParseFile> dirtyFiles, final Set<ParseObject> alreadySeen, final Set<ParseObject> alreadySeenNew) {
        new ParseTraverser(){

            @Override
            protected boolean visit(Object node) {
                if (node instanceof ParseFile) {
                    if (dirtyFiles == null) {
                        return true;
                    }
                    ParseFile file = (ParseFile)node;
                    if (file.getUrl() == null) {
                        dirtyFiles.add(file);
                    }
                    return true;
                }
                if (!(node instanceof ParseObject)) {
                    return true;
                }
                if (dirtyChildren == null) {
                    return true;
                }
                ParseObject object = (ParseObject)node;
                HashSet<ParseObject> seen = alreadySeen;
                HashSet<ParseObject> seenNew = alreadySeenNew;
                if (object.getObjectId() != null) {
                    seenNew = new HashSet<ParseObject>();
                } else {
                    if (seenNew.contains(object)) {
                        throw new RuntimeException("Found a circular dependency while saving.");
                    }
                    seenNew = new HashSet(seenNew);
                    seenNew.add(object);
                }
                if (seen.contains(object)) {
                    return true;
                }
                seen = new HashSet<ParseObject>(seen);
                seen.add(object);
                ParseObject.collectDirtyChildren(object.estimatedData, dirtyChildren, dirtyFiles, seen, seenNew);
                if (object.isDirty(false)) {
                    dirtyChildren.add(object);
                }
                return true;
            }
        }.setYieldRoot(true).traverse(node);
    }

    private static void collectDirtyChildren(Object node, Collection<ParseObject> dirtyChildren, Collection<ParseFile> dirtyFiles) {
        ParseObject.collectDirtyChildren(node, dirtyChildren, dirtyFiles, new HashSet<ParseObject>(), new HashSet<ParseObject>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canBeSerialized() {
        Object object = this.mutex;
        synchronized (object) {
            final Capture result = new Capture((Object)true);
            new ParseTraverser(){

                @Override
                protected boolean visit(Object value) {
                    ParseObject object;
                    ParseFile file;
                    if (value instanceof ParseFile && (file = (ParseFile)value).isDirty()) {
                        result.set((Object)false);
                    }
                    if (value instanceof ParseObject && (object = (ParseObject)value).getObjectId() == null) {
                        result.set((Object)false);
                    }
                    return (Boolean)result.get();
                }
            }.setYieldRoot(false).setTraverseParseObjects(true).traverse(this);
            return (Boolean)result.get();
        }
    }

    private static Task<Void> deepSaveAsync(Object object, final String sessionToken) {
        HashSet<ParseObject> objects = new HashSet<ParseObject>();
        HashSet<ParseFile> files = new HashSet<ParseFile>();
        ParseObject.collectDirtyChildren(object, objects, files);
        HashSet<ParseUser> users = new HashSet<ParseUser>();
        for (ParseObject o : objects) {
            ParseUser user;
            if (!(o instanceof ParseUser) || !(user = (ParseUser)o).isLazy()) continue;
            users.add((ParseUser)o);
        }
        objects.removeAll(users);
        final AtomicBoolean filesComplete = new AtomicBoolean(false);
        ArrayList<Task<Void>> tasks = new ArrayList<Task<Void>>();
        for (ParseFile file : files) {
            tasks.add(file.saveAsync(sessionToken, null, null));
        }
        Task filesTask = Task.whenAll(tasks).continueWith((Continuation)new Continuation<Void, Void>(){

            public Void then(Task<Void> task) throws Exception {
                filesComplete.set(true);
                return null;
            }
        });
        final AtomicBoolean usersComplete = new AtomicBoolean(false);
        tasks = new ArrayList();
        for (ParseUser user : users) {
            tasks.add(user.saveAsync(sessionToken));
        }
        Task usersTask = Task.whenAll(tasks).continueWith((Continuation)new Continuation<Void, Void>(){

            public Void then(Task<Void> task) throws Exception {
                usersComplete.set(true);
                return null;
            }
        });
        final Capture remaining = new Capture(objects);
        Task objectsTask = Task.forResult(null).continueWhile((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return ((Set)remaining.get()).size() > 0;
            }
        }, (Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                final ArrayList<ParseObject> current = new ArrayList<ParseObject>();
                HashSet<ParseObject> nextBatch = new HashSet<ParseObject>();
                for (ParseObject obj : (Set)remaining.get()) {
                    if (obj.canBeSerialized()) {
                        current.add(obj);
                        continue;
                    }
                    nextBatch.add(obj);
                }
                remaining.set(nextBatch);
                if (current.size() == 0 && filesComplete.get() && usersComplete.get()) {
                    throw new RuntimeException("Unable to save a ParseObject with a relation to a cycle.");
                }
                if (current.size() == 0) {
                    return Task.forResult(null);
                }
                return ParseObject.enqueueForAll(current, new Continuation<Void, Task<Void>>(){

                    public Task<Void> then(Task<Void> toAwait) throws Exception {
                        return ParseObject.saveAllAsync(current, sessionToken, (Task<Void>)toAwait);
                    }
                });
            }
        });
        return Task.whenAll(Arrays.asList(filesTask, usersTask, objectsTask));
    }

    private static <T extends ParseObject> Task<Void> saveAllAsync(final List<T> uniqueObjects, final String sessionToken, Task<Void> toAwait) {
        return toAwait.continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                int objectCount = uniqueObjects.size();
                ArrayList<State> states = new ArrayList<State>(objectCount);
                ArrayList<ParseOperationSet> operationsList = new ArrayList<ParseOperationSet>(objectCount);
                ArrayList<ParseDecoder> decoders = new ArrayList<ParseDecoder>(objectCount);
                for (int i = 0; i < objectCount; ++i) {
                    ParseObject object = (ParseObject)uniqueObjects.get(i);
                    object.updateBeforeSave();
                    object.validateSave();
                    states.add(object.getState());
                    operationsList.add(object.startSave());
                    Map fetchedObjects = object.collectFetchedObjects();
                    decoders.add(new KnownParseObjectDecoder(fetchedObjects));
                }
                List<Task<State>> batchTasks = ParseObject.getObjectController().saveAllAsync(states, operationsList, sessionToken, decoders);
                ArrayList<Task> tasks = new ArrayList<Task>(objectCount);
                for (int i = 0; i < objectCount; ++i) {
                    Task<State> batchTask = batchTasks.get(i);
                    final ParseObject object = (ParseObject)uniqueObjects.get(i);
                    final ParseOperationSet operations = (ParseOperationSet)operationsList.get(i);
                    tasks.add(batchTask.continueWithTask((Continuation)new Continuation<State, Task<Void>>(){

                        public Task<Void> then(final Task<State> batchTask) throws Exception {
                            State result = (State)batchTask.getResult();
                            return object.handleSaveResultAsync(result, operations).continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                                public Task<Void> then(Task<Void> task) throws Exception {
                                    if (task.isFaulted() || task.isCancelled()) {
                                        return task;
                                    }
                                    return batchTask.makeVoid();
                                }
                            });
                        }
                    }));
                }
                return Task.whenAll(tasks);
            }
        });
    }

    public static <T extends ParseObject> void saveAll(List<T> objects) throws ParseException {
        ParseTaskUtils.wait(ParseObject.saveAllInBackground(objects));
    }

    public static <T extends ParseObject> void saveAllInBackground(List<T> objects, SaveCallback callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(ParseObject.saveAllInBackground(objects), callback);
    }

    public static <T extends ParseObject> Task<Void> saveAllInBackground(final List<T> objects) {
        return ParseUser.getCurrentUserAsync().onSuccessTask((Continuation)new Continuation<ParseUser, Task<String>>(){

            public Task<String> then(Task<ParseUser> task) throws Exception {
                ParseUser current = (ParseUser)task.getResult();
                if (current == null) {
                    return Task.forResult(null);
                }
                if (!current.isLazy()) {
                    return Task.forResult((Object)current.getSessionToken());
                }
                for (ParseObject object : objects) {
                    ParseUser user;
                    ParseACL acl;
                    if (!object.isDataAvailable(ParseObject.KEY_ACL) || (acl = object.getACL(false)) == null || (user = acl.getUnresolvedUser()) == null || !user.isCurrentUser()) continue;
                    return user.saveAsync(null).onSuccess((Continuation)new Continuation<Void, String>(){

                        public String then(Task<Void> task) throws Exception {
                            if (acl.hasUnresolvedUser()) {
                                throw new IllegalStateException("ACL has an unresolved ParseUser. Save or sign up before attempting to serialize the ACL.");
                            }
                            return user.getSessionToken();
                        }
                    });
                }
                return Task.forResult(null);
            }
        }).onSuccessTask((Continuation)new Continuation<String, Task<Void>>(){

            public Task<Void> then(Task<String> task) throws Exception {
                String sessionToken = (String)task.getResult();
                return ParseObject.deepSaveAsync(objects, sessionToken);
            }
        });
    }

    public static <T extends ParseObject> Task<List<T>> fetchAllIfNeededInBackground(List<T> objects) {
        return ParseObject.fetchAllAsync(objects, true);
    }

    public static <T extends ParseObject> List<T> fetchAllIfNeeded(List<T> objects) throws ParseException {
        return ParseTaskUtils.wait(ParseObject.fetchAllIfNeededInBackground(objects));
    }

    public static <T extends ParseObject> void fetchAllIfNeededInBackground(List<T> objects, FindCallback<T> callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(ParseObject.fetchAllIfNeededInBackground(objects), callback);
    }

    private static <T extends ParseObject> Task<List<T>> fetchAllAsync(final List<T> objects, final boolean onlyIfNeeded) {
        return ParseUser.getCurrentUserAsync().onSuccessTask(new Continuation<ParseUser, Task<List<T>>>(){

            public Task<List<T>> then(Task<ParseUser> task) throws Exception {
                final ParseUser user = (ParseUser)task.getResult();
                return ParseObject.enqueueForAll(objects, new Continuation<Void, Task<List<T>>>(){

                    public Task<List<T>> then(Task<Void> task) throws Exception {
                        return ParseObject.fetchAllAsync(objects, user, onlyIfNeeded, (Task<Void>)task);
                    }
                });
            }
        });
    }

    private static <T extends ParseObject> Task<List<T>> fetchAllAsync(final List<T> objects, final ParseUser user, final boolean onlyIfNeeded, Task<Void> toAwait) {
        if (objects.size() == 0) {
            return Task.forResult(objects);
        }
        ArrayList<String> objectIds = new ArrayList<String>();
        String className = null;
        for (ParseObject object : objects) {
            if (onlyIfNeeded && object.isDataAvailable()) continue;
            if (className != null && !object.getClassName().equals(className)) {
                throw new IllegalArgumentException("All objects should have the same class");
            }
            className = object.getClassName();
            String objectId = object.getObjectId();
            if (objectId != null) {
                objectIds.add(object.getObjectId());
                continue;
            }
            if (onlyIfNeeded) continue;
            throw new IllegalArgumentException("All objects must exist on the server");
        }
        if (objectIds.size() == 0) {
            return Task.forResult(objects);
        }
        final ParseQuery query = ParseQuery.getQuery(className).whereContainedIn(KEY_OBJECT_ID, objectIds);
        return toAwait.continueWithTask(new Continuation<Void, Task<List<T>>>(){

            public Task<List<T>> then(Task<Void> task) throws Exception {
                return query.findAsync(query.getBuilder().build(), user, null);
            }
        }).onSuccess(new Continuation<List<T>, List<T>>(){

            public List<T> then(Task<List<T>> task) throws Exception {
                HashMap<String, ParseObject> resultMap = new HashMap<String, ParseObject>();
                for (ParseObject o : (List)task.getResult()) {
                    resultMap.put(o.getObjectId(), o);
                }
                for (ParseObject object : objects) {
                    if (onlyIfNeeded && object.isDataAvailable()) continue;
                    ParseObject newObject = (ParseObject)resultMap.get(object.getObjectId());
                    if (newObject == null) {
                        throw new RuntimeException("Object id " + object.getObjectId() + " does not exist");
                    }
                    if (Parse.isLocalDatastoreEnabled()) continue;
                    object.mergeFromObject(newObject);
                }
                return objects;
            }
        });
    }

    public static <T extends ParseObject> Task<List<T>> fetchAllInBackground(List<T> objects) {
        return ParseObject.fetchAllAsync(objects, false);
    }

    public static <T extends ParseObject> List<T> fetchAll(List<T> objects) throws ParseException {
        return ParseTaskUtils.wait(ParseObject.fetchAllInBackground(objects));
    }

    public static <T extends ParseObject> void fetchAllInBackground(List<T> objects, FindCallback<T> callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(ParseObject.fetchAllInBackground(objects), callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParseOperationSet currentOperations() {
        Object object = this.mutex;
        synchronized (object) {
            return this.operationSetQueue.getLast();
        }
    }

    private void applyOperations(ParseOperationSet operations, Map<String, Object> map) {
        for (String key : operations.keySet()) {
            Object oldValue;
            ParseFieldOperation operation = (ParseFieldOperation)operations.get(key);
            Object newValue = operation.apply(oldValue = map.get(key), key);
            if (newValue != null) {
                map.put(key, newValue);
                continue;
            }
            map.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildEstimatedData() {
        Object object = this.mutex;
        synchronized (object) {
            this.estimatedData.clear();
            for (String key : this.state.keySet()) {
                this.estimatedData.put(key, this.state.get(key));
            }
            for (ParseOperationSet operations : this.operationSetQueue) {
                this.applyOperations(operations, this.estimatedData);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildDataAvailability() {
        Object object = this.mutex;
        synchronized (object) {
            this.dataAvailability.clear();
            for (String key : this.state.keySet()) {
                this.dataAvailability.put(key, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void performOperation(String key, ParseFieldOperation operation) {
        Object object = this.mutex;
        synchronized (object) {
            Object oldValue = this.estimatedData.get(key);
            Object newValue = operation.apply(oldValue, key);
            if (newValue != null) {
                this.estimatedData.put(key, newValue);
            } else {
                this.estimatedData.remove(key);
            }
            ParseFieldOperation oldOperation = (ParseFieldOperation)this.currentOperations().get(key);
            ParseFieldOperation newOperation = operation.mergeWithPrevious(oldOperation);
            this.currentOperations().put(key, newOperation);
            this.checkpointMutableContainer(key, newValue);
            this.dataAvailability.put(key, Boolean.TRUE);
        }
    }

    public void put(String key, Object value) {
        this.checkKeyIsMutable(key);
        this.performPut(key, value);
    }

    void performPut(String key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("key may not be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("value may not be null.");
        }
        if (!ParseEncoder.isValidType(value)) {
            throw new IllegalArgumentException("invalid type for value: " + value.getClass().toString());
        }
        this.performOperation(key, new ParseSetOperation(value));
    }

    public boolean has(String key) {
        return this.containsKey(key);
    }

    public void increment(String key) {
        this.increment(key, 1);
    }

    public void increment(String key, Number amount) {
        ParseIncrementOperation operation = new ParseIncrementOperation(amount);
        this.performOperation(key, operation);
    }

    public void add(String key, Object value) {
        this.addAll(key, Arrays.asList(value));
    }

    public void addAll(String key, Collection<?> values) {
        ParseAddOperation operation = new ParseAddOperation(values);
        this.performOperation(key, operation);
    }

    public void addUnique(String key, Object value) {
        this.addAllUnique(key, Arrays.asList(value));
    }

    public void addAllUnique(String key, Collection<?> values) {
        ParseAddUniqueOperation operation = new ParseAddUniqueOperation(values);
        this.performOperation(key, operation);
    }

    public void remove(String key) {
        this.checkKeyIsMutable(key);
        this.performRemove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void performRemove(String key) {
        Object object = this.mutex;
        synchronized (object) {
            Object object2 = this.get(key);
            if (object2 != null) {
                this.performOperation(key, ParseDeleteOperation.getInstance());
            }
        }
    }

    public void removeAll(String key, Collection<?> values) {
        this.checkKeyIsMutable(key);
        ParseRemoveOperation operation = new ParseRemoveOperation(values);
        this.performOperation(key, operation);
    }

    private void checkKeyIsMutable(String key) {
        if (!this.isKeyMutable(key)) {
            throw new IllegalArgumentException("Cannot modify `" + key + "` property of an " + this.getClassName() + " object.");
        }
    }

    boolean isKeyMutable(String key) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(String key) {
        Object object = this.mutex;
        synchronized (object) {
            return this.estimatedData.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(String key) {
        Object object = this.mutex;
        synchronized (object) {
            this.checkGetAccess(key);
            Object value = this.estimatedData.get(key);
            if (!(value instanceof String)) {
                return null;
            }
            return (String)value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(String key) {
        Object object = this.mutex;
        synchronized (object) {
            this.checkGetAccess(key);
            Object value = this.estimatedData.get(key);
            if (!(value instanceof byte[])) {
                return null;
            }
            return (byte[])value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Number getNumber(String key) {
        Object object = this.mutex;
        synchronized (object) {
            this.checkGetAccess(key);
            Object value = this.estimatedData.get(key);
            if (!(value instanceof Number)) {
                return null;
            }
            return (Number)value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONArray getJSONArray(String key) {
        Object object = this.mutex;
        synchronized (object) {
            this.checkGetAccess(key);
            Object value = this.estimatedData.get(key);
            if (value instanceof List) {
                value = PointerOrLocalIdEncoder.get().encode(value);
                this.put(key, value);
            }
            if (!(value instanceof JSONArray)) {
                return null;
            }
            return (JSONArray)value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> getList(String key) {
        Object object = this.mutex;
        synchronized (object) {
            List<Object> value = this.estimatedData.get(key);
            if (value instanceof JSONArray) {
                ParseDecoder decoder = ParseDecoder.get();
                value = decoder.convertJSONArrayToList((JSONArray)value);
                this.put(key, value);
            }
            if (!(value instanceof List)) {
                return null;
            }
            List returnValue = value;
            return returnValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> Map<String, V> getMap(String key) {
        Object object = this.mutex;
        synchronized (object) {
            Map<String, Object> value = this.estimatedData.get(key);
            if (value instanceof JSONObject) {
                ParseDecoder decoder = ParseDecoder.get();
                value = decoder.convertJSONObjectToMap((JSONObject)value);
                this.put(key, value);
            }
            if (!(value instanceof Map)) {
                return null;
            }
            Map returnValue = value;
            return returnValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getJSONObject(String key) {
        Object object = this.mutex;
        synchronized (object) {
            this.checkGetAccess(key);
            Object value = this.estimatedData.get(key);
            if (value instanceof Map) {
                value = PointerOrLocalIdEncoder.get().encode(value);
                this.put(key, value);
            }
            if (!(value instanceof JSONObject)) {
                return null;
            }
            return (JSONObject)value;
        }
    }

    public int getInt(String key) {
        Number number = this.getNumber(key);
        if (number == null) {
            return 0;
        }
        return number.intValue();
    }

    public double getDouble(String key) {
        Number number = this.getNumber(key);
        if (number == null) {
            return 0.0;
        }
        return number.doubleValue();
    }

    public long getLong(String key) {
        Number number = this.getNumber(key);
        if (number == null) {
            return 0L;
        }
        return number.longValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(String key) {
        Object object = this.mutex;
        synchronized (object) {
            this.checkGetAccess(key);
            Object value = this.estimatedData.get(key);
            if (!(value instanceof Boolean)) {
                return false;
            }
            return (Boolean)value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDate(String key) {
        Object object = this.mutex;
        synchronized (object) {
            this.checkGetAccess(key);
            Object value = this.estimatedData.get(key);
            if (!(value instanceof Date)) {
                return null;
            }
            return (Date)value;
        }
    }

    public ParseObject getParseObject(String key) {
        Object value = this.get(key);
        if (!(value instanceof ParseObject)) {
            return null;
        }
        return (ParseObject)value;
    }

    public ParseUser getParseUser(String key) {
        Object value = this.get(key);
        if (!(value instanceof ParseUser)) {
            return null;
        }
        return (ParseUser)value;
    }

    public ParseFile getParseFile(String key) {
        Object value = this.get(key);
        if (!(value instanceof ParseFile)) {
            return null;
        }
        return (ParseFile)value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParseGeoPoint getParseGeoPoint(String key) {
        Object object = this.mutex;
        synchronized (object) {
            this.checkGetAccess(key);
            Object value = this.estimatedData.get(key);
            if (!(value instanceof ParseGeoPoint)) {
                return null;
            }
            return (ParseGeoPoint)value;
        }
    }

    public ParseACL getACL() {
        return this.getACL(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParseACL getACL(boolean mayCopy) {
        Object object = this.mutex;
        synchronized (object) {
            this.checkGetAccess(KEY_ACL);
            Object acl = this.estimatedData.get(KEY_ACL);
            if (acl == null) {
                return null;
            }
            if (!(acl instanceof ParseACL)) {
                throw new RuntimeException("only ACLs can be stored in the ACL key");
            }
            if (mayCopy && ((ParseACL)acl).isShared()) {
                ParseACL copy = ((ParseACL)acl).copy();
                this.estimatedData.put(KEY_ACL, copy);
                this.addToHashedObjects(copy);
                return copy;
            }
            return (ParseACL)acl;
        }
    }

    public void setACL(ParseACL acl) {
        this.put(KEY_ACL, acl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDataAvailable() {
        Object object = this.mutex;
        synchronized (object) {
            return this.state.isComplete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDataAvailable(String key) {
        Object object = this.mutex;
        synchronized (object) {
            return this.isDataAvailable() || this.dataAvailability.containsKey(key) && this.dataAvailability.get(key) != false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends ParseObject> ParseRelation<T> getRelation(String key) {
        Object object = this.mutex;
        synchronized (object) {
            Object value = this.estimatedData.get(key);
            if (value instanceof ParseRelation) {
                ParseRelation relation = (ParseRelation)value;
                relation.ensureParentAndKey(this, key);
                return relation;
            }
            ParseRelation relation = new ParseRelation(this, key);
            this.estimatedData.put(key, relation);
            return relation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String key) {
        Object object = this.mutex;
        synchronized (object) {
            if (key.equals(KEY_ACL)) {
                return this.getACL();
            }
            this.checkGetAccess(key);
            Object value = this.estimatedData.get(key);
            if (value instanceof ParseRelation) {
                ((ParseRelation)value).ensureParentAndKey(this, key);
            }
            return value;
        }
    }

    private void checkGetAccess(String key) {
        if (!this.isDataAvailable(key)) {
            throw new IllegalStateException("ParseObject has no data for '" + key + "'. Call fetchIfNeeded() to get the data.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSameId(ParseObject other) {
        Object object = this.mutex;
        synchronized (object) {
            return this.getClassName() != null && this.getObjectId() != null && this.getClassName().equals(other.getClassName()) && this.getObjectId().equals(other.getObjectId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerSaveListener(GetCallback<ParseObject> callback) {
        Object object = this.mutex;
        synchronized (object) {
            this.saveEvent.subscribe(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterSaveListener(GetCallback<ParseObject> callback) {
        Object object = this.mutex;
        synchronized (object) {
            this.saveEvent.unsubscribe(callback);
        }
    }

    static String getClassName(Class<? extends ParseObject> clazz) {
        String name = classNames.get(clazz);
        if (name == null) {
            ParseClassName info = clazz.getAnnotation(ParseClassName.class);
            if (info == null) {
                return null;
            }
            name = info.value();
            classNames.put(clazz, name);
        }
        return name;
    }

    void setDefaultValues() {
        if (this.needsDefaultACL() && ParseACL.getDefaultACL() != null) {
            this.setACL(ParseACL.getDefaultACL());
        }
    }

    boolean needsDefaultACL() {
        return true;
    }

    static void registerParseSubclasses() {
        ParseObject.registerSubclass(ParseUser.class);
        ParseObject.registerSubclass(ParseRole.class);
        ParseObject.registerSubclass(ParseInstallation.class);
        ParseObject.registerSubclass(ParseSession.class);
        ParseObject.registerSubclass(ParsePin.class);
        ParseObject.registerSubclass(EventuallyPin.class);
    }

    static void unregisterParseSubclasses() {
        ParseObject.unregisterSubclass(ParseUser.class);
        ParseObject.unregisterSubclass(ParseRole.class);
        ParseObject.unregisterSubclass(ParseInstallation.class);
        ParseObject.unregisterSubclass(ParseSession.class);
        ParseObject.unregisterSubclass(ParsePin.class);
        ParseObject.unregisterSubclass(EventuallyPin.class);
    }

    public static <T extends ParseObject> void pinAllInBackground(String name, List<T> objects, SaveCallback callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(ParseObject.pinAllInBackground(name, objects), callback);
    }

    public static <T extends ParseObject> Task<Void> pinAllInBackground(String name, List<T> objects) {
        return ParseObject.pinAllInBackground(name, objects, true);
    }

    private static <T extends ParseObject> Task<Void> pinAllInBackground(final String name, final List<T> objects, final boolean includeAllChildren) {
        if (!Parse.isLocalDatastoreEnabled()) {
            throw new IllegalStateException("Method requires Local Datastore. Please refer to `Parse#enableLocalDatastore(Context)`.");
        }
        Task task = Task.forResult(null);
        for (final ParseObject object : objects) {
            task = task.onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

                public Task<Void> then(Task<Void> task) throws Exception {
                    if (!object.isDataAvailable(ParseObject.KEY_ACL)) {
                        return Task.forResult(null);
                    }
                    ParseACL acl = object.getACL(false);
                    if (acl == null) {
                        return Task.forResult(null);
                    }
                    ParseUser user = acl.getUnresolvedUser();
                    if (user == null || !user.isCurrentUser()) {
                        return Task.forResult(null);
                    }
                    return ParseUser.pinCurrentUserIfNeededAsync(user);
                }
            });
        }
        return task.onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                return Parse.getLocalDatastore().pinAllObjectsAsync(name != null ? name : ParseObject.DEFAULT_PIN, objects, includeAllChildren);
            }
        }).onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                if ("_currentUser".equals(name)) {
                    return task;
                }
                for (ParseObject object : objects) {
                    ParseUser user;
                    if (!(object instanceof ParseUser) || !(user = (ParseUser)object).isCurrentUser()) continue;
                    return ParseUser.pinCurrentUserIfNeededAsync(user);
                }
                return task;
            }
        });
    }

    public static <T extends ParseObject> void pinAll(String name, List<T> objects) throws ParseException {
        ParseTaskUtils.wait(ParseObject.pinAllInBackground(name, objects));
    }

    public static <T extends ParseObject> void pinAllInBackground(List<T> objects, SaveCallback callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(ParseObject.pinAllInBackground(DEFAULT_PIN, objects), callback);
    }

    public static <T extends ParseObject> Task<Void> pinAllInBackground(List<T> objects) {
        return ParseObject.pinAllInBackground(DEFAULT_PIN, objects);
    }

    public static <T extends ParseObject> void pinAll(List<T> objects) throws ParseException {
        ParseTaskUtils.wait(ParseObject.pinAllInBackground(DEFAULT_PIN, objects));
    }

    public static <T extends ParseObject> void unpinAllInBackground(String name, List<T> objects, DeleteCallback callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(ParseObject.unpinAllInBackground(name, objects), callback);
    }

    public static <T extends ParseObject> Task<Void> unpinAllInBackground(String name, List<T> objects) {
        if (!Parse.isLocalDatastoreEnabled()) {
            throw new IllegalStateException("Method requires Local Datastore. Please refer to `Parse#enableLocalDatastore(Context)`.");
        }
        if (name == null) {
            name = DEFAULT_PIN;
        }
        return Parse.getLocalDatastore().unpinAllObjectsAsync(name, objects);
    }

    public static <T extends ParseObject> void unpinAll(String name, List<T> objects) throws ParseException {
        ParseTaskUtils.wait(ParseObject.unpinAllInBackground(name, objects));
    }

    public static <T extends ParseObject> void unpinAllInBackground(List<T> objects, DeleteCallback callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(ParseObject.unpinAllInBackground(DEFAULT_PIN, objects), callback);
    }

    public static <T extends ParseObject> Task<Void> unpinAllInBackground(List<T> objects) {
        return ParseObject.unpinAllInBackground(DEFAULT_PIN, objects);
    }

    public static <T extends ParseObject> void unpinAll(List<T> objects) throws ParseException {
        ParseTaskUtils.wait(ParseObject.unpinAllInBackground(DEFAULT_PIN, objects));
    }

    public static void unpinAllInBackground(String name, DeleteCallback callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(ParseObject.unpinAllInBackground(name), callback);
    }

    public static Task<Void> unpinAllInBackground(String name) {
        if (!Parse.isLocalDatastoreEnabled()) {
            throw new IllegalStateException("Method requires Local Datastore. Please refer to `Parse#enableLocalDatastore(Context)`.");
        }
        if (name == null) {
            name = DEFAULT_PIN;
        }
        return Parse.getLocalDatastore().unpinAllObjectsAsync(name);
    }

    public static void unpinAll(String name) throws ParseException {
        ParseTaskUtils.wait(ParseObject.unpinAllInBackground(name));
    }

    public static void unpinAllInBackground(DeleteCallback callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(ParseObject.unpinAllInBackground(), callback);
    }

    public static Task<Void> unpinAllInBackground() {
        return ParseObject.unpinAllInBackground(DEFAULT_PIN);
    }

    public static void unpinAll() throws ParseException {
        ParseTaskUtils.wait(ParseObject.unpinAllInBackground());
    }

    <T extends ParseObject> Task<T> fetchFromLocalDatastoreAsync() {
        if (!Parse.isLocalDatastoreEnabled()) {
            throw new IllegalStateException("Method requires Local Datastore. Please refer to `Parse#enableLocalDatastore(Context)`.");
        }
        return Parse.getLocalDatastore().fetchLocallyAsync(this);
    }

    public <T extends ParseObject> void fetchFromLocalDatastoreInBackground(GetCallback<T> callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(this.fetchFromLocalDatastoreAsync(), callback);
    }

    public void fetchFromLocalDatastore() throws ParseException {
        ParseTaskUtils.wait(this.fetchFromLocalDatastoreAsync());
    }

    public void pinInBackground(String name, SaveCallback callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(this.pinInBackground(name), callback);
    }

    public Task<Void> pinInBackground(String name) {
        return ParseObject.pinAllInBackground(name, Arrays.asList(this));
    }

    Task<Void> pinInBackground(String name, boolean includeAllChildren) {
        return ParseObject.pinAllInBackground(name, Arrays.asList(this), includeAllChildren);
    }

    public void pin(String name) throws ParseException {
        ParseTaskUtils.wait(this.pinInBackground(name));
    }

    public void pinInBackground(SaveCallback callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(this.pinInBackground(), callback);
    }

    public Task<Void> pinInBackground() {
        return ParseObject.pinAllInBackground(DEFAULT_PIN, Arrays.asList(this));
    }

    public void pin() throws ParseException {
        ParseTaskUtils.wait(this.pinInBackground());
    }

    public void unpinInBackground(String name, DeleteCallback callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(this.unpinInBackground(name), callback);
    }

    public Task<Void> unpinInBackground(String name) {
        return ParseObject.unpinAllInBackground(name, Arrays.asList(this));
    }

    public void unpin(String name) throws ParseException {
        ParseTaskUtils.wait(this.unpinInBackground(name));
    }

    public void unpinInBackground(DeleteCallback callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(this.unpinInBackground(), callback);
    }

    public Task<Void> unpinInBackground() {
        return ParseObject.unpinAllInBackground(DEFAULT_PIN, Arrays.asList(this));
    }

    public void unpin() throws ParseException {
        ParseTaskUtils.wait(this.unpinInBackground());
    }

    static class State {
        private final String className;
        private final String objectId;
        private final long createdAt;
        private final long updatedAt;
        private final Map<String, Object> serverData;
        private final boolean isComplete;

        State(Init<?> builder) {
            this.className = ((Init)builder).className;
            this.objectId = ((Init)builder).objectId;
            this.createdAt = ((Init)builder).createdAt;
            this.updatedAt = ((Init)builder).updatedAt > 0L ? ((Init)builder).updatedAt : this.createdAt;
            this.serverData = Collections.unmodifiableMap(new HashMap<String, Object>(builder.serverData));
            this.isComplete = ((Init)builder).isComplete;
        }

        public <T extends Init<?>> T newBuilder() {
            return (T)new Builder(this);
        }

        public String className() {
            return this.className;
        }

        public String objectId() {
            return this.objectId;
        }

        public long createdAt() {
            return this.createdAt;
        }

        public long updatedAt() {
            return this.updatedAt;
        }

        public boolean isComplete() {
            return this.isComplete;
        }

        public Object get(String key) {
            return this.serverData.get(key);
        }

        public Set<String> keySet() {
            return this.serverData.keySet();
        }

        public String toString() {
            return String.format(Locale.US, "%s@%s[className=%s, objectId=%s, createdAt=%d, updatedAt=%d, isComplete=%s, serverData=%s]", this.getClass().getName(), Integer.toHexString(this.hashCode()), this.className, this.objectId, this.createdAt, this.updatedAt, this.isComplete, this.serverData);
        }

        static class Builder
        extends Init<Builder> {
            public Builder(String className) {
                super(className);
            }

            public Builder(State state) {
                super(state);
            }

            @Override
            Builder self() {
                return this;
            }

            @Override
            public State build() {
                return new State(this);
            }
        }

        static abstract class Init<T extends Init> {
            private final String className;
            private String objectId;
            private long createdAt = -1L;
            private long updatedAt = -1L;
            private boolean isComplete;
            Map<String, Object> serverData = new HashMap<String, Object>();

            public Init(String className) {
                this.className = className;
            }

            Init(State state) {
                this.className = state.className();
                this.objectId = state.objectId();
                this.createdAt = state.createdAt();
                this.updatedAt = state.updatedAt();
                for (String key : state.keySet()) {
                    this.serverData.put(key, state.get(key));
                }
                this.isComplete = state.isComplete();
            }

            abstract T self();

            abstract <S extends State> S build();

            public T objectId(String objectId) {
                this.objectId = objectId;
                return this.self();
            }

            public T createdAt(Date createdAt) {
                this.createdAt = createdAt.getTime();
                return this.self();
            }

            public T createdAt(long createdAt) {
                this.createdAt = createdAt;
                return this.self();
            }

            public T updatedAt(Date updatedAt) {
                this.updatedAt = updatedAt.getTime();
                return this.self();
            }

            public T updatedAt(long updatedAt) {
                this.updatedAt = updatedAt;
                return this.self();
            }

            public T isComplete(boolean complete) {
                this.isComplete = complete;
                return this.self();
            }

            public T put(String key, Object value) {
                this.serverData.put(key, value);
                return this.self();
            }

            public T remove(String key) {
                this.serverData.remove(key);
                return this.self();
            }

            public T clear() {
                this.objectId = null;
                this.createdAt = -1L;
                this.updatedAt = -1L;
                this.isComplete = false;
                this.serverData.clear();
                return this.self();
            }

            public T apply(State other) {
                if (other.objectId() != null) {
                    this.objectId(other.objectId());
                }
                if (other.createdAt() > 0L) {
                    this.createdAt(other.createdAt());
                }
                if (other.updatedAt() > 0L) {
                    this.updatedAt(other.updatedAt());
                }
                this.isComplete(this.isComplete || other.isComplete());
                for (String key : other.keySet()) {
                    this.put(key, other.get(key));
                }
                return this.self();
            }

            public T apply(ParseOperationSet operations) {
                for (String key : operations.keySet()) {
                    Object oldValue;
                    ParseFieldOperation operation = (ParseFieldOperation)operations.get(key);
                    Object newValue = operation.apply(oldValue = this.serverData.get(key), key);
                    if (newValue != null) {
                        this.put(key, newValue);
                        continue;
                    }
                    this.remove(key);
                }
                return this.self();
            }
        }
    }
}

