/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import bolts.Task;
import com.parse.NoObjectsEncoder;
import com.parse.ParseConfig;
import com.parse.ParseDecoder;
import com.parse.ParseExecutors;
import com.parse.ParseFileUtils;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.json.JSONException;
import org.json.JSONObject;

class ParseCurrentConfigController {
    private final Object currentConfigMutex = new Object();
    ParseConfig currentConfig;
    private File currentConfigFile;

    public ParseCurrentConfigController(File currentConfigFile) {
        this.currentConfigFile = currentConfigFile;
    }

    public Task<Void> setCurrentConfigAsync(final ParseConfig config) {
        return Task.call((Callable)new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                Object object = ParseCurrentConfigController.this.currentConfigMutex;
                synchronized (object) {
                    ParseCurrentConfigController.this.currentConfig = config;
                    ParseCurrentConfigController.this.saveToDisk(config);
                }
                return null;
            }
        }, (Executor)ParseExecutors.io());
    }

    public Task<ParseConfig> getCurrentConfigAsync() {
        return Task.call((Callable)new Callable<ParseConfig>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParseConfig call() throws Exception {
                Object object = ParseCurrentConfigController.this.currentConfigMutex;
                synchronized (object) {
                    if (ParseCurrentConfigController.this.currentConfig == null) {
                        ParseConfig config = ParseCurrentConfigController.this.getFromDisk();
                        ParseCurrentConfigController.this.currentConfig = config != null ? config : new ParseConfig();
                    }
                }
                return ParseCurrentConfigController.this.currentConfig;
            }
        }, (Executor)ParseExecutors.io());
    }

    ParseConfig getFromDisk() {
        JSONObject json;
        try {
            json = ParseFileUtils.readFileToJSONObject(this.currentConfigFile);
        }
        catch (IOException | JSONException e) {
            return null;
        }
        return new ParseConfig(json, ParseDecoder.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearCurrentConfigForTesting() {
        Object object = this.currentConfigMutex;
        synchronized (object) {
            this.currentConfig = null;
        }
    }

    void saveToDisk(ParseConfig config) {
        JSONObject object = new JSONObject();
        try {
            JSONObject jsonParams = (JSONObject)NoObjectsEncoder.get().encode(config.getParams());
            object.put("params", (Object)jsonParams);
        }
        catch (JSONException e) {
            throw new RuntimeException("could not serialize config to JSON");
        }
        try {
            ParseFileUtils.writeJSONObjectToFile(this.currentConfigFile, object);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

