/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import bolts.Task;
import com.parse.ParseException;
import com.parse.ParseHttpResponse;
import com.parse.ParseIOUtils;
import com.parse.ParseRequest;
import com.parse.ProgressCallback;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

class ParseAWSRequest
extends ParseRequest<byte[]> {
    public ParseAWSRequest(ParseRequest.Method method, String url) {
        super(method, url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Task<byte[]> onResponseAsync(ParseHttpResponse response, ProgressCallback downloadProgressCallback) {
        int statusCode = response.getStatusCode();
        if ((statusCode < 200 || statusCode >= 300) && statusCode != 304) {
            String action = this.method == ParseRequest.Method.GET ? "Download from" : "Upload to";
            return Task.forError((Exception)new ParseException(100, String.format("%s S3 failed. %s", action, response.getReasonPhrase())));
        }
        if (this.method != ParseRequest.Method.GET) {
            return null;
        }
        int totalSize = response.getTotalSize();
        int downloadedSize = 0;
        InputStream responseStream = null;
        try {
            int nRead;
            responseStream = response.getContent();
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[32768];
            while ((nRead = responseStream.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
                downloadedSize += nRead;
                if (downloadProgressCallback == null || totalSize == -1) continue;
                int progressToReport = Math.round((float)downloadedSize / (float)totalSize * 100.0f);
                downloadProgressCallback.done(progressToReport);
            }
            Task task = Task.forResult((Object)buffer.toByteArray());
            return task;
        }
        catch (IOException e) {
            Task task = Task.forError((Exception)e);
            return task;
        }
        finally {
            ParseIOUtils.closeQuietly(responseStream);
        }
    }
}

