/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import com.parse.Parse;
import com.parse.ParseFileUtils;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import org.json.JSONException;
import org.json.JSONObject;

class LocalIdManager {
    private static LocalIdManager defaultInstance;
    private final File diskPath;
    private final Random random;

    public static synchronized LocalIdManager getDefaultInstance() {
        if (defaultInstance == null) {
            defaultInstance = new LocalIdManager();
        }
        return defaultInstance;
    }

    private LocalIdManager() {
        this(new File(Parse.getParseDir(), "LocalId"));
    }

    LocalIdManager(File path) {
        this.diskPath = path;
        this.random = new Random();
    }

    private boolean isLocalId(String localId) {
        if (!localId.startsWith("local_")) {
            return false;
        }
        for (int i = 6; i < localId.length(); ++i) {
            char c = localId.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f') continue;
            return false;
        }
        return true;
    }

    private synchronized MapEntry getMapEntry(String localId) {
        if (!this.isLocalId(localId)) {
            throw new IllegalStateException("Tried to get invalid local id: \"" + localId + "\".");
        }
        try {
            JSONObject json = ParseFileUtils.readFileToJSONObject(new File(this.diskPath, localId));
            MapEntry entry = new MapEntry();
            entry.retainCount = json.optInt("retainCount", 0);
            entry.objectId = json.optString("objectId", null);
            return entry;
        }
        catch (IOException | JSONException e) {
            return new MapEntry();
        }
    }

    private synchronized void putMapEntry(String localId, MapEntry entry) {
        if (!this.isLocalId(localId)) {
            throw new IllegalStateException("Tried to get invalid local id: \"" + localId + "\".");
        }
        JSONObject json = new JSONObject();
        try {
            json.put("retainCount", entry.retainCount);
            if (entry.objectId != null) {
                json.put("objectId", (Object)entry.objectId);
            }
        }
        catch (JSONException je) {
            throw new IllegalStateException("Error creating local id map entry.", je);
        }
        File file = new File(this.diskPath, localId);
        if (!this.diskPath.exists()) {
            this.diskPath.mkdirs();
        }
        try {
            ParseFileUtils.writeJSONObjectToFile(file, json);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private synchronized void removeMapEntry(String localId) {
        if (!this.isLocalId(localId)) {
            throw new IllegalStateException("Tried to get invalid local id: \"" + localId + "\".");
        }
        File file = new File(this.diskPath, localId);
        file.delete();
    }

    synchronized String createLocalId() {
        long localIdNumber = this.random.nextLong();
        String localId = "local_" + Long.toHexString(localIdNumber);
        if (!this.isLocalId(localId)) {
            throw new IllegalStateException("Generated an invalid local id: \"" + localId + "\". " + "This should never happen. Contact us at https://parse.com/help");
        }
        return localId;
    }

    synchronized void retainLocalIdOnDisk(String localId) {
        MapEntry entry = this.getMapEntry(localId);
        ++entry.retainCount;
        this.putMapEntry(localId, entry);
    }

    synchronized void releaseLocalIdOnDisk(String localId) {
        MapEntry entry = this.getMapEntry(localId);
        --entry.retainCount;
        if (entry.retainCount > 0) {
            this.putMapEntry(localId, entry);
        } else {
            this.removeMapEntry(localId);
        }
    }

    synchronized String getObjectId(String localId) {
        MapEntry entry = this.getMapEntry(localId);
        return entry.objectId;
    }

    synchronized void setObjectId(String localId, String objectId) {
        MapEntry entry = this.getMapEntry(localId);
        if (entry.retainCount > 0) {
            if (entry.objectId != null) {
                throw new IllegalStateException("Tried to set an objectId for a localId that already has one.");
            }
            entry.objectId = objectId;
            this.putMapEntry(localId, entry);
        }
    }

    synchronized boolean clear() throws IOException {
        String[] files = this.diskPath.list();
        if (files == null) {
            return false;
        }
        if (files.length == 0) {
            return false;
        }
        for (String fileName : files) {
            File file = new File(this.diskPath, fileName);
            if (file.delete()) continue;
            throw new IOException("Unable to delete file " + fileName + " in localId cache.");
        }
        return true;
    }

    private static class MapEntry {
        String objectId;
        int retainCount;

        private MapEntry() {
        }
    }
}

