/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.SystemClock;
import bolts.Continuation;
import bolts.Task;
import com.parse.ManifestInfo;
import com.parse.PLog;
import com.parse.Parse;
import com.parse.ParseFileUtils;
import com.parse.ParseInstallation;
import com.parse.PushType;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;

class GcmRegistrar {
    private static final String TAG = "com.parse.GcmRegistrar";
    private static final String REGISTRATION_ID_EXTRA = "registration_id";
    private static final String ERROR_EXTRA = "error";
    private static final String PARSE_SENDER_ID = "1076345567071";
    private static final String SENDER_ID_EXTRA = "com.parse.push.gcm_sender_id";
    public static final String REGISTER_ACTION = "com.google.android.c2dm.intent.REGISTER";
    public static final String REGISTER_RESPONSE_ACTION = "com.google.android.c2dm.intent.REGISTRATION";
    private static final String FILENAME_DEVICE_TOKEN_LAST_MODIFIED = "deviceTokenLastModified";
    private long localDeviceTokenLastModified;
    private final Object localDeviceTokenLastModifiedMutex = new Object();
    private final Object lock = new Object();
    private Request request = null;
    private Context context = null;

    public static GcmRegistrar getInstance() {
        return Singleton.INSTANCE;
    }

    private static String actualSenderIDFromExtra(Object senderIDExtra) {
        if (!(senderIDExtra instanceof String)) {
            return null;
        }
        String senderID = (String)senderIDExtra;
        if (!senderID.startsWith("id:")) {
            return null;
        }
        return senderID.substring(3);
    }

    GcmRegistrar(Context context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<Void> registerAsync() {
        if (ManifestInfo.getPushType() != PushType.GCM) {
            return Task.forResult(null);
        }
        Object object = this.lock;
        synchronized (object) {
            final ParseInstallation installation = ParseInstallation.getCurrentInstallation();
            Task checkTask = installation.getDeviceToken() == null ? Task.forResult((Object)true) : this.isLocalDeviceTokenStaleAsync();
            return checkTask.onSuccessTask((Continuation)new Continuation<Boolean, Task<Void>>(){

                public Task<Void> then(Task<Boolean> task) throws Exception {
                    Task<Void> saveTask;
                    if (!((Boolean)task.getResult()).booleanValue()) {
                        return Task.forResult(null);
                    }
                    if (installation.getPushType() != PushType.GCM) {
                        installation.setPushType(PushType.GCM);
                        saveTask = installation.saveInBackground();
                    } else {
                        saveTask = Task.forResult(null);
                    }
                    GcmRegistrar.this.sendRegistrationRequestAsync();
                    return saveTask;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Task<Void> sendRegistrationRequestAsync() {
        Object object = this.lock;
        synchronized (object) {
            Object senderIDExtra;
            if (this.request != null) {
                return Task.forResult(null);
            }
            Bundle metaData = ManifestInfo.getApplicationMetadata(this.context);
            String senderIDs = PARSE_SENDER_ID;
            if (metaData != null && (senderIDExtra = metaData.get(SENDER_ID_EXTRA)) != null) {
                String senderID = GcmRegistrar.actualSenderIDFromExtra(senderIDExtra);
                if (senderID != null) {
                    senderIDs = senderIDs + "," + senderID;
                } else {
                    PLog.e(TAG, "Found com.parse.push.gcm_sender_id <meta-data> element with value \"" + senderIDExtra.toString() + "\", but the value is missing the expected \"id:\" " + "prefix.");
                }
            }
            this.request = Request.createAndSend(this.context, senderIDs);
            return this.request.getTask().continueWith((Continuation)new Continuation<String, Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void then(Task<String> task) {
                    Exception e = task.getError();
                    if (e != null) {
                        PLog.e(GcmRegistrar.TAG, "Got error when trying to register for GCM push", e);
                    }
                    Object object = GcmRegistrar.this.lock;
                    synchronized (object) {
                        GcmRegistrar.this.request = null;
                    }
                    return null;
                }
            });
        }
    }

    public boolean isRegistrationIntent(Intent intent) {
        return intent != null && REGISTER_RESPONSE_ACTION.equals(intent.getAction());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<Void> handleRegistrationIntentAsync(Intent intent) {
        if (!this.isRegistrationIntent(intent)) {
            return Task.forResult(null);
        }
        ArrayList<Task<Void>> tasks = new ArrayList<Task<Void>>();
        String registrationId = intent.getStringExtra(REGISTRATION_ID_EXTRA);
        if (registrationId != null && registrationId.length() > 0) {
            ParseInstallation installation = ParseInstallation.getCurrentInstallation();
            if (!registrationId.equals(installation.getDeviceToken())) {
                installation.setPushType(PushType.GCM);
                installation.setDeviceToken(registrationId);
                tasks.add(installation.saveInBackground());
            }
            tasks.add(this.updateLocalDeviceTokenLastModifiedAsync());
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.request != null) {
                this.request.onReceiveResponseIntent(intent);
            }
        }
        return Task.whenAll(tasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getRequestIdentifier() {
        Object object = this.lock;
        synchronized (object) {
            return this.request != null ? this.request.identifier : 0;
        }
    }

    Task<Boolean> isLocalDeviceTokenStaleAsync() {
        return this.getLocalDeviceTokenLastModifiedAsync().onSuccessTask((Continuation)new Continuation<Long, Task<Boolean>>(){

            public Task<Boolean> then(Task<Long> task) throws Exception {
                long localDeviceTokenLastModified = (Long)task.getResult();
                return Task.forResult((Object)(localDeviceTokenLastModified != ManifestInfo.getLastModified() ? 1 : 0));
            }
        });
    }

    Task<Void> updateLocalDeviceTokenLastModifiedAsync() {
        return Task.call((Callable)new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                Object object = GcmRegistrar.this.localDeviceTokenLastModifiedMutex;
                synchronized (object) {
                    GcmRegistrar.this.localDeviceTokenLastModified = ManifestInfo.getLastModified();
                    String localDeviceTokenLastModifiedStr = String.valueOf(GcmRegistrar.this.localDeviceTokenLastModified);
                    try {
                        ParseFileUtils.writeStringToFile(GcmRegistrar.getLocalDeviceTokenLastModifiedFile(), localDeviceTokenLastModifiedStr, "UTF-8");
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return null;
            }
        }, (Executor)Task.BACKGROUND_EXECUTOR);
    }

    private Task<Long> getLocalDeviceTokenLastModifiedAsync() {
        return Task.call((Callable)new Callable<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Long call() throws Exception {
                Object object = GcmRegistrar.this.localDeviceTokenLastModifiedMutex;
                synchronized (object) {
                    if (GcmRegistrar.this.localDeviceTokenLastModified == 0L) {
                        try {
                            String localDeviceTokenLastModifiedStr = ParseFileUtils.readFileToString(GcmRegistrar.getLocalDeviceTokenLastModifiedFile(), "UTF-8");
                            GcmRegistrar.this.localDeviceTokenLastModified = Long.valueOf(localDeviceTokenLastModifiedStr);
                        }
                        catch (IOException e) {
                            GcmRegistrar.this.localDeviceTokenLastModified = 0L;
                        }
                    }
                    return GcmRegistrar.this.localDeviceTokenLastModified;
                }
            }
        }, (Executor)Task.BACKGROUND_EXECUTOR);
    }

    static File getLocalDeviceTokenLastModifiedFile() {
        File dir = Parse.getParseCacheDir("GCMRegistrar");
        return new File(dir, FILENAME_DEVICE_TOKEN_LAST_MODIFIED);
    }

    static void deleteLocalDeviceTokenLastModifiedFile() {
        ParseFileUtils.deleteQuietly(GcmRegistrar.getLocalDeviceTokenLastModifiedFile());
    }

    private static class Request {
        private static final String RETRY_ACTION = "com.parse.RetryGcmRegistration";
        private static final int MAX_RETRIES = 5;
        private static final int BACKOFF_INTERVAL_MS = 3000;
        private final Context context;
        private final String senderId;
        private final Random random;
        private final int identifier;
        private final Task.TaskCompletionSource tcs;
        private final PendingIntent appIntent;
        private final AtomicInteger tries;
        private final PendingIntent retryIntent;
        private final BroadcastReceiver retryReceiver;

        public static Request createAndSend(Context context, String senderId) {
            Request request = new Request(context, senderId);
            request.send();
            return request;
        }

        private Request(Context context, String senderId) {
            this.context = context;
            this.senderId = senderId;
            this.random = new Random();
            this.identifier = this.random.nextInt();
            this.tcs = Task.create();
            this.appIntent = PendingIntent.getBroadcast((Context)this.context, (int)this.identifier, (Intent)new Intent(), (int)0);
            this.tries = new AtomicInteger(0);
            String packageName = this.context.getPackageName();
            Intent intent = new Intent(RETRY_ACTION).setPackage(packageName);
            intent.addCategory(packageName);
            intent.putExtra("random", this.identifier);
            this.retryIntent = PendingIntent.getBroadcast((Context)this.context, (int)this.identifier, (Intent)intent, (int)0);
            this.retryReceiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    if (intent != null && intent.getIntExtra("random", 0) == Request.this.identifier) {
                        Request.this.send();
                    }
                }
            };
            IntentFilter filter = new IntentFilter();
            filter.addAction(RETRY_ACTION);
            filter.addCategory(packageName);
            context.registerReceiver(this.retryReceiver, filter);
        }

        public Task<String> getTask() {
            return this.tcs.getTask();
        }

        private void send() {
            Intent intent = new Intent(GcmRegistrar.REGISTER_ACTION);
            intent.setPackage("com.google.android.gsf");
            intent.putExtra("sender", this.senderId);
            intent.putExtra("app", (Parcelable)this.appIntent);
            ComponentName name = null;
            try {
                name = this.context.startService(intent);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (name == null) {
                this.finish(null, "GSF_PACKAGE_NOT_AVAILABLE");
            }
            this.tries.incrementAndGet();
            PLog.v(GcmRegistrar.TAG, "Sending GCM registration intent");
        }

        public void onReceiveResponseIntent(Intent intent) {
            String registrationId = intent.getStringExtra(GcmRegistrar.REGISTRATION_ID_EXTRA);
            String error = intent.getStringExtra(GcmRegistrar.ERROR_EXTRA);
            if (registrationId == null && error == null) {
                PLog.e(GcmRegistrar.TAG, "Got no registration info in GCM onReceiveResponseIntent");
                return;
            }
            if ("SERVICE_NOT_AVAILABLE".equals(error) && this.tries.get() < 5) {
                AlarmManager manager = (AlarmManager)this.context.getSystemService("alarm");
                int alarmType = 2;
                long delay = (1 << this.tries.get()) * 3000 + this.random.nextInt(3000);
                long start = SystemClock.elapsedRealtime() + delay;
                manager.set(alarmType, start, this.retryIntent);
            } else {
                this.finish(registrationId, error);
            }
        }

        private void finish(String registrationId, String error) {
            boolean didSetResult = registrationId != null ? this.tcs.trySetResult((Object)registrationId) : this.tcs.trySetError(new Exception("GCM registration error: " + error));
            if (didSetResult) {
                this.appIntent.cancel();
                this.retryIntent.cancel();
                this.context.unregisterReceiver(this.retryReceiver);
            }
        }
    }

    private static class Singleton {
        public static final GcmRegistrar INSTANCE = new GcmRegistrar(Parse.getApplicationContext());

        private Singleton() {
        }
    }
}

