/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.map;

import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.View;
import com.baidu.mapapi.map.BitmapDescriptor;
import com.baidu.mapapi.map.BitmapDescriptorFactory;
import com.baidu.mapapi.map.HeatMap;
import com.baidu.mapapi.map.InfoWindow;
import com.baidu.mapapi.map.MapPoi;
import com.baidu.mapapi.map.MapStatus;
import com.baidu.mapapi.map.MapStatusUpdate;
import com.baidu.mapapi.map.MapStatusUpdateFactory;
import com.baidu.mapapi.map.MapView;
import com.baidu.mapapi.map.MapViewLayoutParams;
import com.baidu.mapapi.map.Marker;
import com.baidu.mapapi.map.MarkerOptions;
import com.baidu.mapapi.map.MyLocationConfiguration;
import com.baidu.mapapi.map.MyLocationData;
import com.baidu.mapapi.map.Overlay;
import com.baidu.mapapi.map.OverlayOptions;
import com.baidu.mapapi.map.Projection;
import com.baidu.mapapi.map.UiSettings;
import com.baidu.mapapi.map.a;
import com.baidu.mapapi.map.b;
import com.baidu.mapapi.map.c;
import com.baidu.mapapi.model.LatLng;
import com.baidu.platform.comapi.map.e;
import com.baidu.platform.comapi.map.f;
import com.baidu.platform.comapi.map.z;
import com.baidu.platform.comjni.tools.ParcelItem;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.microedition.khronos.opengles.GL10;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BaiduMap {
    public static final int MAP_TYPE_NORMAL = 1;
    public static final int MAP_TYPE_SATELLITE = 2;
    private static final String b = BaiduMap.class.getSimpleName();
    private Projection c;
    private UiSettings d;
    private f e;
    private List<Overlay> f;
    private Overlay.a g;
    private OnMapStatusChangeListener h;
    private OnMapClickListener i;
    private OnMapLoadedCallback j;
    private OnMapDoubleClickListener k;
    private OnMapLongClickListener l;
    private OnMarkerClickListener m;
    private OnMarkerDragListener n;
    private OnMyLocationClickListener o;
    private SnapshotReadyCallback p;
    private OnMapDrawFrameCallback q;
    private HeatMap r;
    private Lock s = new ReentrantLock();
    private InfoWindow t;
    private Marker u;
    private View v;
    private Marker w;
    private MyLocationData x;
    private MyLocationConfiguration y;
    MapView a;
    private boolean z;

    BaiduMap(f f2) {
        this.e = f2;
        this.d = new UiSettings(this.e);
        this.f = new LinkedList<Overlay>();
        this.g = new a(this);
        b b2 = new b(this);
        this.e.a(b2);
        c c2 = new c(this);
        this.e.a(c2);
    }

    public final Overlay addOverlay(OverlayOptions overlayOptions) {
        Overlay overlay = overlayOptions.a();
        overlay.listener = this.g;
        Bundle bundle = new Bundle();
        overlay.a(bundle);
        this.e.a(bundle);
        this.f.add(overlay);
        return overlay;
    }

    public final void clear() {
        this.f.clear();
        this.e.r();
        this.hideInfoWindow();
    }

    public final void setMapStatus(MapStatusUpdate mapStatusUpdate) {
        if (mapStatusUpdate == null) {
            return;
        }
        z z2 = this.a(mapStatusUpdate);
        this.e.a(z2);
        if (this.h != null) {
            this.h.onMapStatusChange(this.getMapStatus());
        }
    }

    public final MapStatus getMapStatus() {
        z z2 = this.e.o();
        return MapStatus.a(z2);
    }

    public final void animateMapStatus(MapStatusUpdate mapStatusUpdate, int n2) {
        if (mapStatusUpdate == null || n2 <= 0) {
            return;
        }
        z z2 = this.a(mapStatusUpdate);
        if (!this.z) {
            this.e.a(z2);
        } else {
            this.e.a(z2, n2);
        }
    }

    public final void animateMapStatus(MapStatusUpdate mapStatusUpdate) {
        this.animateMapStatus(mapStatusUpdate, 300);
    }

    private z a(MapStatusUpdate mapStatusUpdate) {
        z z2 = this.e.o();
        MapStatus mapStatus = mapStatusUpdate.a(this.e, this.getMapStatus());
        z z3 = mapStatus.b(z2);
        return z3;
    }

    public final void setMapType(int n2) {
        if (n2 == 1) {
            this.e.c(false);
        } else if (n2 == 2) {
            this.e.c(true);
        }
    }

    public final int getMapType() {
        return this.e.e() ? 2 : 1;
    }

    public final float getMaxZoomLevel() {
        return this.e.a;
    }

    public final void setMaxAndMinZoomLevel(float f2, float f3) {
        if (f2 > 19.0f) {
            return;
        }
        if (f3 < 3.0f) {
            return;
        }
        if (f2 < f3) {
            return;
        }
        this.e.a = f2;
        this.e.b = f3;
    }

    public final float getMinZoomLevel() {
        return this.e.b;
    }

    public final Projection getProjection() {
        return this.c;
    }

    public final UiSettings getUiSettings() {
        return this.d;
    }

    public final void setBuildingsEnabled(boolean bl) {
        this.e.d(bl);
    }

    public final boolean isBuildingsEnabled() {
        return this.e.f();
    }

    public final void setMyLocationEnabled(boolean bl) {
        this.e.f(bl);
    }

    public final boolean isMyLocationEnabled() {
        return this.e.h();
    }

    public final void setMyLocationData(MyLocationData myLocationData) {
        this.x = myLocationData;
        if (this.y == null) {
            this.y = new MyLocationConfiguration(MyLocationConfiguration.LocationMode.NORMAL, false, null);
        }
        this.a(myLocationData, this.y);
    }

    public final MyLocationData getLocationData() {
        return this.x;
    }

    public final void setMyLocationConfigeration(MyLocationConfiguration myLocationConfiguration) {
        this.y = myLocationConfiguration;
        this.a(this.x, this.y);
    }

    public final MyLocationConfiguration getLocationConfigeration() {
        return this.y;
    }

    private final void a(MyLocationData myLocationData, MyLocationConfiguration myLocationConfiguration) {
        Object object;
        Bundle bundle;
        if (myLocationData == null || myLocationConfiguration == null || !this.isMyLocationEnabled()) {
            return;
        }
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        JSONObject jSONObject2 = new JSONObject();
        JSONObject jSONObject3 = new JSONObject();
        LatLng latLng = new LatLng(myLocationData.latitude, myLocationData.longitude);
        com.baidu.platform.comapi.a.b b2 = com.baidu.mapapi.model.a.a(latLng);
        try {
            jSONObject.put("type", 0);
            jSONObject2.put("ptx", b2.b());
            jSONObject2.put("pty", b2.a());
            float f2 = com.baidu.mapapi.model.a.a(latLng, (int)myLocationData.accuracy);
            jSONObject2.put("radius", (double)f2);
            float f3 = myLocationData.direction;
            if (myLocationConfiguration.enableDirection) {
                f3 = myLocationData.direction % 360.0f;
                if (f3 > 180.0f) {
                    f3 -= 360.0f;
                } else if (f3 < -180.0f) {
                    f3 += 360.0f;
                }
            } else {
                f3 = -1.0f;
            }
            jSONObject2.put("direction", (double)f3);
            jSONObject2.put("iconarrownor", (Object)"NormalLocArrow");
            jSONObject2.put("iconarrownorid", 28);
            jSONObject2.put("iconarrowfoc", (Object)"FocusLocArrow");
            jSONObject2.put("iconarrowfocid", 29);
            jSONArray.put((Object)jSONObject2);
            jSONObject.put("data", (Object)jSONArray);
            if (myLocationConfiguration.locationMode == MyLocationConfiguration.LocationMode.COMPASS) {
                jSONObject3.put("ptx", b2.b());
                jSONObject3.put("pty", b2.a());
                jSONObject3.put("radius", 0);
                jSONObject3.put("direction", 0);
                jSONObject3.put("iconarrownor", (Object)"direction_wheel");
                jSONObject3.put("iconarrownorid", 54);
                jSONObject3.put("iconarrowfoc", (Object)"direction_wheel");
                jSONObject3.put("iconarrowfocid", 54);
                jSONArray.put((Object)jSONObject3);
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        if (myLocationConfiguration.customMarker == null) {
            bundle = null;
        } else {
            ArrayList<BitmapDescriptor> arrayList = new ArrayList<BitmapDescriptor>();
            arrayList.add(myLocationConfiguration.customMarker);
            bundle = new Bundle();
            object = new ArrayList();
            for (BitmapDescriptor bitmapDescriptor : arrayList) {
                ParcelItem parcelItem = new ParcelItem();
                Bundle bundle2 = new Bundle();
                Bitmap bitmap = bitmapDescriptor.a;
                ByteBuffer byteBuffer = ByteBuffer.allocate(bitmap.getWidth() * bitmap.getHeight() * 4);
                bitmap.copyPixelsToBuffer((Buffer)byteBuffer);
                byte[] byArray = byteBuffer.array();
                bundle2.putByteArray("imgdata", byArray);
                bundle2.putInt("imgindex", bitmapDescriptor.hashCode());
                bundle2.putInt("imgH", bitmap.getHeight());
                bundle2.putInt("imgW", bitmap.getWidth());
                parcelItem.setBundle(bundle2);
                ((ArrayList)object).add(parcelItem);
            }
            if (((ArrayList)object).size() > 0) {
                Parcelable[] parcelableArray = new ParcelItem[((ArrayList)object).size()];
                for (int i2 = 0; i2 < ((ArrayList)object).size(); ++i2) {
                    parcelableArray[i2] = (ParcelItem)((ArrayList)object).get(i2);
                }
                bundle.putParcelableArray("icondata", parcelableArray);
            }
        }
        this.e.a(jSONObject.toString(), bundle);
        switch (myLocationConfiguration.locationMode) {
            case COMPASS: {
                MapStatus mapStatus = new MapStatus.Builder().rotate(myLocationData.direction).overlook(-45.0f).target(new LatLng(myLocationData.latitude, myLocationData.longitude)).targetScreen(this.getMapStatus().targetScreen).zoom(this.getMapStatus().zoom).build();
                object = MapStatusUpdateFactory.newMapStatus(mapStatus);
                this.animateMapStatus((MapStatusUpdate)object);
                break;
            }
            case FOLLOWING: {
                MapStatus mapStatus = new MapStatus.Builder().target(new LatLng(myLocationData.latitude, myLocationData.longitude)).zoom(this.getMapStatus().zoom).rotate(this.getMapStatus().rotate).overlook(this.getMapStatus().overlook).targetScreen(this.getMapStatus().targetScreen).build();
                object = MapStatusUpdateFactory.newMapStatus(mapStatus);
                this.animateMapStatus((MapStatusUpdate)object);
                break;
            }
            case NORMAL: {
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHeatMap(HeatMap heatMap) {
        if (heatMap == null) {
            return;
        }
        this.s.lock();
        try {
            if (heatMap == this.r) {
                return;
            }
            if (this.r != null) {
                this.r.b();
                this.r.c();
                this.r.a = null;
                this.e.s();
            }
            this.r = heatMap;
            this.r.a = this;
            this.e.g(true);
        }
        finally {
            this.s.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void a(HeatMap heatMap) {
        this.s.lock();
        try {
            if (this.r != null && heatMap == this.r) {
                this.r.b();
                this.r.c();
                this.r.a = null;
                this.e.s();
                this.r = null;
                this.e.g(false);
            }
        }
        finally {
            this.s.unlock();
        }
    }

    void a() {
        this.e.i();
    }

    public final void setBaiduHeatMapEnabled(boolean bl) {
        this.e.a(bl);
    }

    public final boolean isBaiduHeatMapEnabled() {
        return this.e.c();
    }

    public final boolean isSupportBaiduHeatMap() {
        return this.e.d();
    }

    public final void setTrafficEnabled(boolean bl) {
        this.e.b(bl);
    }

    public final boolean isTrafficEnabled() {
        return this.e.b();
    }

    public final void snapshot(SnapshotReadyCallback snapshotReadyCallback) {
        this.p = snapshotReadyCallback;
        this.e.a("anything");
    }

    public void showInfoWindow(InfoWindow infoWindow) {
        if (infoWindow != null) {
            this.hideInfoWindow();
            this.t = infoWindow;
            BitmapDescriptor bitmapDescriptor = infoWindow.b != null ? BitmapDescriptorFactory.fromView(infoWindow.b) : infoWindow.a;
            MarkerOptions markerOptions = new MarkerOptions().perspective(false).icon(bitmapDescriptor).position(infoWindow.c).zIndex(Integer.MAX_VALUE).a(infoWindow.e);
            Overlay overlay = markerOptions.a();
            overlay.listener = this.g;
            overlay.k = com.baidu.platform.comapi.map.e.b;
            Bundle bundle = new Bundle();
            overlay.a(bundle);
            this.e.a(bundle);
            this.f.add(overlay);
            this.u = (Marker)overlay;
            if (infoWindow.b != null) {
                this.v = infoWindow.b;
                this.v.destroyDrawingCache();
                MapViewLayoutParams.Builder builder = new MapViewLayoutParams.Builder();
                MapViewLayoutParams mapViewLayoutParams = builder.layoutMode(MapViewLayoutParams.ELayoutMode.mapMode).position(infoWindow.c).yOffset(infoWindow.e).build();
                this.a.addView(this.v, mapViewLayoutParams);
            }
        }
    }

    public void hideInfoWindow() {
        if (this.t != null) {
            if (this.t.b != null) {
                this.a.removeView(this.v);
                this.v = null;
            }
            this.t = null;
            this.u.remove();
            this.u = null;
        }
    }

    public final void setOnMapStatusChangeListener(OnMapStatusChangeListener onMapStatusChangeListener) {
        this.h = onMapStatusChangeListener;
    }

    public final void setOnMapClickListener(OnMapClickListener onMapClickListener) {
        this.i = onMapClickListener;
    }

    public void setOnMapLoadedCallback(OnMapLoadedCallback onMapLoadedCallback) {
        this.j = onMapLoadedCallback;
    }

    public final void setOnMapDoubleClickListener(OnMapDoubleClickListener onMapDoubleClickListener) {
        this.k = onMapDoubleClickListener;
    }

    public final void setOnMapLongClickListener(OnMapLongClickListener onMapLongClickListener) {
        this.l = onMapLongClickListener;
    }

    public final void setOnMarkerClickListener(OnMarkerClickListener onMarkerClickListener) {
        this.m = onMarkerClickListener;
    }

    public final void setOnMarkerDragListener(OnMarkerDragListener onMarkerDragListener) {
        this.n = onMarkerDragListener;
    }

    public final void setOnMyLocationClickListener(OnMyLocationClickListener onMyLocationClickListener) {
        this.o = onMyLocationClickListener;
    }

    public final void setOnMapDrawFrameCallback(OnMapDrawFrameCallback onMapDrawFrameCallback) {
        this.q = onMapDrawFrameCallback;
    }

    static /* synthetic */ List a(BaiduMap baiduMap) {
        return baiduMap.f;
    }

    static /* synthetic */ f b(BaiduMap baiduMap) {
        return baiduMap.e;
    }

    static /* synthetic */ View c(BaiduMap baiduMap) {
        return baiduMap.v;
    }

    static /* synthetic */ OnMapStatusChangeListener d(BaiduMap baiduMap) {
        return baiduMap.h;
    }

    static /* synthetic */ OnMapClickListener e(BaiduMap baiduMap) {
        return baiduMap.i;
    }

    static /* synthetic */ OnMapDoubleClickListener f(BaiduMap baiduMap) {
        return baiduMap.k;
    }

    static /* synthetic */ OnMapLongClickListener g(BaiduMap baiduMap) {
        return baiduMap.l;
    }

    static /* synthetic */ Projection a(BaiduMap baiduMap, Projection projection) {
        baiduMap.c = projection;
        return baiduMap.c;
    }

    static /* synthetic */ boolean a(BaiduMap baiduMap, boolean bl) {
        baiduMap.z = bl;
        return baiduMap.z;
    }

    static /* synthetic */ OnMapLoadedCallback h(BaiduMap baiduMap) {
        return baiduMap.j;
    }

    static /* synthetic */ SnapshotReadyCallback i(BaiduMap baiduMap) {
        return baiduMap.p;
    }

    static /* synthetic */ OnMyLocationClickListener j(BaiduMap baiduMap) {
        return baiduMap.o;
    }

    static /* synthetic */ InfoWindow k(BaiduMap baiduMap) {
        return baiduMap.t;
    }

    static /* synthetic */ Marker l(BaiduMap baiduMap) {
        return baiduMap.u;
    }

    static /* synthetic */ OnMarkerClickListener m(BaiduMap baiduMap) {
        return baiduMap.m;
    }

    static /* synthetic */ Marker n(BaiduMap baiduMap) {
        return baiduMap.w;
    }

    static /* synthetic */ Projection o(BaiduMap baiduMap) {
        return baiduMap.c;
    }

    static /* synthetic */ OnMarkerDragListener p(BaiduMap baiduMap) {
        return baiduMap.n;
    }

    static /* synthetic */ Marker a(BaiduMap baiduMap, Marker marker) {
        baiduMap.w = marker;
        return baiduMap.w;
    }

    static /* synthetic */ Lock q(BaiduMap baiduMap) {
        return baiduMap.s;
    }

    static /* synthetic */ HeatMap r(BaiduMap baiduMap) {
        return baiduMap.r;
    }

    static /* synthetic */ OnMapDrawFrameCallback s(BaiduMap baiduMap) {
        return baiduMap.q;
    }

    public static interface OnMapDrawFrameCallback {
        public void onMapDrawFrame(GL10 var1, MapStatus var2);
    }

    public static interface SnapshotReadyCallback {
        public void onSnapshotReady(Bitmap var1);
    }

    public static interface OnMyLocationClickListener {
        public boolean onMyLocationClick();
    }

    public static interface OnMarkerDragListener {
        public void onMarkerDrag(Marker var1);

        public void onMarkerDragEnd(Marker var1);

        public void onMarkerDragStart(Marker var1);
    }

    public static interface OnMarkerClickListener {
        public boolean onMarkerClick(Marker var1);
    }

    public static interface OnMapLongClickListener {
        public void onMapLongClick(LatLng var1);
    }

    public static interface OnMapDoubleClickListener {
        public void onMapDoubleClick(LatLng var1);
    }

    public static interface OnMapLoadedCallback {
        public void onMapLoaded();
    }

    public static interface OnMapClickListener {
        public void onMapClick(LatLng var1);

        public boolean onMapPoiClick(MapPoi var1);
    }

    public static interface OnMapStatusChangeListener {
        public void onMapStatusChangeStart(MapStatus var1);

        public void onMapStatusChange(MapStatus var1);

        public void onMapStatusChangeFinish(MapStatus var1);
    }
}

