/*
 * Decompiled with CFR 0.152.
 */
package com.thirdparty.bumptech.glide.util;

import java.util.LinkedHashMap;
import java.util.Map;

public class LruCache<T, Y> {
    private final LinkedHashMap<T, Y> cache = new LinkedHashMap(100, 0.75f, true);
    private int maxSize;
    private final int initialMaxSize;
    private int currentSize = 0;

    /*
     * WARNING - void declaration
     */
    public LruCache(int size) {
        void var1_1;
        this.initialMaxSize = size;
        this.maxSize = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setSizeMultiplier(float multiplier) {
        void var1_1;
        if (multiplier < 0.0f) {
            throw new IllegalArgumentException("Multiplier must be >= 0");
        }
        this.maxSize = Math.round((float)this.initialMaxSize * var1_1);
        this.evict();
    }

    protected int getSize(Y y2) {
        return 1;
    }

    protected void onItemEvicted(T t2, Y y2) {
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getCurrentSize() {
        return this.currentSize;
    }

    /*
     * WARNING - void declaration
     */
    public boolean contains(T key) {
        void var1_1;
        return this.cache.containsKey(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Y get(T key) {
        void var1_1;
        return this.cache.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Y put(T key, Y item) {
        Y y2;
        if (this.getSize(item) >= this.maxSize) {
            this.onItemEvicted(key, item);
            return null;
        }
        y2 = this.cache.put(y2, item);
        if (item != null) {
            void var2_2;
            this.currentSize += this.getSize(var2_2);
        }
        if (y2 != null) {
            this.currentSize -= this.getSize(y2);
        }
        this.evict();
        return y2;
    }

    public Y remove(T key) {
        Object v2;
        if ((v2 = this.cache.remove(v2)) != null) {
            this.currentSize -= this.getSize(v2);
        }
        return (Y)v2;
    }

    public void clearMemory() {
        this.trimToSize(0);
    }

    protected void trimToSize(int size) {
        while (this.currentSize > size) {
            Map.Entry<Object, Object> entry = this.cache.entrySet().iterator().next();
            Y y2 = entry.getValue();
            this.currentSize -= this.getSize(y2);
            entry = entry.getKey();
            this.cache.remove(entry);
            this.onItemEvicted(entry, y2);
        }
    }

    private void evict() {
        this.trimToSize(this.maxSize);
    }
}

