/*
 * Decompiled with CFR 0.152.
 */
package com.thirdparty.bumptech.glide.request;

import android.graphics.drawable.Drawable;
import android.os.Handler;
import com.thirdparty.bumptech.glide.request.FutureTarget;
import com.thirdparty.bumptech.glide.request.Request;
import com.thirdparty.bumptech.glide.request.RequestFutureTarget$Waiter;
import com.thirdparty.bumptech.glide.request.animation.GlideAnimation;
import com.thirdparty.bumptech.glide.request.target.SizeReadyCallback;
import com.thirdparty.bumptech.glide.util.Util;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class RequestFutureTarget<T, R>
implements FutureTarget<R>,
Runnable {
    private static final RequestFutureTarget$Waiter DEFAULT_WAITER = new RequestFutureTarget$Waiter();
    private final Handler mainHandler;
    private final int width;
    private final int height;
    private final boolean assertBackgroundThread;
    private final RequestFutureTarget$Waiter waiter;
    private R resource;
    private Request request;
    private boolean isCancelled;
    private Exception exception;
    private boolean resultReceived;
    private boolean exceptionReceived;

    /*
     * WARNING - void declaration
     */
    public RequestFutureTarget(Handler mainHandler, int width, int height) {
        this((Handler)var1_1, (int)var2_2, (int)var3_3, true, DEFAULT_WAITER);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    RequestFutureTarget(Handler mainHandler, int width, int height, boolean assertBackgroundThread, RequestFutureTarget$Waiter waiter) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.mainHandler = var1_1;
        this.width = var2_2;
        this.height = var3_3;
        this.assertBackgroundThread = assertBackgroundThread;
        this.waiter = waiter;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized boolean cancel(boolean mayInterruptIfRunning) {
        if (this.isCancelled) {
            return true;
        }
        boolean bl = !this.isDone();
        if (bl) {
            void var1_1;
            this.isCancelled = true;
            if (var1_1 != false) {
                this.clear();
            }
            this.waiter.notifyAll(this);
        }
        return bl;
    }

    @Override
    public synchronized boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public synchronized boolean isDone() {
        return this.isCancelled || this.resultReceived;
    }

    @Override
    public R get() {
        try {
            return this.doGet(null);
        }
        catch (TimeoutException timeoutException) {
            throw new AssertionError((Object)timeoutException);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public R get(long time, TimeUnit timeUnit) {
        void var1_1;
        void var3_2;
        return this.doGet(var3_2.toMillis((long)var1_1));
    }

    @Override
    public void getSize(SizeReadyCallback cb) {
        cb.onSizeReady(this.width, this.height);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setRequest(Request request) {
        void var1_1;
        this.request = var1_1;
    }

    @Override
    public Request getRequest() {
        return this.request;
    }

    @Override
    public void onLoadCleared(Drawable drawable) {
    }

    @Override
    public void onLoadStarted(Drawable drawable) {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void onLoadFailed(Exception e2, Drawable drawable) {
        void var1_1;
        this.exceptionReceived = true;
        this.exception = var1_1;
        this.waiter.notifyAll(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void onResourceReady(R resource, GlideAnimation<? super R> glideAnimation) {
        void var1_1;
        this.resultReceived = true;
        this.resource = var1_1;
        this.waiter.notifyAll(this);
    }

    /*
     * WARNING - void declaration
     */
    private synchronized R doGet(Long timeoutMillis) {
        if (this.assertBackgroundThread) {
            Util.assertBackgroundThread();
        }
        if (this.isCancelled) {
            throw new CancellationException();
        }
        if (this.exceptionReceived) {
            throw new ExecutionException(this.exception);
        }
        if (this.resultReceived) {
            return this.resource;
        }
        if (timeoutMillis == null) {
            this.waiter.waitForTimeout(this, 0L);
        } else if (timeoutMillis > 0L) {
            void var1_1;
            this.waiter.waitForTimeout(this, var1_1.longValue());
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (this.exceptionReceived) {
            throw new ExecutionException(this.exception);
        }
        if (this.isCancelled) {
            throw new CancellationException();
        }
        if (!this.resultReceived) {
            throw new TimeoutException();
        }
        return this.resource;
    }

    @Override
    public void run() {
        if (this.request != null) {
            this.request.clear();
            this.cancel(false);
        }
    }

    @Override
    public void clear() {
        this.mainHandler.post((Runnable)this);
    }

    @Override
    public void onStart() {
    }

    @Override
    public void onStop() {
    }

    @Override
    public void onDestroy() {
    }
}

