/*
 * Decompiled with CFR 0.152.
 */
package com.thirdparty.bumptech.glide.request;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.Log;
import com.thirdparty.bumptech.glide.Priority;
import com.thirdparty.bumptech.glide.load.Key;
import com.thirdparty.bumptech.glide.load.Transformation;
import com.thirdparty.bumptech.glide.load.data.DataFetcher;
import com.thirdparty.bumptech.glide.load.engine.DiskCacheStrategy;
import com.thirdparty.bumptech.glide.load.engine.Engine;
import com.thirdparty.bumptech.glide.load.engine.Engine$LoadStatus;
import com.thirdparty.bumptech.glide.load.engine.Resource;
import com.thirdparty.bumptech.glide.load.resource.transcode.ResourceTranscoder;
import com.thirdparty.bumptech.glide.provider.LoadProvider;
import com.thirdparty.bumptech.glide.request.GenericRequest$Status;
import com.thirdparty.bumptech.glide.request.Request;
import com.thirdparty.bumptech.glide.request.RequestCoordinator;
import com.thirdparty.bumptech.glide.request.RequestListener;
import com.thirdparty.bumptech.glide.request.ResourceCallback;
import com.thirdparty.bumptech.glide.request.animation.GlideAnimation;
import com.thirdparty.bumptech.glide.request.animation.GlideAnimationFactory;
import com.thirdparty.bumptech.glide.request.target.SizeReadyCallback;
import com.thirdparty.bumptech.glide.request.target.Target;
import com.thirdparty.bumptech.glide.util.LogTime;
import com.thirdparty.bumptech.glide.util.Util;
import java.util.Queue;

public final class GenericRequest<A, T, Z, R>
implements Request,
ResourceCallback,
SizeReadyCallback {
    private static final String TAG = "GenericRequest";
    private static final Queue<GenericRequest<?, ?, ?, ?>> REQUEST_POOL = Util.createQueue(0);
    private static final double TO_MEGABYTE = 9.5367431640625E-7;
    private final String tag = String.valueOf(this.hashCode());
    private Key signature;
    private Drawable fallbackDrawable;
    private int fallbackResourceId;
    private int placeholderResourceId;
    private int errorResourceId;
    private Context context;
    private Transformation<Z> transformation;
    private LoadProvider<A, T, Z, R> loadProvider;
    private RequestCoordinator requestCoordinator;
    private A model;
    private Class<R> transcodeClass;
    private boolean isMemoryCacheable;
    private Priority priority;
    private Target<R> target;
    private RequestListener<? super A, R> requestListener;
    private float sizeMultiplier;
    private Engine engine;
    private GlideAnimationFactory<R> animationFactory;
    private int overrideWidth;
    private int overrideHeight;
    private DiskCacheStrategy diskCacheStrategy;
    private Drawable placeholderDrawable;
    private Drawable errorDrawable;
    private boolean loadedFromMemoryCache;
    private Resource<?> resource;
    private Engine$LoadStatus loadStatus;
    private long startTime;
    private GenericRequest$Status status;

    /*
     * WARNING - void declaration
     */
    public static <A, T, Z, R> GenericRequest<A, T, Z, R> obtain(LoadProvider<A, T, Z, R> loadProvider, A model, Key signature, Context context, Priority priority, Target<R> target, float sizeMultiplier, Drawable placeholderDrawable, int placeholderResourceId, Drawable errorDrawable, int errorResourceId, Drawable fallbackDrawable, int fallbackResourceId, RequestListener<? super A, R> requestListener, RequestCoordinator requestCoordinator, Engine engine, Transformation<Z> transformation, Class<R> transcodeClass, boolean isMemoryCacheable, GlideAnimationFactory<R> animationFactory, int overrideWidth, int overrideHeight, DiskCacheStrategy diskCacheStrategy) {
        void var3_3;
        void var2_2;
        void var1_1;
        LoadProvider<A, T, Z, R> loadProvider2;
        GenericRequest<Object, Object, Object, Object> genericRequest = REQUEST_POOL.poll();
        if (genericRequest == null) {
            genericRequest = new GenericRequest<A, T, Z, R>();
        }
        super.init(loadProvider2, var1_1, (Key)var2_2, (Context)var3_3, priority, target, sizeMultiplier, placeholderDrawable, placeholderResourceId, errorDrawable, errorResourceId, fallbackDrawable, fallbackResourceId, requestListener, requestCoordinator, engine, transformation, transcodeClass, isMemoryCacheable, animationFactory, overrideWidth, overrideHeight, diskCacheStrategy);
        return genericRequest;
    }

    private GenericRequest() {
    }

    @Override
    public final void recycle() {
        this.loadProvider = null;
        this.model = null;
        this.context = null;
        this.target = null;
        this.placeholderDrawable = null;
        this.errorDrawable = null;
        this.fallbackDrawable = null;
        this.requestListener = null;
        this.requestCoordinator = null;
        this.transformation = null;
        this.animationFactory = null;
        this.loadedFromMemoryCache = false;
        this.loadStatus = null;
        REQUEST_POOL.offer(this);
    }

    /*
     * WARNING - void declaration
     */
    private void init(LoadProvider<A, T, Z, R> loadProvider, A model, Key signature, Context context, Priority priority, Target<R> target, float sizeMultiplier, Drawable placeholderDrawable, int placeholderResourceId, Drawable errorDrawable, int errorResourceId, Drawable fallbackDrawable, int fallbackResourceId, RequestListener<? super A, R> requestListener, RequestCoordinator requestCoordinator, Engine engine, Transformation<Z> transformation, Class<R> transcodeClass, boolean isMemoryCacheable, GlideAnimationFactory<R> animationFactory, int overrideWidth, int overrideHeight, DiskCacheStrategy diskCacheStrategy) {
        void var2_2;
        void var3_3;
        this.loadProvider = loadProvider;
        this.model = model;
        this.signature = var3_3;
        this.fallbackDrawable = fallbackDrawable;
        this.fallbackResourceId = fallbackResourceId;
        this.context = context.getApplicationContext();
        this.priority = priority;
        this.target = target;
        this.sizeMultiplier = sizeMultiplier;
        this.placeholderDrawable = placeholderDrawable;
        this.placeholderResourceId = placeholderResourceId;
        this.errorDrawable = errorDrawable;
        this.errorResourceId = errorResourceId;
        this.requestListener = requestListener;
        this.requestCoordinator = requestCoordinator;
        this.engine = engine;
        this.transformation = transformation;
        this.transcodeClass = transcodeClass;
        this.isMemoryCacheable = isMemoryCacheable;
        this.animationFactory = animationFactory;
        this.overrideWidth = overrideWidth;
        this.overrideHeight = overrideHeight;
        this.diskCacheStrategy = diskCacheStrategy;
        this.status = GenericRequest$Status.PENDING;
        if (var2_2 != null) {
            GenericRequest.check("ModelLoader", loadProvider.getModelLoader(), "try .using(ModelLoader)");
            GenericRequest.check("Transcoder", loadProvider.getTranscoder(), "try .as*(Class).transcode(ResourceTranscoder)");
            GenericRequest.check("Transformation", transformation, "try .transform(UnitTransformation.get())");
            if (diskCacheStrategy.cacheSource()) {
                GenericRequest.check("SourceEncoder", loadProvider.getSourceEncoder(), "try .sourceEncoder(Encoder) or .diskCacheStrategy(NONE/RESULT)");
            } else {
                GenericRequest.check("SourceDecoder", loadProvider.getSourceDecoder(), "try .decoder/.imageDecoder/.videoDecoder(ResourceDecoder) or .diskCacheStrategy(ALL/SOURCE)");
            }
            if (diskCacheStrategy.cacheSource() || diskCacheStrategy.cacheResult()) {
                GenericRequest.check("CacheDecoder", loadProvider.getCacheDecoder(), "try .cacheDecoder(ResouceDecoder) or .diskCacheStrategy(NONE)");
            }
            if (diskCacheStrategy.cacheResult()) {
                void var1_1;
                GenericRequest.check("Encoder", var1_1.getEncoder(), "try .encode(ResourceEncoder) or .diskCacheStrategy(NONE/SOURCE)");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void check(String name, Object object, String suggestion) {
        if (object == null) {
            CharSequence charSequence;
            charSequence = new StringBuilder((String)charSequence);
            ((StringBuilder)charSequence).append(" must not be null");
            if (suggestion != null) {
                void var2_2;
                ((StringBuilder)charSequence).append(", ");
                ((StringBuilder)charSequence).append((String)var2_2);
            }
            throw new NullPointerException(((StringBuilder)charSequence).toString());
        }
    }

    @Override
    public final void begin() {
        this.startTime = LogTime.getLogTime();
        if (this.model == null) {
            this.onException(null);
            return;
        }
        this.status = GenericRequest$Status.WAITING_FOR_SIZE;
        if (Util.isValidDimensions(this.overrideWidth, this.overrideHeight)) {
            this.onSizeReady(this.overrideWidth, this.overrideHeight);
        } else {
            this.target.getSize(this);
        }
        if (!this.isComplete() && !this.isFailed() && this.canNotifyStatusChanged()) {
            this.target.onLoadStarted(this.getPlaceholderDrawable());
        }
        if (Log.isLoggable((String)TAG, (int)2)) {
            this.logV("finished run method in " + LogTime.getElapsedMillis(this.startTime));
        }
    }

    final void cancel() {
        this.status = GenericRequest$Status.CANCELLED;
        if (this.loadStatus != null) {
            this.loadStatus.cancel();
            this.loadStatus = null;
        }
    }

    @Override
    public final void clear() {
        Util.assertMainThread();
        if (this.status == GenericRequest$Status.CLEARED) {
            return;
        }
        this.cancel();
        if (this.resource != null) {
            this.releaseResource(this.resource);
        }
        if (this.canNotifyStatusChanged()) {
            this.target.onLoadCleared(this.getPlaceholderDrawable());
        }
        this.status = GenericRequest$Status.CLEARED;
    }

    @Override
    public final boolean isPaused() {
        return this.status == GenericRequest$Status.PAUSED;
    }

    @Override
    public final void pause() {
        this.clear();
        this.status = GenericRequest$Status.PAUSED;
    }

    /*
     * WARNING - void declaration
     */
    private void releaseResource(Resource resource) {
        void var1_1;
        this.engine.release((Resource)var1_1);
        this.resource = null;
    }

    @Override
    public final boolean isRunning() {
        return this.status == GenericRequest$Status.RUNNING || this.status == GenericRequest$Status.WAITING_FOR_SIZE;
    }

    @Override
    public final boolean isComplete() {
        return this.status == GenericRequest$Status.COMPLETE;
    }

    @Override
    public final boolean isResourceSet() {
        return this.isComplete();
    }

    @Override
    public final boolean isCancelled() {
        return this.status == GenericRequest$Status.CANCELLED || this.status == GenericRequest$Status.CLEARED;
    }

    @Override
    public final boolean isFailed() {
        return this.status == GenericRequest$Status.FAILED;
    }

    private Drawable getFallbackDrawable() {
        if (this.fallbackDrawable == null && this.fallbackResourceId > 0) {
            this.fallbackDrawable = this.context.getResources().getDrawable(this.fallbackResourceId);
        }
        return this.fallbackDrawable;
    }

    /*
     * WARNING - void declaration
     */
    private void setErrorPlaceholder(Exception e2) {
        void var1_1;
        if (!this.canNotifyStatusChanged()) {
            return;
        }
        Drawable drawable = this.model == null ? this.getFallbackDrawable() : null;
        if (drawable == null) {
            drawable = this.getErrorDrawable();
        }
        if (drawable == null) {
            drawable = this.getPlaceholderDrawable();
        }
        this.target.onLoadFailed((Exception)var1_1, drawable);
    }

    private Drawable getErrorDrawable() {
        if (this.errorDrawable == null && this.errorResourceId > 0) {
            this.errorDrawable = this.context.getResources().getDrawable(this.errorResourceId);
        }
        return this.errorDrawable;
    }

    private Drawable getPlaceholderDrawable() {
        if (this.placeholderDrawable == null && this.placeholderResourceId > 0) {
            this.placeholderDrawable = this.context.getResources().getDrawable(this.placeholderResourceId);
        }
        return this.placeholderDrawable;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void onSizeReady(int width, int height) {
        void var2_2;
        void var1_1;
        if (Log.isLoggable((String)TAG, (int)2)) {
            this.logV("Got onSizeReady in " + LogTime.getElapsedMillis(this.startTime));
        }
        if (this.status != GenericRequest$Status.WAITING_FOR_SIZE) {
            return;
        }
        this.status = GenericRequest$Status.RUNNING;
        width = Math.round(this.sizeMultiplier * (float)width);
        height = Math.round(this.sizeMultiplier * (float)height);
        DataFetcher<T> dataFetcher = this.loadProvider.getModelLoader().getResourceFetcher(this.model, width, height);
        if (dataFetcher == null) {
            this.onException(new Exception("Failed to load model: '" + this.model + "'"));
            return;
        }
        ResourceTranscoder<Z, R> resourceTranscoder = this.loadProvider.getTranscoder();
        if (Log.isLoggable((String)TAG, (int)2)) {
            this.logV("finished setup for calling load in " + LogTime.getElapsedMillis(this.startTime));
        }
        this.loadedFromMemoryCache = true;
        this.loadStatus = this.engine.load(this.signature, (int)var1_1, (int)var2_2, dataFetcher, this.loadProvider, this.transformation, resourceTranscoder, this.priority, this.isMemoryCacheable, this.diskCacheStrategy, this);
        boolean bl = this.loadedFromMemoryCache = this.resource != null;
        if (Log.isLoggable((String)TAG, (int)2)) {
            this.logV("finished onSizeReady in " + LogTime.getElapsedMillis(this.startTime));
        }
    }

    private boolean canSetResource() {
        return this.requestCoordinator == null || this.requestCoordinator.canSetImage(this);
    }

    private boolean canNotifyStatusChanged() {
        return this.requestCoordinator == null || this.requestCoordinator.canNotifyStatusChanged(this);
    }

    private boolean isFirstReadyResource() {
        return this.requestCoordinator == null || !this.requestCoordinator.isAnyResourceSet();
    }

    private void notifyLoadSuccess() {
        if (this.requestCoordinator != null) {
            this.requestCoordinator.onRequestSuccess(this);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void onResourceReady(Resource<?> resource) {
        void var1_1;
        if (resource == null) {
            this.onException(new Exception("Expected to receive a Resource<R> with an object of " + this.transcodeClass + " inside, but instead got null."));
            return;
        }
        Object obj = resource.get();
        if (obj == null || !this.transcodeClass.isAssignableFrom(obj.getClass())) {
            this.releaseResource(resource);
            this.onException(new Exception("Expected to receive an object of " + this.transcodeClass + " but instead got " + (obj != null ? obj.getClass() : "") + "{" + obj + "} inside Resource{" + resource + "}." + (obj != null ? "" : " To indicate failure return a null Resource object, rather than a Resource object containing null data.")));
            return;
        }
        if (!this.canSetResource()) {
            this.releaseResource(resource);
            this.status = GenericRequest$Status.COMPLETE;
            return;
        }
        this.onResourceReady((Resource<?>)var1_1, (R)obj);
    }

    /*
     * WARNING - void declaration
     */
    private void onResourceReady(Resource<?> resource, R result) {
        boolean bl = this.isFirstReadyResource();
        this.status = GenericRequest$Status.COMPLETE;
        this.resource = resource;
        if (this.requestListener == null || !this.requestListener.onResourceReady(result, this.model, this.target, this.loadedFromMemoryCache, bl)) {
            void var2_2;
            GlideAnimation<R> glideAnimation = this.animationFactory.build(this.loadedFromMemoryCache, bl);
            this.target.onResourceReady(var2_2, glideAnimation);
        }
        this.notifyLoadSuccess();
        if (Log.isLoggable((String)TAG, (int)2)) {
            void var1_1;
            this.logV("Resource ready in " + LogTime.getElapsedMillis(this.startTime) + " size: " + (double)var1_1.getSize() * 9.5367431640625E-7 + " fromCache: " + this.loadedFromMemoryCache);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void onException(Exception e2) {
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)"load failed", (Throwable)e2);
        }
        this.status = GenericRequest$Status.FAILED;
        if (this.requestListener == null || !this.requestListener.onException(e2, this.model, this.target, this.isFirstReadyResource())) {
            void var1_1;
            this.setErrorPlaceholder((Exception)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void logV(String message) {
        void var1_1;
        Log.v((String)TAG, (String)(String.valueOf(var1_1) + " this: " + this.tag));
    }
}

