/*
 * Decompiled with CFR 0.152.
 */
package com.thirdparty.bumptech.glide.manager;

import com.thirdparty.bumptech.glide.request.Request;
import com.thirdparty.bumptech.glide.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;

public class RequestTracker {
    private final Set<Request> requests = Collections.newSetFromMap(new WeakHashMap());
    private final List<Request> pendingRequests = new ArrayList<Request>();
    private boolean isPaused;

    /*
     * WARNING - void declaration
     */
    public void runRequest(Request request) {
        void var1_1;
        this.requests.add(request);
        if (!this.isPaused) {
            request.begin();
            return;
        }
        this.pendingRequests.add((Request)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    void addRequest(Request request) {
        void var1_1;
        this.requests.add((Request)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void removeRequest(Request request) {
        void var1_1;
        this.requests.remove(request);
        this.pendingRequests.remove(var1_1);
    }

    public boolean isPaused() {
        return this.isPaused;
    }

    public void pauseRequests() {
        this.isPaused = true;
        for (Request request : Util.getSnapshot(this.requests)) {
            if (!request.isRunning()) continue;
            request.pause();
            this.pendingRequests.add(request);
        }
    }

    public void resumeRequests() {
        this.isPaused = false;
        for (Request request : Util.getSnapshot(this.requests)) {
            if (request.isComplete() || request.isCancelled() || request.isRunning()) continue;
            request.begin();
        }
        this.pendingRequests.clear();
    }

    public void clearRequests() {
        Iterator<Request> iterator = Util.getSnapshot(this.requests).iterator();
        while (iterator.hasNext()) {
            iterator.next().clear();
        }
        this.pendingRequests.clear();
    }

    public void restartRequests() {
        for (Request request : Util.getSnapshot(this.requests)) {
            if (request.isComplete() || request.isCancelled()) continue;
            request.pause();
            if (!this.isPaused) {
                request.begin();
                continue;
            }
            this.pendingRequests.add(request);
        }
    }
}

