/*
 * Decompiled with CFR 0.152.
 */
package com.thirdparty.bumptech.glide.load.resource.gif;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.Log;
import com.thirdparty.bumptech.glide.Glide;
import com.thirdparty.bumptech.glide.gifdecoder.GifDecoder;
import com.thirdparty.bumptech.glide.gifdecoder.GifHeader;
import com.thirdparty.bumptech.glide.gifdecoder.GifHeaderParser;
import com.thirdparty.bumptech.glide.load.ResourceDecoder;
import com.thirdparty.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.thirdparty.bumptech.glide.load.resource.UnitTransformation;
import com.thirdparty.bumptech.glide.load.resource.gif.GifBitmapProvider;
import com.thirdparty.bumptech.glide.load.resource.gif.GifDrawable;
import com.thirdparty.bumptech.glide.load.resource.gif.GifDrawableResource;
import com.thirdparty.bumptech.glide.load.resource.gif.GifResourceDecoder$GifDecoderPool;
import com.thirdparty.bumptech.glide.load.resource.gif.GifResourceDecoder$GifHeaderParserPool;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class GifResourceDecoder
implements ResourceDecoder<InputStream, GifDrawable> {
    private static final String TAG = "GifResourceDecoder";
    private static final GifResourceDecoder$GifHeaderParserPool PARSER_POOL = new GifResourceDecoder$GifHeaderParserPool();
    private static final GifResourceDecoder$GifDecoderPool DECODER_POOL = new GifResourceDecoder$GifDecoderPool();
    private final Context context;
    private final GifResourceDecoder$GifHeaderParserPool parserPool;
    private final BitmapPool bitmapPool;
    private final GifResourceDecoder$GifDecoderPool decoderPool;
    private final GifBitmapProvider provider;

    /*
     * WARNING - void declaration
     */
    public GifResourceDecoder(Context context) {
        this(context, Glide.get((Context)var1_1).getBitmapPool());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public GifResourceDecoder(Context context, BitmapPool bitmapPool) {
        this((Context)var1_1, (BitmapPool)var2_2, PARSER_POOL, DECODER_POOL);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    GifResourceDecoder(Context context, BitmapPool bitmapPool, GifResourceDecoder$GifHeaderParserPool parserPool, GifResourceDecoder$GifDecoderPool decoderPool) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.context = var1_1;
        this.bitmapPool = bitmapPool;
        this.decoderPool = decoderPool;
        this.provider = new GifBitmapProvider((BitmapPool)var2_2);
        this.parserPool = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public GifDrawableResource decode(InputStream source, int width, int height) {
        Object object = GifResourceDecoder.inputStreamToBytes(source);
        GifHeaderParser gifHeaderParser = this.parserPool.obtain((byte[])object);
        GifDecoder gifDecoder = this.decoderPool.obtain(this.provider);
        try {
            void var3_4;
            void var2_3;
            object = this.decode((byte[])object, (int)var2_3, (int)var3_4, gifHeaderParser, gifDecoder);
            return object;
        }
        finally {
            this.parserPool.release(gifHeaderParser);
            this.decoderPool.release(gifDecoder);
        }
    }

    /*
     * WARNING - void declaration
     */
    private GifDrawableResource decode(byte[] data, int width, int height, GifHeaderParser parser, GifDecoder decoder) {
        GifDrawable gifDrawable;
        void var3_3;
        void var2_2;
        GifHeader gifHeader = parser.parseHeader();
        if (gifHeader.getNumFrames() <= 0 || gifHeader.getStatus() != 0) {
            return null;
        }
        Bitmap bitmap = this.decodeFirstFrame(decoder, gifHeader, data);
        if (bitmap == null) {
            return null;
        }
        UnitTransformation<Bitmap> unitTransformation = UnitTransformation.get();
        gifDrawable = new GifDrawable(this.context, this.provider, this.bitmapPool, unitTransformation, (int)var2_2, (int)var3_3, gifHeader, (byte[])gifDrawable, bitmap);
        return new GifDrawableResource(gifDrawable);
    }

    /*
     * WARNING - void declaration
     */
    private Bitmap decodeFirstFrame(GifDecoder decoder, GifHeader header, byte[] data) {
        void var1_1;
        void var3_3;
        void var2_2;
        decoder.setData((GifHeader)var2_2, (byte[])var3_3);
        decoder.advance();
        return var1_1.getNextFrame();
    }

    @Override
    public String getId() {
        return "";
    }

    private static byte[] inputStreamToBytes(InputStream is) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(16384);
        try {
            int n2;
            byte[] byArray = new byte[16384];
            while ((n2 = is.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
            byteArrayOutputStream.flush();
        }
        catch (IOException iOException) {
            Log.w((String)TAG, (String)"Error reading data from stream", (Throwable)iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

