/*
 * Decompiled with CFR 0.152.
 */
package com.thirdparty.bumptech.glide.load.resource.bitmap;

import android.util.Log;
import com.thirdparty.bumptech.glide.load.resource.bitmap.RecyclableBufferedInputStream$InvalidMarkException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class RecyclableBufferedInputStream
extends FilterInputStream {
    private static final String TAG = "BufferedIs";
    private volatile byte[] buf;
    private int count;
    private int marklimit;
    private int markpos = -1;
    private int pos;

    /*
     * WARNING - void declaration
     */
    public RecyclableBufferedInputStream(InputStream in, byte[] buffer) {
        super((InputStream)var1_1);
        void var2_2;
        void var1_1;
        if (buffer == null || buffer.length == 0) {
            throw new IllegalArgumentException("buffer is null or empty");
        }
        this.buf = var2_2;
    }

    @Override
    public synchronized int available() {
        InputStream inputStream = this.in;
        if (this.buf == null || inputStream == null) {
            throw RecyclableBufferedInputStream.streamClosed();
        }
        return this.count - this.pos + inputStream.available();
    }

    private static IOException streamClosed() {
        throw new IOException("BufferedInputStream is closed");
    }

    public synchronized void fixMarkLimit() {
        this.marklimit = this.buf.length;
    }

    @Override
    public void close() {
        this.buf = null;
        InputStream inputStream = this.in;
        this.in = null;
        if (inputStream != null) {
            inputStream.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    private int fillbuf(InputStream localIn, byte[] localBuf) {
        void var2_2;
        void var1_1;
        if (this.markpos == -1 || this.pos - this.markpos >= this.marklimit) {
            int n2 = localIn.read(localBuf);
            if (n2 > 0) {
                this.markpos = -1;
                this.pos = 0;
                this.count = n2;
            }
            return n2;
        }
        if (this.markpos == 0 && this.marklimit > localBuf.length && this.count == localBuf.length) {
            int n3 = localBuf.length * 2;
            if (n3 > this.marklimit) {
                n3 = this.marklimit;
            }
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("allocate buffer of length: " + n3));
            }
            byte[] byArray = new byte[n3];
            System.arraycopy(localBuf, 0, byArray, 0, localBuf.length);
            this.buf = byArray;
            localBuf = byArray;
        } else if (this.markpos > 0) {
            System.arraycopy(localBuf, this.markpos, localBuf, 0, localBuf.length - this.markpos);
        }
        this.pos -= this.markpos;
        this.markpos = 0;
        this.count = 0;
        int n4 = var1_1.read(localBuf, this.pos, ((void)var2_2).length - this.pos);
        this.count = n4 <= 0 ? this.pos : this.pos + n4;
        return n4;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void mark(int readlimit) {
        void var1_1;
        this.marklimit = Math.max(this.marklimit, (int)var1_1);
        this.markpos = this.pos;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized int read() {
        byte[] byArray = this.buf;
        InputStream inputStream = this.in;
        if (byArray == null || inputStream == null) {
            throw RecyclableBufferedInputStream.streamClosed();
        }
        if (this.pos >= this.count && this.fillbuf(inputStream, byArray) == -1) {
            return -1;
        }
        if (byArray != this.buf) {
            byArray = this.buf;
            if (this.buf == null) {
                throw RecyclableBufferedInputStream.streamClosed();
            }
        }
        if (this.count - this.pos > 0) {
            return byArray[this.pos++] & 0xFF;
        }
        return -1;
    }

    @Override
    public synchronized int read(byte[] buffer, int offset, int byteCount) {
        int n2;
        int n3;
        byte[] byArray = this.buf;
        if (this.buf == null) {
            throw RecyclableBufferedInputStream.streamClosed();
        }
        if (byteCount == 0) {
            return 0;
        }
        InputStream inputStream = this.in;
        if (inputStream == null) {
            throw RecyclableBufferedInputStream.streamClosed();
        }
        if (this.pos < this.count) {
            n3 = this.count - this.pos >= byteCount ? byteCount : this.count - this.pos;
            System.arraycopy(byArray, this.pos, buffer, offset, n3);
            this.pos += n3;
            if (n3 == byteCount || inputStream.available() == 0) {
                return n3;
            }
            offset += n3;
            n2 = byteCount - n3;
        } else {
            n2 = byteCount;
        }
        while (true) {
            if (this.markpos == -1 && n2 >= byArray.length) {
                n3 = inputStream.read(buffer, offset, n2);
                if (n3 == -1) {
                    if (n2 == byteCount) {
                        return -1;
                    }
                    return byteCount - n2;
                }
            } else {
                if (this.fillbuf(inputStream, byArray) == -1) {
                    if (n2 == byteCount) {
                        return -1;
                    }
                    return byteCount - n2;
                }
                if (byArray != this.buf) {
                    byArray = this.buf;
                    if (this.buf == null) {
                        throw RecyclableBufferedInputStream.streamClosed();
                    }
                }
                n3 = this.count - this.pos >= n2 ? n2 : this.count - this.pos;
                System.arraycopy(byArray, this.pos, buffer, offset, n3);
                this.pos += n3;
            }
            if ((n2 -= n3) == 0) {
                return byteCount;
            }
            if (inputStream.available() == 0) {
                return byteCount - n2;
            }
            offset += n3;
        }
    }

    @Override
    public synchronized void reset() {
        if (this.buf == null) {
            throw new IOException("Stream is closed");
        }
        if (-1 == this.markpos) {
            throw new RecyclableBufferedInputStream$InvalidMarkException("Mark has been invalidated");
        }
        this.pos = this.markpos;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized long skip(long byteCount) {
        void var1_1;
        byte[] byArray = this.buf;
        InputStream inputStream = this.in;
        if (byArray == null) {
            throw RecyclableBufferedInputStream.streamClosed();
        }
        if (byteCount < 1L) {
            return 0L;
        }
        if (inputStream == null) {
            throw RecyclableBufferedInputStream.streamClosed();
        }
        if ((long)(this.count - this.pos) >= byteCount) {
            this.pos = (int)((long)this.pos + byteCount);
            return byteCount;
        }
        long l2 = this.count - this.pos;
        this.pos = this.count;
        if (this.markpos != -1 && byteCount <= (long)this.marklimit) {
            if (this.fillbuf(inputStream, byArray) == -1) {
                return l2;
            }
            if ((long)(this.count - this.pos) >= byteCount - l2) {
                this.pos = (int)((long)this.pos + (byteCount - l2));
                return byteCount;
            }
            l2 = l2 + (long)this.count - (long)this.pos;
            this.pos = this.count;
            return l2;
        }
        return l2 + inputStream.skip((long)(var1_1 - l2));
    }
}

