/*
 * Decompiled with CFR 0.152.
 */
package com.thirdparty.bumptech.glide.load.resource.bitmap;

import android.util.Log;
import com.thirdparty.bumptech.glide.load.resource.bitmap.ImageHeaderParser$ImageType;
import com.thirdparty.bumptech.glide.load.resource.bitmap.ImageHeaderParser$RandomAccessReader;
import com.thirdparty.bumptech.glide.load.resource.bitmap.ImageHeaderParser$StreamReader;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;

public class ImageHeaderParser {
    private static final String TAG = "ImageHeaderParser";
    private static final int GIF_HEADER = 4671814;
    private static final int PNG_HEADER = -1991225785;
    private static final int EXIF_MAGIC_NUMBER = 65496;
    private static final int MOTOROLA_TIFF_MAGIC_NUMBER = 19789;
    private static final int INTEL_TIFF_MAGIC_NUMBER = 18761;
    private static final String JPEG_EXIF_SEGMENT_PREAMBLE = "Exif\u0000\u0000";
    private static final byte[] JPEG_EXIF_SEGMENT_PREAMBLE_BYTES;
    private static final int SEGMENT_SOS = 218;
    private static final int MARKER_EOI = 217;
    private static final int SEGMENT_START_ID = 255;
    private static final int EXIF_SEGMENT_TYPE = 225;
    private static final int ORIENTATION_TAG_TYPE = 274;
    private static final int[] BYTES_PER_FORMAT;
    private final ImageHeaderParser$StreamReader streamReader;

    static {
        int[] nArray = new int[13];
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 2;
        nArray[4] = 4;
        nArray[5] = 8;
        nArray[6] = 1;
        nArray[7] = 1;
        nArray[8] = 2;
        nArray[9] = 4;
        nArray[10] = 8;
        nArray[11] = 4;
        nArray[12] = 8;
        BYTES_PER_FORMAT = nArray;
        byte[] byArray = new byte[]{};
        try {
            byArray = JPEG_EXIF_SEGMENT_PREAMBLE.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        JPEG_EXIF_SEGMENT_PREAMBLE_BYTES = byArray;
    }

    /*
     * WARNING - void declaration
     */
    public ImageHeaderParser(InputStream is) {
        void var1_1;
        this.streamReader = new ImageHeaderParser$StreamReader((InputStream)var1_1);
    }

    public boolean hasAlpha() {
        return this.getType().hasAlpha();
    }

    public ImageHeaderParser$ImageType getType() {
        int n2 = this.streamReader.getUInt16();
        if (n2 == 65496) {
            return ImageHeaderParser$ImageType.JPEG;
        }
        if ((n2 = n2 << 16 & 0xFFFF0000 | this.streamReader.getUInt16() & 0xFFFF) == -1991225785) {
            this.streamReader.skip(21L);
            if (this.streamReader.getByte() >= 3) {
                return ImageHeaderParser$ImageType.PNG_A;
            }
            return ImageHeaderParser$ImageType.PNG;
        }
        if (n2 >> 8 == 4671814) {
            return ImageHeaderParser$ImageType.GIF;
        }
        return ImageHeaderParser$ImageType.UNKNOWN;
    }

    public int getOrientation() {
        if (!ImageHeaderParser.handles(this.streamReader.getUInt16())) {
            return -1;
        }
        byte[] byArray = this.getExifSegment();
        boolean bl = byArray != null && byArray.length > JPEG_EXIF_SEGMENT_PREAMBLE_BYTES.length;
        if (bl) {
            int n2 = 0;
            while (n2 < JPEG_EXIF_SEGMENT_PREAMBLE_BYTES.length) {
                if (byArray[n2] != JPEG_EXIF_SEGMENT_PREAMBLE_BYTES[n2]) {
                    bl = false;
                    break;
                }
                ++n2;
            }
        }
        if (bl) {
            return ImageHeaderParser.parseExifSegment(new ImageHeaderParser$RandomAccessReader(byArray));
        }
        return -1;
    }

    private byte[] getExifSegment() {
        short s2;
        int n2;
        block9: {
            long l2;
            do {
                if ((s2 = this.streamReader.getUInt8()) != 255) {
                    if (Log.isLoggable((String)TAG, (int)3)) {
                        Log.d((String)TAG, (String)("Unknown segmentId=" + s2));
                    }
                    return null;
                }
                s2 = this.streamReader.getUInt8();
                if (s2 == 218) {
                    return null;
                }
                if (s2 == 217) {
                    if (Log.isLoggable((String)TAG, (int)3)) {
                        Log.d((String)TAG, (String)"Found MARKER_EOI in exif segment");
                    }
                    return null;
                }
                n2 = this.streamReader.getUInt16() - 2;
                if (s2 == 225) break block9;
            } while ((l2 = this.streamReader.skip(n2)) == (long)n2);
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("Unable to skip enough data, type: " + s2 + ", wanted to skip: " + n2 + ", but actually skipped: " + l2));
            }
            return null;
        }
        byte[] byArray = new byte[n2];
        int n3 = this.streamReader.read(byArray);
        if (n3 != n2) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("Unable to read segment data, type: " + s2 + ", length: " + n2 + ", actually read: " + n3));
            }
            return null;
        }
        return byArray;
    }

    /*
     * Unable to fully structure code
     */
    private static int parseExifSegment(ImageHeaderParser$RandomAccessReader segmentData) {
        var2_1 = segmentData.getInt16(6);
        if (var2_1 == 19789) ** GOTO lbl9
        if (var2_1 == 18761) {
            var2_2 = ByteOrder.LITTLE_ENDIAN;
        } else {
            if (Log.isLoggable((String)"ImageHeaderParser", (int)3)) {
                Log.d((String)"ImageHeaderParser", (String)("Unknown endianness = " + var2_1));
            }
lbl9:
            // 4 sources

            var2_2 = ByteOrder.BIG_ENDIAN;
        }
        segmentData.order(var2_2);
        var1_4 = segmentData.getInt32(10) + 6;
        var2_3 = segmentData.getInt16(var1_4);
        var7_5 = 0;
        while (var7_5 < var2_3) {
            var3_6 = ImageHeaderParser.calcTagOffset(var1_4, var7_5);
            var4_7 = segmentData.getInt16(var3_6);
            if (var4_7 == 274) {
                var5_8 = segmentData.getInt16(var3_6 + 2);
                if (var5_8 <= 0 || var5_8 > 12) {
                    if (Log.isLoggable((String)"ImageHeaderParser", (int)3)) {
                        Log.d((String)"ImageHeaderParser", (String)("Got invalid format code=" + var5_8));
                    }
                } else {
                    var6_9 = segmentData.getInt32(var3_6 + 4);
                    if (var6_9 < 0) {
                        if (Log.isLoggable((String)"ImageHeaderParser", (int)3)) {
                            Log.d((String)"ImageHeaderParser", (String)"Negative tiff component count");
                        }
                    } else {
                        if (Log.isLoggable((String)"ImageHeaderParser", (int)3)) {
                            Log.d((String)"ImageHeaderParser", (String)("Got tagIndex=" + var7_5 + " tagType=" + var4_7 + " formatCode=" + var5_8 + " componentCount=" + var6_9));
                        }
                        if ((var6_9 += ImageHeaderParser.BYTES_PER_FORMAT[var5_8]) > 4) {
                            if (Log.isLoggable((String)"ImageHeaderParser", (int)3)) {
                                Log.d((String)"ImageHeaderParser", (String)("Got byte count > 4, not orientation, continuing, formatCode=" + var5_8));
                            }
                        } else if ((var3_6 += 8) < 0 || var3_6 > segmentData.length()) {
                            if (Log.isLoggable((String)"ImageHeaderParser", (int)3)) {
                                Log.d((String)"ImageHeaderParser", (String)("Illegal tagValueOffset=" + var3_6 + " tagType=" + var4_7));
                            }
                        } else if (var6_9 < 0 || var3_6 + var6_9 > segmentData.length()) {
                            if (Log.isLoggable((String)"ImageHeaderParser", (int)3)) {
                                Log.d((String)"ImageHeaderParser", (String)("Illegal number of bytes for TI tag data tagType=" + var4_7));
                            }
                        } else {
                            return segmentData.getInt16(var3_6);
                        }
                    }
                }
            }
            ++var7_5;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    private static int calcTagOffset(int ifdOffset, int tagIndex) {
        void var1_1;
        return ifdOffset + 2 + 12 * var1_1;
    }

    private static boolean handles(int imageMagicNumber) {
        int n2;
        return (imageMagicNumber & 0xFFD8) == 65496 || imageMagicNumber == 19789 || n2 == 18761;
    }
}

