/*
 * Decompiled with CFR 0.152.
 */
package com.thirdparty.bumptech.glide.load.resource.bitmap;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.Gravity;
import com.thirdparty.bumptech.glide.load.resource.bitmap.GlideBitmapDrawable$BitmapState;
import com.thirdparty.bumptech.glide.load.resource.drawable.GlideDrawable;

public class GlideBitmapDrawable
extends GlideDrawable {
    private final Rect destRect = new Rect();
    private int width;
    private int height;
    private boolean applyGravity;
    private boolean mutated;
    private GlideBitmapDrawable$BitmapState state;

    /*
     * WARNING - void declaration
     */
    public GlideBitmapDrawable(Resources res, Bitmap bitmap) {
        this((Resources)var1_1, new GlideBitmapDrawable$BitmapState((Bitmap)var2_2));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    GlideBitmapDrawable(Resources res, GlideBitmapDrawable$BitmapState state) {
        void var2_3;
        int n2;
        if (state == null) {
            throw new NullPointerException("BitmapState must not be null");
        }
        this.state = state;
        if (res != null) {
            void var1_1;
            n2 = var1_1.getDisplayMetrics().densityDpi;
            state.targetDensity = n2 = n2 == 0 ? 160 : n2;
        } else {
            n2 = state.targetDensity;
        }
        this.width = state.bitmap.getScaledWidth(n2);
        this.height = var2_3.bitmap.getScaledHeight(n2);
    }

    public int getIntrinsicWidth() {
        return this.width;
    }

    public int getIntrinsicHeight() {
        return this.height;
    }

    @Override
    public boolean isAnimated() {
        return false;
    }

    @Override
    public void setLoopCount(int n2) {
    }

    public void start() {
    }

    public void stop() {
    }

    public boolean isRunning() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    protected void onBoundsChange(Rect bounds) {
        void var1_1;
        super.onBoundsChange((Rect)var1_1);
        this.applyGravity = true;
    }

    public Drawable.ConstantState getConstantState() {
        return this.state;
    }

    /*
     * WARNING - void declaration
     */
    public void draw(Canvas canvas) {
        void var1_1;
        if (this.applyGravity) {
            Gravity.apply((int)119, (int)this.width, (int)this.height, (Rect)this.getBounds(), (Rect)this.destRect);
            this.applyGravity = false;
        }
        var1_1.drawBitmap(this.state.bitmap, null, this.destRect, this.state.paint);
    }

    /*
     * WARNING - void declaration
     */
    public void setAlpha(int alpha) {
        if (this.state.paint.getAlpha() != alpha) {
            void var1_1;
            this.state.setAlpha((int)var1_1);
            this.invalidateSelf();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setColorFilter(ColorFilter colorFilter) {
        void var1_1;
        this.state.setColorFilter((ColorFilter)var1_1);
        this.invalidateSelf();
    }

    public int getOpacity() {
        Bitmap bitmap = this.state.bitmap;
        if (bitmap == null || bitmap.hasAlpha() || this.state.paint.getAlpha() < 255) {
            return -3;
        }
        return -1;
    }

    public Drawable mutate() {
        if (!this.mutated && super.mutate() == this) {
            this.state = new GlideBitmapDrawable$BitmapState(this.state);
            this.mutated = true;
        }
        return this;
    }

    public Bitmap getBitmap() {
        return this.state.bitmap;
    }
}

