/*
 * Decompiled with CFR 0.152.
 */
package com.thirdparty.bumptech.glide.load.resource.bitmap;

import android.graphics.Bitmap;
import android.util.Log;
import com.thirdparty.bumptech.glide.load.ResourceEncoder;
import com.thirdparty.bumptech.glide.load.engine.Resource;
import com.thirdparty.bumptech.glide.util.LogTime;
import com.thirdparty.bumptech.glide.util.Util;
import java.io.OutputStream;

public class BitmapEncoder
implements ResourceEncoder<Bitmap> {
    private static final String TAG = "BitmapEncoder";
    private static final int DEFAULT_COMPRESSION_QUALITY = 90;
    private Bitmap.CompressFormat compressFormat;
    private int quality;

    public BitmapEncoder() {
        this(null, 90);
    }

    /*
     * WARNING - void declaration
     */
    public BitmapEncoder(Bitmap.CompressFormat compressFormat, int quality) {
        void var2_2;
        void var1_1;
        this.compressFormat = var1_1;
        this.quality = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean encode(Resource<Bitmap> resource, OutputStream os) {
        void var2_2;
        Bitmap bitmap = resource.get();
        long l2 = LogTime.getLogTime();
        Bitmap.CompressFormat compressFormat = this.getFormat(bitmap);
        bitmap.compress(compressFormat, this.quality, (OutputStream)var2_2);
        if (Log.isLoggable((String)TAG, (int)2)) {
            Log.v((String)TAG, (String)("Compressed with type: " + compressFormat + " of size " + Util.getBitmapByteSize(bitmap) + " in " + LogTime.getElapsedMillis(l2)));
        }
        return true;
    }

    @Override
    public String getId() {
        return "BitmapEncoder.com.bumptech.glide.load.resource.bitmap";
    }

    /*
     * WARNING - void declaration
     */
    private Bitmap.CompressFormat getFormat(Bitmap bitmap) {
        void var1_1;
        if (this.compressFormat != null) {
            return this.compressFormat;
        }
        if (var1_1.hasAlpha()) {
            return Bitmap.CompressFormat.PNG;
        }
        return Bitmap.CompressFormat.JPEG;
    }
}

