/*
 * Decompiled with CFR 0.152.
 */
package com.thirdparty.bumptech.glide.load.model;

import android.net.Uri;
import android.text.TextUtils;
import com.thirdparty.bumptech.glide.load.model.Headers;
import java.net.URL;
import java.util.Map;

public class GlideUrl {
    private static final String ALLOWED_URI_CHARS = "@#&=*+-_.,:!?()/~'%";
    private final URL url;
    private final Headers headers;
    private final String stringUrl;
    private String safeStringUrl;
    private URL safeUrl;

    /*
     * WARNING - void declaration
     */
    public GlideUrl(URL url) {
        this((URL)var1_1, Headers.DEFAULT);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public GlideUrl(String url) {
        this((String)var1_1, Headers.DEFAULT);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public GlideUrl(URL url, Headers headers) {
        void var2_2;
        void var1_1;
        if (url == null) {
            throw new IllegalArgumentException("URL must not be null!");
        }
        if (headers == null) {
            throw new IllegalArgumentException("Headers must not be null");
        }
        this.url = var1_1;
        this.stringUrl = null;
        this.headers = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public GlideUrl(String url, Headers headers) {
        void var2_2;
        void var1_1;
        if (TextUtils.isEmpty((CharSequence)url)) {
            throw new IllegalArgumentException("String url must not be empty or null: " + url);
        }
        if (headers == null) {
            throw new IllegalArgumentException("Headers must not be null");
        }
        this.stringUrl = var1_1;
        this.url = null;
        this.headers = var2_2;
    }

    public URL toURL() {
        return this.getSafeUrl();
    }

    private URL getSafeUrl() {
        if (this.safeUrl == null) {
            this.safeUrl = new URL(this.getSafeStringUrl());
        }
        return this.safeUrl;
    }

    public String toStringUrl() {
        return this.getSafeStringUrl();
    }

    private String getSafeStringUrl() {
        if (TextUtils.isEmpty((CharSequence)this.safeStringUrl)) {
            String string = this.stringUrl;
            if (TextUtils.isEmpty((CharSequence)string)) {
                string = this.url.toString();
            }
            this.safeStringUrl = Uri.encode((String)string, (String)ALLOWED_URI_CHARS);
        }
        return this.safeStringUrl;
    }

    public Map<String, String> getHeaders() {
        return this.headers.getHeaders();
    }

    public String getCacheKey() {
        if (this.stringUrl != null) {
            return this.stringUrl;
        }
        return this.url.toString();
    }

    public final String toString() {
        return String.valueOf(this.getCacheKey()) + '\n' + this.headers.toString();
    }

    public final boolean equals(Object o2) {
        if (o2 instanceof GlideUrl) {
            GlideUrl glideUrl;
            glideUrl = glideUrl;
            return this.getCacheKey().equals(glideUrl.getCacheKey()) && this.headers.equals(glideUrl.headers);
        }
        return false;
    }

    public final int hashCode() {
        int n2 = this.getCacheKey().hashCode();
        return 31 * n2 + this.headers.hashCode();
    }
}

