/*
 * Decompiled with CFR 0.152.
 */
package com.thirdparty.bumptech.glide.load.engine.prefill;

import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import com.thirdparty.bumptech.glide.load.DecodeFormat;
import com.thirdparty.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.thirdparty.bumptech.glide.load.engine.cache.MemoryCache;
import com.thirdparty.bumptech.glide.load.engine.prefill.BitmapPreFillRunner;
import com.thirdparty.bumptech.glide.load.engine.prefill.PreFillQueue;
import com.thirdparty.bumptech.glide.load.engine.prefill.PreFillType;
import com.thirdparty.bumptech.glide.load.engine.prefill.PreFillType$Builder;
import com.thirdparty.bumptech.glide.util.Util;
import java.util.HashMap;

public final class BitmapPreFiller {
    private final MemoryCache memoryCache;
    private final BitmapPool bitmapPool;
    private final DecodeFormat defaultFormat;
    private final Handler handler = new Handler(Looper.getMainLooper());
    private BitmapPreFillRunner current;

    /*
     * WARNING - void declaration
     */
    public BitmapPreFiller(MemoryCache memoryCache, BitmapPool bitmapPool, DecodeFormat defaultFormat) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.memoryCache = var1_1;
        this.bitmapPool = var2_2;
        this.defaultFormat = var3_3;
    }

    public final void preFill(PreFillType$Builder ... bitmapAttributeBuilders) {
        if (this.current != null) {
            this.current.cancel();
        }
        PreFillType[] preFillTypeArray = new PreFillType[bitmapAttributeBuilders.length];
        int n2 = 0;
        while (n2 < bitmapAttributeBuilders.length) {
            PreFillType$Builder preFillType$Builder = bitmapAttributeBuilders[n2];
            if (preFillType$Builder.getConfig() == null) {
                preFillType$Builder.setConfig(this.defaultFormat == DecodeFormat.ALWAYS_ARGB_8888 || this.defaultFormat == DecodeFormat.PREFER_ARGB_8888 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565);
            }
            preFillTypeArray[n2] = preFillType$Builder.build();
            ++n2;
        }
        PreFillQueue preFillQueue = this.generateAllocationOrder(preFillTypeArray);
        this.current = new BitmapPreFillRunner(this.bitmapPool, this.memoryCache, preFillQueue);
        this.handler.post((Runnable)this.current);
    }

    /*
     * WARNING - void declaration
     */
    final PreFillQueue generateAllocationOrder(PreFillType[] preFillSizes) {
        void var1_1;
        int n2 = this.memoryCache.getMaxSize() - this.memoryCache.getCurrentSize() + this.bitmapPool.getMaxSize();
        int n3 = 0;
        PreFillType[] preFillTypeArray = preFillSizes;
        int n4 = preFillSizes.length;
        int n5 = 0;
        while (n5 < n4) {
            PreFillType preFillType = preFillTypeArray[n5];
            n3 += preFillType.getWeight();
            ++n5;
        }
        float f2 = (float)n2 / (float)n3;
        HashMap<PreFillType, Integer> hashMap = new HashMap<PreFillType, Integer>();
        void var2_4 = var1_1;
        int n6 = ((void)var2_4).length;
        int n7 = 0;
        while (n7 < n6) {
            void var6_9 = var2_4[n7];
            n3 = Math.round(f2 * (float)var6_9.getWeight());
            int n8 = BitmapPreFiller.getSizeInBytes((PreFillType)var6_9);
            hashMap.put((PreFillType)var6_9, n3 /= n8);
            ++n7;
        }
        return new PreFillQueue(hashMap);
    }

    private static int getSizeInBytes(PreFillType size) {
        PreFillType preFillType;
        return Util.getBitmapByteSize(size.getWidth(), size.getHeight(), preFillType.getConfig());
    }
}

