/*
 * Decompiled with CFR 0.152.
 */
package com.thirdparty.bumptech.glide.load.engine.bitmap_recycle;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import com.thirdparty.bumptech.glide.load.engine.bitmap_recycle.GroupedLinkedMap;
import com.thirdparty.bumptech.glide.load.engine.bitmap_recycle.LruPoolStrategy;
import com.thirdparty.bumptech.glide.load.engine.bitmap_recycle.SizeConfigStrategy$Key;
import com.thirdparty.bumptech.glide.load.engine.bitmap_recycle.SizeConfigStrategy$KeyPool;
import com.thirdparty.bumptech.glide.util.Util;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

@TargetApi(value=19)
public class SizeConfigStrategy
implements LruPoolStrategy {
    private static final int MAX_SIZE_MULTIPLE = 8;
    private static final Bitmap.Config[] ARGB_8888_IN_CONFIGS;
    private static final Bitmap.Config[] RGB_565_IN_CONFIGS;
    private static final Bitmap.Config[] ARGB_4444_IN_CONFIGS;
    private static final Bitmap.Config[] ALPHA_8_IN_CONFIGS;
    private final SizeConfigStrategy$KeyPool keyPool = new SizeConfigStrategy$KeyPool();
    private final GroupedLinkedMap<SizeConfigStrategy$Key, Bitmap> groupedMap = new GroupedLinkedMap();
    private final Map<Bitmap.Config, NavigableMap<Integer, Integer>> sortedSizes = new HashMap<Bitmap.Config, NavigableMap<Integer, Integer>>();

    static {
        Bitmap.Config[] configArray = new Bitmap.Config[2];
        configArray[0] = Bitmap.Config.ARGB_8888;
        ARGB_8888_IN_CONFIGS = configArray;
        RGB_565_IN_CONFIGS = new Bitmap.Config[]{Bitmap.Config.RGB_565};
        ARGB_4444_IN_CONFIGS = new Bitmap.Config[]{Bitmap.Config.ARGB_4444};
        ALPHA_8_IN_CONFIGS = new Bitmap.Config[]{Bitmap.Config.ALPHA_8};
    }

    @Override
    public void put(Bitmap bitmap) {
        NavigableMap<Integer, Integer> navigableMap;
        int n2 = Util.getBitmapByteSize(bitmap);
        SizeConfigStrategy$Key sizeConfigStrategy$Key = this.keyPool.get(n2, bitmap.getConfig());
        this.groupedMap.put(sizeConfigStrategy$Key, bitmap);
        navigableMap = this.getSizesForConfig(navigableMap.getConfig());
        Integer n3 = (Integer)navigableMap.get(SizeConfigStrategy$Key.access$0(sizeConfigStrategy$Key));
        navigableMap.put(SizeConfigStrategy$Key.access$0(sizeConfigStrategy$Key), n3 == null ? 1 : n3 + 1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Bitmap get(int width, int height, Bitmap.Config config) {
        SizeConfigStrategy$Key sizeConfigStrategy$Key;
        int n2 = Util.getBitmapByteSize(width, height, config);
        SizeConfigStrategy$Key sizeConfigStrategy$Key2 = this.keyPool.get(n2, config);
        sizeConfigStrategy$Key = this.findBestKey(sizeConfigStrategy$Key2, n2, (Bitmap.Config)sizeConfigStrategy$Key);
        if ((sizeConfigStrategy$Key = this.groupedMap.get(sizeConfigStrategy$Key)) != null) {
            void var2_2;
            void var1_1;
            this.decrementBitmapOfSize(Util.getBitmapByteSize((Bitmap)sizeConfigStrategy$Key), sizeConfigStrategy$Key.getConfig());
            sizeConfigStrategy$Key.reconfigure((int)var1_1, (int)var2_2, sizeConfigStrategy$Key.getConfig() != null ? sizeConfigStrategy$Key.getConfig() : Bitmap.Config.ARGB_8888);
        }
        return sizeConfigStrategy$Key;
    }

    private SizeConfigStrategy$Key findBestKey(SizeConfigStrategy$Key key, int size, Bitmap.Config config) {
        SizeConfigStrategy$Key sizeConfigStrategy$Key = key;
        Bitmap.Config[] configArray = SizeConfigStrategy.getInConfigs(config);
        int n2 = configArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Bitmap.Config config2 = configArray[n3];
            Integer n4 = this.getSizesForConfig(config2).ceilingKey(size);
            if (n4 != null && n4 <= size * 8) {
                if (n4 == size && !(config2 == null ? config != null : !config2.equals((Object)config))) break;
                this.keyPool.offer(key);
                sizeConfigStrategy$Key = this.keyPool.get(n4, config2);
                break;
            }
            ++n3;
        }
        return sizeConfigStrategy$Key;
    }

    @Override
    public Bitmap removeLast() {
        Bitmap bitmap = this.groupedMap.removeLast();
        if (bitmap != null) {
            int n2 = Util.getBitmapByteSize(bitmap);
            this.decrementBitmapOfSize(n2, bitmap.getConfig());
        }
        return bitmap;
    }

    /*
     * WARNING - void declaration
     */
    private void decrementBitmapOfSize(Integer size, Bitmap.Config config) {
        void var1_1;
        NavigableMap<Integer, Integer> navigableMap;
        Integer n2 = (Integer)(navigableMap = this.getSizesForConfig((Bitmap.Config)navigableMap)).get(size);
        if (n2 == 1) {
            navigableMap.remove(size);
            return;
        }
        navigableMap.put((Integer)var1_1, n2 - 1);
    }

    /*
     * WARNING - void declaration
     */
    private NavigableMap<Integer, Integer> getSizesForConfig(Bitmap.Config config) {
        NavigableMap<Integer, Integer> navigableMap = this.sortedSizes.get(config);
        if (navigableMap == null) {
            void var1_1;
            navigableMap = new TreeMap<Integer, Integer>();
            this.sortedSizes.put((Bitmap.Config)var1_1, navigableMap);
        }
        return navigableMap;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String logBitmap(Bitmap bitmap) {
        void var1_1;
        return SizeConfigStrategy.getBitmapString(Util.getBitmapByteSize(bitmap), var1_1.getConfig());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String logBitmap(int width, int height, Bitmap.Config config) {
        void var3_3;
        void var2_2;
        return SizeConfigStrategy.getBitmapString(Util.getBitmapByteSize(width, (int)var2_2, config), (Bitmap.Config)var3_3);
    }

    @Override
    public int getSize(Bitmap bitmap) {
        return Util.getBitmapByteSize(bitmap);
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder("SizeConfigStrategy{groupedMap=").append(this.groupedMap).append(", sortedSizes=(");
        for (Map.Entry<Bitmap.Config, NavigableMap<Integer, Integer>> entry : this.sortedSizes.entrySet()) {
            stringBuilder.append(entry.getKey()).append('[').append(entry.getValue()).append("], ");
        }
        if (!this.sortedSizes.isEmpty()) {
            stringBuilder.replace(stringBuilder.length() - 2, stringBuilder.length(), "");
        }
        return stringBuilder.append(")}").toString();
    }

    /*
     * WARNING - void declaration
     */
    private static String getBitmapString(int size, Bitmap.Config config) {
        void var1_1;
        int n2;
        return "[" + n2 + "](" + var1_1 + ")";
    }

    private static Bitmap.Config[] getInConfigs(Bitmap.Config requested) {
        Bitmap.Config config;
        switch (requested) {
            case ARGB_8888: {
                return ARGB_8888_IN_CONFIGS;
            }
            case RGB_565: {
                return RGB_565_IN_CONFIGS;
            }
            case ARGB_4444: {
                return ARGB_4444_IN_CONFIGS;
            }
            case ALPHA_8: {
                return ALPHA_8_IN_CONFIGS;
            }
        }
        return new Bitmap.Config[]{config};
    }

    static /* synthetic */ String access$0(int n2, Bitmap.Config config) {
        return SizeConfigStrategy.getBitmapString(n2, config);
    }
}

