/*
 * Decompiled with CFR 0.152.
 */
package com.thirdparty.bumptech.glide.load.engine;

import android.util.Log;
import com.thirdparty.bumptech.glide.Priority;
import com.thirdparty.bumptech.glide.load.engine.DecodeJob;
import com.thirdparty.bumptech.glide.load.engine.EngineRunnable$EngineRunnableManager;
import com.thirdparty.bumptech.glide.load.engine.EngineRunnable$Stage;
import com.thirdparty.bumptech.glide.load.engine.Resource;
import com.thirdparty.bumptech.glide.load.engine.executor.Prioritized;

class EngineRunnable
implements Prioritized,
Runnable {
    private static final String TAG = "EngineRunnable";
    private final Priority priority;
    private final EngineRunnable$EngineRunnableManager manager;
    private final DecodeJob<?, ?, ?> decodeJob;
    private EngineRunnable$Stage stage;
    private volatile boolean isCancelled;

    /*
     * WARNING - void declaration
     */
    public EngineRunnable(EngineRunnable$EngineRunnableManager manager, DecodeJob<?, ?, ?> decodeJob, Priority priority) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.manager = var1_1;
        this.decodeJob = var2_2;
        this.stage = EngineRunnable$Stage.CACHE;
        this.priority = var3_3;
    }

    public void cancel() {
        this.isCancelled = true;
        this.decodeJob.cancel();
    }

    @Override
    public void run() {
        Resource<?> resource;
        Exception exception;
        block6: {
            if (this.isCancelled) {
                return;
            }
            exception = null;
            resource = null;
            try {
                resource = this.decode();
            }
            catch (Exception exception2) {
                if (!Log.isLoggable((String)TAG, (int)2)) break block6;
                Log.v((String)TAG, (String)"Exception decoding", (Throwable)exception2);
            }
        }
        if (this.isCancelled) {
            if (resource != null) {
                resource.recycle();
            }
            return;
        }
        if (resource == null) {
            this.onLoadFailed(exception);
            return;
        }
        this.onLoadComplete(resource);
    }

    private boolean isDecodingFromCache() {
        return this.stage == EngineRunnable$Stage.CACHE;
    }

    /*
     * WARNING - void declaration
     */
    private void onLoadComplete(Resource resource) {
        void var1_1;
        this.manager.onResourceReady((Resource<?>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void onLoadFailed(Exception e2) {
        void var1_1;
        if (this.isDecodingFromCache()) {
            this.stage = EngineRunnable$Stage.SOURCE;
            this.manager.submitForSource(this);
            return;
        }
        this.manager.onException((Exception)var1_1);
    }

    private Resource<?> decode() {
        if (this.isDecodingFromCache()) {
            return this.decodeFromCache();
        }
        return this.decodeFromSource();
    }

    private Resource<?> decodeFromCache() {
        Resource<?> resource;
        block3: {
            resource = null;
            try {
                resource = this.decodeJob.decodeResultFromCache();
            }
            catch (Exception exception) {
                if (!Log.isLoggable((String)TAG, (int)3)) break block3;
                Log.d((String)TAG, (String)("Exception decoding result from cache: " + exception));
            }
        }
        if (resource == null) {
            resource = this.decodeJob.decodeSourceFromCache();
        }
        return resource;
    }

    private Resource<?> decodeFromSource() {
        return this.decodeJob.decodeFromSource();
    }

    @Override
    public int getPriority() {
        return this.priority.ordinal();
    }
}

