/*
 * Decompiled with CFR 0.152.
 */
package com.thirdparty.bumptech.glide.load.engine;

import android.os.Handler;
import android.os.Looper;
import com.thirdparty.bumptech.glide.load.Key;
import com.thirdparty.bumptech.glide.load.engine.EngineJob$EngineResourceFactory;
import com.thirdparty.bumptech.glide.load.engine.EngineJob$MainThreadCallback;
import com.thirdparty.bumptech.glide.load.engine.EngineJobListener;
import com.thirdparty.bumptech.glide.load.engine.EngineResource;
import com.thirdparty.bumptech.glide.load.engine.EngineRunnable;
import com.thirdparty.bumptech.glide.load.engine.EngineRunnable$EngineRunnableManager;
import com.thirdparty.bumptech.glide.load.engine.Resource;
import com.thirdparty.bumptech.glide.request.ResourceCallback;
import com.thirdparty.bumptech.glide.util.Util;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

class EngineJob
implements EngineRunnable$EngineRunnableManager {
    private static final EngineJob$EngineResourceFactory DEFAULT_FACTORY = new EngineJob$EngineResourceFactory();
    private static final Handler MAIN_THREAD_HANDLER = new Handler(Looper.getMainLooper(), (Handler.Callback)new EngineJob$MainThreadCallback(null));
    private static final int MSG_COMPLETE = 1;
    private static final int MSG_EXCEPTION = 2;
    private final List<ResourceCallback> cbs = new ArrayList<ResourceCallback>();
    private final EngineJob$EngineResourceFactory engineResourceFactory;
    private final EngineJobListener listener;
    private final Key key;
    private final ExecutorService diskCacheService;
    private final ExecutorService sourceService;
    private final boolean isCacheable;
    private boolean isCancelled;
    private Resource<?> resource;
    private boolean hasResource;
    private Exception exception;
    private boolean hasException;
    private Set<ResourceCallback> ignoredCallbacks;
    private EngineRunnable engineRunnable;
    private EngineResource<?> engineResource;
    private volatile Future<?> future;

    /*
     * WARNING - void declaration
     */
    public EngineJob(Key key, ExecutorService diskCacheService, ExecutorService sourceService, boolean isCacheable, EngineJobListener listener) {
        this((Key)var1_1, (ExecutorService)var2_2, (ExecutorService)var3_3, isCacheable, listener, DEFAULT_FACTORY);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public EngineJob(Key key, ExecutorService diskCacheService, ExecutorService sourceService, boolean isCacheable, EngineJobListener listener, EngineJob$EngineResourceFactory engineResourceFactory) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.key = var1_1;
        this.diskCacheService = var2_2;
        this.sourceService = var3_3;
        this.isCacheable = isCacheable;
        this.listener = listener;
        this.engineResourceFactory = engineResourceFactory;
    }

    /*
     * WARNING - void declaration
     */
    public void start(EngineRunnable engineRunnable) {
        void var1_1;
        this.engineRunnable = engineRunnable;
        this.future = this.diskCacheService.submit((Runnable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void submitForSource(EngineRunnable runnable) {
        void var1_1;
        this.future = this.sourceService.submit((Runnable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void addCallback(ResourceCallback cb) {
        void var1_1;
        Util.assertMainThread();
        if (this.hasResource) {
            cb.onResourceReady(this.engineResource);
            return;
        }
        if (this.hasException) {
            cb.onException(this.exception);
            return;
        }
        this.cbs.add((ResourceCallback)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void removeCallback(ResourceCallback cb) {
        void var1_1;
        Util.assertMainThread();
        if (this.hasResource || this.hasException) {
            this.addIgnoredCallback(cb);
            return;
        }
        this.cbs.remove(var1_1);
        if (this.cbs.isEmpty()) {
            this.cancel();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addIgnoredCallback(ResourceCallback cb) {
        void var1_1;
        if (this.ignoredCallbacks == null) {
            this.ignoredCallbacks = new HashSet<ResourceCallback>();
        }
        this.ignoredCallbacks.add((ResourceCallback)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private boolean isInIgnoredCallbacks(ResourceCallback cb) {
        void var1_1;
        return this.ignoredCallbacks != null && this.ignoredCallbacks.contains(var1_1);
    }

    void cancel() {
        if (this.hasException || this.hasResource || this.isCancelled) {
            return;
        }
        this.engineRunnable.cancel();
        Future<?> future = this.future;
        if (future != null) {
            future.cancel(true);
        }
        this.isCancelled = true;
        this.listener.onEngineJobCancelled(this, this.key);
    }

    boolean isCancelled() {
        return this.isCancelled;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onResourceReady(Resource<?> resource) {
        void var1_1;
        this.resource = var1_1;
        MAIN_THREAD_HANDLER.obtainMessage(1, (Object)this).sendToTarget();
    }

    private void handleResultOnMainThread() {
        if (this.isCancelled) {
            this.resource.recycle();
            return;
        }
        if (this.cbs.isEmpty()) {
            throw new IllegalStateException("Received a resource without any callbacks to notify");
        }
        this.engineResource = this.engineResourceFactory.build(this.resource, this.isCacheable);
        this.hasResource = true;
        this.engineResource.acquire();
        this.listener.onEngineJobComplete(this.key, this.engineResource);
        for (ResourceCallback resourceCallback : this.cbs) {
            if (this.isInIgnoredCallbacks(resourceCallback)) continue;
            this.engineResource.acquire();
            resourceCallback.onResourceReady(this.engineResource);
        }
        this.engineResource.release();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onException(Exception e2) {
        void var1_1;
        this.exception = var1_1;
        MAIN_THREAD_HANDLER.obtainMessage(2, (Object)this).sendToTarget();
    }

    private void handleExceptionOnMainThread() {
        if (this.isCancelled) {
            return;
        }
        if (this.cbs.isEmpty()) {
            throw new IllegalStateException("Received an exception without any callbacks to notify");
        }
        this.hasException = true;
        this.listener.onEngineJobComplete(this.key, null);
        for (ResourceCallback resourceCallback : this.cbs) {
            if (this.isInIgnoredCallbacks(resourceCallback)) continue;
            resourceCallback.onException(this.exception);
        }
    }

    static /* synthetic */ void access$0(EngineJob engineJob) {
        engineJob.handleResultOnMainThread();
    }

    static /* synthetic */ void access$1(EngineJob engineJob) {
        engineJob.handleExceptionOnMainThread();
    }
}

