/*
 * Decompiled with CFR 0.152.
 */
package com.thirdparty.bumptech.glide.load.engine;

import android.os.Looper;
import android.os.MessageQueue;
import android.util.Log;
import com.thirdparty.bumptech.glide.Priority;
import com.thirdparty.bumptech.glide.load.Key;
import com.thirdparty.bumptech.glide.load.Transformation;
import com.thirdparty.bumptech.glide.load.data.DataFetcher;
import com.thirdparty.bumptech.glide.load.engine.DecodeJob;
import com.thirdparty.bumptech.glide.load.engine.DiskCacheStrategy;
import com.thirdparty.bumptech.glide.load.engine.Engine$EngineJobFactory;
import com.thirdparty.bumptech.glide.load.engine.Engine$LazyDiskCacheProvider;
import com.thirdparty.bumptech.glide.load.engine.Engine$LoadStatus;
import com.thirdparty.bumptech.glide.load.engine.Engine$RefQueueIdleHandler;
import com.thirdparty.bumptech.glide.load.engine.Engine$ResourceWeakReference;
import com.thirdparty.bumptech.glide.load.engine.EngineJob;
import com.thirdparty.bumptech.glide.load.engine.EngineJobListener;
import com.thirdparty.bumptech.glide.load.engine.EngineKey;
import com.thirdparty.bumptech.glide.load.engine.EngineKeyFactory;
import com.thirdparty.bumptech.glide.load.engine.EngineResource;
import com.thirdparty.bumptech.glide.load.engine.EngineResource$ResourceListener;
import com.thirdparty.bumptech.glide.load.engine.EngineRunnable;
import com.thirdparty.bumptech.glide.load.engine.Resource;
import com.thirdparty.bumptech.glide.load.engine.ResourceRecycler;
import com.thirdparty.bumptech.glide.load.engine.cache.DiskCache$Factory;
import com.thirdparty.bumptech.glide.load.engine.cache.MemoryCache;
import com.thirdparty.bumptech.glide.load.engine.cache.MemoryCache$ResourceRemovedListener;
import com.thirdparty.bumptech.glide.load.resource.transcode.ResourceTranscoder;
import com.thirdparty.bumptech.glide.provider.DataLoadProvider;
import com.thirdparty.bumptech.glide.request.ResourceCallback;
import com.thirdparty.bumptech.glide.util.LogTime;
import com.thirdparty.bumptech.glide.util.Util;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public class Engine
implements EngineJobListener,
EngineResource$ResourceListener,
MemoryCache$ResourceRemovedListener {
    private static final String TAG = "Engine";
    private final Map<Key, EngineJob> jobs;
    private final EngineKeyFactory keyFactory;
    private final MemoryCache cache;
    private final Engine$EngineJobFactory engineJobFactory;
    private final Map<Key, WeakReference<EngineResource<?>>> activeResources;
    private final ResourceRecycler resourceRecycler;
    private final Engine$LazyDiskCacheProvider diskCacheProvider;
    private ReferenceQueue<EngineResource<?>> resourceReferenceQueue;

    /*
     * WARNING - void declaration
     */
    public Engine(MemoryCache memoryCache, DiskCache$Factory diskCacheFactory, ExecutorService diskCacheService, ExecutorService sourceService) {
        this((MemoryCache)var1_1, (DiskCache$Factory)var2_2, (ExecutorService)var3_3, sourceService, null, null, null, null, null);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    Engine(MemoryCache cache, DiskCache$Factory diskCacheFactory, ExecutorService diskCacheService, ExecutorService sourceService, Map<Key, EngineJob> jobs, EngineKeyFactory keyFactory, Map<Key, WeakReference<EngineResource<?>>> activeResources, Engine$EngineJobFactory engineJobFactory, ResourceRecycler resourceRecycler) {
        void var1_1;
        void var2_2;
        this.cache = cache;
        this.diskCacheProvider = new Engine$LazyDiskCacheProvider((DiskCache$Factory)var2_2);
        if (activeResources == null) {
            activeResources = new HashMap();
        }
        this.activeResources = activeResources;
        if (keyFactory == null) {
            keyFactory = new EngineKeyFactory();
        }
        this.keyFactory = keyFactory;
        if (jobs == null) {
            jobs = new HashMap<Key, EngineJob>();
        }
        this.jobs = jobs;
        if (engineJobFactory == null) {
            void var3_3;
            engineJobFactory = new Engine$EngineJobFactory((ExecutorService)var3_3, sourceService, this);
        }
        this.engineJobFactory = engineJobFactory;
        if (resourceRecycler == null) {
            resourceRecycler = new ResourceRecycler();
        }
        this.resourceRecycler = resourceRecycler;
        var1_1.setResourceRemovedListener(this);
    }

    /*
     * WARNING - void declaration
     */
    public <T, Z, R> Engine$LoadStatus load(Key signature, int width, int height, DataFetcher<T> fetcher, DataLoadProvider<T, Z> loadProvider, Transformation<Z> transformation, ResourceTranscoder<Z, R> transcoder, Priority priority, boolean isMemoryCacheable, DiskCacheStrategy diskCacheStrategy, ResourceCallback cb) {
        void var3_4;
        void var2_2;
        EngineKey engineKey;
        Util.assertMainThread();
        long l2 = LogTime.getLogTime();
        Object object = fetcher.getId();
        engineKey = this.keyFactory.buildKey((String)object, engineKey, width, height, loadProvider.getCacheDecoder(), loadProvider.getSourceDecoder(), transformation, loadProvider.getEncoder(), transcoder, loadProvider.getSourceEncoder());
        object = this.loadFromCache(engineKey, isMemoryCacheable);
        if (object != null) {
            cb.onResourceReady((Resource<?>)object);
            if (Log.isLoggable((String)TAG, (int)2)) {
                Engine.logWithTimeAndKey("Loaded resource from cache", l2, engineKey);
            }
            return null;
        }
        object = this.loadFromActiveResources(engineKey, isMemoryCacheable);
        if (object != null) {
            cb.onResourceReady((Resource<?>)object);
            if (Log.isLoggable((String)TAG, (int)2)) {
                Engine.logWithTimeAndKey("Loaded resource from active resources", l2, engineKey);
            }
            return null;
        }
        object = this.jobs.get(engineKey);
        if (object != null) {
            ((EngineJob)object).addCallback(cb);
            if (Log.isLoggable((String)TAG, (int)2)) {
                Engine.logWithTimeAndKey("Added to existing load", l2, engineKey);
            }
            return new Engine$LoadStatus(cb, (EngineJob)object);
        }
        EngineJob engineJob = this.engineJobFactory.build(engineKey, isMemoryCacheable);
        Object object2 = new DecodeJob<T, Z, R>(engineKey, (int)var2_2, (int)var3_4, fetcher, loadProvider, transformation, transcoder, this.diskCacheProvider, diskCacheStrategy, priority);
        object2 = new EngineRunnable(engineJob, (DecodeJob<?, ?, ?>)object2, priority);
        this.jobs.put(engineKey, engineJob);
        engineJob.addCallback(cb);
        engineJob.start((EngineRunnable)object2);
        if (Log.isLoggable((String)TAG, (int)2)) {
            Engine.logWithTimeAndKey("Started new load", l2, engineKey);
        }
        return new Engine$LoadStatus(cb, engineJob);
    }

    /*
     * WARNING - void declaration
     */
    private static void logWithTimeAndKey(String log, long startTime, Key key) {
        void var3_2;
        void var1_1;
        String string;
        Log.v((String)TAG, (String)(String.valueOf(string) + " in " + LogTime.getElapsedMillis((long)var1_1) + "ms, key: " + var3_2));
    }

    /*
     * WARNING - void declaration
     */
    private EngineResource<?> loadFromActiveResources(Key key, boolean isMemoryCacheable) {
        if (!isMemoryCacheable) {
            return null;
        }
        EngineResource engineResource = null;
        WeakReference<EngineResource<?>> weakReference = this.activeResources.get(key);
        if (weakReference != null) {
            engineResource = (EngineResource)weakReference.get();
            if (engineResource != null) {
                engineResource.acquire();
            } else {
                void var1_1;
                this.activeResources.remove(var1_1);
            }
        }
        return engineResource;
    }

    /*
     * WARNING - void declaration
     */
    private EngineResource<?> loadFromCache(Key key, boolean isMemoryCacheable) {
        if (!isMemoryCacheable) {
            return null;
        }
        EngineResource<?> engineResource = this.getEngineResourceFromCache(key);
        if (engineResource != null) {
            void var1_1;
            engineResource.acquire();
            this.activeResources.put(key, new Engine$ResourceWeakReference((Key)var1_1, engineResource, this.getReferenceQueue()));
        }
        return engineResource;
    }

    private EngineResource<?> getEngineResourceFromCache(Key key) {
        EngineResource engineResource;
        engineResource = (engineResource = this.cache.remove((Key)((Object)engineResource))) == null ? null : (engineResource instanceof EngineResource ? (EngineResource)engineResource : new EngineResource(engineResource, true));
        return engineResource;
    }

    /*
     * WARNING - void declaration
     */
    public void release(Resource resource) {
        Util.assertMainThread();
        if (resource instanceof EngineResource) {
            void var1_1;
            ((EngineResource)var1_1).release();
            return;
        }
        throw new IllegalArgumentException("Cannot release anything but an EngineResource");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onEngineJobComplete(Key key, EngineResource<?> resource) {
        void var1_1;
        Util.assertMainThread();
        if (resource != null) {
            resource.setResourceListener(key, this);
            if (resource.isCacheable()) {
                void var2_2;
                this.activeResources.put(key, new Engine$ResourceWeakReference(key, (EngineResource<?>)var2_2, (ReferenceQueue<? super EngineResource<?>>)this.getReferenceQueue()));
            }
        }
        this.jobs.remove(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onEngineJobCancelled(EngineJob engineJob, Key key) {
        void var1_1;
        Util.assertMainThread();
        EngineJob engineJob2 = this.jobs.get(key);
        if (var1_1.equals(engineJob2)) {
            void var2_2;
            this.jobs.remove(var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onResourceRemoved(Resource<?> resource) {
        void var1_1;
        Util.assertMainThread();
        this.resourceRecycler.recycle((Resource<?>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void onResourceReleased(Key cacheKey, EngineResource resource) {
        void var2_2;
        Util.assertMainThread();
        this.activeResources.remove(cacheKey);
        if (resource.isCacheable()) {
            void var1_1;
            this.cache.put((Key)var1_1, resource);
            return;
        }
        this.resourceRecycler.recycle((Resource<?>)var2_2);
    }

    public void clearDiskCache() {
        this.diskCacheProvider.getDiskCache().clear();
    }

    private ReferenceQueue<EngineResource<?>> getReferenceQueue() {
        if (this.resourceReferenceQueue == null) {
            this.resourceReferenceQueue = new ReferenceQueue();
            Looper.myQueue().addIdleHandler((MessageQueue.IdleHandler)new Engine$RefQueueIdleHandler(this.activeResources, this.resourceReferenceQueue));
        }
        return this.resourceReferenceQueue;
    }
}

