/*
 * Decompiled with CFR 0.152.
 */
package com.thirdparty.bumptech.glide.load.data;

import android.text.TextUtils;
import android.util.Log;
import com.thirdparty.bumptech.glide.Priority;
import com.thirdparty.bumptech.glide.load.data.DataFetcher;
import com.thirdparty.bumptech.glide.load.data.HttpUrlFetcher$DefaultHttpUrlConnectionFactory;
import com.thirdparty.bumptech.glide.load.data.HttpUrlFetcher$HttpUrlConnectionFactory;
import com.thirdparty.bumptech.glide.load.model.GlideUrl;
import com.thirdparty.bumptech.glide.util.ContentLengthInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;

public class HttpUrlFetcher
implements DataFetcher<InputStream> {
    private static final String TAG = "HttpUrlFetcher";
    private static final int MAXIMUM_REDIRECTS = 5;
    private static final HttpUrlFetcher$HttpUrlConnectionFactory DEFAULT_CONNECTION_FACTORY = new HttpUrlFetcher$DefaultHttpUrlConnectionFactory(null);
    private final GlideUrl glideUrl;
    private final HttpUrlFetcher$HttpUrlConnectionFactory connectionFactory;
    private HttpURLConnection urlConnection;
    private InputStream stream;
    private volatile boolean isCancelled;

    /*
     * WARNING - void declaration
     */
    public HttpUrlFetcher(GlideUrl glideUrl) {
        this((GlideUrl)var1_1, DEFAULT_CONNECTION_FACTORY);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    HttpUrlFetcher(GlideUrl glideUrl, HttpUrlFetcher$HttpUrlConnectionFactory connectionFactory) {
        void var2_2;
        void var1_1;
        this.glideUrl = var1_1;
        this.connectionFactory = var2_2;
    }

    @Override
    public InputStream loadData(Priority priority) {
        return this.loadDataWithRedirects(this.glideUrl.toURL(), 0, null, this.glideUrl.getHeaders());
    }

    /*
     * WARNING - void declaration
     */
    private InputStream loadDataWithRedirects(URL url, int redirects, URL lastUrl, Map<String, String> headers) {
        int n2;
        while (true) {
            if (redirects >= 5) {
                throw new IOException("Too many (> 5) redirects!");
            }
            try {
                void n22;
                if (lastUrl != null && ((URL)url).toURI().equals(n22.toURI())) {
                    throw new IOException("In re-direct loop");
                }
            }
            catch (URISyntaxException uRISyntaxException) {}
            this.urlConnection = this.connectionFactory.build((URL)url);
            for (Map.Entry entry : headers.entrySet()) {
                this.urlConnection.addRequestProperty((String)entry.getKey(), (String)entry.getValue());
            }
            this.urlConnection.setConnectTimeout(2500);
            this.urlConnection.setReadTimeout(2500);
            this.urlConnection.setUseCaches(false);
            this.urlConnection.setDoInput(true);
            this.urlConnection.connect();
            if (this.isCancelled) {
                return null;
            }
            n2 = this.urlConnection.getResponseCode();
            if (n2 / 100 == 2) {
                return this.getStreamForSuccessfulRequest(this.urlConnection);
            }
            if (n2 / 100 != 3) break;
            String string = this.urlConnection.getHeaderField("Location");
            if (TextUtils.isEmpty((CharSequence)string)) {
                throw new IOException("Received empty or null redirect url");
            }
            URL uRL = new URL((URL)url, string);
            Object object = url;
            ++redirects;
            url = uRL;
        }
        if (n2 == -1) {
            throw new IOException("Unable to retrieve response code from HttpUrlConnection.");
        }
        throw new IOException("Request failed " + n2 + ": " + this.urlConnection.getResponseMessage());
    }

    /*
     * WARNING - void declaration
     */
    private InputStream getStreamForSuccessfulRequest(HttpURLConnection urlConnection) {
        if (TextUtils.isEmpty((CharSequence)urlConnection.getContentEncoding())) {
            int n2 = urlConnection.getContentLength();
            this.stream = ContentLengthInputStream.obtain(urlConnection.getInputStream(), n2);
        } else {
            void var1_1;
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("Got non empty content encoding: " + urlConnection.getContentEncoding()));
            }
            this.stream = var1_1.getInputStream();
        }
        return this.stream;
    }

    @Override
    public void cleanup() {
        if (this.stream != null) {
            try {
                this.stream.close();
            }
            catch (IOException iOException) {}
        }
        if (this.urlConnection != null) {
            this.urlConnection.disconnect();
        }
    }

    @Override
    public String getId() {
        return this.glideUrl.getCacheKey();
    }

    @Override
    public void cancel() {
        this.isCancelled = true;
    }
}

