/*
 * Decompiled with CFR 0.152.
 */
package com.thirdparty.bumptech.glide.load;

import com.thirdparty.bumptech.glide.load.Transformation;
import com.thirdparty.bumptech.glide.load.engine.Resource;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class MultiTransformation<T>
implements Transformation<T> {
    private final Collection<? extends Transformation<T>> transformations;
    private String id;

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    public MultiTransformation(Transformation<T> ... transformations) {
        void var1_1;
        if (transformations.length <= 0) {
            throw new IllegalArgumentException("MultiTransformation must contain at least one Transformation");
        }
        this.transformations = Arrays.asList(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public MultiTransformation(Collection<? extends Transformation<T>> transformationList) {
        void var1_1;
        if (transformationList.size() <= 0) {
            throw new IllegalArgumentException("MultiTransformation must contain at least one Transformation");
        }
        this.transformations = var1_1;
    }

    @Override
    public Resource<T> transform(Resource<T> resource, int outWidth, int outHeight) {
        Resource<T> resource2 = resource;
        Iterator<Transformation<T>> iterator = this.transformations.iterator();
        while (iterator.hasNext()) {
            Resource<T> resource3 = iterator.next().transform(resource2, outWidth, outHeight);
            if (resource2 != null && !resource2.equals(resource) && !resource2.equals(resource3)) {
                resource2.recycle();
            }
            resource2 = resource3;
        }
        return resource2;
    }

    @Override
    public String getId() {
        if (this.id == null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Transformation<T> transformation : this.transformations) {
                stringBuilder.append(transformation.getId());
            }
            this.id = stringBuilder.toString();
        }
        return this.id;
    }
}

