/*
 * Decompiled with CFR 0.152.
 */
package com.thirdparty.bumptech.glide.gifdecoder;

import android.util.Log;
import com.thirdparty.bumptech.glide.gifdecoder.GifFrame;
import com.thirdparty.bumptech.glide.gifdecoder.GifHeader;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class GifHeaderParser {
    public static final String TAG = "GifHeaderParser";
    static final int MIN_FRAME_DELAY = 3;
    static final int DEFAULT_FRAME_DELAY = 10;
    private static final int MAX_BLOCK_SIZE = 256;
    private final byte[] block = new byte[256];
    private ByteBuffer rawData;
    private GifHeader header;
    private int blockSize = 0;

    /*
     * WARNING - void declaration
     */
    public GifHeaderParser setData(byte[] data) {
        this.reset();
        if (data != null) {
            void var1_1;
            this.rawData = ByteBuffer.wrap((byte[])var1_1);
            this.rawData.rewind();
            this.rawData.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            this.rawData = null;
            this.header.status = 2;
        }
        return this;
    }

    public void clear() {
        this.rawData = null;
        this.header = null;
    }

    private void reset() {
        this.rawData = null;
        Arrays.fill(this.block, (byte)0);
        this.header = new GifHeader();
        this.blockSize = 0;
    }

    public GifHeader parseHeader() {
        if (this.rawData == null) {
            throw new IllegalStateException("You must call setData() before parseHeader()");
        }
        if (this.err()) {
            return this.header;
        }
        this.readHeader();
        if (!this.err()) {
            this.readContents();
            if (this.header.frameCount < 0) {
                this.header.status = 1;
            }
        }
        return this.header;
    }

    private void readContents() {
        boolean bl = false;
        while (!bl && !this.err()) {
            block0 : switch (this.read()) {
                case 44: {
                    if (this.header.currentFrame == null) {
                        this.header.currentFrame = new GifFrame();
                    }
                    this.readBitmap();
                    break;
                }
                case 33: {
                    switch (this.read()) {
                        case 249: {
                            this.header.currentFrame = new GifFrame();
                            this.readGraphicControlExt();
                            break block0;
                        }
                        case 255: {
                            this.readBlock();
                            String string = "";
                            int n2 = 0;
                            while (n2 < 11) {
                                string = String.valueOf(string) + (char)this.block[n2];
                                ++n2;
                            }
                            if (string.equals("NETSCAPE2.0")) {
                                this.readNetscapeExt();
                                break block0;
                            }
                            this.skip();
                            break block0;
                        }
                        case 254: {
                            this.skip();
                            break block0;
                        }
                        case 1: {
                            this.skip();
                            break block0;
                        }
                    }
                    this.skip();
                    break;
                }
                case 59: {
                    bl = true;
                    break;
                }
                default: {
                    this.header.status = 1;
                }
            }
        }
    }

    private void readGraphicControlExt() {
        this.read();
        int n2 = this.read();
        this.header.currentFrame.dispose = (n2 & 0x1C) >> 2;
        if (this.header.currentFrame.dispose == 0) {
            this.header.currentFrame.dispose = 1;
        }
        this.header.currentFrame.transparency = (n2 & 1) != 0;
        n2 = this.readShort();
        if (n2 < 3) {
            n2 = 10;
        }
        this.header.currentFrame.delay = n2 * 10;
        this.header.currentFrame.transIndex = this.read();
        this.read();
    }

    private void readBitmap() {
        this.header.currentFrame.ix = this.readShort();
        this.header.currentFrame.iy = this.readShort();
        this.header.currentFrame.iw = this.readShort();
        this.header.currentFrame.ih = this.readShort();
        int n2 = this.read();
        boolean bl = (n2 & 0x80) != 0;
        int n3 = (int)Math.pow(2.0, (n2 & 7) + 1);
        this.header.currentFrame.interlace = (n2 & 0x40) != 0;
        this.header.currentFrame.lct = (int[])(bl ? this.readColorTable(n3) : null);
        this.header.currentFrame.bufferFrameStart = this.rawData.position();
        this.skipImageData();
        if (this.err()) {
            return;
        }
        ++this.header.frameCount;
        this.header.frames.add(this.header.currentFrame);
    }

    private void readNetscapeExt() {
        do {
            this.readBlock();
            if (this.block[0] != 1) continue;
            int n2 = this.block[1] & 0xFF;
            int n3 = this.block[2] & 0xFF;
            this.header.loopCount = n3 << 8 | n2;
        } while (this.blockSize > 0 && !this.err());
    }

    private void readHeader() {
        String string = "";
        int n2 = 0;
        while (n2 < 6) {
            string = String.valueOf(string) + (char)this.read();
            ++n2;
        }
        if (!string.startsWith("GIF")) {
            this.header.status = 1;
            return;
        }
        this.readLSD();
        if (this.header.gctFlag && !this.err()) {
            this.header.gct = this.readColorTable(this.header.gctSize);
            this.header.bgColor = this.header.gct[this.header.bgIndex];
        }
    }

    private void readLSD() {
        this.header.width = this.readShort();
        this.header.height = this.readShort();
        int n2 = this.read();
        this.header.gctFlag = (n2 & 0x80) != 0;
        this.header.gctSize = 2 << (n2 & 7);
        this.header.bgIndex = this.read();
        this.header.pixelAspect = this.read();
    }

    private int[] readColorTable(int ncolors) {
        int n2 = 3 * ncolors;
        int[] nArray = null;
        byte[] byArray = new byte[n2];
        try {
            this.rawData.get(byArray);
            nArray = new int[256];
            int n3 = 0;
            int n4 = 0;
            while (n3 < ncolors) {
                int n5 = byArray[n4++] & 0xFF;
                int n6 = byArray[n4++] & 0xFF;
                int n7 = byArray[n4++] & 0xFF;
                nArray[n3++] = 0xFF000000 | n5 << 16 | n6 << 8 | n7;
            }
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)"Format Error Reading Color Table", (Throwable)bufferUnderflowException);
            }
            this.header.status = 1;
        }
        return nArray;
    }

    private void skipImageData() {
        this.read();
        this.skip();
    }

    private void skip() {
        int n2;
        do {
            n2 = this.read();
            this.rawData.position(this.rawData.position() + n2);
        } while (n2 > 0);
    }

    private int readBlock() {
        this.blockSize = this.read();
        int n2 = 0;
        if (this.blockSize > 0) {
            int n3 = 0;
            try {
                while (n2 < this.blockSize) {
                    n3 = this.blockSize - n2;
                    this.rawData.get(this.block, n2, n3);
                    n2 += n3;
                }
            }
            catch (Exception exception) {
                if (Log.isLoggable((String)TAG, (int)3)) {
                    Log.d((String)TAG, (String)("Error Reading Block n: " + n2 + " count: " + n3 + " blockSize: " + this.blockSize), (Throwable)exception);
                }
                this.header.status = 1;
            }
        }
        return n2;
    }

    private int read() {
        int n2 = 0;
        try {
            n2 = this.rawData.get() & 0xFF;
        }
        catch (Exception exception) {
            this.header.status = 1;
        }
        return n2;
    }

    private int readShort() {
        return this.rawData.getShort();
    }

    private boolean err() {
        return this.header.status != 0;
    }
}

